/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: ChainProcessor.cpp 25 2011-05-10 03:46:00Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#include "spcf/processor/ChainProcessor.hpp"

#include <list>
using namespace std;

namespace spcf {

	class ChainProcessor_i {
	public:
		list<ProcessorPtr> processors_;
	};

	ChainProcessor::ChainProcessor() : impl(new ChainProcessor_i()) {
	}

	ChainProcessor::~ChainProcessor() {
		delete impl;
	}

	void ChainProcessor::addProcessor(const ProcessorPtr& processor) {
		impl->processors_.push_back(processor);
	}

	void ChainProcessor::start(Context& context) {
		for(list<ProcessorPtr>::const_iterator i = impl->processors_.begin();
				i != impl->processors_.end(); ++i) {
			const ProcessorPtr& processor = *i;
			processor->start(context);
		}
	}

	void ChainProcessor::soundStarted(Context& context) {
		for(list<ProcessorPtr>::const_iterator i = impl->processors_.begin();
				i != impl->processors_.end(); ++i) {
			const ProcessorPtr& processor = *i;
			processor->soundStarted(context);
		}
	}

	void ChainProcessor::soundStoped(Context& context) {
		for(list<ProcessorPtr>::const_iterator i = impl->processors_.begin();
				i != impl->processors_.end(); ++i) {
			const ProcessorPtr& processor = *i;
			processor->soundStoped(context);
		}
	}

	void ChainProcessor::recognized(Context& context, Recognition& recognition) {
		for(list<ProcessorPtr>::const_iterator i = impl->processors_.begin();
				i != impl->processors_.end(); ++i) {
			const ProcessorPtr& processor = *i;
			processor->recognized(context, recognition);
		}
	}

	void ChainProcessor::stop(Context& context) {
		for(list<ProcessorPtr>::const_iterator i = impl->processors_.begin();
				i != impl->processors_.end(); ++i) {
			const ProcessorPtr& processor = *i;
			processor->stop(context);
		}
	}

	void ChainProcessor::finish(Context& context) {
		for(list<ProcessorPtr>::const_iterator i = impl->processors_.begin();
				i != impl->processors_.end(); ++i) {
			const ProcessorPtr& processor = *i;
			processor->finish(context);
		}
	}

}  // namespace spcf
