/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: SAPIRecognition.cpp 61 2011-05-21 00:49:21Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifdef _MSC_VER
#pragma warning(disable:4996)
#endif

#include "spcf/sapi/SAPIRecognition.hpp"

#include "spcf/sapi/SAPIRecognitionProperty.hpp"
#include "spcf/sapi/utils/Char2WChar.hpp"
#include "spcf/sapi/utils/WChar2Char.hpp"

#include <algorithm>
#include <cassert>
#include <iostream>

using namespace std;

namespace spcf {

	class SAPIRecognition_i {
	public:
		CComPtr<ISpRecoResult> recognition_;
		SPPHRASE* phrase_;
		string rulename_;
		RecognitionPropertyContainer properties_;

	public:
		SAPIRecognition_i(CSpEvent& event);
		~SAPIRecognition_i();
	};

	SAPIRecognition::SAPIRecognition(CSpEvent& event) : impl(new SAPIRecognition_i(event)) {
	}

	SAPIRecognition::~SAPIRecognition() {
		delete impl;
	}

	string SAPIRecognition::getText() {
		USES_CONVERSION;

		HRESULT result;

		CSpDynamicString dtext;
		if (SUCCEEDED(result = impl->recognition_->GetText(SP_GETWHOLEPHRASE, SP_GETWHOLEPHRASE, TRUE, &dtext, NULL))) {
			return string(WChar2Char(dtext));
		} else {
			return "";
		}
	}

	string SAPIRecognition::getGrammarName() {
		return impl->rulename_;
	}

	size_t SAPIRecognition::sizeOfProperties() const {
		return impl->properties_.size();
	}

	RecognitionPropertyIterator SAPIRecognition::beginProperty() {
		return impl->properties_.begin();
	}

	RecognitionPropertyConstIterator SAPIRecognition::beginProperty() const {
		return impl->properties_.begin();
	}

	RecognitionPropertyIterator SAPIRecognition::endProperty() {
		return impl->properties_.end();
	}

	RecognitionPropertyConstIterator SAPIRecognition::endProperty() const {
		return impl->properties_.end();
	}

	class PropertyEqualsByName {
	private:
		string name_;
	public:
		PropertyEqualsByName(const string& name) : name_(name) {}

	public:
		bool operator()(const RecognitionPropertyPtr& p) const {
			return p->getName() == name_;
		}
	};

	size_t SAPIRecognition::sizeOfProperties(const string& name) const {
		return count_if(impl->properties_.begin(), impl->properties_.end(), PropertyEqualsByName(name));
	}

	RecognitionPropertyPtr SAPIRecognition::getProperty(size_t index) const {
		return (index < impl->properties_.size()) ? impl->properties_[index] : RecognitionPropertyPtr();
	}

	RecognitionPropertyPtr SAPIRecognition::getProperty(const string& name) const {
		return getProperty(name, 0);
	}

	RecognitionPropertyPtr SAPIRecognition::getProperty(const string& name, size_t n) const {
		RecognitionPropertyIterator i = impl->properties_.begin();
		while(i != impl->properties_.end()) {
			i = find_if(i, impl->properties_.end(), PropertyEqualsByName(name));
			if(n-- == 0) {
				return *i;
			}
			++i;
		}

		return RecognitionPropertyPtr();
	}

	SAPIRecognition_i::SAPIRecognition_i(CSpEvent& event) : recognition_(event.RecoResult()), phrase_(NULL) {
		assert( recognition_);

		if (FAILED(recognition_->GetPhrase(&phrase_))) {
			phrase_ = NULL;
		}

		if (phrase_) {
			// [ƃvpeB擾
			rulename_ = WChar2Char(phrase_->Rule.pszName);
			for (const SPPHRASEPROPERTY* property = phrase_->pProperties; property != 0; property = property->pNextSibling) {
				properties_.push_back(RecognitionPropertyPtr(new SAPIRecognitionProperty(property)));
			}
		}
	}

	SAPIRecognition_i::~SAPIRecognition_i() {
		if (phrase_) {
			CoTaskMemFree(phrase_);
		}
	}

}  // namespace spcf
