/* L[{[h֌W */

#include "bootpack.h"

Queue *keyqueue;
int keydata0;

void inthandler21(int *esp)
{
	int data;
	io_out8(PIC0_OCW2, 0x61);	/* IRQ-01tPICɒʒm */
	data = io_in8(PORT_KEYDAT);
	Queue::push(keyqueue, data + keydata0);
	return;
}

#define PORT_KEYSTA				0x0064
#define KEYSTA_SEND_NOTREADY	0x02
#define KEYCMD_WRITE_MODE		0x60
#define KBC_MODE				0x47

void Keyboard::sendready(void)
{
	/* L[{[hRg[f[^M\ɂȂ̂҂ */
	for (;;) {
		if ((io_in8(PORT_KEYSTA) & KEYSTA_SEND_NOTREADY) == 0) {
			break;
		}
	}
	return;
}

void Keyboard::init(Queue *queue, int data0)
{
	/* ݐFIFOobt@L */
	keyqueue = queue;
	keydata0 = data0;
	/* L[{[hRg[̏ */
	Keyboard::sendready();
	io_out8(PORT_KEYCMD, KEYCMD_WRITE_MODE);
	Keyboard::sendready();
	io_out8(PORT_KEYDAT, KBC_MODE);
	return;
}
