/* FIFOCu */

#include "bootpack.h"

#define FLAGS_OVERRUN		0x0001

void Queue::init(Queue *queue, int size, int *buf, Task *task)
/* FIFOobt@̏ */
{
	queue->size = size;
	queue->buf = buf;
	queue->free = size; /*  */
	queue->flags = 0;
	queue->p = 0; /* ݈ʒu */
	queue->q = 0; /* ǂݍ݈ʒu */
	queue->task = task; /* f[^ƂɋN^XN */
	return;
}

int Queue::push(Queue *queue, int data)
/* FIFOփf[^𑗂荞Œ~ */
{
	if (queue->free == 0) {
		/* 󂫂ȂĂӂꂽ */
		queue->flags |= FLAGS_OVERRUN;
		return -1;
	}
	queue->buf[queue->p] = data;
	queue->p++;
	if (queue->p == queue->size) {
		queue->p = 0;
	}
	queue->free--;
	if (queue->task != 0) {
		if (queue->task->flags != 2) { /* ^XNQĂ */
			Task::run(queue->task, -1, 0); /* NĂ */
		}
	}
	return 0;
}

int Queue::pop(Queue *queue)
/* FIFOf[^ƂĂ */
{
	int data;
	if (queue->free == queue->size) {
		/* obt@ۂ̂Ƃ́AƂ肠-1Ԃ */
		return -1;
	}
	data = queue->buf[queue->q];
	queue->q++;
	if (queue->q == queue->size) {
		queue->q = 0;
	}
	queue->free++;
	return data;
}

int Queue::status(Queue *queue)
/* ǂ̂炢f[^܂Ă邩񍐂 */
{
	return queue->size - queue->free;
}
