/* ^C}֌W */

#include "bootpack.h"

#define PIT_CTRL	0x0043
#define PIT_CNT0	0x0040

TimerManager timer_manager;

#define TIMER_FLAGS_ALLOC		1	/* mۂ */
#define TIMER_FLAGS_USING		2	/* ^C}쓮 */

void PIT::init(void)
{
	io_out8(PIT_CTRL, 0x34);
	io_out8(PIT_CNT0, 0x9c);
	io_out8(PIT_CNT0, 0x2e);
	timer_manager.count = 0;
	timer_manager.next = 0xffffffff; /* ԕȂ̂Ŕԕ̎ */
	return;
}

void TimerManager::init(void)
{
	MemoryManager *memory_manager = (MemoryManager *) MEMMAN_ADDR;
	int i;
	Timer *t;
	timer_manager.timers0 = (Timer *) MemoryManager::allocate_4k(memory_manager, MAX_TIMER * sizeof(Timer));
	for (i = 0; i < MAX_TIMER; i++) {
		timer_manager.timers0[i].flags = 0; /* gp */
	}
	t = Timer::allocate(); /* Ă */
	t->timeout = 0xffffffff;
	t->flags = TIMER_FLAGS_USING;
	t->next = 0; /* Ԃ */
	timer_manager.t0 = t; /* ͔ԕȂ̂Ő擪ł */
	return;
}

Timer *Timer::allocate(void)
{
	int i;
	for (i = 0; i < MAX_TIMER; i++) {
		if (timer_manager.timers0[i].flags == 0) {
			timer_manager.timers0[i].flags = TIMER_FLAGS_ALLOC;
			timer_manager.timers0[i].flags2 = 0;
			return &timer_manager.timers0[i];
		}
	}
	return 0; /* Ȃ */
}

void Timer::deallocate(Timer *timer)
{
	Timer::cancel(timer); /* Ôߎ */
	timer->flags = 0; /* gp */
	return;
}

void Timer::init(Timer *timer, Queue *queue, int data)
{
	timer->queue = queue;
	timer->data = data;
	return;
}

void Timer::set_time(Timer *timer, unsigned int timeout)
{
	int e;
	Timer *t, *s;
	timer->timeout = timeout + timer_manager.count;
	timer->flags = TIMER_FLAGS_USING;
	e = io_load_eflags();
	io_cli();
	t = timer_manager.t0;
	if (timer->timeout <= t->timeout) {
		/* 擪ɓꍇ */
		timer_manager.t0 = timer;
		timer->next = t; /* t */
		timer_manager.next = timer->timeout;
		io_store_eflags(e);
		return;
	}
	/* ǂɓ΂T */
	for (;;) {
		s = t;
		t = t->next;
		if (timer->timeout <= t->timeout) {
			/* st̊Ԃɓꍇ */
			s->next = timer; /* s̎timer */
			timer->next = t; /* timer̎t */
			io_store_eflags(e);
			return;
		}
	}
}

void inthandler20(int *esp)
{
	Timer *timer;
	char ts = 0;
	io_out8(PIC0_OCW2, 0x60);	/* IRQ-00tPICɒʒm */
	timer_manager.count++;
	if (timer_manager.next > timer_manager.count) {
		return;
	}
	timer = timer_manager.t0; /* Ƃ肠擪̔Ԓntimerɑ */
	for (;;) {
		/* timers̃^C}͑Sē쒆̂̂Ȃ̂ŁAflagsmFȂ */
		if (timer->timeout > timer_manager.count) {
			break;
		}
		/* ^CAEg */
		timer->flags = TIMER_FLAGS_ALLOC;
		if (timer != task_timer) {
			Queue::push(timer->queue, timer->data);
		} else {
			ts = 1; /* task_timer^CAEg */
		}
		timer = timer->next; /* ̃^C}̔Ԓntimerɑ */
	}
	timer_manager.t0 = timer;
	timer_manager.next = timer->timeout;
	if (ts != 0) {
		Task::switcher();
	}
	return;
}

int Timer::cancel(Timer *timer)
{
	int e;
	Timer *t;
	e = io_load_eflags();
	io_cli();	/* ݒ蒆Ƀ^C}̏ԂωȂ悤ɂ邽 */
	if (timer->flags == TIMER_FLAGS_USING) {	/* ͕KvH */
		if (timer == timer_manager.t0) {
			/* 擪ꍇ̎ */
			t = timer->next;
			timer_manager.t0 = t;
			timer_manager.next = t->timeout;
		} else {
			/* 擪ȊȌꍇ̎ */
			/* timer̈OT */
			t = timer_manager.t0;
			for (;;) {
				if (t->next == timer) {
					break;
				}
				t = t->next;
			}
			t->next = timer->next; /* utimer̒Ov̎Autimer̎vw悤ɂ */
		}
		timer->flags = TIMER_FLAGS_ALLOC;
		io_store_eflags(e);
		return 1;	/* LZ */
	}
	io_store_eflags(e);
	return 0; /* LZ͕sv */
}

void Timer::cancel_all(Queue *queue)
{
	int e, i;
	Timer *t;
	e = io_load_eflags();
	io_cli();	/* ݒ蒆Ƀ^C}̏ԂωȂ悤ɂ邽 */
	for (i = 0; i < MAX_TIMER; i++) {
		t = &timer_manager.timers0[i];
		if (t->flags != 0 && t->flags2 != 0 && t->queue == queue) {
			Timer::cancel(t);
			Timer::deallocate(t);
		}
	}
	io_store_eflags(e);
	return;
}
