package jp.co.areaweb.tools.command;
import java.io.*;

public class Job
{
    public static final boolean debug = false;

    public static void execJob(File jobFile) throws IOException {
        execJob(jobFile, null);
    }

    public static void execJob(File jobFile, File workDir) throws IOException {
        if (jobFile == null) {
            throw new IOException("実行するジョブファイルが指定されていません。");
        }
        if (debug) {
            System.out.println("[s JobFile] " + jobFile.getName());
        }

        FileInputStream fis = new FileInputStream(jobFile);
        BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
        String commandLine;
        Command command = new Command();
        while((commandLine = dis.readLine()) != null) {
            command.setCmd(commandLine);
            command.setWorkDir(workDir);
            command.execCommand();
            System.out.println(command.getOutput());
        }

        if (debug) {
            System.out.println("[e JobFile] " + jobFile.getName());
        }
        dis.close();
    }

    /** 
    *	サンプル
    */
    static public void main(String[] args) {
        if (args.length < 1) {
            System.out.println("exp: java jp.co.areaweb.tools.command.Job [jobFileName]");
            return;
        }

        try {
            Job.execJob(new File(args[0]), null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}
