#include <pixqt_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include "BibleBook.h"
#include "BibleAllBooks.h"

int BibleAllBooks::_iOldBookStart = 1;
int BibleAllBooks::_iOldBookEnd = 39;
int BibleAllBooks::_iNewBookStart = 40;
int BibleAllBooks::_iNewBookEnd = 66;

//
// returns true if the book belong to the old testment
//
// notes:
// book number starts from zero, 0-38 = old
//
bool BibleAllBooks::isBookOld( int iBook )// [i] book number starting from zero
{
   bool bOld;
   
   if( _iOldBookEnd > iBook ) {
      bOld = true;
   } else {
      bOld = false;
   }

   return bOld;
}

// the first and the last book for the bible version
//
// notes:
// book number starts from zero. i.e. 0=genesis, 65=rev
// most of the versions have 66, 0 to 65 books
// some version onkly have new testament, in such a case it is 39-65
//
void BibleAllBooks::VersionBookRange( int iVersion,
                                     int &iBookFirst, // [o] 
                                     int &iBookLast )// [o] 
{
   switch( iVersion ) {
   case pixq_Properties::BibleShinkaiyaku2:  
   case pixq_Properties::BibleKougoyaku: 
   case pixq_Properties::BibleKingJames: 
   case pixq_Properties::BibleBungo: 
      //
      // both new and old exist
      //
      iBookFirst = 0;
      iBookLast = BibleAllBooks::_iNewBookEnd - 1;
      break;
       
   case pixq_Properties::BibleRaguet:
      //
      // new testament only
      //
      iBookFirst = BibleAllBooks::_iNewBookStart - 1;
      iBookLast = BibleAllBooks::_iNewBookEnd - 1;
      break;

   default:
      iBookFirst = -1;
      iBookLast = -1;
      break;
   }

   return;
}

BibleAllBooks::BibleAllBooks(void)
{
   _BibleList.clear( );
   _strTorreyBookPatterns.clear( );
}

BibleAllBooks::~BibleAllBooks(void)
{
   _BibleList.clear( );
   _strTorreyBookPatterns.clear( );
} 
  
void BibleAllBooks::Setup( void )
{
   MakeList( );

   AddJpShortBookNames( );

   AddShinkai3BookNames( );
   AddShortShinkaiBookNames( );
   AddShortBookNames( );
   AddBungoBookNames( );
   AddShortTorreyNames( );
   AddShortKjvBookNames( );
   AddEnglishBookNames( );
   AddShortKjvBookOccNames( );

   AddAllBungoFiles( );
   AddAllShinkaiFiles( );
   AddAllKougoFile( );
   AddAllKjvFile( );
   AddAllIsvFile( );

   AddChapterVerseNumbers( );

   return;
}

//
// make a list of bible books
//
void BibleAllBooks::MakeList( void )
{
   BibleBook bc;
   int i;
   
   _BibleList.clear( );
   
   i = 0;

   bc.Set( i++, "nL\0", true );                       _BibleList.push_back( bc );
   bc.Set( i++, "oGWvgL\0", true );                 _BibleList.push_back( bc );
   bc.Set( i++, "rL\0", true );                       _BibleList.push_back( bc );
   bc.Set( i++, "L\0", true );                       _BibleList.push_back( bc );
   bc.Set( i++, "\L\0", true );                       _BibleList.push_back( bc );
   bc.Set( i++, "VAL\0", true );                   _BibleList.push_back( bc );
   bc.Set( i++, "mtL\0", true );                       _BibleList.push_back( bc );
   bc.Set( i++, "cL\0", true );                       _BibleList.push_back( bc );
   bc.Set( i++, "TGL \0", true );              _BibleList.push_back( bc );
   bc.Set( i++, "TGL \0", true );              _BibleList.push_back( bc );
   bc.Set( i++, "񉤋L \0", true );                  _BibleList.push_back( bc );
   bc.Set( i++, "񉤋L \0", true );                  _BibleList.push_back( bc );
   bc.Set( i++, "㎏ \0", true );                  _BibleList.push_back( bc );
   bc.Set( i++, "㎏ \0", true );                  _BibleList.push_back( bc );
   bc.Set( i++, "GYL\0", true );                     _BibleList.push_back( bc );
   bc.Set( i++, "lw~L\0", true );                   _BibleList.push_back( bc );
   bc.Set( i++, "GXeL\0", true );                   _BibleList.push_back( bc );
   bc.Set( i++, "uL\0", true );                       _BibleList.push_back( bc );
   bc.Set( i++, "\0", true );                         _BibleList.push_back( bc );
   bc.Set( i++, "⼌\0", true );                         _BibleList.push_back( bc );
   bc.Set( i++, "`҂̏\0", true );                   _BibleList.push_back( bc );
   bc.Set( i++, "\0", true );                         _BibleList.push_back( bc );
   bc.Set( i++, "CU\0", true );                     _BibleList.push_back( bc );
   bc.Set( i++, "G~\0", true );                   _BibleList.push_back( bc );
   bc.Set( i++, "\0", true );                         _BibleList.push_back( bc );
   bc.Set( i++, "G[LG\0", true );                 _BibleList.push_back( bc );
   bc.Set( i++, "_jG\0", true );                   _BibleList.push_back( bc );
   bc.Set( i++, "zZA\0", true );                     _BibleList.push_back( bc );
   bc.Set( i++, "G\0", true );                     _BibleList.push_back( bc );
   bc.Set( i++, "AX\0", true );                     _BibleList.push_back( bc );
   bc.Set( i++, "Iof\0", true );                   _BibleList.push_back( bc );
   bc.Set( i++, "i\0", true );                       _BibleList.push_back( bc );
   bc.Set( i++, "~J\0", true );                       _BibleList.push_back( bc );
   bc.Set( i++, "iz\0", true );                     _BibleList.push_back( bc );
   bc.Set( i++, "noNN\0", true );                   _BibleList.push_back( bc );
   bc.Set( i++, "[pj\0", true );                   _BibleList.push_back( bc );
   bc.Set( i++, "nKC\0", true );                     _BibleList.push_back( bc );
   bc.Set( i++, "[J\0", true );                   _BibleList.push_back( bc );
   bc.Set( i++, "}L\0", true );                     _BibleList.push_back( bc );
   bc.Set( i++, "}^C̕\0", false );              _BibleList.push_back( bc );
   bc.Set( i++, "}R̕\0", false );              _BibleList.push_back( bc );
   bc.Set( i++, "J̕\0", false );                _BibleList.push_back( bc );
   bc.Set( i++, "nl̕\0", false );              _BibleList.push_back( bc );
   bc.Set( i++, "gk̓\0", false );                  _BibleList.push_back( bc );
   bc.Set( i++, "[}lւ̎莆\0", false );            _BibleList.push_back( bc );
   bc.Set( i++, "Rglւ̎莆 \0", false );     _BibleList.push_back( bc );
   bc.Set( i++, "Rglւ̎莆 \0", false );     _BibleList.push_back( bc );
   bc.Set( i++, "Kelւ̎莆\0", false );          _BibleList.push_back( bc );
   bc.Set( i++, "Gy\lւ̎莆\0", false );            _BibleList.push_back( bc );
   bc.Set( i++, "sslւ̎莆\0", false );            _BibleList.push_back( bc );
   bc.Set( i++, "RTClւ̎莆\0", false );          _BibleList.push_back( bc );
   bc.Set( i++, "eTjPlւ̎莆 \0", false );   _BibleList.push_back( bc );
   bc.Set( i++, "eTjPlւ̎莆 \0", false );   _BibleList.push_back( bc );
   bc.Set( i++, "eeւ̎莆 \0", false );         _BibleList.push_back( bc );
   bc.Set( i++, "eeւ̎莆 \0", false );         _BibleList.push_back( bc );
   bc.Set( i++, "egXւ̎莆\0", false );              _BibleList.push_back( bc );
   bc.Set( i++, "sւ̎莆\0", false );            _BibleList.push_back( bc );
   bc.Set( i++, "wulւ̎莆\0", false );            _BibleList.push_back( bc );
   bc.Set( i++, "Ru̎莆\0", false );                _BibleList.push_back( bc );
   bc.Set( i++, "ye̎莆 \0", false );           _BibleList.push_back( bc );
   bc.Set( i++, "ye̎莆 \0", false );           _BibleList.push_back( bc );
   bc.Set( i++, "nl̎莆 \0", false );           _BibleList.push_back( bc );
   bc.Set( i++, "nl̎莆 \0", false );           _BibleList.push_back( bc );
   bc.Set( i++, "nl̎莆 O\0", false );           _BibleList.push_back( bc );
   bc.Set( i++, "_̎莆\0", false );                  _BibleList.push_back( bc );
   bc.Set( i++, "nlَ̖^\0", false );              _BibleList.push_back( bc );
                                                            
   return;                                                  
} 

//
// ̃XgɐV3ł̏ǉ
//
void BibleAllBooks::AddShinkai3BookNames( void )
{
   BibleBook *bc;
   int i;

   i = 0;
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "nL\0" ); 
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "oGWvgL\0" ); 
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "rL\0" );
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "L\0" );
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "\L\0" );
  
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "VAL\0" );
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "mtL\0" );
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "cL\0" );
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "TGL \0" );
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "TGL \0" );
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "񉤋L \0" );
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "񉤋L \0" ); 
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "㎏ \0" ); 
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "㎏ \0" ); 
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "GYL\0" );  
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "lw~L\0" );
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "GXeL\0" );
 
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "uL\0" ); 
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "\0" );   
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "⼌\0" );   
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "`҂̏\0" );
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "\0" ); 
 
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "CU\0" ); 
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "G~\0" ); 
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "\0" ); 
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "G[LG\0" ); 
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "_jG\0" ); 
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "zZA\0" ); 
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "G\0" ); 
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "AX\0" ); 
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "Iof\0" ); 
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "i\0" ); 
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "~J\0" ); 
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "iz\0" ); 
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "noNN\0" ); 
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "[pj\0" );
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "nKC\0" ); 
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "[J\0" ); 
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "}L\0" ); 

   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "}^C̕\0" ); 
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "}R̕\0" ); 
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "J̕\0" );   
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "nl̕\0" ); 
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "gk̓\0" );     

   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "[}lւ̎莆\0" );
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "Rglւ̎莆 \0" ); 
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "Rglւ̎莆 \0" ); 
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "Kelւ̎莆\0" ); 
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "Gy\lւ̎莆\0" ); 
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "sslւ̎莆\0" ); 
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "RTClւ̎莆\0" ); 
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "eTjPlւ̎莆 \0" ); 
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "eTjPlւ̎莆 \0" ); 
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "eeւ̎莆 \0" ); 
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "eeւ̎莆 \0" ); 
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "egXւ̎莆\0" ); 
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "sւ̎莆\0" ); 
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "wulւ̎莆\0" ); 
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "Ru̎莆\0" ); 
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "ye̎莆 \0" ); 
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "ye̎莆 \0" ); 
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "nl̎莆 \0" ); 
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "nl̎莆 \0" ); 
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "nl̎莆 O\0" ); 
   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "_̎莆\0" ); 

   bc = &_BibleList.at( i++ );  bc->SetShinkai3Book( "nlَ̖^\0" );
                                                                         
   return;                                                                                        
}

//
// ̃XgɐV̗̂ǉ
//
void BibleAllBooks::AddShortShinkaiBookNames( void )
{
   BibleBook *bc;
   int i;

   // ڂ̂قK邱!

   i = 0;
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "n\0" );     bc->SetShinkaiBookShort( 1, "n\0" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "o\0" );     bc->SetShinkaiBookShort( 1, "o\0" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "r\0" );   bc->SetShinkaiBookShort( 1, "q\0" );           
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "\0" );     bc->SetShinkaiBookShort( 1, "\0" );           
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "\\0" );     bc->SetShinkaiBookShort( 1, "\\0" );           
  
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "V\0" );   bc->SetShinkaiBookShort( 1, "V\0" );       
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "mt\0" );   bc->SetShinkaiBookShort( 1, "m\0" );           
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "c\0" );   bc->SetShinkaiBookShort( 1, "c\0" );           
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "1T\0" );  bc->SetShinkaiBookShort( 1, "1T\0" );  
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "2T\0" );  bc->SetShinkaiBookShort( 1, "2T\0" );  
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "1\0" );    bc->SetShinkaiBookShort( 1, "1\0" );      
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "2\0" );    bc->SetShinkaiBookShort( 1, "2\0" );      
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "1\0" );  bc->SetShinkaiBookShort( 1, "1\0" );      
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "2\0" );  bc->SetShinkaiBookShort( 1, "2\0" );      
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "GY\0" );   bc->SetShinkaiBookShort( 1, "GY\0" );         
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "lw\0" );   bc->SetShinkaiBookShort( 1, "lw\0" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "GX\0" );   bc->SetShinkaiBookShort( 1, "GX\0" );       
 
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "u\0" );   bc->SetShinkaiBookShort( 1, "u\0" );           
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "\0" );     bc->SetShinkaiBookShort( 1, "\0" );             
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "⼌\0" );   bc->SetShinkaiBookShort( 1, "\0" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "`\0" );     bc->SetShinkaiBookShort( 1, "`\0" );       
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "\0" );     bc->SetShinkaiBookShort( 1, "\0" );             
 
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "CU\0" );   bc->SetShinkaiBookShort( 1, "CU\0" );         
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "G\0" );   bc->SetShinkaiBookShort( 1, "G\0" );       
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "\0" );     bc->SetShinkaiBookShort( 1, "\0" );             
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "G[\0" );   bc->SetShinkaiBookShort( 1, "G[\0" );     
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "_j\0" );   bc->SetShinkaiBookShort( 1, "_j\0" );       
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "zZ\0" );   bc->SetShinkaiBookShort( 1, "zZ\0" ); 
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "G\0" );   bc->SetShinkaiBookShort( 1, "G\0" );         
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "A\0" );   bc->SetShinkaiBookShort( 1, "A\0" );         
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "Io\0" );   bc->SetShinkaiBookShort( 1, "Io\0" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "i\0" );   bc->SetShinkaiBookShort( 1, "i\0" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "~J\0" );   bc->SetShinkaiBookShort( 1, "~J\0" );           
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "iz\0" );   bc->SetShinkaiBookShort( 1, "iz\0" );         
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "no\0" );   bc->SetShinkaiBookShort( 1, "no\0" );       
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "[p\0" );   bc->SetShinkaiBookShort( 1, "[p\0" );     
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "nKC\0" ); bc->SetShinkaiBookShort( 1, "nK\0" );         
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "[J\0" );   bc->SetShinkaiBookShort( 1, "[J\0" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "}\0" );   bc->SetShinkaiBookShort( 1, "}\0" );

   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "}^\0" );   bc->SetShinkaiBookShort( 1, "}^\0" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "}R\0" ); bc->SetShinkaiBookShort( 1, "}\0" );             
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "J\0" );   bc->SetShinkaiBookShort( 1, "J\0" );               
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "n\0" );   bc->SetShinkaiBookShort( 1, "n\0" );             
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "g\0" );     bc->SetShinkaiBookShort( 1, "g\0" );                 

   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "}\0" );   bc->SetShinkaiBookShort( 1, "}\0" );           
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "1R\0" );  bc->SetShinkaiBookShort( 1, "1R\0" );    
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "2R\0" );  bc->SetShinkaiBookShort( 1, "2R\0" );    
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "K\0" );   bc->SetShinkaiBookShort( 1, "K\0" );         
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "Gy\0" );   bc->SetShinkaiBookShort( 1, "Gy\0" );           
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "ss\0" ); bc->SetShinkaiBookShort( 1, "s\0" );           
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "R\0" );   bc->SetShinkaiBookShort( 1, "R\0" );         
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "1eT\0" );  bc->SetShinkaiBookShort( 1, "1eT\0" );  
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "2eT\0" );  bc->SetShinkaiBookShort( 1, "2eT\0" );  
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "1e\0" );  bc->SetShinkaiBookShort( 1, "1e\0" );        
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "2e\0" );  bc->SetShinkaiBookShort( 1, "2e\0" );        
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "eg\0" );   bc->SetShinkaiBookShort( 1, "eg\0" );             
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "s\0" );   bc->SetShinkaiBookShort( 1, "s\0" );           
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "wu\0" ); bc->SetShinkaiBookShort( 1, "wu\0" );           
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "R\0" );   bc->SetShinkaiBookShort( 1, "R\0" );               
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "1ye\0" );bc->SetShinkaiBookShort( 1, "1ye\0" );          
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "2ye\0" );  bc->SetShinkaiBookShort( 1, "2ye\0" );          
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "1n\0" );  bc->SetShinkaiBookShort( 1, "1n\0" );          
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "2n\0" );  bc->SetShinkaiBookShort( 1, "2n\0" );          
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "3n\0" );  bc->SetShinkaiBookShort( 1, "3n\0" );          
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "_\0" );   bc->SetShinkaiBookShort( 1, "_\0" );                 
 
   bc = &_BibleList.at( i++ );  bc->SetShinkaiBookShort( 0, "َ\0" );   bc->SetShinkaiBookShort( 1, "\0" );             
                                                                                                  
   return;                                                                                        
}

//
// ̃XgɋԒ̗̂ǉ
//
void BibleAllBooks::AddShortKjvBookNames( void )
{
   BibleBook *bc;
   int i;

   i = 0;
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "Gen.\0" );        //  0
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "Exo.\0" );        //  1
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "Lev.\0" );        //  2
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "Num.\0" );        //  3
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "Deut.\0" );       //  4

   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "Josh.\0" );       //  5
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "Judg.\0" );       //  6
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "Ruth.\0" );       //  7
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "I Sam.\0" );      //  8
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "II Sam.\0" );     //  9
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "I Kgs.\0" );      // 10
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "II Kgs.\0" );     // 11
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "I Chr.\0" );      // 12
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "II Chr.\0" );     // 13
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "Ezra.\0" );       // 14
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "Neh.\0" );        // 15
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "Esth.\0" );       // 16

   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "Job.\0" );        // 17
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "Psa.\0" );        // 18
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "Prov.\0" );       // 19
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "Eccl.\0" );       // 20
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "Song.\0" );       // 21

   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "Isa.\0" );        // 22
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "Jer.\0" );        // 23
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "Lam.\0" );        // 24
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "Ezek.\0" );       // 25
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "Dan.\0" );        // 26
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "Hos.\0" );        // 27
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "Joel.\0" );       // 28
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "Amos.\0" );       // 29
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "Ob.\0" );         // 30 gĂȂ
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "Jon.\0" );        // 31
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "Mic.\0" );        // 32
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "Nah.\0" );        // 33
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "Hab.\0" );        // 34
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "Zeph.\0" );       // 35
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "Hag.\0" );        // 36
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "Zech.\0" );       // 37
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "Mal.\0" );        // 38

   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "Matt.\0" );       // 39
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "Mark.\0" );       // 40
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "Luke.\0" );       // 41
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "John.\0" );       // 42
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "Acts.\0" );       // 43

   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "Rom.\0" );        // 44
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "I Cor.\0" );      // 45
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "II Cor.\0" );     // 46
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "Gal.\0" );        // 47
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "Eph.\0" );        // 48
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "Phi.\0" );        // 49
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "Col.\0" );        // 50
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "I Thes.\0" );     // 51
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "II Thes.\0" );    // 52
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "I Tim.\0" );      // 53
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "II Tim.\0" );     // 54
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "Tit.\0" );        // 55
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "Phm.\0" );        // 56 gĂȂ
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "Heb.\0" );        // 57
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "Jas.\0" );        // 58
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "I Pet.\0" );      // 59
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "II Pet.\0" );     // 60
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "I John.\0" );     // 61
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "II John.\0" );    // 62
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "III John.\0" );   // 63
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "Jude.\0" );       // 64
   bc = &_BibleList.at( i++ );  bc->SetKjvBookShort( "Rev.\0" );        // 65
                                                                             
   return;                                                                   
}                                                                            
 
//
// ̃XgɋԒ̏ǉ
//
void BibleAllBooks::AddEnglishBookNames( void )
{
   BibleBook *bc;
   int i;

   i = 0;
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "Genesis\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "Exodus\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "Leviticus\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "Numbers\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "Deuteronomy\0" );
                                                      
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "Joshua\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "Judges\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "Ruth\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "1 Samuel\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "2 Samuel\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "1 Kings\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "2 Kings\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "1 Chronicles\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "2 Chronicles\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "Ezra\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "Nehemiah\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "Esther\0" );
                                                      
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "Job\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "Psalms\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "Proverbs\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "Ecclesiastes\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "Song of Songs\0" );
                                                      
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "Isaiah\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "Jeremiah\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "Lamentations\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "Ezekiel\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "Daniel\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "Hosea\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "Joel\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "Amos\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "Obadiah\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "Jonah\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "Micah\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "Nahum\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "Habakkuk\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "Zephaniah\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "Haggai\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "Zechariah\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "Malachi\0" );
                                                      
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "Matthew\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "Mark\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "Luke\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "John\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "Acts\0" );
                                                      
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "Romans\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "1 Corinthians\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "2 Corinthians\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "Galatians\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "Ephesians\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "Philippians\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "Colossians\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "1 Thessalonians\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "2 Thessalonians\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "1 Timothy\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "2 Timothy\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "Titus\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "Philemon\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "Hebrews\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "James\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "1 Peter\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "2 Peter\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "1 John\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "2 John\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "3 John\0" );
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "Jude\0" );
                                                     
   bc = &_BibleList.at( i++ );  bc->SetEngBookName( "Revelation\0" );
  
   return;                                                                  
}                                             
                                              
//
// ̃XgɋԒXyVIP[Ŵ̗ǉ
//
void BibleAllBooks::AddShortKjvBookOccNames( void )
{
   BibleBook *bc;
   int i;

   i = 0;
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "Gen\0" );   //  0
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "Exo\0" );   //  1
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "Lev\0" );   //  2
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "Num\0" );   //  3
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "Deu\0" );   //  4
                                                             
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "Jos\0" );   //  5
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "Jug\0" );   //  6
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "Rut\0" );   //  7
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "1Sa\0" );   //  8
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "2Sa\0" );   //  9
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "1Ki\0" );   // 10
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "2Ki\0" );   // 11
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "1Ch\0" );   // 12
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "2Ch\0" );   // 13
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "Ezr\0" );   // 14
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "Neh\0" );   // 15
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "Est\0" );   // 16
                                                               
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "Job\0" );   // 17
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "Psa\0" );   // 18
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "Pro\0" );   // 19
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "Ecc\0" );   // 20
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "Son\0" );   // 21
                                                               
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "Isa\0" );   // 22
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "Jer\0" );   // 23
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "Lam\0" );   // 24
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "Eze\0" );   // 25
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "Dan\0" );   // 26
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "Hos\0" );   // 27
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "Joe\0" );   // 28
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "Amo\0" );   // 29
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "Oba\0" );   // 30
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "Jon\0" );   // 31
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "Mic\0" );   // 32
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "Nah\0" );   // 33
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "Hab\0" );   // 34
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "Zep\0" );   // 35
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "Hag\0" );   // 36
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "Zec\0" );   // 37
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "Mal\0" );   // 38
                                                               
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "Mat\0" );   // 39
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "Mar\0" );   // 40
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "Luk\0" );   // 41
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "Joh\0" );   // 42
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "Act\0" );   // 43
                                                               
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "Rom\0" );   // 44
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "1Co\0" );   // 45
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "2Co\0" );   // 46
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "Gal\0" );   // 47
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "Eph\0" );   // 48
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "Php\0" );   // 49
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "Col\0" );   // 50
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "1Th\0" );   // 51
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "2Th\0" );   // 52
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "1Ti\0" );   // 53
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "2Ti\0" );   // 54
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "Tit\0" );   // 55
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "Phm\0" );   // 56
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "Heb\0" );   // 57
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "Jam\0" );   // 58
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "1Pe\0" );   // 59
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "2Pe\0" );   // 60
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "1Jo\0" );   // 61
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "2Jo\0" );   // 62
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "3Jo\0" );   // 63
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "Jud\0" );   // 64
                                                               
   bc = &_BibleList.at( i++ );  bc->SetKjvBookOccShort( "Rev\0" );   // 65
                                                                
   return;                                                             
}                                                               
                                                                
//                                                                       
// ̃XgɌAKJVAʂ̗̂ǉ
//
void BibleAllBooks::AddShortBookNames( void )
{
   BibleBook *bc;
   int i;

   i = 0;
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "Ge\0", "Gen\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "Ex\0", "Ex\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "Le\0", "Lev\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "Nu\0", "Num\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "De\0", "Deut\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "Jos\0", "Josh\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "Jg\0", "Jud\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "Ru\0", "Ruth\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "1Sa\0", "1Sam\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "2Sa\0", "2Sam\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "1Ki\0", "1King\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "2Ki\0", "2King\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "1Ch\0", "1Chron\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "2Ch\0", "2Chron\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "Ezr\0", "Ezra\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "Ne\0", "Neh\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "Es\0", "Est\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "Job\0", "Job\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "Ps\0", "Ps\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "Pr\0", "Prov\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "Ec\0", "Ecc\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "Song\0", "Solomon\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "Isa\0", "Is\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "Jer\0", "Jer\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "La\0", "Lam\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "Eze\0", "Ezek\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "Da\0", "Dan\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "Ho\0", "Hos\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "Joe\0", "Joel\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "Am\0", "Amos\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "Ob\0", "Oba\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "Jon\0", "Jonah\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "Mic\0", "Micah\0" ); 
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "Na\0", "Nahum\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "Hab\0", "Habak\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "Zep\0", "Zephaniah\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "Hag\0", "Haggai\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "Zec\0", "Zech\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "Mal\0", "Malachi\0" );
                                                                 
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "Mt\0", "Matt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "Mr\0", "Mark\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "Lu\0", "Luke\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "Joh\0", "John\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "Ac\0", "Acts\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "Ro\0", "Rom\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "1Co\0", "1Cor\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "2Co\0", "2Cor\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "Ga\0", "Gal\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "Eph\0", "Eph\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "Php\0", "Philip\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "Col\0", "Colos\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "1Th\0", "1Thess\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "2Th\0", "2Thess\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "1Ti\0", "1Timothy\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "2Ti\0", "2Timothy\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "Tit\0", "Titus\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "Phm\0", "Philemon\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "Heb\0", "Heb\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "Jas\0", "James\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "1Pe\0", "1Peter\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "2Pe\0", "2Peter\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "1Jo\0", "1John\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "2Jo\0", "2John\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "3Jo\0", "3John\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "Jude\0", "Jude\0" );
   bc = &_BibleList.at( i++ );  bc->SetBookEnAbbrev( "Re\0", "Rev\0" );
                                                                
   return;                                                            
}   

                                                          
//                                                                       
// ̃XgɕAǉ
//
void BibleAllBooks::AddBungoBookNames( void )
{
   BibleBook *bc;
   int i;

   i = 0;
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "nL\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "oGWvgL\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "rL\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "ɋI\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "\L\0" );

   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "VAL\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "mtL\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "cL\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "TGO\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "TG㏑\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "񉤋I\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "񉤋I\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "u\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "u\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "GY\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "lw~L\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "GXe\0" );

   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "uL\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "⼌\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "BV\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "\0" );

   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "CU\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "~L\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "G~̈\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "G[LG\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "_jG\0" );
   
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "zZA\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "G\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "AX\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "Iof\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "i\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "~J\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "iz\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "noNN\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "[pj\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "nKC\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "[J\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "}L\0" );

   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "}^CB\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "}RB\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "JB\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "nlB\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "gksB\0" );

   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "}lւ̏\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "Rglւ̑Ȍ\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "Rglւ̌̏\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "Kelւ̏\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "Gy\lւ̏\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "sslւ̏\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "RTClւ̏\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "eTjPlւ̑Ȍ\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "eTjPlւ̌̏\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "eeւ̑Ȍ\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "eeւ̌̏\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "egXւ̏\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "sւ̏\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "wulւ̏\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "Rȕ\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "yȇȌ\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "yě̏\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "nl̑̏\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "nl̑̏\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "nl̑Ȍ\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "_̏\0" );

   bc = &_BibleList.at( i++ );  bc->SetBungoBook( "nlҎ^\0" );

   return;                                                              
}   

int BibleAllBooks::KjvShortNameSize( int iBook )
{
   int nBooks;
   BibleBook bc;
   QString strShort;

   int nLength = -1;

   nBooks = (int)_BibleList.size( );
   if( 0 > iBook || nBooks <= iBook ) {
      goto PIX_EXIT;
   }

   bc = _BibleList.at( iBook );  
   strShort = bc.GetKjvBookShort( );  

   nLength = strShort.size( );

PIX_EXIT:
   return nLength;
}

QString BibleAllBooks::KjvShortName( int iBook )
{
   int nBooks;
   BibleBook bc;
   QString strShort;

   nBooks = (int)_BibleList.size( );
   if( 0 > iBook || nBooks <= iBook ) {
      strShort.clear( );
      goto PIX_EXIT;
   }

   bc = _BibleList.at( iBook );  
   strShort = bc.GetKjvBookShort( );  

PIX_EXIT:
   return strShort;
}

int BibleAllBooks::ShinkaiShortNameSize( int iBook, int iSide )
{
   int nBooks;
   BibleBook bc;
   QString strShort;

   int nLength = -1;

   if( 0 > iSide || 1 < iSide ) {
      goto PIX_EXIT;
   }

   nBooks = (int)_BibleList.size( );
   if( 0 > iBook || nBooks <= iBook ) {
      goto PIX_EXIT;
   }

   bc = _BibleList.at( iBook );  
   strShort = bc.GetShinkaiBookShort( iSide );  

   nLength = strShort.size( );

PIX_EXIT:
   return nLength;
}

QString BibleAllBooks::GetShinkaiName( int iBook, int iSide )
{
   int nBooks;
   QString strShinkai;
   BibleBook bc;
   
   if( 0 > iSide || 1 < iSide ) {
      goto PIX_EXIT;
   }

   strShinkai.clear( );

   nBooks = (int)_BibleList.size( );
   if( 0 > iBook || nBooks <= iBook ) {
      goto PIX_EXIT;
   }

   bc = _BibleList.at( iBook );  
   strShinkai = bc.GetShinkaiBookShort( iSide );
  
PIX_EXIT:
   return strShinkai;
}

QString BibleAllBooks::GetJpShortName( int iBook )
{
   int nBooks;
   QString strShinkai;
   BibleBook bc;
   
   strShinkai.clear( );

   nBooks = (int)_BibleList.size( );
   if( 0 > iBook || nBooks <= iBook ) {
      goto PIX_EXIT;
   }

   bc = _BibleList.at( iBook );  
   strShinkai = bc.GetBookJpShortame( );
  
PIX_EXIT:
   return strShinkai;
}

int BibleAllBooks::GetBookChapters( int iBook ) // [i] book number starting from 0
{
   int nChapters, nBooks;
   BibleBook bc;
   
   nChapters = -1;

   nBooks = (int)_BibleList.size( );
   if( 0 > iBook || nBooks <= iBook ) {
      goto PIX_EXIT;
   }

   bc = _BibleList.at( iBook );  
   nChapters = bc.GetChapters( );
  
PIX_EXIT:
   return nChapters;
}

int BibleAllBooks::GetBookChapterVerses( int iBook,  // [i] book number starting from 0
                                        int iChapter )  // [i] chapter number starting from 1
{
   int nChapters, nVerses, nBooks;
   BibleBook bc;
   
   nVerses = -1;

   nBooks = (int)_BibleList.size( );
   if( 0 > iBook || nBooks <= iBook ) {
      goto PIX_EXIT;
   }

   bc = _BibleList.at( iBook );  
   nChapters = bc.GetChapters( );
   if( 0 >= iChapter || nChapters < iChapter ) {
      goto PIX_EXIT;
   }
  
   nVerses = bc.GetChapterVerseNumber( iChapter );

PIX_EXIT:
   return nVerses;
}

QString BibleAllBooks::GetBookEnAbbrev( int iBook, int iSide )
{
   int nBooks;
   QString strKougo;
   BibleBook bc;
   
   strKougo.clear( );

   nBooks = (int)_BibleList.size( );
   if( 0 > iBook || nBooks <= iBook ) {
      goto PIX_EXIT;
   }

   bc = _BibleList.at( iBook );  
   strKougo = bc.GetBookEnAbbrev( iSide );
  
PIX_EXIT:
   return strKougo;
}

QString BibleAllBooks::GetKjvFile( int iBook )
{
   int nBooks;
   QString strFile;
   BibleBook bc;
   
   strFile.clear( );

   nBooks = (int)_BibleList.size( );
   if( 0 > iBook || nBooks <= iBook ) {
      goto PIX_EXIT;
   }

   bc = _BibleList.at( iBook ); 
   
   strFile = "Files_KJV/";
   strFile.append( bc.GetKjvFile( ) );
  
PIX_EXIT:
   return strFile;
}

QString BibleAllBooks::GetKjvBookOccShort( int iBook )
{
   int nBooks;
   QString strFile;
   BibleBook bc;
   
   strFile.clear( );

   nBooks = (int)_BibleList.size( );
   if( 0 > iBook || nBooks <= iBook ) {
      goto PIX_EXIT;
   }

   bc = _BibleList.at( iBook );  
   
   strFile = bc.GetKjvBookOccShort( );
  
PIX_EXIT:
   return strFile;
}

QString BibleAllBooks::GetShinkai2File( int iBook )
{
   int nBooks;
   QString strFile;
   BibleBook bc;
   
   strFile.clear( );

   nBooks = (int)_BibleList.size( );
   if( 0 > iBook || nBooks <= iBook ) {
      goto PIX_EXIT;
   }

   bc = _BibleList.at( iBook );  

   strFile = "Files_Shinkai/";
   strFile.append( bc.GetShinkaiFile( ) );
  
PIX_EXIT:
   return strFile;
}

QString BibleAllBooks::GetBungoFile( int iBook )
{
   int nBooks;
   QString strFile;
   BibleBook bc;
   
   strFile.clear( );

   nBooks = (int)_BibleList.size( );
   if( 0 > iBook || nBooks <= iBook ) {
      goto PIX_EXIT;
   }

   bc = _BibleList.at( iBook );  

   strFile = "Files_Bungo/";
   strFile.append( bc.GetBungoFile( ) );
  
PIX_EXIT:
   return strFile;
}

//
// input file names of Raguet are identical to Bungo
//
QString BibleAllBooks::GetRaguetFile( int iBook )
{
   int nBooks;
   QString strFile;
   BibleBook bc;
   
   strFile.clear( );

   nBooks = (int)_BibleList.size( );
   if( 0 > iBook || nBooks <= iBook ) {
      goto PIX_EXIT;
   }

   bc = _BibleList.at( iBook );  

   strFile = "Files_Raguet/";
   strFile.append( bc.GetBungoFile( ) );
  
PIX_EXIT:
   return strFile;
}


QString BibleAllBooks::GetShinkai3File( int iBook )
{
   int nBooks;
   QString strFile;
   BibleBook bc;
   
   strFile.clear( );

   nBooks = (int)_BibleList.size( );
   if( 0 > iBook || nBooks <= iBook ) {
      goto PIX_EXIT;
   }

   bc = _BibleList.at( iBook );  

   strFile = "Files_Shinkai3/";
   strFile.append( bc.GetShinkaiFile( ) );
  
PIX_EXIT:
   return strFile;
}

QString BibleAllBooks::GetKougoFile( int iBook )
{
   int nBooks;
   QString strFile;
   BibleBook bc;
   
   strFile.clear( );

   nBooks = (int)_BibleList.size( );
   if( 0 > iBook || nBooks <= iBook ) {
      goto PIX_EXIT;
   }

   bc = _BibleList.at( iBook );  
   
   strFile = "Files_Kougo/";
   strFile.append( bc.GetKougoFile( ) );
  
PIX_EXIT:
   return strFile;
}

//
// ̃XgɕTEXT file nameǉ
//
void BibleAllBooks::AddAllBungoFiles( void )
{
   BibleBook *bc;
   int i;

   i = 0;
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "01_genesis.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "02_exodus.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "03_leviticus.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "04_numbers.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "05_deuteronomy.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "06_joshua.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "07_judges.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "08_ruth.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "09_1samuel.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "10_2samuel.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "11_1kings.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "12_2kings.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "13_1chronicles.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "14_2chronicles.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "15_ezra.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "16_nehemiah.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "17_esther.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "18_job.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "19_psalms.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "20_proverbs.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "21_ecclesiastes.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "22_songofsongs.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "23_isaiah.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "24_jeremiah.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "25_lamentations.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "26_ezekiel.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "27_daniel.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "28_hosea.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "29_joel.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "30_amos.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "31_obadiah.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "32_jonah.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "33_micah.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "34_nahum.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "35_habakkuk.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "36_zephaniah.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "37_haggai.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "38_zecariah.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "39_malachi.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "40_matthew.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "41_mark.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "42_luke.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "43_john.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "44_acts.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "45_romans.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "46_1corintians.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "47_2corintians.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "48_galatians.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "49_ephesians.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "50_philippians.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "51_colossians.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "52_1thessalonians.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "53_2thessalonians.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "54_1timothy.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "55_2timothy.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "56_titus.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "57_philemon.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "58_hebrews.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "59_james.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "60_1peter.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "61_2peter.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "62_1john.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "63_2john.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "64_3john.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "65_jude.txt\0" );
   bc = &_BibleList.at( i++ );  bc->SetBungoFile( "66_revelation.txt\0" );
                                                            
   return;                                                  
}

//
// ̃XgɐVTEXT file nameǉ
//
void BibleAllBooks::AddAllShinkaiFiles( void )
{
   BibleBook *bc;
   int i;

   i = 0;
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "01nL.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "02oGWvgL.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "03rL.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "04L.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "05\L.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "06VAL.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "07mtL.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "08cL.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "09TGL.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "10TGL.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "11񉤋L.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "12񉤋L.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "13j.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "14j.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "15GYL.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "16lw~L.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "17GXeL.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "18uL.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "19.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "20⼌.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "21`҂̏.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "22.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "23CU.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "24G~.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "25.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "26G[LG.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "27_jG.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "28zZA.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "29G.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "30AX.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "31Iof.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "32i.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "33~J.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "34iz.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "35noNN.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "36[pj.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "37nKC.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "38[J.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "39}L.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "40}^C`.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "41}R`.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "42J`.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "43nl`.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "44gks`.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "45[}.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "46TRg.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "47URg.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "48Ke.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "49Gy\.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "50ss.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "51RTC.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "52TeTjP.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "53UeTjP.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "54Tee.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "55Uee.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "56egX.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "57s.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "58wu.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "59Ru.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "60Tye.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "61Uye.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "62Tnl.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "63Unl.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "64Vnl.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "65_.txt" );
   bc = &_BibleList.at( i++ );  bc->SetShinkaiFile( "66nlَ^.txt" );
                                                            
   return;                                                  
}

//
// ̃XgKougoTEXT file nameǉ
//
void BibleAllBooks::AddAllKougoFile( void )
{
   BibleBook *bc;
   int i;

   i = 0;
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_01.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_02.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_03.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_04.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_05.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_06.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_07.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_08.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_09.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_10.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_11.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_12.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_13.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_14.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_15.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_16.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_17.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_18.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_19.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_20.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_21.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_22.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_23.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_24.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_25.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_26.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_27.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_28.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_29.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_30.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_31.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_32.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_33.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_34.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_35.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_36.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_37.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_38.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_39.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_40.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_41.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_42.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_43.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_44.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_45.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_46.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_47.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_48.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_49.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_50.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_51.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_52.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_53.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_54.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_55.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_56.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_57.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_58.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_59.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_60.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_61.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_62.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_63.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_64.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_65.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKougoFile( "kg1955_66.txt" );

   return;
}  

//
// ̃XgKJVTEXT file nameǉ
//
void BibleAllBooks::AddAllKjvFile( void )
{
   BibleBook *bc;
   int i;

   i = 0;
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "01kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "02kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "03kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "04kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "05kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "06kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "07kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "08kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "09kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "10kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "11kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "12kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "13kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "14kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "15kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "16kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "17kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "18kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "19kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "20kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "21kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "22kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "23kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "24kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "25kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "26kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "27kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "28kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "29kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "30kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "31kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "32kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "33kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "34kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "35kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "36kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "37kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "38kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "39kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "40kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "41kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "42kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "43kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "44kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "45kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "46kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "47kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "48kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "49kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "50kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "51kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "52kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "53kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "54kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "55kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "56kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "57kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "58kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "59kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "60kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "61kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "62kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "63kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "64kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "65kjv_en_2004.txt" );
   bc = &_BibleList.at( i++ );  bc->SetKjvFile( "66kjv_en_2004.txt" );
                                                  
   return;                                        
}                                                 
           

//
// ̃XgISVxml nameǉ
//
void BibleAllBooks::AddAllIsvFile( void )
{
   BibleBook *bc;
   int i;

   i = 0;
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "01ge.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "02ex.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "03lev.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "04num.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "05deu.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "06jos.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "07jdg.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "08rut.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "09sa1.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "10sa2.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "11ki1.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "12ki2.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "13ch1.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "14ch2.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "15ezr.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "16neh.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "17est.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "18job.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "19psa.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "20pro.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "21ecc.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "22sos.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "23isa.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "24jer.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "25lam.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "26eze.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "27da.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "28hos.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "29joe.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "30amo.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "31oba.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "32jo.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "33mic.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "34nah.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "35hab.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "36zep.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "37hag.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "38zec.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "39mal.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "40mat.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "41mar.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "42luk.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "43joh.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "44act.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "45rom.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "46cor1.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "47cor2.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "48gal.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "49eph.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "50php.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "51col.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "52th1.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "53th2.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "54ti1.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "55ti2.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "56tit.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "57phm.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "58heb.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "59jam.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "60pe1.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "61pe2.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "62jo1.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "63jo2.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "64jo3.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "65jud.xml" );
   bc = &_BibleList.at( i++ );  bc->SetIsvFile( "66rev.xml" );
                                                  
   return;                                        
}                                                 
                                                  
                                                  
//
// ̃XgɊe͂̐ߐZbg
//
void BibleAllBooks::AddChapterVerseNumbers( void )
{
   BibleBook *bc;
   int iBook;

   //
   // 1 : nL
   //
   iBook = 0;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 31, false );
   bc->AddVerseNumbers( 25, false );
   bc->AddVerseNumbers( 24, false );
   bc->AddVerseNumbers( 26, false );
   bc->AddVerseNumbers( 32, false );
   bc->AddVerseNumbers( 22, false );
   bc->AddVerseNumbers( 24, false );
   bc->AddVerseNumbers( 22, false );
   bc->AddVerseNumbers( 29, false );
   bc->AddVerseNumbers( 32, false );
   bc->AddVerseNumbers( 32, false );
   bc->AddVerseNumbers( 20, false );
   bc->AddVerseNumbers( 18, false );
   bc->AddVerseNumbers( 24, false );
   bc->AddVerseNumbers( 21, false );
   bc->AddVerseNumbers( 16, false );
   bc->AddVerseNumbers( 27, false );
   bc->AddVerseNumbers( 33, false );
   bc->AddVerseNumbers( 38, false );
   bc->AddVerseNumbers( 18, false );
   bc->AddVerseNumbers( 34, false );
   bc->AddVerseNumbers( 24, false );
   bc->AddVerseNumbers( 20, false );
   bc->AddVerseNumbers( 67, false );
   bc->AddVerseNumbers( 34, false );
   bc->AddVerseNumbers( 35, false );
   bc->AddVerseNumbers( 46, false );
   bc->AddVerseNumbers( 22, false );
   bc->AddVerseNumbers( 35, false );
   bc->AddVerseNumbers( 43, false );
   bc->AddVerseNumbers( 55, false );
   bc->AddVerseNumbers( 32, false );
   bc->AddVerseNumbers( 20, false );
   bc->AddVerseNumbers( 31, false );
   bc->AddVerseNumbers( 29, false );
   bc->AddVerseNumbers( 43, false );
   bc->AddVerseNumbers( 36, false );
   bc->AddVerseNumbers( 30, false );
   bc->AddVerseNumbers( 23, false );
   bc->AddVerseNumbers( 23, false );
   bc->AddVerseNumbers( 57, false );
   bc->AddVerseNumbers( 38, false );
   bc->AddVerseNumbers( 34, false );
   bc->AddVerseNumbers( 34, false );
   bc->AddVerseNumbers( 28, false );
   bc->AddVerseNumbers( 34, false );
   bc->AddVerseNumbers( 31, false );
   bc->AddVerseNumbers( 22, false );
   bc->AddVerseNumbers( 33, false );
   bc->AddVerseNumbers( 26, false );
   
   //
   // 2 : oGWvgL
   //
   iBook = 1;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 22, false );
   bc->AddVerseNumbers( 25, false );
   bc->AddVerseNumbers( 22, false );
   bc->AddVerseNumbers( 31, false );
   bc->AddVerseNumbers( 23, false );
   bc->AddVerseNumbers( 30, false );
   bc->AddVerseNumbers( 25, false );
   bc->AddVerseNumbers( 32, false );
   bc->AddVerseNumbers( 35, false );
   bc->AddVerseNumbers( 29, false );
   bc->AddVerseNumbers( 10, false );
   bc->AddVerseNumbers( 51, false );
   bc->AddVerseNumbers( 22, false );
   bc->AddVerseNumbers( 31, false );
   bc->AddVerseNumbers( 27, false );
   bc->AddVerseNumbers( 36, false );
   bc->AddVerseNumbers( 16, false );
   bc->AddVerseNumbers( 27, false );
   bc->AddVerseNumbers( 25, false );
   bc->AddVerseNumbers( 26, false );
   bc->AddVerseNumbers( 36, false );
   bc->AddVerseNumbers( 31, false );
   bc->AddVerseNumbers( 33, false );
   bc->AddVerseNumbers( 18, false );
   bc->AddVerseNumbers( 40, false );
   bc->AddVerseNumbers( 37, false );
   bc->AddVerseNumbers( 21, false );
   bc->AddVerseNumbers( 43, false );
   bc->AddVerseNumbers( 46, false );
   bc->AddVerseNumbers( 38, false );
   bc->AddVerseNumbers( 18, false );
   bc->AddVerseNumbers( 35, false );
   bc->AddVerseNumbers( 23, false );
   bc->AddVerseNumbers( 35, false );
   bc->AddVerseNumbers( 35, false );
   bc->AddVerseNumbers( 38, false );
   bc->AddVerseNumbers( 29, false );
   bc->AddVerseNumbers( 31, false );
   bc->AddVerseNumbers( 43, false );
   bc->AddVerseNumbers( 38, false );
   
   //
   // 3 : rL
   //
   iBook = 2;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 17, false );
   bc->AddVerseNumbers( 16, false );
   bc->AddVerseNumbers( 17, false );
   bc->AddVerseNumbers( 35, false );
   bc->AddVerseNumbers( 19, false );
   bc->AddVerseNumbers( 30, false );
   bc->AddVerseNumbers( 38, false );
   bc->AddVerseNumbers( 36, false );
   bc->AddVerseNumbers( 24, false );
   bc->AddVerseNumbers( 20, false );
   bc->AddVerseNumbers( 47, false );
   bc->AddVerseNumbers( 8, false );
   bc->AddVerseNumbers( 59, false );
   bc->AddVerseNumbers( 57, false );
   bc->AddVerseNumbers( 33, false );
   bc->AddVerseNumbers( 34, false );
   bc->AddVerseNumbers( 16, false );
   bc->AddVerseNumbers( 30, false );
   bc->AddVerseNumbers( 37, false );
   bc->AddVerseNumbers( 27, false );
   bc->AddVerseNumbers( 24, false );
   bc->AddVerseNumbers( 33, false );
   bc->AddVerseNumbers( 44, false );
   bc->AddVerseNumbers( 23, false );
   bc->AddVerseNumbers( 55, false );
   bc->AddVerseNumbers( 46, false );
   bc->AddVerseNumbers( 34, false );
   
   //
   // 4 : L
   //
   iBook = 3;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 54, false );
   bc->AddVerseNumbers( 34, false );
   bc->AddVerseNumbers( 51, false );
   bc->AddVerseNumbers( 49, false );
   bc->AddVerseNumbers( 31, false );
   bc->AddVerseNumbers( 27, false );
   bc->AddVerseNumbers( 89, false );
   bc->AddVerseNumbers( 26, false );
   bc->AddVerseNumbers( 23, false );
   bc->AddVerseNumbers( 36, false );
   bc->AddVerseNumbers( 35, false );
   bc->AddVerseNumbers( 16, false );
   bc->AddVerseNumbers( 33, false );
   bc->AddVerseNumbers( 45, false );
   bc->AddVerseNumbers( 41, false );
   bc->AddVerseNumbers( 50, false );
   bc->AddVerseNumbers( 13, false );
   bc->AddVerseNumbers( 32, false );
   bc->AddVerseNumbers( 22, false );
   bc->AddVerseNumbers( 29, false );
   bc->AddVerseNumbers( 35, false );
   bc->AddVerseNumbers( 41, false );
   bc->AddVerseNumbers( 30, false );
   bc->AddVerseNumbers( 25, false );
   bc->AddVerseNumbers( 18, false );
   bc->AddVerseNumbers( 65, false );
   bc->AddVerseNumbers( 23, false );
   bc->AddVerseNumbers( 31, false );
   bc->AddVerseNumbers( 40, false );
   bc->AddVerseNumbers( 16, false );
   bc->AddVerseNumbers( 54, false );
   bc->AddVerseNumbers( 42, false );
   bc->AddVerseNumbers( 56, false );
   bc->AddVerseNumbers( 29, false );
   bc->AddVerseNumbers( 34, false );
   bc->AddVerseNumbers( 13, false );
   
   //
   // 5 : \L
   //
   iBook = 4;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 46, false );
   bc->AddVerseNumbers( 37, false );
   bc->AddVerseNumbers( 29, false );
   bc->AddVerseNumbers( 49, false );
   bc->AddVerseNumbers( 33, false );
   bc->AddVerseNumbers( 25, false );
   bc->AddVerseNumbers( 26, false );
   bc->AddVerseNumbers( 20, false );
   bc->AddVerseNumbers( 29, false );
   bc->AddVerseNumbers( 22, false );
   bc->AddVerseNumbers( 32, false );
   bc->AddVerseNumbers( 32, false );
   bc->AddVerseNumbers( 18, false );
   bc->AddVerseNumbers( 29, false );
   bc->AddVerseNumbers( 23, false );
   bc->AddVerseNumbers( 22, false );
   bc->AddVerseNumbers( 20, false );
   bc->AddVerseNumbers( 22, false );
   bc->AddVerseNumbers( 21, false );
   bc->AddVerseNumbers( 20, false );
   bc->AddVerseNumbers( 23, false );
   bc->AddVerseNumbers( 30, false );
   bc->AddVerseNumbers( 25, false );
   bc->AddVerseNumbers( 22, false );
   bc->AddVerseNumbers( 19, false );
   bc->AddVerseNumbers( 19, false );
   bc->AddVerseNumbers( 26, false );
   bc->AddVerseNumbers( 68, false );
   bc->AddVerseNumbers( 29, false );
   bc->AddVerseNumbers( 20, false );
   bc->AddVerseNumbers( 30, false );
   bc->AddVerseNumbers( 52, false );
   bc->AddVerseNumbers( 29, false );
   bc->AddVerseNumbers( 12, false );
   
   //
   // 6 : VAL
   //
   iBook = 5;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 18, false );
   bc->AddVerseNumbers( 24, false );
   bc->AddVerseNumbers( 17, false );
   bc->AddVerseNumbers( 24, false );
   bc->AddVerseNumbers( 15, false );
   bc->AddVerseNumbers( 27, false );
   bc->AddVerseNumbers( 26, false );
   bc->AddVerseNumbers( 35, false );
   bc->AddVerseNumbers( 27, false );
   bc->AddVerseNumbers( 43, false );
   bc->AddVerseNumbers( 23, false );
   bc->AddVerseNumbers( 24, false );
   bc->AddVerseNumbers( 33, false );
   bc->AddVerseNumbers( 15, false );
   bc->AddVerseNumbers( 63, false );
   bc->AddVerseNumbers( 10, false );
   bc->AddVerseNumbers( 18, false );
   bc->AddVerseNumbers( 28, false );
   bc->AddVerseNumbers( 51, false );
   bc->AddVerseNumbers( 9, false );
   bc->AddVerseNumbers( 45, false );
   bc->AddVerseNumbers( 34, false );
   bc->AddVerseNumbers( 16, false );
   bc->AddVerseNumbers( 33, false );
   
   //
   // 7 : mtL
   //
   iBook = 6;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 36, false );
   bc->AddVerseNumbers( 23, false );
   bc->AddVerseNumbers( 31, false );
   bc->AddVerseNumbers( 24, false );
   bc->AddVerseNumbers( 31, false );
   bc->AddVerseNumbers( 40, false );
   bc->AddVerseNumbers( 25, false );
   bc->AddVerseNumbers( 35, false );
   bc->AddVerseNumbers( 57, false );
   bc->AddVerseNumbers( 18, false );
   bc->AddVerseNumbers( 40, false );
   bc->AddVerseNumbers( 15, false );
   bc->AddVerseNumbers( 25, false );
   bc->AddVerseNumbers( 20, false );
   bc->AddVerseNumbers( 20, false );
   bc->AddVerseNumbers( 31, false );
   bc->AddVerseNumbers( 13, false );
   bc->AddVerseNumbers( 31, false );
   bc->AddVerseNumbers( 30, false );
   bc->AddVerseNumbers( 48, false );
   bc->AddVerseNumbers( 25, false );
   
   //
   // 8 : cL
   //
   iBook = 7;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 22, false );
   bc->AddVerseNumbers( 23, false );
   bc->AddVerseNumbers( 18, false );
   bc->AddVerseNumbers( 22, false );
   
   //
   // 9 : TGL 
   //
   iBook = 8;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 28, false ); // 1
   bc->AddVerseNumbers( 36, false ); // 2
   bc->AddVerseNumbers( 21, false ); // 3
   bc->AddVerseNumbers( 22, false ); // 4
   bc->AddVerseNumbers( 12, false ); // 5
   bc->AddVerseNumbers( 21, false ); // 6
   bc->AddVerseNumbers( 17, false ); // 7
   bc->AddVerseNumbers( 22, false ); // 8
   bc->AddVerseNumbers( 27, false ); // 9
   bc->AddVerseNumbers( 27, false ); // 10
   bc->AddVerseNumbers( 15, false ); // 11
   bc->AddVerseNumbers( 25, false ); // 12
   bc->AddVerseNumbers( 23, false ); // 13
   bc->AddVerseNumbers( 52, false ); // 14
   bc->AddVerseNumbers( 35, false ); // 15
   bc->AddVerseNumbers( 23, false ); // 16
   bc->AddVerseNumbers( 58, false ); // 17
   bc->AddVerseNumbers( 30, false ); // 18
   bc->AddVerseNumbers( 24, false ); // 19
   bc->AddVerseNumbers( 42, false ); // 20
   bc->AddVerseNumbers( 15, false ); // 21
   bc->AddVerseNumbers( 23, false ); // 22
   bc->AddVerseNumbers( 29, false ); // 23
   bc->AddVerseNumbers( 22, false ); // 24
   bc->AddVerseNumbers( 44, false ); // 25
   bc->AddVerseNumbers( 25, false ); // 26
   bc->AddVerseNumbers( 12, false ); // 27
   bc->AddVerseNumbers( 25, false ); // 28
   bc->AddVerseNumbers( 11, false ); // 29
   bc->AddVerseNumbers( 31, false ); // 30
   bc->AddVerseNumbers( 13, false ); // 31
                                     
   //                                
   // 10 : TGL            
   //                                
   iBook = 9;                        
   bc = &_BibleList.at( iBook );     
   bc->ClearVerseNumbers( );         
   bc->AddVerseNumbers( 27, false ); 
   bc->AddVerseNumbers( 32, false );
   bc->AddVerseNumbers( 39, false );
   bc->AddVerseNumbers( 12, false );
   bc->AddVerseNumbers( 25, false );
   bc->AddVerseNumbers( 23, false );
   bc->AddVerseNumbers( 29, false );
   bc->AddVerseNumbers( 18, false );
   bc->AddVerseNumbers( 13, false );
   bc->AddVerseNumbers( 19, false );
   bc->AddVerseNumbers( 27, false );
   bc->AddVerseNumbers( 31, false );
   bc->AddVerseNumbers( 39, false );
   bc->AddVerseNumbers( 33, false );
   bc->AddVerseNumbers( 37, false );
   bc->AddVerseNumbers( 23, false );
   bc->AddVerseNumbers( 29, false );
   bc->AddVerseNumbers( 33, false );
   bc->AddVerseNumbers( 43, false );
   bc->AddVerseNumbers( 26, false );
   bc->AddVerseNumbers( 22, false );
   bc->AddVerseNumbers( 51, false );
   bc->AddVerseNumbers( 39, false );
   bc->AddVerseNumbers( 25, false );
   
   //
   // 11 : 񉤋L 
   //
   iBook = 10;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 53, false );
   bc->AddVerseNumbers( 46, false );
   bc->AddVerseNumbers( 28, false );
   bc->AddVerseNumbers( 34, false );
   bc->AddVerseNumbers( 18, false );
   bc->AddVerseNumbers( 38, false );
   bc->AddVerseNumbers( 51, false );
   bc->AddVerseNumbers( 66, false );
   bc->AddVerseNumbers( 28, false );
   bc->AddVerseNumbers( 29, false );
   bc->AddVerseNumbers( 43, false );
   bc->AddVerseNumbers( 33, false );
   bc->AddVerseNumbers( 34, false );
   bc->AddVerseNumbers( 31, false );
   bc->AddVerseNumbers( 34, false );
   bc->AddVerseNumbers( 34, false );
   bc->AddVerseNumbers( 24, false );
   bc->AddVerseNumbers( 46, false );
   bc->AddVerseNumbers( 21, false );
   bc->AddVerseNumbers( 43, false );
   bc->AddVerseNumbers( 29, false );
   bc->AddVerseNumbers( 53, false );
   
   //
   // 12 : 񉤋L 
   //
   iBook = 11;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 18, false );
   bc->AddVerseNumbers( 25, false );
   bc->AddVerseNumbers( 27, false );
   bc->AddVerseNumbers( 44, false );
   bc->AddVerseNumbers( 27, false );
   bc->AddVerseNumbers( 33, false );
   bc->AddVerseNumbers( 20, false );
   bc->AddVerseNumbers( 29, false );
   bc->AddVerseNumbers( 37, false );
   bc->AddVerseNumbers( 36, false );
   bc->AddVerseNumbers( 21, false );
   bc->AddVerseNumbers( 21, false );
   bc->AddVerseNumbers( 25, false );
   bc->AddVerseNumbers( 29, false );
   bc->AddVerseNumbers( 38, false );
   bc->AddVerseNumbers( 20, false );
   bc->AddVerseNumbers( 41, false );
   bc->AddVerseNumbers( 37, false );
   bc->AddVerseNumbers( 37, false );
   bc->AddVerseNumbers( 21, false );
   bc->AddVerseNumbers( 26, false );
   bc->AddVerseNumbers( 20, false );
   bc->AddVerseNumbers( 37, false );
   bc->AddVerseNumbers( 20, false );
   bc->AddVerseNumbers( 30, false );
   
   //
   // 13 : ㎏ 
   //
   iBook = 12;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 54, false );
   bc->AddVerseNumbers( 55, false );
   bc->AddVerseNumbers( 24, false );
   bc->AddVerseNumbers( 43, false );
   bc->AddVerseNumbers( 26, false );
   bc->AddVerseNumbers( 81, false );
   bc->AddVerseNumbers( 40, false );
   bc->AddVerseNumbers( 40, false );
   bc->AddVerseNumbers( 44, false );
   bc->AddVerseNumbers( 14, false );
   bc->AddVerseNumbers( 47, false );
   bc->AddVerseNumbers( 40, false );
   bc->AddVerseNumbers( 14, false );
   bc->AddVerseNumbers( 17, false );
   bc->AddVerseNumbers( 29, false );
   bc->AddVerseNumbers( 43, false );
   bc->AddVerseNumbers( 27, false );
   bc->AddVerseNumbers( 17, false );
   bc->AddVerseNumbers( 19, false );
   bc->AddVerseNumbers(  8, false );
   bc->AddVerseNumbers( 30, false );
   bc->AddVerseNumbers( 19, false );
   bc->AddVerseNumbers( 32, false );
   bc->AddVerseNumbers( 31, false );
   bc->AddVerseNumbers( 31, false );
   bc->AddVerseNumbers( 32, false );
   bc->AddVerseNumbers( 34, false );
   bc->AddVerseNumbers( 21, false );
   bc->AddVerseNumbers( 30, false );
   
   //
   // 14 : ㎏ 
   //
   iBook = 13;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 17, false );
   bc->AddVerseNumbers( 18, false );
   bc->AddVerseNumbers( 17, false );
   bc->AddVerseNumbers( 22, false );
   bc->AddVerseNumbers( 14, false );
   bc->AddVerseNumbers( 42, false );
   bc->AddVerseNumbers( 22, false );
   bc->AddVerseNumbers( 18, false );
   bc->AddVerseNumbers( 31, false );
   bc->AddVerseNumbers( 19, false );
   bc->AddVerseNumbers( 23, false );
   bc->AddVerseNumbers( 16, false );
   bc->AddVerseNumbers( 22, false );
   bc->AddVerseNumbers( 15, false );
   bc->AddVerseNumbers( 19, false );
   bc->AddVerseNumbers( 14, false );
   bc->AddVerseNumbers( 19, false );
   bc->AddVerseNumbers( 34, false );
   bc->AddVerseNumbers( 11, false );
   bc->AddVerseNumbers( 37, false );
   bc->AddVerseNumbers( 20, false );
   bc->AddVerseNumbers( 12, false );
   bc->AddVerseNumbers( 21, false );
   bc->AddVerseNumbers( 27, false );
   bc->AddVerseNumbers( 28, false );
   bc->AddVerseNumbers( 23, false );
   bc->AddVerseNumbers(  9, false );
   bc->AddVerseNumbers( 27, false );
   bc->AddVerseNumbers( 36, false );
   bc->AddVerseNumbers( 27, false );
   bc->AddVerseNumbers( 21, false );
   bc->AddVerseNumbers( 33, false );
   bc->AddVerseNumbers( 25, false );
   bc->AddVerseNumbers( 33, false );
   bc->AddVerseNumbers( 27, false );
   bc->AddVerseNumbers( 23, false );
   
   //
   // 15 : GYL
   //
   iBook = 14;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 11, false );
   bc->AddVerseNumbers( 70, false );
   bc->AddVerseNumbers( 13, false );
   bc->AddVerseNumbers( 24, false );
   bc->AddVerseNumbers( 17, false );
   bc->AddVerseNumbers( 22, false );
   bc->AddVerseNumbers( 28, false );
   bc->AddVerseNumbers( 36, false );
   bc->AddVerseNumbers( 15, false );
   bc->AddVerseNumbers( 44, false );
   
   //
   // 16 : lw~L
   //
   iBook = 15;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 11, false );
   bc->AddVerseNumbers( 20, false );
   bc->AddVerseNumbers( 32, false );
   bc->AddVerseNumbers( 23, false );
   bc->AddVerseNumbers( 19, false );
   bc->AddVerseNumbers( 19, false );
   bc->AddVerseNumbers( 73, false );
   bc->AddVerseNumbers( 18, false );
   bc->AddVerseNumbers( 38, false );
   bc->AddVerseNumbers( 39, false );
   bc->AddVerseNumbers( 36, false );
   bc->AddVerseNumbers( 47, false );
   bc->AddVerseNumbers( 31, false );
   
   //
   // 17 : GXeL
   //
   iBook = 16;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 22, false );
   bc->AddVerseNumbers( 23, false );
   bc->AddVerseNumbers( 15, false );
   bc->AddVerseNumbers( 17, false );
   bc->AddVerseNumbers( 14, false );
   bc->AddVerseNumbers( 14, false );
   bc->AddVerseNumbers( 10, false );
   bc->AddVerseNumbers( 17, false );
   bc->AddVerseNumbers( 32, false );
   bc->AddVerseNumbers( 3, false );
   
   //
   // 18 : uL
   //
   iBook = 17;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 22, false );
   bc->AddVerseNumbers( 13, false );
   bc->AddVerseNumbers( 26, false );
   bc->AddVerseNumbers( 21, false );
   bc->AddVerseNumbers( 27, false );
   bc->AddVerseNumbers( 30, false );
   bc->AddVerseNumbers( 21, false );
   bc->AddVerseNumbers( 22, false );
   bc->AddVerseNumbers( 35, false );
   bc->AddVerseNumbers( 22, false );
   bc->AddVerseNumbers( 20, false );
   bc->AddVerseNumbers( 25, false );
   bc->AddVerseNumbers( 28, false );
   bc->AddVerseNumbers( 22, false );
   bc->AddVerseNumbers( 35, false );
   bc->AddVerseNumbers( 22, false );
   bc->AddVerseNumbers( 16, false );
   bc->AddVerseNumbers( 21, false );
   bc->AddVerseNumbers( 29, false );
   bc->AddVerseNumbers( 29, false );
   bc->AddVerseNumbers( 34, false );
   bc->AddVerseNumbers( 30, false );
   bc->AddVerseNumbers( 17, false );
   bc->AddVerseNumbers( 25, false );
   bc->AddVerseNumbers( 6, false );
   bc->AddVerseNumbers( 14, false );
   bc->AddVerseNumbers( 23, false );
   bc->AddVerseNumbers( 28, false );
   bc->AddVerseNumbers( 25, false );
   bc->AddVerseNumbers( 31, false );
   bc->AddVerseNumbers( 40, false );
   bc->AddVerseNumbers( 22, false );
   bc->AddVerseNumbers( 33, false );
   bc->AddVerseNumbers( 37, false );
   bc->AddVerseNumbers( 16, false );
   bc->AddVerseNumbers( 33, false );
   bc->AddVerseNumbers( 24, false );
   bc->AddVerseNumbers( 41, false );
   bc->AddVerseNumbers( 30, false );
   bc->AddVerseNumbers( 24, false );
   bc->AddVerseNumbers( 34, false );
   bc->AddVerseNumbers( 17, false );
   
   //
   // 19 : 
   //
   iBook = 18;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 6, false );    // 1
   bc->AddVerseNumbers( 12, false );   // 2 
   bc->AddVerseNumbers( 8, true );     // 3
   bc->AddVerseNumbers( 8, true );     // 4
   bc->AddVerseNumbers( 12, true );    // 5
   bc->AddVerseNumbers( 10, true );    // 6
   bc->AddVerseNumbers( 17, true );    // 7
   bc->AddVerseNumbers( 9, true );     // 8
   bc->AddVerseNumbers( 20, true );    // 9
   bc->AddVerseNumbers( 18, false );   // 10

   bc->AddVerseNumbers( 7, true );     // 11 
   bc->AddVerseNumbers( 8, true );     // 12
   bc->AddVerseNumbers( 6, true );     // 13
   bc->AddVerseNumbers( 7, true );     // 14
   bc->AddVerseNumbers( 5, true );     // 15
   bc->AddVerseNumbers( 11, true );    // 16
   bc->AddVerseNumbers( 15, true );    // 17
   bc->AddVerseNumbers( 50, true );    // 18
   bc->AddVerseNumbers( 14, true );    // 19
   bc->AddVerseNumbers( 9, true );     // 20

   bc->AddVerseNumbers( 13, true );    // 21
   bc->AddVerseNumbers( 31, true );    // 22
   bc->AddVerseNumbers( 6, true );     // 23
   bc->AddVerseNumbers( 10, true );    // 24
   bc->AddVerseNumbers( 22, true );   // 25
   bc->AddVerseNumbers( 12, true );    // 26
   bc->AddVerseNumbers( 14, true );    // 27
   bc->AddVerseNumbers( 9, true );     // 28
   bc->AddVerseNumbers( 11, true );    // 29
   bc->AddVerseNumbers( 12, true );    // 30

   bc->AddVerseNumbers( 24, true );    // 31
   bc->AddVerseNumbers( 11, true );    // 32
   bc->AddVerseNumbers( 22, false );   // 33
   bc->AddVerseNumbers( 22, true );    // 34
   bc->AddVerseNumbers( 28, true );    // 35
   bc->AddVerseNumbers( 12, true );    // 36
   bc->AddVerseNumbers( 40, true );    // 37
   bc->AddVerseNumbers( 22, true );    // 38
   bc->AddVerseNumbers( 13, true );    // 39
   bc->AddVerseNumbers( 17, true );    // 40

   bc->AddVerseNumbers( 13, true );    // 41
   bc->AddVerseNumbers( 11, true );    // 42
   bc->AddVerseNumbers( 5, false );    // 43
   bc->AddVerseNumbers( 26, true );    // 44
   bc->AddVerseNumbers( 17, true );    // 45
   bc->AddVerseNumbers( 11, true );    // 46
   bc->AddVerseNumbers( 10, true );    // 47
   bc->AddVerseNumbers( 14, true );    // 48
   bc->AddVerseNumbers( 20, true );    // 49
   bc->AddVerseNumbers( 23, true );    // 50

   bc->AddVerseNumbers( 19, true );    // 51
   bc->AddVerseNumbers( 9, true );     // 52
   bc->AddVerseNumbers( 6, true );     // 53
   bc->AddVerseNumbers( 7, true );     // 54
   bc->AddVerseNumbers( 23, true );    // 55
   bc->AddVerseNumbers( 13, true );    // 56
   bc->AddVerseNumbers( 11, true );    // 57
   bc->AddVerseNumbers( 11, true );    // 58
   bc->AddVerseNumbers( 17, true );    // 59
   bc->AddVerseNumbers( 12, true );    // 60

   bc->AddVerseNumbers( 8, true );     // 61
   bc->AddVerseNumbers( 12, true );    // 62
   bc->AddVerseNumbers( 11, true );    // 63
   bc->AddVerseNumbers( 10, true );    // 64
   bc->AddVerseNumbers( 13, true );    // 65
   bc->AddVerseNumbers( 20, true );    // 66
   bc->AddVerseNumbers( 7, true );     // 67
   bc->AddVerseNumbers( 35, true );    // 68
   bc->AddVerseNumbers( 36, true );    // 69
   bc->AddVerseNumbers( 5, true );     // 70

   bc->AddVerseNumbers( 24, false );   // 71
   bc->AddVerseNumbers( 20, true );    // 72
   bc->AddVerseNumbers( 28, true );    // 73
   bc->AddVerseNumbers( 23, true );    // 74
   bc->AddVerseNumbers( 10, true );    // 75
   bc->AddVerseNumbers( 12, true );    // 76
   bc->AddVerseNumbers( 20, true );    // 77
   bc->AddVerseNumbers( 72, true );    // 78
   bc->AddVerseNumbers( 13, true );    // 79
   bc->AddVerseNumbers( 19, true );    // 80

   bc->AddVerseNumbers( 16, true );    // 81
   bc->AddVerseNumbers( 8, true );     // 82
   bc->AddVerseNumbers( 18, true );    // 83
   bc->AddVerseNumbers( 12, true );    // 84
   bc->AddVerseNumbers( 13, true );    // 85
   bc->AddVerseNumbers( 17, true );    // 86
   bc->AddVerseNumbers( 7, true );     // 87
   bc->AddVerseNumbers( 18, true );    // 88
   bc->AddVerseNumbers( 52, true );    // 89
   bc->AddVerseNumbers( 17, true );    // 90

   bc->AddVerseNumbers( 16, false );   // 91
   bc->AddVerseNumbers( 15, true );    // 92
   bc->AddVerseNumbers( 5, false );    // 93
   bc->AddVerseNumbers( 23, false );   // 94
   bc->AddVerseNumbers( 11, false );   // 95
   bc->AddVerseNumbers( 13, false );   // 96
   bc->AddVerseNumbers( 12, false );   // 97
   bc->AddVerseNumbers( 9, true );     // 98
   bc->AddVerseNumbers( 9, false );    // 99
   bc->AddVerseNumbers( 5, true );     // 100

   bc->AddVerseNumbers( 8, true );     // 101
   bc->AddVerseNumbers( 28, true );    // 102
   bc->AddVerseNumbers( 22, true );    // 103
   bc->AddVerseNumbers( 35, false );   // 104
   bc->AddVerseNumbers( 45, false );   // 105
   bc->AddVerseNumbers( 48, false );   // 106
   bc->AddVerseNumbers( 43, false );   // 107
   bc->AddVerseNumbers( 13, true );    // 108
   bc->AddVerseNumbers( 31, true );    // 109
   bc->AddVerseNumbers( 7, true );     // 110

   bc->AddVerseNumbers( 10, false );   // 111
   bc->AddVerseNumbers( 10, false );   // 112
   bc->AddVerseNumbers( 9, false );    // 113
   bc->AddVerseNumbers( 8, false );    // 114
   bc->AddVerseNumbers( 18, false );   // 115
   bc->AddVerseNumbers( 19, false );   // 116
   bc->AddVerseNumbers( 2, false );    // 117
   bc->AddVerseNumbers( 29, false );   // 118
   bc->AddVerseNumbers( 176, false );   // 119
   bc->AddVerseNumbers( 7, true );     // 120
                                          
   bc->AddVerseNumbers( 8, true );     // 121
   bc->AddVerseNumbers( 9, true );     // 122
   bc->AddVerseNumbers( 4, true );     // 123
   bc->AddVerseNumbers( 8, true );     // 124
   bc->AddVerseNumbers( 5, true );     // 125
   bc->AddVerseNumbers( 6, true );     // 126
   bc->AddVerseNumbers( 5, true );     // 127
   bc->AddVerseNumbers( 6, true );     // 128
   bc->AddVerseNumbers( 8, true );     // 129
   bc->AddVerseNumbers( 8, true );     // 130
                                          
   bc->AddVerseNumbers( 3, true );     // 131
   bc->AddVerseNumbers( 18, true );    // 132
   bc->AddVerseNumbers( 3, true );     // 133
   bc->AddVerseNumbers( 3, true );     // 134
   bc->AddVerseNumbers( 21, false );   // 135
   bc->AddVerseNumbers( 26, false );   // 136
   bc->AddVerseNumbers( 9, false );    // 137
   bc->AddVerseNumbers( 8, true );     // 138
   bc->AddVerseNumbers( 24, true );    // 139
   bc->AddVerseNumbers( 13, true );    // 140
                                          
   bc->AddVerseNumbers( 10, true );    // 141
   bc->AddVerseNumbers( 7, true );     // 142
   bc->AddVerseNumbers( 12, true );    // 143
   bc->AddVerseNumbers( 15, true );    // 144
   bc->AddVerseNumbers( 21, true );    // 145
   bc->AddVerseNumbers( 10, false );   // 146
   bc->AddVerseNumbers( 20, false );   // 147
   bc->AddVerseNumbers( 14, false );   // 148
   bc->AddVerseNumbers( 9, false );    // 149
   bc->AddVerseNumbers( 6, false );    // 150
   
   //
   // 20 : ⼌
   //
   iBook = 19;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 33, false );
   bc->AddVerseNumbers( 22, false );
   bc->AddVerseNumbers( 35, false );
   bc->AddVerseNumbers( 27, false );
   bc->AddVerseNumbers( 23, false );
   bc->AddVerseNumbers( 35, false );
   bc->AddVerseNumbers( 27, false );
   bc->AddVerseNumbers( 36, false );
   bc->AddVerseNumbers( 18, false );
   bc->AddVerseNumbers( 32, false );
   bc->AddVerseNumbers( 31, false );
   bc->AddVerseNumbers( 28, false );
   bc->AddVerseNumbers( 25, false );
   bc->AddVerseNumbers( 35, false );
   bc->AddVerseNumbers( 33, false );
   bc->AddVerseNumbers( 33, false );
   bc->AddVerseNumbers( 28, false );
   bc->AddVerseNumbers( 24, false );
   bc->AddVerseNumbers( 29, false );
   bc->AddVerseNumbers( 30, false );
   bc->AddVerseNumbers( 31, false );
   bc->AddVerseNumbers( 29, false );
   bc->AddVerseNumbers( 35, false );
   bc->AddVerseNumbers( 34, false );
   bc->AddVerseNumbers( 28, false );
   bc->AddVerseNumbers( 28, false );
   bc->AddVerseNumbers( 27, false );
   bc->AddVerseNumbers( 28, false );
   bc->AddVerseNumbers( 27, false );
   bc->AddVerseNumbers( 33, false );
   bc->AddVerseNumbers( 31, false );
   
   //
   // 21 : `҂̏
   //
   iBook = 20;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 18, false );
   bc->AddVerseNumbers( 26, false );
   bc->AddVerseNumbers( 22, false );
   bc->AddVerseNumbers( 16, false );
   bc->AddVerseNumbers( 20, false );
   bc->AddVerseNumbers( 12, false );
   bc->AddVerseNumbers( 29, false );
   bc->AddVerseNumbers( 17, false );
   bc->AddVerseNumbers( 18, false );
   bc->AddVerseNumbers( 20, false );
   bc->AddVerseNumbers( 10, false );
   bc->AddVerseNumbers( 14, false );
   
   //
   // 22 : 
   //
   iBook = 21;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 17, false );
   bc->AddVerseNumbers( 17, false );
   bc->AddVerseNumbers( 11, false );
   bc->AddVerseNumbers( 16, false );
   bc->AddVerseNumbers( 16, false );
   bc->AddVerseNumbers( 13, false );
   bc->AddVerseNumbers( 13, false );
   bc->AddVerseNumbers( 14, false );
   
   //
   // 23 : CU
   //
   iBook = 22;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 31, false );
   bc->AddVerseNumbers( 22, false );
   bc->AddVerseNumbers( 26, false );
   bc->AddVerseNumbers( 6, false );
   bc->AddVerseNumbers( 30, false );
   bc->AddVerseNumbers( 13, false );
   bc->AddVerseNumbers( 25, false );
   bc->AddVerseNumbers( 22, false );
   bc->AddVerseNumbers( 21, false );
   bc->AddVerseNumbers( 34, false );
   bc->AddVerseNumbers( 16, false );
   bc->AddVerseNumbers( 6, false );
   bc->AddVerseNumbers( 22, false );
   bc->AddVerseNumbers( 32, false );
   bc->AddVerseNumbers( 9, false );
   bc->AddVerseNumbers( 14, false );
   bc->AddVerseNumbers( 14, false );
   bc->AddVerseNumbers( 7, false );
   bc->AddVerseNumbers( 25, false );
   bc->AddVerseNumbers( 6, false );
   bc->AddVerseNumbers( 17, false );
   bc->AddVerseNumbers( 25, false );
   bc->AddVerseNumbers( 18, false );
   bc->AddVerseNumbers( 23, false );
   bc->AddVerseNumbers( 12, false );
   bc->AddVerseNumbers( 21, false );
   bc->AddVerseNumbers( 13, false );
   bc->AddVerseNumbers( 29, false );
   bc->AddVerseNumbers( 24, false );
   bc->AddVerseNumbers( 33, false );
   bc->AddVerseNumbers( 9, false );
   bc->AddVerseNumbers( 20, false );
   bc->AddVerseNumbers( 24, false );
   bc->AddVerseNumbers( 17, false );
   bc->AddVerseNumbers( 10, false );
   bc->AddVerseNumbers( 22, false );
   bc->AddVerseNumbers( 38, false );
   bc->AddVerseNumbers( 22, false );
   bc->AddVerseNumbers( 8, false );
   bc->AddVerseNumbers( 31, false );
   bc->AddVerseNumbers( 29, false );
   bc->AddVerseNumbers( 25, false );
   bc->AddVerseNumbers( 28, false );
   bc->AddVerseNumbers( 28, false );
   bc->AddVerseNumbers( 25, false );
   bc->AddVerseNumbers( 13, false );
   bc->AddVerseNumbers( 15, false );
   bc->AddVerseNumbers( 22, false );
   bc->AddVerseNumbers( 26, false );
   bc->AddVerseNumbers( 11, false );
   bc->AddVerseNumbers( 23, false );
   bc->AddVerseNumbers( 15, false );
   bc->AddVerseNumbers( 12, false );
   bc->AddVerseNumbers( 17, false );
   bc->AddVerseNumbers( 13, false );
   bc->AddVerseNumbers( 12, false );
   bc->AddVerseNumbers( 21, false );
   bc->AddVerseNumbers( 14, false );
   bc->AddVerseNumbers( 21, false );
   bc->AddVerseNumbers( 22, false );
   bc->AddVerseNumbers( 11, false );
   bc->AddVerseNumbers( 12, false );
   bc->AddVerseNumbers( 19, false );
   bc->AddVerseNumbers( 12, false );
   bc->AddVerseNumbers( 25, false );
   bc->AddVerseNumbers( 24, false );
   
   //
   // 24 : G~
   //
   iBook = 23;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 19, false );
   bc->AddVerseNumbers( 37, false );
   bc->AddVerseNumbers( 25, false );
   bc->AddVerseNumbers( 31, false );
   bc->AddVerseNumbers( 31, false );
   bc->AddVerseNumbers( 30, false );
   bc->AddVerseNumbers( 34, false );
   bc->AddVerseNumbers( 22, false );
   bc->AddVerseNumbers( 26, false );
   bc->AddVerseNumbers( 25, false );
   bc->AddVerseNumbers( 23, false );
   bc->AddVerseNumbers( 17, false );
   bc->AddVerseNumbers( 27, false );
   bc->AddVerseNumbers( 22, false );
   bc->AddVerseNumbers( 21, false );
   bc->AddVerseNumbers( 21, false );
   bc->AddVerseNumbers( 27, false );
   bc->AddVerseNumbers( 23, false );
   bc->AddVerseNumbers( 15, false );
   bc->AddVerseNumbers( 18, false );
   bc->AddVerseNumbers( 14, false );
   bc->AddVerseNumbers( 30, false );
   bc->AddVerseNumbers( 40, false );
   bc->AddVerseNumbers( 10, false );
   bc->AddVerseNumbers( 38, false );
   bc->AddVerseNumbers( 24, false );
   bc->AddVerseNumbers( 22, false );
   bc->AddVerseNumbers( 17, false );
   bc->AddVerseNumbers( 32, false );
   bc->AddVerseNumbers( 24, false );
   bc->AddVerseNumbers( 40, false );
   bc->AddVerseNumbers( 44, false );
   bc->AddVerseNumbers( 26, false );
   bc->AddVerseNumbers( 22, false );
   bc->AddVerseNumbers( 19, false );
   bc->AddVerseNumbers( 32, false );
   bc->AddVerseNumbers( 21, false );
   bc->AddVerseNumbers( 28, false );
   bc->AddVerseNumbers( 18, false );
   bc->AddVerseNumbers( 16, false );
   bc->AddVerseNumbers( 18, false );
   bc->AddVerseNumbers( 22, false );
   bc->AddVerseNumbers( 13, false );
   bc->AddVerseNumbers( 30, false );
   bc->AddVerseNumbers( 5, false );
   bc->AddVerseNumbers( 28, false );
   bc->AddVerseNumbers( 7, false );
   bc->AddVerseNumbers( 47, false );
   bc->AddVerseNumbers( 39, false );
   bc->AddVerseNumbers( 46, false );
   bc->AddVerseNumbers( 64, false );
   bc->AddVerseNumbers( 34, false );
   
   //
   // 25 : 
   //
   iBook = 24;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 22, false );
   bc->AddVerseNumbers( 22, false );
   bc->AddVerseNumbers( 66, false );
   bc->AddVerseNumbers( 22, false );
   bc->AddVerseNumbers( 22, false );
   
   //
   // 26 : G[LG
   //
   iBook = 25;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 28, false );
   bc->AddVerseNumbers( 10, false );
   bc->AddVerseNumbers( 27, false );
   bc->AddVerseNumbers( 17, false );
   bc->AddVerseNumbers( 17, false );
   bc->AddVerseNumbers( 14, false );
   bc->AddVerseNumbers( 27, false );
   bc->AddVerseNumbers( 18, false );
   bc->AddVerseNumbers( 11, false );
   bc->AddVerseNumbers( 22, false );
   bc->AddVerseNumbers( 25, false );
   bc->AddVerseNumbers( 28, false );
   bc->AddVerseNumbers( 23, false );
   bc->AddVerseNumbers( 23, false );
   bc->AddVerseNumbers( 8, false );
   bc->AddVerseNumbers( 63, false );
   bc->AddVerseNumbers( 24, false );
   bc->AddVerseNumbers( 32, false );
   bc->AddVerseNumbers( 14, false );
   bc->AddVerseNumbers( 49, false );
   bc->AddVerseNumbers( 32, false );
   bc->AddVerseNumbers( 31, false );
   bc->AddVerseNumbers( 49, false );
   bc->AddVerseNumbers( 27, false );
   bc->AddVerseNumbers( 17, false );
   bc->AddVerseNumbers( 21, false );
   bc->AddVerseNumbers( 36, false );
   bc->AddVerseNumbers( 26, false );
   bc->AddVerseNumbers( 21, false );
   bc->AddVerseNumbers( 26, false );
   bc->AddVerseNumbers( 18, false );
   bc->AddVerseNumbers( 32, false );
   bc->AddVerseNumbers( 33, false );
   bc->AddVerseNumbers( 31, false );
   bc->AddVerseNumbers( 15, false );
   bc->AddVerseNumbers( 38, false );
   bc->AddVerseNumbers( 28, false );
   bc->AddVerseNumbers( 23, false );
   bc->AddVerseNumbers( 29, false );
   bc->AddVerseNumbers( 49, false );
   bc->AddVerseNumbers( 26, false );
   bc->AddVerseNumbers( 20, false );
   bc->AddVerseNumbers( 27, false );
   bc->AddVerseNumbers( 31, false );
   bc->AddVerseNumbers( 25, false );
   bc->AddVerseNumbers( 24, false );
   bc->AddVerseNumbers( 23, false );
   bc->AddVerseNumbers( 35, false );
   
   //
   // 27 : _jG
   //
   iBook = 26;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 21, false );
   bc->AddVerseNumbers( 49, false );
   bc->AddVerseNumbers( 30, false );
   bc->AddVerseNumbers( 37, false );
   bc->AddVerseNumbers( 31, false );
   bc->AddVerseNumbers( 28, false );
   bc->AddVerseNumbers( 28, false );
   bc->AddVerseNumbers( 27, false );
   bc->AddVerseNumbers( 27, false );
   bc->AddVerseNumbers( 21, false );
   bc->AddVerseNumbers( 45, false );
   bc->AddVerseNumbers( 13, false );
   
   //
   // 28 : zZA
   //
   iBook = 27;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 11, false );
   bc->AddVerseNumbers( 23, false );
   bc->AddVerseNumbers( 5, false );
   bc->AddVerseNumbers( 19, false );
   bc->AddVerseNumbers( 15, false );
   bc->AddVerseNumbers( 11, false );
   bc->AddVerseNumbers( 16, false );
   bc->AddVerseNumbers( 14, false );
   bc->AddVerseNumbers( 17, false );
   bc->AddVerseNumbers( 15, false );
   bc->AddVerseNumbers( 12, false );
   bc->AddVerseNumbers( 14, false );
   bc->AddVerseNumbers( 16, false );
   bc->AddVerseNumbers( 9, false );
   
   //
   // 29 : G
   //
   iBook = 28;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 20, false );
   bc->AddVerseNumbers( 32, false );
   bc->AddVerseNumbers( 21, false );
   
   //
   // 30 : AX
   //
   iBook = 29;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 15, false );
   bc->AddVerseNumbers( 16, false );
   bc->AddVerseNumbers( 15, false );
   bc->AddVerseNumbers( 13, false );
   bc->AddVerseNumbers( 27, false );
   bc->AddVerseNumbers( 14, false );
   bc->AddVerseNumbers( 17, false );
   bc->AddVerseNumbers( 14, false );
   bc->AddVerseNumbers( 15, false );
   
   //
   // 31 : Iof
   //
   iBook = 30;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 21, false );
   
   //
   // 32 : i
   //
   iBook = 31;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 17, false );
   bc->AddVerseNumbers( 10, false );
   bc->AddVerseNumbers( 10, false );
   bc->AddVerseNumbers( 11, false );
   
   //
   // 33 : ~J
   //
   iBook = 32;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 16, false );
   bc->AddVerseNumbers( 13, false );
   bc->AddVerseNumbers( 12, false );
   bc->AddVerseNumbers( 13, false );
   bc->AddVerseNumbers( 15, false );
   bc->AddVerseNumbers( 16, false );
   bc->AddVerseNumbers( 20, false );
   
   //
   // 34 : iz
   //
   iBook = 33;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 15, false );
   bc->AddVerseNumbers( 13, false );
   bc->AddVerseNumbers( 19, false );
   
   //
   // 35 : noNN
   //
   iBook = 34;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 17, false );
   bc->AddVerseNumbers( 20, false );
   bc->AddVerseNumbers( 19, false );
   
   //
   // 36 : [pj
   //
   iBook = 35;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 18, false );
   bc->AddVerseNumbers( 15, false );
   bc->AddVerseNumbers( 20, false );
   
   //
   // 37 : nKC
   //
   iBook = 36;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 15, false );
   bc->AddVerseNumbers( 23, false );
   
   //
   // 38 : [J
   //
   iBook = 37;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 21, false );
   bc->AddVerseNumbers( 13, false );
   bc->AddVerseNumbers( 10, false );
   bc->AddVerseNumbers( 14, false );
   bc->AddVerseNumbers( 11, false );
   bc->AddVerseNumbers( 15, false );
   bc->AddVerseNumbers( 14, false );
   bc->AddVerseNumbers( 23, false );
   bc->AddVerseNumbers( 17, false );
   bc->AddVerseNumbers( 12, false );
   bc->AddVerseNumbers( 17, false );
   bc->AddVerseNumbers( 14, false );
   bc->AddVerseNumbers( 9, false );
   bc->AddVerseNumbers( 21, false );
   
   //
   // 39 : }L
   //
   iBook = 38;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 14, false );
   bc->AddVerseNumbers( 17, false );
   bc->AddVerseNumbers( 18, false );
   bc->AddVerseNumbers( 6, false );
   
   //
   // 40 : }^C̕
   //
   iBook = 39;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 25, false ); // 1
   bc->AddVerseNumbers( 23, false ); // 2 
   bc->AddVerseNumbers( 17, false ); // 3
   bc->AddVerseNumbers( 25, false ); // 4
   bc->AddVerseNumbers( 48, false ); // 5
   bc->AddVerseNumbers( 34, false ); // 6
   bc->AddVerseNumbers( 29, false ); // 7
   bc->AddVerseNumbers( 34, false ); // 8
   bc->AddVerseNumbers( 38, false ); // 9
   bc->AddVerseNumbers( 42, false ); // 10

   bc->AddVerseNumbers( 30, false ); // 11
   bc->AddVerseNumbers( 50, false ); // 12  
   bc->AddVerseNumbers( 58, false ); // 13
   bc->AddVerseNumbers( 36, false ); // 14
   bc->AddVerseNumbers( 39, false ); // 15
   bc->AddVerseNumbers( 28, false ); // 16
   bc->AddVerseNumbers( 27, false ); // 17
   bc->AddVerseNumbers( 35, false ); // 18
   bc->AddVerseNumbers( 30, false ); // 19
   bc->AddVerseNumbers( 34, false ); // 20

   bc->AddVerseNumbers( 46, false ); // 21
   bc->AddVerseNumbers( 46, false ); // 22
   bc->AddVerseNumbers( 39, false ); // 23
   bc->AddVerseNumbers( 51, false ); // 24
   bc->AddVerseNumbers( 46, false ); // 25
   bc->AddVerseNumbers( 75, false ); // 26
   bc->AddVerseNumbers( 66, false ); // 27
   bc->AddVerseNumbers( 20, false ); // 28
   
   //
   // 41 : }R̕
   //
   iBook = 40;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 45, false ); // 1
   bc->AddVerseNumbers( 28, false ); // 2 
   bc->AddVerseNumbers( 35, false ); // 3
   bc->AddVerseNumbers( 41, false ); // 4
   bc->AddVerseNumbers( 43, false ); // 5
   bc->AddVerseNumbers( 56, false ); // 6
   bc->AddVerseNumbers( 37, false ); // 7
   bc->AddVerseNumbers( 38, false ); // 8
   bc->AddVerseNumbers( 50, false ); // 9
   bc->AddVerseNumbers( 52, false ); // 10

   bc->AddVerseNumbers( 33, false ); // 11
   bc->AddVerseNumbers( 44, false ); // 12
   bc->AddVerseNumbers( 37, false ); // 13
   bc->AddVerseNumbers( 72, false ); // 14
   bc->AddVerseNumbers( 47, false ); // 15
   bc->AddVerseNumbers( 20, false ); // 16
   
   //
   // 42 : J̕
   //
   iBook = 41;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 80, false );
   bc->AddVerseNumbers( 52, false );
   bc->AddVerseNumbers( 38, false );
   bc->AddVerseNumbers( 44, false );
   bc->AddVerseNumbers( 39, false );
   bc->AddVerseNumbers( 49, false );
   bc->AddVerseNumbers( 50, false );
   bc->AddVerseNumbers( 56, false );
   bc->AddVerseNumbers( 62, false );
   bc->AddVerseNumbers( 42, false );
   bc->AddVerseNumbers( 54, false );
   bc->AddVerseNumbers( 59, false );
   bc->AddVerseNumbers( 35, false );
   bc->AddVerseNumbers( 35, false );
   bc->AddVerseNumbers( 32, false );
   bc->AddVerseNumbers( 31, false );
   bc->AddVerseNumbers( 37, false );
   bc->AddVerseNumbers( 43, false );
   bc->AddVerseNumbers( 48, false );
   bc->AddVerseNumbers( 47, false );
   bc->AddVerseNumbers( 38, false );
   bc->AddVerseNumbers( 71, false );
   bc->AddVerseNumbers( 56, false );
   bc->AddVerseNumbers( 53, false );
   
   //
   // 43 : nl̕
   //
   iBook = 42;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 51, false );
   bc->AddVerseNumbers( 25, false );
   bc->AddVerseNumbers( 36, false );
   bc->AddVerseNumbers( 54, false );
   bc->AddVerseNumbers( 47, false );
   bc->AddVerseNumbers( 71, false );
   bc->AddVerseNumbers( 53, false );
   bc->AddVerseNumbers( 59, false );
   bc->AddVerseNumbers( 41, false );
   bc->AddVerseNumbers( 42, false );
   bc->AddVerseNumbers( 57, false );
   bc->AddVerseNumbers( 50, false );
   bc->AddVerseNumbers( 38, false );
   bc->AddVerseNumbers( 31, false );
   bc->AddVerseNumbers( 27, false );
   bc->AddVerseNumbers( 33, false );
   bc->AddVerseNumbers( 26, false );
   bc->AddVerseNumbers( 40, false );
   bc->AddVerseNumbers( 42, false );
   bc->AddVerseNumbers( 31, false );
   bc->AddVerseNumbers( 25, false );
   
   //
   // 44 : gk̓
   //
   iBook = 43;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 26, false );
   bc->AddVerseNumbers( 47, false );
   bc->AddVerseNumbers( 26, false );
   bc->AddVerseNumbers( 37, false );
   bc->AddVerseNumbers( 42, false );
   bc->AddVerseNumbers( 15, false );
   bc->AddVerseNumbers( 60, false );
   bc->AddVerseNumbers( 40, false );
   bc->AddVerseNumbers( 43, false );
   bc->AddVerseNumbers( 48, false );
   bc->AddVerseNumbers( 30, false );
   bc->AddVerseNumbers( 25, false );
   bc->AddVerseNumbers( 52, false );
   bc->AddVerseNumbers( 28, false );
   bc->AddVerseNumbers( 41, false );
   bc->AddVerseNumbers( 40, false );
   bc->AddVerseNumbers( 34, false );
   bc->AddVerseNumbers( 28, false );
   bc->AddVerseNumbers( 41, false );
   bc->AddVerseNumbers( 38, false );
   bc->AddVerseNumbers( 40, false );
   bc->AddVerseNumbers( 30, false );
   bc->AddVerseNumbers( 35, false );
   bc->AddVerseNumbers( 27, false );
   bc->AddVerseNumbers( 27, false );
   bc->AddVerseNumbers( 32, false );
   bc->AddVerseNumbers( 44, false );
   bc->AddVerseNumbers( 31, false );
   
   //
   // 45 : [}lւ̎莆
   //
   iBook = 44;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 32, false );
   bc->AddVerseNumbers( 29, false );
   bc->AddVerseNumbers( 31, false );
   bc->AddVerseNumbers( 25, false );
   bc->AddVerseNumbers( 21, false );
   bc->AddVerseNumbers( 23, false );
   bc->AddVerseNumbers( 25, false );
   bc->AddVerseNumbers( 39, false );
   bc->AddVerseNumbers( 33, false );
   bc->AddVerseNumbers( 21, false );
   bc->AddVerseNumbers( 36, false );
   bc->AddVerseNumbers( 21, false );
   bc->AddVerseNumbers( 14, false );
   bc->AddVerseNumbers( 23, false );
   bc->AddVerseNumbers( 33, false );
   bc->AddVerseNumbers( 27, false );
   
   //
   // 46 : Rglւ̎莆 
   //
   iBook = 45;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 31, false );
   bc->AddVerseNumbers( 16, false );
   bc->AddVerseNumbers( 23, false );
   bc->AddVerseNumbers( 21, false );
   bc->AddVerseNumbers( 13, false );
   bc->AddVerseNumbers( 20, false );
   bc->AddVerseNumbers( 40, false );
   bc->AddVerseNumbers( 13, false );
   bc->AddVerseNumbers( 27, false );
   bc->AddVerseNumbers( 33, false );
   bc->AddVerseNumbers( 34, false );
   bc->AddVerseNumbers( 31, false );
   bc->AddVerseNumbers( 13, false );
   bc->AddVerseNumbers( 40, false );
   bc->AddVerseNumbers( 58, false );
   bc->AddVerseNumbers( 24, false );
   
   //
   // 47 : Rglւ̎莆 
   //
   iBook = 46;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 24, false );
   bc->AddVerseNumbers( 17, false );
   bc->AddVerseNumbers( 18, false );
   bc->AddVerseNumbers( 18, false );
   bc->AddVerseNumbers( 21, false );
   bc->AddVerseNumbers( 18, false );
   bc->AddVerseNumbers( 16, false );
   bc->AddVerseNumbers( 24, false );
   bc->AddVerseNumbers( 15, false );
   bc->AddVerseNumbers( 18, false );
   bc->AddVerseNumbers( 33, false );
   bc->AddVerseNumbers( 21, false );
   bc->AddVerseNumbers( 14, false );
   
   //
   // 48 : Kelւ̎莆
   //
   iBook = 47;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 24, false );
   bc->AddVerseNumbers( 21, false );
   bc->AddVerseNumbers( 29, false );
   bc->AddVerseNumbers( 31, false );
   bc->AddVerseNumbers( 26, false );
   bc->AddVerseNumbers( 18, false );
   
   //
   // 49 : Gy\lւ̎莆
   //
   iBook = 48;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 23, false );
   bc->AddVerseNumbers( 22, false );
   bc->AddVerseNumbers( 21, false );
   bc->AddVerseNumbers( 32, false );
   bc->AddVerseNumbers( 33, false );
   bc->AddVerseNumbers( 24, false );
   
   //
   // 50 : sslւ̎莆
   //
   iBook = 49;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 30, false );
   bc->AddVerseNumbers( 30, false );
   bc->AddVerseNumbers( 21, false );
   bc->AddVerseNumbers( 23, false );
   
   //
   // 51 : RTClւ̎莆
   //
   iBook = 50;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 29, false );
   bc->AddVerseNumbers( 23, false );
   bc->AddVerseNumbers( 25, false );
   bc->AddVerseNumbers( 18, false );
   
   //
   // 52 : eTjPlւ̎莆 
   //
   iBook = 51;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 10, false );
   bc->AddVerseNumbers( 20, false );
   bc->AddVerseNumbers( 13, false );
   bc->AddVerseNumbers( 18, false );
   bc->AddVerseNumbers( 28, false );
   
   //
   // 53 : eTjPlւ̎莆 
   //
   iBook = 52;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 12, false );
   bc->AddVerseNumbers( 17, false );
   bc->AddVerseNumbers( 18, false );
   
   //
   // 54 : eeւ̎莆 
   //
   iBook = 53;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 20, false );
   bc->AddVerseNumbers( 15, false );
   bc->AddVerseNumbers( 16, false );
   bc->AddVerseNumbers( 16, false );
   bc->AddVerseNumbers( 25, false );
   bc->AddVerseNumbers( 21, false );
   
   //
   // 55 : eeւ̎莆 
   //
   iBook = 54;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 18, false );
   bc->AddVerseNumbers( 26, false );
   bc->AddVerseNumbers( 17, false );
   bc->AddVerseNumbers( 22, false );
   
   //
   // 56 : egXւ̎莆
   //
   iBook = 55;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 16, false );
   bc->AddVerseNumbers( 15, false );
   bc->AddVerseNumbers( 15, false );
   
   //
   // 57 : sւ̎莆
   //
   iBook = 56;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 25, false );
   
   //
   // 58 : wulւ̎莆
   //
   iBook = 57;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 14, false );
   bc->AddVerseNumbers( 18, false );
   bc->AddVerseNumbers( 19, false );
   bc->AddVerseNumbers( 16, false );
   bc->AddVerseNumbers( 14, false );
   bc->AddVerseNumbers( 20, false );
   bc->AddVerseNumbers( 28, false );
   bc->AddVerseNumbers( 13, false );
   bc->AddVerseNumbers( 28, false );
   bc->AddVerseNumbers( 39, false );
   bc->AddVerseNumbers( 40, false );
   bc->AddVerseNumbers( 29, false );
   bc->AddVerseNumbers( 25, false );
   
   //
   // 59 : Ru̎莆
   //
   iBook = 58;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 27, false );
   bc->AddVerseNumbers( 26, false );
   bc->AddVerseNumbers( 18, false );
   bc->AddVerseNumbers( 17, false );
   bc->AddVerseNumbers( 20, false );
   
   //
   // 60 : ye̎莆 
   //
   iBook = 59;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 25, false );
   bc->AddVerseNumbers( 25, false );
   bc->AddVerseNumbers( 22, false );
   bc->AddVerseNumbers( 19, false );
   bc->AddVerseNumbers( 14, false );
   
   //
   // 61 : ye̎莆 
   //
   iBook = 60;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 21, false );
   bc->AddVerseNumbers( 22, false );
   bc->AddVerseNumbers( 18, false );
   
   //
   // 62 : nl̎莆 
   //
   iBook = 61;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 10, false );
   bc->AddVerseNumbers( 29, false );
   bc->AddVerseNumbers( 24, false );
   bc->AddVerseNumbers( 21, false );
   bc->AddVerseNumbers( 21, false );
   
   //
   // 63 : nl̎莆 
   //
   iBook = 62;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 13, false );
   
   //
   // 64 : nl̎莆 O
   //
   iBook = 63;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 15, false );
   
   //
   // 65 : _̎莆
   //
   iBook = 64;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 25, false );
   
   //
   // 66 : nlَ̖^
   //
   iBook = 65;
   bc = &_BibleList.at( iBook );
   bc->ClearVerseNumbers( );
   bc->AddVerseNumbers( 20, false );   // 1
   bc->AddVerseNumbers( 29, false );   // 2
   bc->AddVerseNumbers( 22, false );   // 3
   bc->AddVerseNumbers( 11, false );   // 4
   bc->AddVerseNumbers( 14, false );   // 5
   bc->AddVerseNumbers( 17, false );   // 6
   bc->AddVerseNumbers( 17, false );   // 7
   bc->AddVerseNumbers( 13, false );   // 8
   bc->AddVerseNumbers( 21, false );   // 9
   bc->AddVerseNumbers( 11, false );   // 10

   bc->AddVerseNumbers( 19, false );   // 11
   bc->AddVerseNumbers( 18, false );   // 12
   bc->AddVerseNumbers( 18, false );   // 13
   bc->AddVerseNumbers( 20, false );   // 14
   bc->AddVerseNumbers( 8, false );    // 15
   bc->AddVerseNumbers( 21, false );   // 16
   bc->AddVerseNumbers( 18, false );   // 17
   bc->AddVerseNumbers( 24, false );   // 18
   bc->AddVerseNumbers( 21, false );   // 19
   bc->AddVerseNumbers( 15, false );   // 20

   bc->AddVerseNumbers( 27, false );   // 21
   bc->AddVerseNumbers( 21, false );   // 22

   return;
} 

QString BibleAllBooks::GetVersionFile( int iVersion,
                                         int iBook )
{
   QString strFile;
   
   switch( iVersion ) {
   case pixq_Properties::BibleShinkaiyaku2:   
      strFile = GetShinkai2File( iBook );
      break;
   case pixq_Properties::BibleKougoyaku:
      strFile = GetKougoFile( iBook );
      break;
   case pixq_Properties::BibleKingJames: // IRAN
      strFile = GetKjvFile( iBook );
      break;
   case pixq_Properties::BibleShinkaiyaku3:
      strFile = GetShinkai3File( iBook );
      break;      
   case pixq_Properties::BibleBungo: 
      strFile = GetBungoFile( iBook );
      break;
   case pixq_Properties::BibleRaguet:
      strFile = GetRaguetFile( iBook );
      break;

   default:
      strFile.clear( );
      break;
   }
  
   return strFile;
}

QString BibleAllBooks::GetVersionPath( int iVersion, 
                                         int iBook )
{
   QString strFile, strPath;
   
   strFile = GetVersionFile( iVersion, iBook );

   strPath = QFileInfo( QCoreApplication::applicationDirPath( ) ).filePath( );
   strPath.append( "/" );
   strPath.append( strFile );

   return strPath;
}

QString BibleAllBooks::GetVersionBookName( int iVersion,
                                         int iBook )
{
   int nBooks;
   QString strBook;
   BibleBook bc;
   
   strBook.clear( );

   nBooks = (int)_BibleList.size( );
   if( 0 > iBook || nBooks <= iBook ) {
      goto PIX_EXIT;
   }

   bc = _BibleList.at( iBook );  
   strBook = bc.GetVersionBookName( iVersion );
  
PIX_EXIT:
   return strBook;
}


//
// ̃XgɋԒ̗̂ǉ
//
void BibleAllBooks::AddShortTorreyNames( void )
{
   BibleBook *bc;
   QString strShort, strPattern;
   int k, nLength, i;

   i = 0;
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "Ge\0" );   
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "Ex\0" );   
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "Le\0" );   
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "Nu\0" );   
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "De\0" );   
                                                                
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "Jo\0" );   
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "Jdj\0" );  
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "Ru\0" );   
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "1Sa\0" );  
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "2Sa\0" );  
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "1Ki\0" );  
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "2Ki\0" );  
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "1Ch\0" );  
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "2Ch\0" );  
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "Ezr\0" );  
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "Ne\0" );   
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "Es\0" );   
                                                                
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "Job\0" );  
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "Ps\0" );   
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "Pr\0" );   
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "Ec\0" );   
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "Song\0" ); 
                                                                
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "Isa\0" );  
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "Jer\0" );        
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "La\0" );         
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "Eze\0" );        
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "Da\0" );         
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "Ho\0" );         
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "Joe\0" );        
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "Am\0" );         
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "Ob\0" );         
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "Jon\0" );        
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "Mic\0" );        
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "Na\0" );         
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "Hab\0" );        
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "Zep\0" );        
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "Hag\0" );        
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "Zec\0" );        
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "Mal\0" );        
                                                                      
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "Mt\0" );         
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "Mr\0" );         
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "Lu\0" );         
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "Joh\0" );        
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "Ac\0" );         
                                                                      
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "Ro\0" );
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "1Co\0" );        
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "2Co\0" );        
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "Ga\0" );         
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "Eph\0" );        
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "Php\0" );        
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "Col\0" );        
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "1Th\0" );        
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "2Th\0" );        
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "1Ti\0" );        
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "2Ti\0" );        
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "Tit\0" );        
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "Phm\0" );        
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "Heb\0" );        
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "Jas\0" );        
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "1Pe\0" );        
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "2Pe\0" );        
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "1Jo\0" );        
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "2Jo\0" );        
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "3Jo\0" );        
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "Jude\0" );       
                                                                      
   bc = &_BibleList.at( i++ );  bc->SetTorreyShort( "Re\0" );         

   // supported function for torrey files
   // make a list of pattern with " XXXX #"
   // where XXX is short book name # is a digit betwwen 1 and 9 

   _strTorreyBookPatterns.clear( );
   nLength = i;
   for( k = 0 ; k < nLength ; k++ ) {
      bc = &_BibleList.at( k ); 
      strShort = bc->GetTorreyShort( );
      strPattern = " " + strShort + " 1"; _strTorreyBookPatterns.push_back( strPattern );
      strPattern = " " + strShort + " 2"; _strTorreyBookPatterns.push_back( strPattern );
      strPattern = " " + strShort + " 3"; _strTorreyBookPatterns.push_back( strPattern );
      strPattern = " " + strShort + " 4"; _strTorreyBookPatterns.push_back( strPattern );
      strPattern = " " + strShort + " 5"; _strTorreyBookPatterns.push_back( strPattern );
      strPattern = " " + strShort + " 6"; _strTorreyBookPatterns.push_back( strPattern );
      strPattern = " " + strShort + " 7"; _strTorreyBookPatterns.push_back( strPattern );
      strPattern = " " + strShort + " 8"; _strTorreyBookPatterns.push_back( strPattern );
      strPattern = " " + strShort + " 9"; _strTorreyBookPatterns.push_back( strPattern );
   }

#ifdef _DEBUG
   nLength = _strTorreyBookPatterns.size( );
#endif

   return;                                           
} 

//
// ̏̒ŐV̗̂Ƀ}b`̂T
//
// returns:
// 0-65}b`鏑
// -1Ȃ
//
int BibleAllBooks::FindFromShinkai( QString strBook, 
                                    int *iSide ) const
{
   int nBooks, i;
   BibleBook bc;
   
   nBooks = (int)_BibleList.size( );
   
   for( i = 0 ; i < nBooks ; i++ ) {
      bc = _BibleList.at( i );
      if( bc.CheckShinkai( strBook, iSide ) ) {
         return i;
      }
   }

   return -1;
}


//
// ̏̒KJV̗̂Ƀ}b`̂T
//
// returns:
// 0-65}b`鏑
// -1Ȃ
//
int BibleAllBooks::FindFromShortKjv( QString strBook ) const
{
   int nBooks, i;
   BibleBook bc;
   
   nBooks = (int)_BibleList.size( );
   
   for( i = 0 ; i < nBooks ; i++ ) {
      bc = _BibleList.at( i );
      if( bc.CheckShortKjv( strBook ) ) {
         return i;
      }
   }

   return -1;
}

//
// ̏̒EnglishɃ}b`̂T
//
// returns:
// 0-65}b`鏑
// -1Ȃ
//
int BibleAllBooks::FindFromEngName( QString strBook ) const
{
   int nBooks, i;
   BibleBook bc;
   
   nBooks = (int)_BibleList.size( );
   
   for( i = 0 ; i < nBooks ; i++ ) {
      bc = _BibleList.at( i );
      if( bc.CheckEngBook( strBook ) ) {
         return i;
      }
   }

   return -1;
}

int BibleAllBooks::FindFromEnAbbrev( QString strBook ) const
{
   int nBooks, i;
   BibleBook bc;
   
   nBooks = (int)_BibleList.size( );
   
   for( i = 0 ; i < nBooks ; i++ ) {
      bc = _BibleList.at( i );
      if( bc.CheckEnAbbrev( strBook ) ) {
         return i;
      }
   }

   return -1;
}

int BibleAllBooks::FindFromJpShort( QString strBook ) const
{
   int nBooks, i;
   BibleBook bc;
   
   nBooks = (int)_BibleList.size( );
   
   for( i = 0 ; i < nBooks ; i++ ) {
      bc = _BibleList.at( i );
      if( bc.CheckJpShort( strBook ) ) {
         return i;
      }
   }

   return -1;
}

//
// ̃Xgɓ{ꏑi3ȉjǉ
//
void BibleAllBooks::AddJpShortBookNames( void )
{
   BibleBook *bc;
   int i;

   i = 0;
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "n\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "oG\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "r\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "\\0" );
  
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "V\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "mt\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "c\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "1T\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "2T\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "1\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "2\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "1\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "2\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "GY\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "lw\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "GX\0" );
                                                               
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "u\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "⼌\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "`\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "\0" );
                                                                
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "CU\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "G\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "G[\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "_j\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "zZA\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "G\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "AX\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "Io\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "i\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "~J\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "iz\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "no\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "[p\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "nKC\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "[J\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "}L\0" );          
                                                      
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "}^C\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "}R\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "J\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "nl\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "gk\0" );
                                                                       
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "[}\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "1R\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "2R\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "K\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "Gy\\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "ss\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "R\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "1eT\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "2eT\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "1e\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "2e\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "egX\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "s\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "wu\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "Ru\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "1ye\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "2ye\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "1n\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "2n\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "3n\0" );
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "_\0" );
                                                             
   bc = &_BibleList.at( i++ );  bc->SetJpShortBook( "َ^\0" );
                                                      
   return;                                                      
}
