#pragma once

namespace _pix_plot_qt_framework {

#include <pixqtlib_global.h>

class BibleBook;

class PIXQTLIB_EXPORT BibleAllBooks
{
public:
   BibleAllBooks(void);
   ~BibleAllBooks(void);

private:
   vector<BibleBook> _BibleList;
   
   // supporter data
   // list of all possible pattern for torrey's index
   QStringList _strTorreyBookPatterns;

public:
   // book number for old and new testament

   static int _iOldBookStart;
   static int _iOldBookEnd;
   static int _iNewBookStart;
   static int _iNewBookEnd;

public:
   void Setup( void );
   void MakeList( void );

   void AddJpShortBookNames( void );
   void AddShinkai3BookNames( void );
   void AddShortShinkaiBookNames( void );
   void AddBungoBookNames( void );
   void AddShortBookNames( void );

   void AddShortTorreyNames( void );
   void AddShortKjvBookNames( void );
   void AddEnglishBookNames( void );
   void AddShortKjvBookOccNames( void );

   void AddAllBungoFiles( void );
   void AddAllShinkaiFiles( void );
   void AddAllKougoFile( void );
   void AddAllKjvFile( void );
   void AddAllIsvFile( void );

   void AddChapterVerseNumbers( void );

   int GetLength( void ) { return (int)_BibleList.size( ); }

   BibleBook GetBook( int i ) { 
      return _BibleList.at( i );
   }
   
   BibleBook *pGetBook( int i ) { 
      return &_BibleList.at( i );
   }

   int GetBookChapters( int iBook );
   int GetBookChapterVerses( int iBook, int iChapter );

   int ShinkaiShortNameSize( int iBook, int iSide );
   int KjvShortNameSize( int iBook );
   QString KjvShortName( int iBook );
   int FindFromShinkai( QString strBook, int *iSide ) const;
   int FindFromShortKjv( QString strBook ) const;
   int FindFromEngName( QString strBook ) const;
   int FindFromEnAbbrev( QString strBook ) const;
   int FindFromJpShort( QString strBook ) const;

   QString GetShinkaiName( int iBook, int iSide );
   QString GetJpShortName( int iBook );

   QString GetBookEnAbbrev( int iBook, int iSide );

   QString GetBungoFile( int iBook );
   QString GetRaguetFile( int iBook );
   QString GetShinkai2File( int iBook );
   QString GetShinkai3File( int iBook );
   QString GetKougoFile( int iBook );
   QString GetKjvFile( int iBook );
   
   QString GetVersionFile( int iVersion, int iBook );
   QString GetVersionPath( int iVersion, int iBook );

   QString GetKjvBookOccShort( int iBook );
   
   QString GetVersionBookName( int iVersion, int iBook );

   //

   int TorreyBookPatterns( void ) { return (int)_strTorreyBookPatterns.size( ); }
   QString GetTorreyBookPatterns( int iPos ) { return _strTorreyBookPatterns.at( iPos ); }
   
   static void VersionBookRange( int iVersion, int &iBookFirst, int &iBookLast );
   static bool isBookOld( int iBook );
};


} // namespace 

// 01 nL          
// 02 oGWvgL    
// 03 rL          
// 04 L          
// 05 \L          
// 06 VAL      
// 07 mtL          
// 08 cL          
// 09 TGL  
// 10 TGL  
// 11 񉤋L      
// 12 񉤋L      
// 13 ㎏      
// 14 ㎏      
// 15 GYL        
// 16 lw~L      
// 17 GXeL      
// 18 uL          
// 19             
// 20 ⼌            
// 21 `҂̏      
// 22             
// 23 CU        
// 24 G~      
// 25             
// 26 G[LG    
// 27 _jG      
// 28 zZA        
// 29 G        
// 30 AX        
// 31 Iof      
// 32 i          
// 33 ~J          
// 34 iz        
// 35 noNN      
// 36 [pj      
// 37 nKC                    
// 38 [J                  
// 39 }L                    
// 40 }^C̕             
// 41 }R̕             
// 42 J̕               
// 43 nl̕             
// 44 gk̓                 
// 45 [}lւ̎莆           
// 46 Rglւ̎莆     
// 47 Rglւ̎莆     
// 48 Kelւ̎莆         
// 49 Gy\lւ̎莆           
// 50 sslւ̎莆           
// 51 RTClւ̎莆         
// 52 eTjPlւ̎莆  
// 53 eTjPlւ̎莆   
// 54 eeւ̎莆         
// 55 eeւ̎莆         
// 56 egXւ̎莆             
// 57 sւ̎莆           
// 58 wulւ̎莆           
// 59 Ru̎莆               
// 60 ye̎莆           
// 61 ye̎莆           
// 62 nl̎莆           
// 63 nl̎莆           
// 64 nl̎莆 O          
// 65 _̎莆                 
// 66 nlَ̖^    

// http://livinghope-chinese.org.uk/DailyLight_English/KJVhtml/SpecialDLukjv.htm
// 
// Alphabetical Order of The Books of the Bible
// special occasions
//
// GENESIS (Gen) 
// EXODUS (Exo) 
// LEVITICUS (Lev)
// NUMBERS (Num)
// DEUTERONOMY (Deu)
//
// JOSHUA (Jos) 
// JUDGES (Jug) 
// RUTH (Rut) 
// 1 SAMUEL (1Sa)
// 2 SAMUEL (2Sa) 
// 1 KINGS (1Ki) 
// 2 KINGS (2Ki)
// 1 CHRONICLES (1Ch) 
// 2 CHRONICLES (2Ch)
// EZRA (Ezr)
// NEHEMIAH (Neh) 
// ESTHER (Est)
//
// JOB (Job) 
// PSALMS (Psa) 
// PROVERBS (Pro) 
// ECCLESIASTES (Ecc) 
// SONG OF SONGS (Son) 

// ISAIAH (Isa)
// JEREMIAH (Jer) 
// LAMENTATIONS (Lam) 
// EZEKIEL (Eze) 
// DANIEL (Dan) 
// HOSEA (Hos) 
// JOEL (Joe)
// AMOS (Amo)
// OBADIAH (Oba) 
// JONAH (Jon) 
// MICAH (Mic) 
// NAHUM (Nah) 
// HABAKKUK (Hab)
// ZEPHANIAH (Zep)
// HAGGAI (Hag) 
// ZECHARIAH (Zec) 
// MALACHI (Mal) 
//
// MATTHEW (Mat)
// MARK (Mar) 
// LUKE (Luk) 
// JOHN (Joh) 
// ACTS (Act) 
//
// ROMANS (Rom)
// 1 CORINTHIANS (1Co) 
// 2 CORINTHIANS (2Co) 
// GALATIANS (Gal) 
// EPHESIANS (Eph) 
// PHILIPPIANS (Php)
// COLOSSIANS (Col) 
// 1 THESSALONIANS (1Th) 
// 2 THESSALONIANS (2Th)
// 1 TIMOTHY (1Ti) 
// 2 TIMOTHY (2Ti) 
// TITUS (Tit) 
// PHILEMON (Phm) 
// HEBREWS (Heb) 
// JAMES (Jam) 
// 1 PETER (1Pe) 
// 2 PETER (2Pe) 
// 1 JOHN (1Jo)
// 2 JOHN (2Jo) 
// 3 JOHN (3Jo) 
// JUDE (Jud)
//
// REVELATION (Rev) 
// 
