#include <pixqt_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include "BibleShiori.h"
#include "BibleAllShiori.h"

BibleAllShiori::BibleAllShiori(void)
{
   Init( );
}

BibleAllShiori::~BibleAllShiori(void)
{
   _BibleShiori.clear( );
}

BibleAllShiori &BibleAllShiori::operator=( const BibleAllShiori &that )
{
   int nSize;

   nSize = (int)that._BibleShiori.size( );
   _BibleShiori.resize( nSize );
   qCopy( that._BibleShiori.begin(), that._BibleShiori.end( ), _BibleShiori.begin( ) );

   return *this;
}


//
// get hikari shiori file name for the user
//
// notes:
// created for the first time in the user's document path
//
QString BibleAllShiori::GetHikariShioriFile( void ) 
{
   QString strFile;

   //strFile = QDesktopServices::storageLocation( QDesktopServices::DocumentsLocation );
   //strFile = QDesktopServices::storageLocation( QDesktopServices::ApplicationsLocation );
   strFile = QDesktopServices::storageLocation( QDesktopServices::DataLocation );
  
   strFile.append( "\\Hikari\\shiori.xml\0" );

   return strFile;
}

//
// 胊Xg̏
//
void BibleAllShiori::Init( void ) 
{
   int k;
   BibleShiori shiori;

   shiori.Init( );

   _BibleShiori.clear( );

   for( k = 0 ; k < _nShioriNumber ; k++ ) {
      _BibleShiori.push_back( shiori );
   }

   return;
}

int BibleAllShiori::Size( void )
{
   return (int)_BibleShiori.size( );
}

BibleShiori BibleAllShiori::GetNthShiori( int iShiori )
{
   BibleShiori shiori;
   int nShiori;
   
   shiori.Init( );

   if( 0 > iShiori ) {
      goto PIX_EXIT;
   }
   
   nShiori = (int)_BibleShiori.size( );

   if( nShiori <= iShiori ) {
      goto PIX_EXIT;
   }

   shiori = _BibleShiori.at( iShiori );

   // --- Done ---
PIX_EXIT:
   return shiori;
}

bool BibleAllShiori::SetShiori( int iShiori, 
                               int iBook,
                               int iChapter )
{
   bool bRetCode =  false;
   int nShiori;
   BibleShiori shiori;

   if( 0 > iShiori ) {
      goto PIX_EXIT;
   }
   
   nShiori = (int)_BibleShiori.size( );

   if( nShiori <= iShiori ) {
      goto PIX_EXIT;
   }

   shiori.Set( iBook, iChapter );
   
   _BibleShiori.at( iShiori ) = shiori;

   // --- Done ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

bool BibleAllShiori::SetShiori( int iShiori, 
                               BibleShiori shiori )
{
   bool bRetCode =  false;
   int nShiori;

   if( 0 > iShiori ) {
      goto PIX_EXIT;
   }
   
   nShiori = (int)_BibleShiori.size( );

   if( nShiori <= iShiori ) {
      goto PIX_EXIT;
   }
   
   _BibleShiori.at( iShiori ) = shiori;

   // --- Done ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

//
// store this data in file
// file is overwritten!
// XMLt@C𐶐
//
bool BibleAllShiori::Save( void ) 
{
   bool bRetCode =  false;
   QString strFile;
   QFile *file = NULL;
   QXmlStreamWriter writer;
   BibleShiori shiori;
   int k, nShiori;
   QString strMessage, strValue, strXmlFile;
   
   // create output xml file

   strXmlFile = GetHikariShioriFile( );
   
   if( !CreateFolder_PC( strXmlFile ) ) {
      // ERROR! Failed to Create Temporary Path
      goto PIX_EXIT;
   }

   file = new QFile( strXmlFile );
   if ( !file->open( QFile::WriteOnly | QFile::Text ) ) {
      goto PIX_EXIT;
   }

   writer.setAutoFormatting( true );
   writer.setDevice( file );

   writer.writeStartDocument();
   //writer.writeDTD("<!DOCTYPE occasions>");

   writer.writeStartElement( "hikari" );
   writer.writeAttribute( "version", "1.0");
   writer.writeAttribute( "data", "shiori" );


   nShiori = GetLength( );
   for( k = 0 ; k < nShiori ; k++ ) {
      shiori = _BibleShiori.at( k );
      
      writer.writeStartElement( "Shiori" );
      
      strValue.sprintf( "%d", k+1 );
      writer.writeAttribute( "ID", strValue );
      
      strValue.sprintf( "%d", shiori.GetBook( ) );
      writer.writeAttribute( "Book", strValue );
      
      strValue.sprintf( "%d", shiori.GetChapter( ) );
      writer.writeAttribute( "Chapter", strValue );
      
      strValue.sprintf( "%d", shiori.GetYear( ) );
      writer.writeAttribute( "Year", strValue );

      strValue.sprintf( "%d", shiori.GetMonth( ) );
      writer.writeAttribute( "Month", strValue );

      strValue.sprintf( "%d", shiori.GetDay( ) );
      writer.writeAttribute( "Day", strValue );

      writer.writeEndElement(); // ID
   }

   // end the last section

   writer.writeEndElement();

   // create output xml file

   writer.writeEndDocument();

   // --- Done --- 
   bRetCode = true;
PIX_EXIT:
   if( file ) {
      file->close( );
      file = NULL;
   }
   return bRetCode;
}

bool BibleAllShiori::Load( void )  
{
   bool bRetCode =  false;
   bool bStatus, bOK;
   int k, nID, nBook, nChapter, nYear, nMonth, nDay;
   
   BibleShiori shiori;

   QString strMessage, strValue, strXmlFile;   
   QFile *file = NULL;
   QXmlStreamReader reader;
   QXmlStreamAttributes attr;

   // create file

   // create output xml file

   strXmlFile = GetHikariShioriFile( );
   file = new QFile( strXmlFile );   
   if ( !file->open( QIODevice::ReadOnly | QIODevice::Text ) ) {
      goto PIX_EXIT;
   }

   reader.setDevice( file );

   if( !reader.readNextStartElement( ) ) {
      goto PIX_EXIT;
   }

   if( reader.name() != "hikari" ) {
      goto PIX_EXIT;
   }

   attr = reader.attributes( );
   
   if( attr.value("version") != "1.0") {
      goto PIX_EXIT;
   }

   if( attr.value("data") != "shiori") {
      goto PIX_EXIT;
   }

   k = 0;
   bStatus = true;
   while( bStatus ) {

      if( reader.atEnd( ) ) {
         bStatus = false;
         continue;
      }

      if( !reader.readNextStartElement()) {
         bStatus = false;
         continue;
      }

      strValue = reader.name().toString( );
      if( "Shiori" != strValue ) {
         continue;
      }

      //
      
      attr = reader.attributes();
      strValue = attr.value( "ID" ).toString();
      nID = strValue.toInt( &bOK );
      if( !bOK ) {
         goto PIX_EXIT;
      }

      strValue = attr.value( "Book" ).toString();
      nBook = strValue.toInt( &bOK );
      if( !bOK ) {
         goto PIX_EXIT;
      }
      
      strValue = attr.value( "Chapter" ).toString();
      nChapter = strValue.toInt( &bOK );
      if( !bOK ) {
         goto PIX_EXIT;
      }      
      
      strValue = attr.value( "Year" ).toString();
      nYear = strValue.toInt( &bOK );
      if( !bOK ) {
         goto PIX_EXIT;
      }
      
      strValue = attr.value( "Month" ).toString();
      nMonth = strValue.toInt( &bOK );
      if( !bOK ) {
         goto PIX_EXIT;
      }
      
      strValue = attr.value( "Day" ).toString();
      nDay = strValue.toInt( &bOK );
      if( !bOK ) {
         goto PIX_EXIT;
      }

      reader.skipCurrentElement();

      // 

      shiori.Set( nBook, nChapter, nYear, nMonth, nDay );
      SetShiori( k, shiori );
      k++;

      if( k >= _nShioriNumber ) {
         bStatus = false;
         continue;
      }
   }

   // --- Done ---
   bRetCode = true;
PIX_EXIT:
   if( file ) {
      file->close( );
      file = NULL;
   }
   return bRetCode;
}
