#pragma once

namespace _pix_plot_qt_framework {

#include <pixqtlib_global.h>

//
// Collection of Bookmarks for Bible
//

class BibleShiori;

class PIXQTLIB_EXPORT BibleAllShiori
{
private:
   static const int _nShioriNumber = 5;

public:
   BibleAllShiori(void);
   ~BibleAllShiori(void);

private:
   vector<BibleShiori> _BibleShiori;

public:
   void Init( void );
   bool Load( void );
   bool Save( void );

	BibleAllShiori &operator=( const BibleAllShiori &that );

   int GetLength( void ) { return (int)_BibleShiori.size( ); }

   static QString GetHikariShioriFile( void );

   bool SetShiori( int iShiori, int iBook, int iChapter );
   bool SetShiori( int iShiori, BibleShiori shiori );
   BibleShiori GetNthShiori( int iShiori );
   int Size( void );
   
   static int MaxShioriNumber( void ) { return _nShioriNumber; }

};

} // namespace 
