#include <pixqt_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include "BibleBook.h"

BibleBook::BibleBook(void)
{
   _nID = -1;
   _strJpnBook.clear( );
   _strEngBook.clear( );

   _strJpShortBook.clear( );
   
   _bOld = true;

   _strShinkai3Book.clear( );
   _strShinkaiBookShort[0].clear( );
   _strShinkaiBookShort[1].clear( );
   _strEnBookAbbrev[0].clear( );
   _strEnBookAbbrev[1].clear( );
   _strKjvBookShort.clear( );
   _strKjvBookOccShort.clear( );

   _strBungoFile.clear( );   
   _strShinkaiFile.clear( );   
   _strKougoFile.clear( );
   _strKjvFile.clear( );
   _strBungoBook.clear( );   
   
   _viVerses.clear( );
   _vbVerseZero.clear( );
}

BibleBook::~BibleBook(void)
{
}

BibleBook &BibleBook::operator=( const BibleBook &that )
{
   int nSize;

   _nID = that._nID;
   _strJpnBook = that._strJpnBook;   
   _strEngBook = that._strEngBook;   

   _strJpShortBook = that._strJpShortBook;   

   _bOld = that._bOld;

   _strShinkai3Book = that._strShinkai3Book;
   _strShinkaiBookShort[0] = that._strShinkaiBookShort[0];
   _strShinkaiBookShort[1] = that._strShinkaiBookShort[1];

   _strEnBookAbbrev[0] = that._strEnBookAbbrev[0];
   _strEnBookAbbrev[1] = that._strEnBookAbbrev[1];
   _strKjvBookShort = that._strKjvBookShort;
   _strKjvBookOccShort = that._strKjvBookOccShort;
   _strBungoBook = that._strBungoBook;

   _strShinkaiFile = that._strShinkaiFile;
   _strBungoFile = that._strBungoFile;
   _strKougoFile = that._strKougoFile;
   _strKjvFile = that._strKjvFile;

   //
   nSize = (int)that._viVerses.size( );
   _viVerses.resize( nSize );
   qCopy( that._viVerses.begin(), that._viVerses.end( ), _viVerses.begin( ) );

   //

   nSize = (int)that._vbVerseZero.size( );
   _vbVerseZero.resize( nSize );
   qCopy( that._vbVerseZero.begin(), that._vbVerseZero.end(), _vbVerseZero.begin( ) );

   return *this;
}

QString BibleBook::GetBookName( int iLang ) 
{       
   switch( iLang ) {
   case pixq_Properties::PixTopoLanguangeJp:
      return _strJpnBook;
      break;
   
   case pixq_Properties::PixTopoLanguangeEn:
      return _strEngBook;
      break;

   default: 
      return _strEngBook;
      break;
   }
}

void BibleBook::Set( int nID,
                    QString strBook,
                    bool bOld )
{
   _nID = nID;
   _strJpnBook = strBook;
   _bOld = bOld;

   _strEngBook.clear( );

   _strShinkai3Book.clear( );
   _strShinkaiBookShort[0].clear( );
   _strShinkaiBookShort[1].clear( );

   _strEnBookAbbrev[0].clear( );
   _strEnBookAbbrev[1].clear( );
   _strBungoBook.clear( );
   _strKjvBookShort.clear( );
   _strKjvBookOccShort.clear( );

   _strBungoFile.clear( );
   _strShinkaiFile.clear( );
   _strKougoFile.clear( );
   _strKjvFile.clear( );

   _viVerses.clear( );
   _vbVerseZero.clear( );

	return;
}

bool BibleBook::CheckShinkai( QString strShinkai,
                              int *iSide )
{   
   bool bRetCode = false;
   int k, nLen, nShinkaiLen;
   QString strComp;

   nShinkaiLen = (int)strShinkai.size( );

   for( k = 0 ; k < 2 ; k++ ) {
      nLen = (int)_strShinkaiBookShort[k].size( );
      if( nShinkaiLen < nLen ) {
         continue;
      }
      strComp = strShinkai.left( nLen );
      //if( 0 == strShinkai.compare( 0, nLen, _strShinkaiBookShort[k] ) ) {
      if( 0 == strComp.compare( _strShinkaiBookShort[k], Qt::CaseSensitive ) ) {
         *iSide = k;
         bRetCode = true;
         goto PIX_EXIT;
      }
   }

   goto PIX_EXIT;

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

bool BibleBook::CheckShortKjv( QString strBook )
{   
   bool bRetCode = false;
   int  nLen, nBookLen;
   QString strComp;

   nBookLen = (int)strBook.size( );

   nLen = (int)_strKjvBookShort.size( );
   if( nBookLen < nLen ) {
      goto PIX_EXIT;
   }

   strComp = strBook.left( nLen );
   if( 0 != strComp.compare( _strKjvBookShort, Qt::CaseSensitive ) ) {
      goto PIX_EXIT;
   }

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}


bool BibleBook::CheckEngBook( QString strBook )
{   
   bool bRetCode = false;
   int  nLen, nBookLen;
   QString strComp;

   nBookLen = (int)strBook.size( );

   nLen = (int)_strEngBook.size( );
   if( nBookLen != nLen ) {
      goto PIX_EXIT;
   }

   strComp = strBook.left( nLen );
   if( 0 != strComp.compare( _strEngBook, Qt::CaseSensitive ) ) {
      goto PIX_EXIT;
   }

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

bool BibleBook::CheckEnAbbrev( QString strBook )
{   
   bool bRetCode = false;
   int i, nLen, nBookLen;
   QString strComp;

   nBookLen = (int)strBook.size( );

   for( i = 0 ; i < 2 ; i++ ) {
      nLen = (int)_strEnBookAbbrev[i].size( );
      if( nBookLen < nLen ) {
         continue;
      }

      strComp = strBook.left( nLen );
      if( 0 == strComp.compare( _strEnBookAbbrev[i], Qt::CaseSensitive ) ) {
         bRetCode = true;
         goto PIX_EXIT;
      }
   }

   goto PIX_EXIT;

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

bool BibleBook::CheckJpShort( QString strBook )
{   
   bool bRetCode = false;
   int  nLen, nBookLen;
   QString strComp;

   nBookLen = (int)strBook.size( );

   nLen = (int)_strJpShortBook.size( );
   if( nBookLen < nLen ) {
      goto PIX_EXIT;
   }

   strComp = strBook.left( nLen );
   if( 0 != strComp.compare( _strJpShortBook, Qt::CaseSensitive ) ) {
      goto PIX_EXIT;
   }

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

void BibleBook::AddVerseNumbers( int nVerses, bool bZero )
{
   _viVerses.push_back( nVerses );
   _vbVerseZero.push_back( bZero );

   return;
}

void BibleBook::ClearVerseNumbers( void )
{
   _viVerses.clear( );
   _vbVerseZero.clear( );

   return;
}

QString BibleBook::GetVersionBookName( int iVersion )
{
   QString strBook;
   
   switch( iVersion ) {
   case pixq_Properties::BibleShinkaiyaku2:   
   case pixq_Properties::BibleKougoyaku:
   case pixq_Properties::BibleBungo: 
   case pixq_Properties::BibleRaguet:
      strBook = GetBookJpName( );
      break;

   case pixq_Properties::BibleKingJames: 
   case pixq_Properties::BibleIntlStandard:
      strBook = GetBookEnName( );
      break;

   default:
      strBook.clear( );
      break;
   }
  
   return strBook;
}

int BibleBook::GetChapters( void ) 
{
   int nChapters = (int)_viVerses.size( );
   return nChapters;
}

void BibleBook::GetChapterVerseNumbers( QVector<int> &viVerses )
{ 
   viVerses.clear( );
   int nChapters = (int)_viVerses.size( );
   viVerses.resize( nChapters );
   qCopy( _viVerses.begin(), _viVerses.end(), viVerses.begin() );
   
   return;
}

//
// returns number of verses of the chapter
//
// returns:
// number of verses
// or -1, if something went wrong
//
int BibleBook::GetChapterVerseNumber( int iChapter ) // [i] chapter number starting from 1
{
   int nVerses = -1;
   int nChapters;

   if( 1 > iChapter ) {
      goto PIX_EXIT;
   }

   nChapters = (int)_viVerses.size( );
   if( nChapters < iChapter ) {
      goto PIX_EXIT;
   }

   nVerses = (int)_viVerses.at( iChapter - 1 );

PIX_EXIT:
   return nVerses;
}


bool BibleBook::GetVerseZero( int iChapter )
{
   bool bVerseZero = false;

   int nChapters = _vbVerseZero.size( );
   if( 0 > iChapter ) goto PIX_EXIT;
   if( iChapter >= nChapters ) goto PIX_EXIT;

   bVerseZero = _vbVerseZero.at( iChapter );

PIX_EXIT:
   return bVerseZero;
}


