#pragma once

namespace _pix_plot_qt_framework {

#include <pixqtlib_global.h>

class PIXQTLIB_EXPORT BibleBook
{
public:
   BibleBook(void);
   ~BibleBook(void);

private:
   int _nID;

   // name of the bookA{
   QString _strJpnBook;

   // name of the bookAp
   QString _strEngBook;

   // name of the bookA{Short
   QString _strJpShortBook;

   // true for old testament
   bool _bOld;

   // V3ŁA
   QString _strShinkai3Book;

   // VÂ̗
   QString _strShinkaiBookShort[2];

   // KJVA̗
   QString _strKjvBookShort;

   // pA̗@Torreỹt@C
   QString _strTorreyShort;

   // KJVAXyVIP[WA̗
   QString _strKjvBookOccShort;

   // KJVA̗,2-3 characters
   QString _strEnBookAbbrev[2];

   // VATEXT FILE name
   QString _strShinkaiFile;

   // KougoATEXT FILE name
   QString _strKougoFile;

   // KJVATEXT FILE name
   QString _strKjvFile;

   // ̃t@C(S)
   // 吳uV񐹏v(1950N)
      // up񐹏v(1953N)
      // QuCGYXLXg̐V񐹏v(1910N)
   QString _strBungoFile;

   // e͂̐ߐ
   QVector<int> _viVerses;

   // e͂0Ԗڂ̐߂܂ށHiт̂݁j
   QVector<bool> _vbVerseZero;

   // ISVAXML FILE name
   QString _strIsvFile;

   // ̏
   // 吳uV񐹏v(1950N)
   // up񐹏v(1953N)
   QString _strBungoBook;

public:
   bool GetVerseZero( int iChapter );

	BibleBook &operator=( const BibleBook &that );
   void Set( int nID, QString strBook, bool bOld );

   void SetJpShortBook( QString strShort ) { _strJpShortBook = strShort; }

   void SetShinkai3Book( QString strShort ) { _strShinkai3Book = strShort; }
   QString GetShinkai3Book( void ) { return _strShinkai3Book; }

   void SetShinkaiBookShort( int i, QString strShort ) { _strShinkaiBookShort[i] = strShort; }
   QString GetShinkaiBookShort( int i ) { return _strShinkaiBookShort[i]; }

   void SetKjvBookShort( QString strShort ) { _strKjvBookShort = strShort; }
   QString GetKjvBookShort( void ) { return _strKjvBookShort; }
   
   void SetBungoBook( QString strBook ) { _strBungoBook = strBook; }
   QString GetBungoBook( void ) { return _strBungoBook; }

   void SetTorreyShort( QString strShort ) { _strTorreyShort = strShort; }
   QString GetTorreyShort( void ) { return _strTorreyShort; }
   
   void SetKjvBookOccShort( QString strShort ) { _strKjvBookOccShort = strShort; }
   QString GetKjvBookOccShort( void ) { return _strKjvBookOccShort; }

   void SetBookEnAbbrev( QString strShort0, QString strShort1 ) {
      _strEnBookAbbrev[0] = strShort0; 
      _strEnBookAbbrev[1] = strShort1; }
   QString GetBookEnAbbrev( int iSide ) { return _strEnBookAbbrev[iSide]; }

   bool CheckShinkai( QString strShinkai, int *iSide );
   bool CheckShortKjv( QString strKjv );
   bool CheckEngBook( QString strKjv );
   bool CheckEnAbbrev( QString strKjv );
   bool CheckJpShort( QString strKjv );
   
   void SetBungoFile( QString strFile ) { _strBungoFile = strFile; }
   void SetShinkaiFile( QString strFile ) { _strShinkaiFile = strFile; }
   void SetKougoFile( QString strFile ) { _strKougoFile = strFile; }
   void SetKjvFile( QString strFile ) { _strKjvFile = strFile; }
   void SetIsvFile( QString strFile ) { _strIsvFile = strFile; }

   QString GetShinkaiFile( void ) { return _strShinkaiFile; }
   QString GetBungoFile( void ) { return _strBungoFile; }
   QString GetKougoFile( void ) { return _strKougoFile; }
   QString GetKjvFile( void ) { return _strKjvFile; }
   QString GetIsvFile( void ) { return _strIsvFile; }
      
   QString GetVersionBookName( int iVersion );

   void ClearVerseNumbers( void );
   void AddVerseNumbers( int nVerses, bool bZero );
   
   void SetEngBookName( QString strBook ) { _strEngBook = strBook; }

   QString GetBookName( int iLang );
   QString GetBookEnName( void ) { return _strEngBook; }
   QString GetBookJpName( void ) { return _strJpnBook; }
   QString GetBookJpShortame( void ) { return _strJpShortBook; }

   int GetChapters( void );
   void GetChapterVerseNumbers( QVector<int> &viVerses );
   
   int GetChapterVerseNumber( int iChapter );

};

} // namespace 
