#include <pixqt_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include "BibleMikotobaUnit.h"
#include "BibleMikotobaList.h"
#include "BibleMikotobaAllList.h"

BibleMikotobaAllList::BibleMikotobaAllList(void)
{
   Init( );
}

BibleMikotobaAllList::~BibleMikotobaAllList(void)
{
   _MikotobaAllList.clear( );
}

BibleMikotobaAllList &BibleMikotobaAllList::operator=( const BibleMikotobaAllList &that )
{
   int nSize;

   nSize = (int)that._MikotobaAllList.size( );
   _MikotobaAllList.resize( nSize );
   qCopy( that._MikotobaAllList.begin(), that._MikotobaAllList.end( ), _MikotobaAllList.begin( ) );

   return *this;
}


//
// 
//
// 
// 
//
QString BibleMikotobaAllList::GetMikotobaAllFile( void ) 
{
   QString strFile;

   //strFile = QDesktopServices::storageLocation( QDesktopServices::DocumentsLocation );
   //strFile = QDesktopServices::storageLocation( QDesktopServices::ApplicationsLocation );
   strFile = QDesktopServices::storageLocation( QDesktopServices::DataLocation );
  
   strFile.append( "\\Hikari\\mikotoba.xml\0" );

   return strFile;
}

//
// 
//
void BibleMikotobaAllList::Init( void ) 
{
   _MikotobaAllList.clear( );
   return;
}

int BibleMikotobaAllList::Size( void )
{
   return (int)_MikotobaAllList.size( );
}

BibleMikotobaList BibleMikotobaAllList::GetNthMikotobaList( int iPos )
{
   BibleMikotobaList list;
   int nLists;
   
   list.Init( );

   if( 0 > iPos ) {
      goto PIX_EXIT;
   }
   
   nLists = (int)_MikotobaAllList.size( );

   if( nLists <= iPos ) {
      goto PIX_EXIT;
   }

   list = _MikotobaAllList.at( iPos );

   // --- Done ---
PIX_EXIT:
   return list;
}

void BibleMikotobaAllList::Add( BibleMikotobaList &list )
{   
   _MikotobaAllList.push_back( list );
}

//
// store this data in file
// file is overwritten!
// XMLt@C𐶐
//
bool BibleMikotobaAllList::Save( void ) 
{
   bool bRetCode =  false;
   QString strFile;
   QFile *file = NULL;
   QXmlStreamWriter writer;
   BibleMikotobaList list;
   int k, nLists;
   QString strMessage, strValue, strXmlFile;
   
   // create output xml file

   strXmlFile = GetMikotobaAllFile( );
   
   if( !CreateFolder_PC( strXmlFile ) ) {
      // ERROR! Failed to Create Temporary Path
      goto PIX_EXIT;
   }

   file = new QFile( strXmlFile );
   if ( !file->open( QFile::WriteOnly | QFile::Text ) ) {
      goto PIX_EXIT;
   }

   writer.setAutoFormatting( true );
   writer.setDevice( file );

   writer.writeStartDocument();
   //writer.writeDTD("<!DOCTYPE occasions>");

   //rite file header

   writer.writeStartElement( "hikari" );
   writer.writeAttribute( "version", "1.0");
   writer.writeAttribute( "data", "mikotoba" );


   nLists = GetLength( );
   for( k = 0 ; k < nLists ; k++ ) {
      list = _MikotobaAllList.at( k );
      list.Save( k+1, writer ); 
   }

   // end the last section

   writer.writeEndElement();

   // create output xml file

   writer.writeEndDocument();

   // --- Done ---
   bRetCode = true;
PIX_EXIT:
   if( file ) {
      file->close( );
      file = NULL;
   }
   return bRetCode;
}

bool BibleMikotobaAllList::Load( void )  
{
   bool bRetCode =  false;
   bool bStatus;
   int k;
   
   BibleMikotobaList list;

   QString strMessage, strValue, strXmlFile;   
   QFile *file = NULL;
   QXmlStreamReader reader;
   QXmlStreamAttributes attr;

   Init( );

   // create output xml file

   strXmlFile = GetMikotobaAllFile( );
   file = new QFile( strXmlFile );   
   if ( !file->open( QIODevice::ReadOnly | QIODevice::Text ) ) {
      goto PIX_EXIT;
   }

   reader.setDevice( file );

   if( !reader.readNextStartElement( ) ) {
      goto PIX_EXIT;
   }

   if( reader.name() != "hikari" ) {
      goto PIX_EXIT;
   }

   if( reader.attributes().value("version") != "1.0") {
      goto PIX_EXIT;
   }

   if( attr.value("data") != "mikotoba") {
      goto PIX_EXIT;
   }

   k = 0;
   bStatus = true;
   while( bStatus ) {

      if( reader.atEnd( ) ) {
         bStatus = false;
         continue;
      }

      if( !reader.readNextStartElement()) {
         bStatus = false;
         continue;
      }

      strValue = reader.name().toString( );
      if( "MikotobaList" != strValue ) {
         continue;
      }

      //
      
      if( list.Load( reader ) ) {
         goto PIX_EXIT;
      }
            
      reader.skipCurrentElement();

      // 

      Add( list );
   }

   // --- Done ---
   bRetCode = true;
PIX_EXIT:
   if( file ) {
      file->close( );
      file = NULL;
   }
   return bRetCode;
}
