#include <pixqt_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include "BibleMikotobaUnit.h"
#include "BibleMikotobaList.h"

BibleMikotobaList::BibleMikotobaList(void)
{
   Init( );
}

BibleMikotobaList::~BibleMikotobaList(void)
{
   _Mikotoba.clear( );
}

BibleMikotobaList &BibleMikotobaList::operator=( const BibleMikotobaList &that )
{
   int nSize;

   _strJpListName = that._strJpListName;
   _strEnListName = that._strEnListName;

   nSize = (int)that._Mikotoba.size( );
   _Mikotoba.resize( nSize );
   qCopy( that._Mikotoba.begin(), that._Mikotoba.end( ), _Mikotoba.begin( ) );

   return *this;
}

//
QString BibleMikotobaList::GetMikotobaFile( void ) 
{
   QString strFile;

   //strFile = QDesktopServices::storageLocation( QDesktopServices::DocumentsLocation );
   //strFile = QDesktopServices::storageLocation( QDesktopServices::ApplicationsLocation );
   strFile = QDesktopServices::storageLocation( QDesktopServices::DataLocation );
  
   strFile.append( "\\Hikari\\mikotoba.xml\0" );

   return strFile;
}

//
// Xg̏
//
void BibleMikotobaList::Init( void ) 
{
   _strJpListName.clear( );
   _strEnListName.clear( );
   _Mikotoba.clear( );

   return;
}

int BibleMikotobaList::Size( void )
{
   return (int)_Mikotoba.size( );
}

BibleMikotobaUnit BibleMikotobaList::GetNthMikotoba( int iPos )
{
   BibleMikotobaUnit unit;
   int nCount;
   
   unit.Clear( );

   if( 0 > iPos ) {
      goto PIX_EXIT;
   }
   
   nCount = (int)_Mikotoba.size( );

   if( nCount <= iPos ) {
      goto PIX_EXIT;
   }

   unit = _Mikotoba.at( iPos );

   // --- Done ---
PIX_EXIT:
   return unit;
}



void BibleMikotobaList::Add( BibleMikotobaUnit unit )
{
   int nCount;
   
   nCount = (int)_Mikotoba.size( );
   
   _Mikotoba.push_back( unit );

   nCount = (int)_Mikotoba.size( );

   return;
}

//
// store this data in file
// file is overwritten!
// XMLt@C𐶐
//
bool BibleMikotobaList::Save( int iRec,
                             QXmlStreamWriter &writer ) 
{
   bool bRetCode =  false;
   QString strFile;
   BibleMikotobaUnit unit;
   int k, nCount;
   QString strMessage, strValue;
   
   // start to write this list

   writer.writeStartElement( "MikotobaList" );

   strValue.sprintf( "%d", iRec );
   writer.writeAttribute( "ID", strValue );

   writer.writeAttribute( "Jp Name", _strJpListName );
   writer.writeAttribute( "En Name", _strEnListName );

   nCount = GetLength( );
   for( k = 0 ; k < nCount ; k++ ) {

      unit = _Mikotoba.at( k );
      unit.Save( k+1, writer ); 
   }

   writer.writeEndElement();

   // --- Done ---
   bRetCode = true;
//PIX_EXIT:
   return bRetCode;
}

bool BibleMikotobaList::Load( QXmlStreamReader &reader )  
{
   bool bRetCode =  false;
   bool bStatus, bOK;
   int nID;
   
   BibleMikotobaUnit unit;

   QString strMessage, strValue;   
   QXmlStreamAttributes attr;

   Init( );

   attr = reader.attributes();

   //
   
   strValue = attr.value( "ID" ).toString();
   nID = strValue.toInt( &bOK );
   if( !bOK ) {
      goto PIX_EXIT;
   }
   
   _strJpListName = attr.value( " JpName" ).toString();
   _strEnListName = attr.value( "EnName" ).toString();

   // read each unit

   bStatus = true;
   while( bStatus ) {

      if( reader.atEnd( ) ) {
         bStatus = false;
         continue;
      }

      if( !reader.readNextStartElement()) {
         bStatus = false;
         continue;
      }

      strValue = reader.name().toString( );
      if( "MikotobaUnit" != strValue ) {
         continue;
      }

      //
      
      if( unit.Load( reader ) ) {
         goto PIX_EXIT;
      }
            
      reader.skipCurrentElement();

      // 

      Add( unit );
   }

   // --- Done ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}