#pragma once

namespace _pix_plot_qt_framework {

#include <pixqtlib_global.h>

//
// Collection of Bookmarks for Bible
//

class BibleMikotobaUnit;

class PIXQTLIB_EXPORT BibleMikotobaList
{
public:
   BibleMikotobaList(void);
   ~BibleMikotobaList(void);

private:
   QString _strJpListName;
   QString _strEnListName;

   // list of mikoto unit
   // mikotoba or label
   vector<BibleMikotobaUnit> _Mikotoba;

public:
   void Init( void );

	BibleMikotobaList &operator=( const BibleMikotobaList &that );

   int GetLength( void ) { return (int)_Mikotoba.size( ); }

   static QString GetMikotobaFile( void );

   void Add( BibleMikotobaUnit unit );
   BibleMikotobaUnit GetNthMikotoba( int iPos );
   int Size( void );
   
   bool Save( int iRec, QXmlStreamWriter &writer );
   bool Load( QXmlStreamReader &reader );

};

} // namespace 
