#include <pixqt_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include "BibleMikotobaUnit.h"

BibleMikotobaUnit::BibleMikotobaUnit(void)
{
   Clear( );
}

BibleMikotobaUnit::~BibleMikotobaUnit(void)
{
   Clear( );
}

BibleMikotobaUnit &BibleMikotobaUnit::operator=( const BibleMikotobaUnit &that )
{
   _iType = that._iType;
   _strJpLabel = that._strJpLabel;
   _strEnLabel = that._strEnLabel;

   _iBook      = that._iBook;
   _iChapter   = that._iChapter;
   _iVerse0    = that._iVerse0;
   _iVerse1    = that._iVerse1;

   return *this;
}


void BibleMikotobaUnit::Clear(void)
{
   _iType = MikotobaUnitUnknown;
   _strJpLabel.clear( );
   _strEnLabel.clear( );
   _iBook = -1;
   _iChapter = -1;
   _iVerse0 = -1;
   _iVerse1 = -1;

   return;
}

void BibleMikotobaUnit::Save( int iRec,
                             QXmlStreamWriter &writer ) 
{
   QString strValue;

   writer.writeStartElement( "MikotobaUnit" );
   
   strValue.sprintf( "%d", iRec );
   writer.writeAttribute( "ID", strValue );
   
   strValue.sprintf( "%d", _iType );
   writer.writeAttribute( "Type", strValue );
   
   switch( _iType ) {
   case MikotobaUnitLabel1:
   case MikotobaUnitLabel2:
      writer.writeAttribute( "Jp Label", _strJpLabel );
      writer.writeAttribute( "En Label", _strEnLabel );
      break;

   case MikotobaUnitVerses:
      strValue.sprintf( "%d", _iBook );
      writer.writeAttribute( "Book", strValue );
   
      strValue.sprintf( "%d", _iChapter );
      writer.writeAttribute( "Chapter", strValue );

      strValue.sprintf( "%d", _iVerse0 );
      writer.writeAttribute( "Verse0", strValue );

      strValue.sprintf( "%d", _iVerse1 );
      writer.writeAttribute( "Verse1", strValue );
      break;
   
   case MikotobaUnitUnknown:
   default:
      break;
   }

   writer.writeEndElement(); 
  
   return;
}

bool BibleMikotobaUnit::Load( QXmlStreamReader &reader ) 
{
   bool bRetCode =  false;
   QString strValue;
   QXmlStreamAttributes attr;
   bool bOK;
   int nID;

   Clear( );

   attr = reader.attributes();

   //
   
   strValue = attr.value( "ID" ).toString();
   nID = strValue.toInt( &bOK );
   if( !bOK ) {
      goto PIX_EXIT;
   }
   
   //

   strValue = attr.value( "Type" ).toString();
   _iType = strValue.toInt( &bOK );
   if( !bOK ) {
      goto PIX_EXIT;
   }

   //

   switch( _iType ) {
   case MikotobaUnitLabel1:
   case MikotobaUnitLabel2:
      _strJpLabel = attr.value( "Jp Label" ).toString();
      _strEnLabel = attr.value( "En Label" ).toString();
      break;

   case MikotobaUnitVerses:
      strValue = attr.value( "Book" ).toString();
      _iBook = strValue.toInt( &bOK );
      if( !bOK ) {
         goto PIX_EXIT;
      }
      
      strValue = attr.value( "Chapter" ).toString();
      _iChapter = strValue.toInt( &bOK );
      if( !bOK ) {
         goto PIX_EXIT;
      }
      
      strValue = attr.value( "Verse0" ).toString();
      _iVerse0 = strValue.toInt( &bOK );
      if( !bOK ) {
         goto PIX_EXIT;
      }
      
      strValue = attr.value( "Verse1" ).toString();
      _iVerse1 = strValue.toInt( &bOK );
      if( !bOK ) {
         goto PIX_EXIT;
      }
      break;
   
   case MikotobaUnitUnknown:
   default:
      break;
   }
  
   // --- Done ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}
