#include <pixqt_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include "BibleOccasion.h"

BibleOccasion::BibleOccasion(void)
{
   Clear( );
}

BibleOccasion::~BibleOccasion(void)
{
}

void BibleOccasion::Clear( void )
{   
   _nOccasion = -1;
   _strOccasion.clear( );
   _strEnOccasion.clear( );

   _nOccasionLine = -1;
   _nOccasionSection = -1;

   _iBook = -1;
   _iChapter = -1;

   _viVerses.clear( );

   _strInKjvLine.clear( );
   _strKjvLine.clear( );
   _strShinkaiLine.clear( );
   _strKougoLine.clear( );

   return;
}

BibleOccasion &BibleOccasion::operator=( const BibleOccasion &that )
{
   int i, nVerses, iVerse;

   _nOccasion        =  that._nOccasion;
   _strOccasion      =  that._strOccasion;
   _strEnOccasion    =  that._strEnOccasion;
   
   _nOccasionLine    =  that._nOccasionLine;
   _nOccasionSection =  that._nOccasionSection;
                             
   _iBook            =  that._iBook;
   _iChapter         =  that._iChapter;

   nVerses = that._viVerses.size( );
   _viVerses.clear( );
   for( i = 0 ; i < nVerses ; i++ ) {
      iVerse = that._viVerses.at( i );
      _viVerses.push_back( iVerse );
   }                             
   
   _strInKjvLine     =  that._strInKjvLine;
   _strKjvLine       =  that._strKjvLine;
   _strShinkaiLine   =  that._strShinkaiLine;
   _strKougoLine     =  that._strKougoLine;

   return *this;
}

void BibleOccasion::AddVerse( int iValue )
{
   _viVerses.push_back( iValue );
}


void BibleOccasion::AddVerseSeq( int iStart, int iEnd )
{
   int i;
   
   if( iStart > iEnd ) goto PIX_EXIT;
   
   for( i = iStart ; i <= iEnd ; i++ ) {
      _viVerses.push_back( i );
   }

PIX_EXIT:
   return;
}


QString BibleOccasion::strVerseBuffer( void )
{
   QString strVerses;
   int iPrevVerse, iVerse, nVerses;

   strVerses.clear( );
   nVerses = _viVerses.size( );

   if( 1 == nVerses ) {
      iVerse = _viVerses.at( 0 );
      strVerses.sprintf( "%d", iVerse );
      
   } else if( 2 == nVerses ) {
      iVerse = _viVerses.at( 1 );
      iPrevVerse = _viVerses.at( 0 );
      if( 1 < iVerse - iPrevVerse ) {
         strVerses.sprintf( "%d,%d", iPrevVerse, iVerse );
      } else {
         strVerses.sprintf( "%d-%d", iPrevVerse, iVerse );
      }

   } else {

      iPrevVerse = _viVerses.first( );
      iVerse = _viVerses.last( );
      strVerses.sprintf( "%d-%d", iPrevVerse, iVerse );
   }

   return strVerses;
}

//
// set english occasion name from occasion number
//
void BibleOccasion::SetEnOccasion( void )
{
   QStringList strEnOccasion;

   strEnOccasion.clear( );

   strEnOccasion.push_back( "Thanksgiving 1" );
   strEnOccasion.push_back( "Thanksgiving 2" );
   strEnOccasion.push_back( "For a birthday 1" );
   strEnOccasion.push_back( "For a birthday 2" );
   strEnOccasion.push_back( "Marriage 1" );
   strEnOccasion.push_back( "Marriage 2 " );
   strEnOccasion.push_back( "For times of anxiety 1" );
   strEnOccasion.push_back( "For times of anxiety 2" );
   strEnOccasion.push_back( "Affliction 1" );
   strEnOccasion.push_back( "Affliction 2" );
   strEnOccasion.push_back( "For sickness 1" );
   strEnOccasion.push_back( "For sickness 2" );
   strEnOccasion.push_back( "Bereavement 1" );
   strEnOccasion.push_back( "Bereavement 2" );
   strEnOccasion.push_back( "Unwelcome news 1" );
   strEnOccasion.push_back( "Unwelcome news 2" );
   strEnOccasion.push_back( "Separation 1" );
   strEnOccasion.push_back( "Separation 2" );
   strEnOccasion.push_back( "Reunion 1" );
   strEnOccasion.push_back( "Reunion 2" );
   strEnOccasion.push_back( "Recovery from sickness 1" );
   strEnOccasion.push_back( "Recovery from sickness 2" );
   strEnOccasion.push_back( "Convalescence 1" );
   strEnOccasion.push_back( "Convalescence 2" );
   strEnOccasion.push_back( "Disappointed hopes 1" );
   strEnOccasion.push_back( "Disappointed hopes 2" );
   strEnOccasion.push_back( "Days of prosperity 1" );
   strEnOccasion.push_back( "Days of prosperity 2" );
   strEnOccasion.push_back( "Success 1" );
   strEnOccasion.push_back( "Success 2" );
   strEnOccasion.push_back( "The birth of a child 1" );
   strEnOccasion.push_back( "The birth of a child 2" );
   strEnOccasion.push_back( "A jubilee 1" );
   strEnOccasion.push_back( "A jubilee 2" );
   strEnOccasion.push_back( "Long life 1" );
   strEnOccasion.push_back( "Long life 2" );
   strEnOccasion.push_back( "The end of the journey 1" );
   strEnOccasion.push_back( "The end of the journey 2" );

   if( 0 >= _nOccasion ) goto PIX_EXIT;
   if( _nOccasion > strEnOccasion.size( ) ) goto PIX_EXIT;

   _strEnOccasion = strEnOccasion.at( _nOccasion-1 );

PIX_EXIT:
   return;
}