#include <pixqt_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include "BiblePlanChapterUnit.h"

BiblePlanChapterUnit::BiblePlanChapterUnit(void)
{
   Clear( );
}

BiblePlanChapterUnit::~BiblePlanChapterUnit(void)
{
   return;
}

void BiblePlanChapterUnit::Clear( void )
{
   _nID = -1;

   _bWhole = false;

   _iBook = -1;   
   _iChapter = -1;
   _iVerse0 = -1;
   _iVerse1 = -1;

   Unread( );

   return;
}

void BiblePlanChapterUnit::Read( int iYear, int iMonth, int iDay ) 
{
   _iReadYear = iYear;
   _iReadMonth = iMonth;
   _iReadDay = iDay;  

   return;
}

void BiblePlanChapterUnit::ReadToday( void ) 
{
   QDateTime today = QDateTime::currentDateTime( );
   QDate dt = today.date( );
   
   _iReadYear = dt.year( ); 
   _iReadMonth = dt.month( ); 
   _iReadDay = dt.day( );

   return;
}

void BiblePlanChapterUnit::Unread( void )
{
   _iReadYear = -1;
   _iReadMonth = -1;
   _iReadDay = -1;

   return;
}

BiblePlanChapterUnit &BiblePlanChapterUnit::operator=( const BiblePlanChapterUnit &that )
{
   _nID        = that._nID;
   _bWhole     = that._bWhole;

   _iBook      = that._iBook;
   _iChapter   = that._iChapter;
   _iVerse0    = that._iVerse0;
   _iVerse1    = that._iVerse1;

   _iReadYear  = that._iReadYear;
   _iReadMonth = that._iReadMonth;
   _iReadDay   = that._iReadDay; 

   return *this;
}

void BiblePlanChapterUnit::Set( int nID, int iBook, int iChapter )
{
   _nID = nID;
   _bWhole = true;
   _iBook = iBook;
   _iChapter = iChapter;

   Unread( );

   return;
}

void BiblePlanChapterUnit::Set( int nID, 
                               int iBook, 
                               int iChapter, 
                               int iVerse0, 
                               int iVerse1 )
{
   _nID = nID;
   _bWhole = false;
   _iBook = iBook;
   _iChapter = iChapter;
   _iVerse0 = iVerse0;
   _iVerse1 = iVerse1;

   Unread( );

   return;
}

bool BiblePlanChapterUnit::Save(  QXmlStreamWriter *writer )
{
   bool bRetCode = false;
   QString strValue;
      
   writer->writeStartElement( "Unit" );
   
   strValue.sprintf( "%d", _nID );
   writer->writeAttribute( "ID", strValue );

   writer->writeAttribute( "Whole", _bWhole ? "Y" : "N" );
   
   strValue.sprintf( "%d", _iBook );
   writer->writeAttribute( "Book", strValue );

   strValue.sprintf( "%d", _iChapter );
   writer->writeAttribute( "Chapter", strValue );

   if( !_bWhole ) {
      strValue.sprintf( "%d", _iVerse0 );
      writer->writeAttribute( "Verse0", strValue );

      strValue.sprintf( "%d", _iVerse1 );
      writer->writeAttribute( "Verse1", strValue );
   }

   strValue.sprintf( "%d", _iReadYear );
   writer->writeAttribute( "Year", strValue );

   strValue.sprintf( "%d", _iReadMonth );
   writer->writeAttribute( "Month", strValue );
   
   strValue.sprintf( "%d", _iReadDay );
   writer->writeAttribute( "Day", strValue );

   writer->writeEndElement( );

	// --- DONE ---
   bRetCode = true;
//PIX_EXIT:
   return bRetCode;
}

bool BiblePlanChapterUnit::Load( QXmlStreamReader *reader )
{
   bool bRetCode = false;
   bool bOK;
   QXmlStreamAttributes attr;
   QString strValue;
   QChar ch;

   Clear( );

   //

   if( reader->atEnd( ) ) {
      goto PIX_EXIT;
   }

   if( !reader->readNextStartElement()) {
      goto PIX_EXIT;
   }


   strValue = reader->name().toString( );
   if( "Unit" != strValue ) {
      goto PIX_EXIT;
   }

   //
   
   attr = reader->attributes( );

   strValue = attr.value( "ID" ).toString();
   _nID = strValue.toInt( &bOK );
   if( !bOK ) {
      goto PIX_EXIT;
   }

   //

   strValue = attr.value( "Whole" ).toString( );
   if( strValue.isEmpty( ) ) {
      goto PIX_EXIT;
   }
   ch = strValue.at( 0 );
   if( "Y" == ch ) {
      _bWhole = true;
   } else {
      _bWhole = false;
   }
   
   //

   strValue = attr.value( "Book" ).toString();
   _iBook = strValue.toInt( &bOK );
   if( !bOK ) {
      goto PIX_EXIT;
   }

   strValue = attr.value( "Chapter" ).toString();
   _iChapter = strValue.toInt( &bOK );
   if( !bOK ) {
      goto PIX_EXIT;
   }

   if( !_bWhole ) {
      strValue = attr.value( "Verse0" ).toString();
      _iVerse0 = strValue.toInt( &bOK );
      if( !bOK ) {
         goto PIX_EXIT;
      }

      strValue = attr.value( "Verse1" ).toString();
      _iVerse1 = strValue.toInt( &bOK );
      if( !bOK ) {
         goto PIX_EXIT;
      }
   }

   //

   strValue = attr.value( "Year" ).toString();
   _iReadYear = strValue.toInt( &bOK );
   if( !bOK ) {
      goto PIX_EXIT;
   }

   strValue = attr.value( "Month" ).toString();
   _iReadMonth = strValue.toInt( &bOK );
   if( !bOK ) {
      goto PIX_EXIT;
   }

   strValue = attr.value( "Day" ).toString();
   _iReadDay = strValue.toInt( &bOK );
   if( !bOK ) {
      goto PIX_EXIT;
   }

   reader->skipCurrentElement();

	// --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}