#pragma once

namespace _pix_plot_qt_framework {

#include <pixqtlib_global.h>

//
// ʓǂ̈񕪂͕̒̈
// 񕪂Ɉ͑ŚA܂͈͂̒̐ߔ͈́@ 
//

class PIXQTLIB_EXPORT BiblePlanChapterUnit
{
public:

public:
   BiblePlanChapterUnit(void);
   ~BiblePlanChapterUnit(void);

private:
   int _nID;

   // read whole chapter
   bool _bWhole;

   int _iBook;
   int _iChapter;
   int _iVerse0;
   int _iVerse1;

   //
   int _iReadYear;
   int _iReadMonth;
   int _iReadDay;

public:
	BiblePlanChapterUnit &operator=( const BiblePlanChapterUnit &that );

   void Set( int nID, int iBook, int iChapter );
   void Set( int nID, int iBook, int iChapter, int iVerse0, int iVerse1 );

   void Unread( void );
   void Clear( void );
   void Read( int iYear, int iMonth, int iDay );
   void ReadToday( void );

   bool Save( QXmlStreamWriter *writer ); 
   bool Load( QXmlStreamReader *reader ); 
   

   int GetID( void ) const { return _nID; }
   bool GetWhole( void ) const { return _bWhole; }

   int GetBook( void ) const { return _iBook; }
   int GetChapter( void ) const { return _iChapter; }
   int GetVerse0( void ) const { return _iVerse0; }
   int GetVerse1( void ) const { return _iVerse1; }

   //
   int GetReadYear( void ) const { return _iReadYear; }
   int GetReadMonth( void ) const { return _iReadMonth; }
   int GetReadDay( void ) const { return _iReadDay; }
};

} // namespace 
