#include <pixqt_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include "BiblePlanChapterUnit.h"
#include "BiblePlanDay.h"

BiblePlanDay::BiblePlanDay(void)
{
   Clear( );
}

BiblePlanDay::~BiblePlanDay(void)
{
   Clear( );
}

BiblePlanDay &BiblePlanDay::operator=( const BiblePlanDay &that )
{
   int nSize = (int)that._Units.size( );

   _nID = that._nID;

   _Units.resize( nSize );
   qCopy( that._Units.begin(), that._Units.end( ), _Units.begin( ) );

   return *this;
}

//
// check if all chaoters for this day are read
// some of the chapters are reads
// or, no cha
short BiblePlanDay::GetReadStatus( void )
{
   short sStatus;
   bool bAllRead;
   int i, iReadYear;
   int nChapters = Size( );
   BiblePlanChapterUnit chapter_unit;
   
   bAllRead = true;
   sStatus = DaysPlanNotRead;

   for( i = 0 ; i < nChapters ; i++ ) {
      chapter_unit = Unit( i );
      iReadYear = chapter_unit.GetReadYear( );
      if( 0 > iReadYear ) {
         bAllRead = false;
         continue;
      }
      sStatus = DaysPlanPartRead;
   }

   if( bAllRead ) {
      sStatus = DaysPlanAllRead;
   }

   return sStatus;
}

int BiblePlanDay::Size( void )
const
{
   return (int)_Units.size( );
}

void BiblePlanDay::setUnit( int iPos, const BiblePlanChapterUnit unit )
{
   int nSize = Size( );

   if( 0 > iPos ) goto PIX_EXIT;
   if( nSize <= iPos ) goto PIX_EXIT;

   _Units.replace( iPos, unit );

PIX_EXIT:
   return;
}

BiblePlanChapterUnit BiblePlanDay::Unit( int iPos )
const
{
   return (BiblePlanChapterUnit)_Units.at( iPos );
}


void BiblePlanDay::Clear( void )
{
   _Units.clear( );

	return;
}

void BiblePlanDay::Set( int nID,
                       const QVector<BiblePlanChapterUnit> &list )
{
   int nSize = (int)list.size( );

   _nID = nID;

   _Units.resize( nSize );
   qCopy( list.begin(), list.end( ), _Units.begin( ) );

   return;
}

bool BiblePlanDay::Save( QXmlStreamWriter *writer )
const
{
   bool bRetCode = false;
   int nUnits, i;
   QString strValue;
   BiblePlanChapterUnit chapter_unit;
      
   nUnits = Size( );
      
   writer->writeStartElement( "Day" );
   
   strValue.sprintf( "%d", _nID );
   writer->writeAttribute( "ID", strValue );
   
   strValue.sprintf( "%d", nUnits );
   writer->writeAttribute( "Size", strValue );

   for( i = 0 ; i < nUnits ; i++ ) {
      chapter_unit = Unit( i );
      if( !chapter_unit.Save( writer ) ) {
         goto PIX_EXIT;
      }
   }

   writer->writeEndElement();

	// --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

bool BiblePlanDay::Load( QXmlStreamReader *reader )
{
   bool bRetCode = false;
   bool bOK;
   int nID, nUnits, i;
   QString strValue;
   QXmlStreamAttributes attr;
   BiblePlanChapterUnit chapter_unit;
      
   Clear( );
   
   //

   if( reader->atEnd( ) ) {
      goto PIX_EXIT;
   }

   if( !reader->readNextStartElement()) {
      goto PIX_EXIT;
   }


   strValue = reader->name().toString( );
   if( "Day" != strValue ) {
      goto PIX_EXIT;
   }

   
   attr = reader->attributes();

   strValue = attr.value( "ID" ).toString();
   nID = strValue.toInt( &bOK );
   if( !bOK ) {
      goto PIX_EXIT;
   }

   strValue = attr.value( "Size" ).toString();
   nUnits = strValue.toInt( &bOK );
   if( !bOK ) {
      goto PIX_EXIT;
   }
   
   for( i = 0 ; i < nUnits ; i++ ) {
      if( !chapter_unit.Load( reader ) ) {
         goto PIX_EXIT;
      }
      _Units.push_back( chapter_unit );
   }

   reader->skipCurrentElement();

	// --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

//
// make a list of chapters, verses to be shown on the table
// separated by return
QString BiblePlanDay::ChaptersList( BibleAllBooks *pBL )
{
   QString strChapter, strList, strBook;
   bool bWhole;
   int k, iBook, iChapter, iVerse0, iVerse1;
   BiblePlanChapterUnit chapter_unit;
   BibleBook bc;

   int nChapters = Size( );

   //

   strList.clear( );
   for( k = 0 ; k < nChapters ; k++ ) {
      chapter_unit = Unit( k );
      
      bWhole = chapter_unit.GetWhole( );
      iBook = chapter_unit.GetBook( );
      bc = pBL->GetBook( iBook-1 );
      strBook = bc.GetBookJpShortame( );
   
      iChapter = chapter_unit.GetChapter( );
      if( bWhole ) {
         strChapter.sprintf( " %d", iChapter );
      } else {
         iVerse0 = chapter_unit.GetVerse0( );
         iVerse1 = chapter_unit.GetVerse1( );
         strChapter.sprintf( " %d:%d-%d", iChapter, iVerse0, iVerse1 );
      }
   
      strList = strList + strBook + strChapter;
      if( nChapters-1 >  k ) strList = strList + "\n\r";
   }

   return strList;
}

//
// shorter list for the table
//
QString BiblePlanDay::ChaptersShortList( BibleAllBooks *pBL )
{
   QString strChapter, strUnit, strList, strBook;
   bool bWhole, bWhole0;
   int iUnit, iLastUnit, iFirst, iLast, k;
   int iBook, iBook0, iChapter, iChapter0, iVerse0, iVerse1;
   BiblePlanChapterUnit chapter_unit, chapter_unit0;
   BibleBook bc;
   vector<int> viUnit;

   int nChapters = Size( );

   // make a list of 'units'

   iUnit = 0;
   viUnit.resize( nChapters );
   for( k = 0 ; k < nChapters ; k++ ) {
      chapter_unit = Unit( k );
      
      iBook = chapter_unit.GetBook( );   
      iChapter = chapter_unit.GetChapter( );

      if( 0 == k ) {
         iUnit = 0;
      } else {
         chapter_unit0 = Unit( k-1 );
         iBook0 = chapter_unit0.GetBook( );   
         iChapter0 = chapter_unit0.GetChapter( );
         if( iBook0 != iBook ) {
            iUnit++;
         } else {
            if( 1 < ( iChapter - iChapter0 ) ) {
               iUnit++;
            }
         }
      }

      viUnit.at( k ) = iUnit;
   }

   //

   iLastUnit = viUnit.at( nChapters-1 );
   strList.clear( );
   for( iUnit = 0 ; iUnit <= iLastUnit ; iUnit++ ) {
      
      iFirst = -1;
      iLast = -1;
      for( k = 0 ; k < nChapters ; k++ ) {
         if( iUnit != viUnit.at( k ) ) continue;
         if( 0 > iFirst ) iFirst = k;
         iLast = k;
      }

      if( iFirst == iLast ) {
         chapter_unit = Unit( iFirst );
         iBook = chapter_unit.GetBook( );
         bc = pBL->GetBook( iBook-1 );
         strBook = bc.GetBookJpShortame( );
         iChapter = chapter_unit.GetChapter( );
         bWhole = chapter_unit.GetWhole( );
         if( bWhole ) {
            strChapter.sprintf( " %d", iChapter );
         } else {
            iVerse0 = chapter_unit.GetVerse0( );
            iVerse1 = chapter_unit.GetVerse1( );
            strChapter.sprintf( " %d:%d-%d", iChapter, iVerse0, iVerse1 );
         }
      } else {
         chapter_unit0 = Unit( iFirst );
         chapter_unit = Unit( iLast );
         //
         iBook = chapter_unit0.GetBook( );
         bc = pBL->GetBook( iBook-1 );
         strBook = bc.GetBookJpShortame( );
         //
         bWhole0 = chapter_unit0.GetWhole( );
         bWhole = chapter_unit.GetWhole( );
         iChapter0 = chapter_unit0.GetChapter( );
         iChapter = chapter_unit.GetChapter( );
         if( bWhole0 && bWhole ) {
            strChapter.sprintf( " %d-%d", iChapter0, iChapter );
         } else if ( !bWhole0 && bWhole ) { 
            iVerse0 = chapter_unit0.GetVerse0( );
            strChapter.sprintf( " %d:%d-%d", iChapter0, iVerse0, iChapter );
         } else if ( bWhole0 && !bWhole ) { 
            iVerse1 = chapter_unit.GetVerse1( );
            strChapter.sprintf( " %d-%d:%d", iChapter0, iChapter, iVerse1 );
         } else {
            iVerse0 = chapter_unit0.GetVerse0( );
            iVerse1 = chapter_unit.GetVerse1( );
            strChapter.sprintf( " %d:%d-%d:%d", iChapter0, iVerse0, iChapter, iVerse1 );
         }
      }

      //

      strList = strList + strBook + strChapter;
      if( iLastUnit != iUnit ) strList = strList + "\n\r";

   }

   return strList;
}

