#include <pixqt_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include "BiblePlanUnit.h"

BiblePlanUnit::BiblePlanUnit(void)
{
   Clear( );
}

BiblePlanUnit::~BiblePlanUnit(void)
{
}

void BiblePlanUnit::Clear( void )
{
   _sType = UnitTypeUnknown;

   _iDay = -1;
   _iBook = -1;

   _iChapter0 = -1;
   _iChapter1 = -1;
   
   _iChapter = -1;
   _iVerse0 = -1;
   _iVerse1 = -1;
}

//
// szBookChapters must look like:
// Genesis 1-2, or
// Psalm 119
// Obadiah 
//
bool BiblePlanUnit::SetBookChapters( int iDay,
                        BibleAllBooks books, 
                        char *szBook,
                        char *szChapters ) // [i] short english book name and chapters
{
   bool bRetCode = false;
   QString strBook, strChapters, strChapter;
   bool bOK;
   int iBook, nChapters, iChapter0, iChapter1; 
   QStringList sep;
   BibleBook bc;

   QChar chBlank = ' ';
   QChar chHyphen = '-';

   _iDay = iDay;

   // decode the string to book and chpaters

   strBook = szBook;
   strBook = strBook.trimmed( );
   if( 0 >= strBook.size( ) ) {
      goto PIX_EXIT;
   }

   iBook = books.FindFromEngName( strBook );
   if( 0 > iBook ) {
      goto PIX_EXIT;
   }

   //
   // split chapter list by hyphen(-)
   // "1-3" split to 1 and 3
   //
      
   strChapters = szChapters;
   strChapters = strChapters.trimmed( );
   if( 0 >= strChapters.size( ) ) {
      iChapter0 = 1;
      iChapter1 = books.GetBookChapters( iBook );
   } else {
      sep = strChapters.split( chHyphen, QString::SkipEmptyParts );
      if( 1 == sep.size( ) ) {
         strChapter = sep.at( 0 );
         iChapter0 = strChapter.toInt( &bOK );
         if( !bOK ) {
            goto PIX_EXIT;
         }
         iChapter1 = iChapter0;
      } else if( 2 == sep.size( ) ) {
         strChapter = sep.at( 0 );
         iChapter0 = strChapter.toInt( &bOK );
         if( !bOK ) {
            goto PIX_EXIT;
         }
         strChapter = sep.at( 1 );
         iChapter1 = strChapter.toInt( &bOK );
         if( !bOK ) {
            goto PIX_EXIT;
         }
      } else {
         goto PIX_EXIT;
      }
   } 

   // check chapter numbers

   nChapters = books.GetBookChapters( iBook );
   if( 0 >= iChapter0 || nChapters < iChapter0 ) {
      goto PIX_EXIT;
   }
   if( 0 >= iChapter1 || nChapters < iChapter1 ) {
      goto PIX_EXIT;
   }

   //

   _sType = UnitTypeBookChapters;
   _iBook = iBook+1;
   _iChapter0 = iChapter0;
   _iChapter1 = iChapter1;   

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}


BiblePlanUnit &BiblePlanUnit::operator=( const BiblePlanUnit &that )
{
   _sType      = that._sType;
   _iDay       = that._iDay;
   _iBook      = that._iBook;

   _iChapter0  = that._iChapter0;
   _iChapter1  = that._iChapter1;

   _iChapter   = that._iChapter;
   _iVerse0    = that._iVerse0;
   _iVerse1    = that._iVerse1;

   return *this;
}


//
// szBookChapters must look like:
// Obadiah
// Genesis 1-2
// Psalm 119
// Luke 1:1-45 
//
bool BiblePlanUnit::SetBookChapterJpVerses( int iDay,
                        BibleAllBooks books, 
                        QString strUnit ) // [i] short english book name and chapters
{
   bool bRetCode = false;
   bool bOK;
   short sType;
   int nVerses, nSize, iBook, nChapters, iChapter0, iChapter1; 
   int iChapter, iVerse0, iVerse1;
   QString strBuffer, strBook, strChapters, strChapter0;
   QString strChapter1, strVerses, strVerse0, strVerse1;
   QStringList sep;
   BibleBook bc;

   QChar chBlank = ' ';
   QChar chColon = ':';
   QChar chHyphen = '-';

   _iDay = iDay;

   // decode the string to book and chpaters

   strUnit = strUnit.trimmed( );
   if( 0 >= strUnit.size( ) ) {
      goto PIX_EXIT;
   }

   sep = strUnit.split( chBlank, QString::SkipEmptyParts );
   nSize = (int)sep.size( );
   if( 0 >= nSize || 2 < nSize ) {
      goto PIX_EXIT;
   }

   // first word must be a short name of the book 
   strBook = sep.at( 0 );
   iBook = books.FindFromJpShort( strBook );
   if( 0 > iBook ) {
      goto PIX_EXIT;
   }

   if( 1 == nSize ) {
      // book name only - read the whole book
      iChapter0 = 1;
      iChapter1 = books.GetBookChapters( iBook );
      sType = UnitTypeBookChapters;
   } else {
      strBuffer = sep.at( 1 );
      //
      // colon?
      //
      sep = strBuffer.split( chColon, QString::SkipEmptyParts );
      nSize = (int)sep.size( );
      //
      if( 1 == nSize ) {
         // chapter(s) only
         strChapters = sep.at( 0 );
         sep = strChapters.split( chHyphen, QString::SkipEmptyParts );
         nSize = (int)sep.size( );
         if( 1 == nSize ) {
            // one chapter only
            strChapter0 = sep.at( 0 );
            iChapter0 = strChapter0.toInt( &bOK );
            if( !bOK ) {
               goto PIX_EXIT;
            }
            iChapter1 = iChapter0;
         } else if( 2 == nSize ) {
            strChapter0 = sep.at( 0 );
            iChapter0 = strChapter0.toInt( &bOK );
            if( !bOK ) {
               goto PIX_EXIT;
            }
            strChapter1 = sep.at( 1 );
            iChapter1 = strChapter1.toInt( &bOK );
            if( !bOK ) {
               goto PIX_EXIT;
            }
         } else {
            goto PIX_EXIT;
         }
         sType = UnitTypeBookChapters;
      } else if( 2 == nSize ) {
         // chapter(s):Verses
         //
         // it must be only one chapter
         strChapters = sep.at( 0 );
         iChapter = strChapters.toInt( &bOK );
         if( !bOK ) {
            goto PIX_EXIT;
         }
         // split verses, must look like 11-22
         strVerses = sep.at( 1 );
         sep = strVerses.split( chHyphen, QString::SkipEmptyParts );
         nSize = (int)sep.size( );
         if( 2 != nSize ) {
            goto PIX_EXIT;
         }
         strVerse0 = sep.at( 0 );
         iVerse0 = strVerse0.toInt( &bOK );
         if( !bOK ) {
            goto PIX_EXIT;
         }
         strVerse1 = sep.at( 1 );
         iVerse1 = strVerse1.toInt( &bOK );
         if( !bOK ) {
            goto PIX_EXIT;
         }
         sType = UnitTypeBookChapterVerses;
      } else {
         goto PIX_EXIT;
      }
   }

   // check chapter numbers

   nChapters = books.GetBookChapters( iBook );
   if( 0 > nChapters ) {
      goto PIX_EXIT;
   }

   switch( sType ) {
   case UnitTypeBookChapters:
      if( 0 >= iChapter0 || nChapters < iChapter0 ) {
         goto PIX_EXIT;
      }
      if( 0 >= iChapter1 || nChapters < iChapter1 ) {
         goto PIX_EXIT;
      }
      _iChapter0 = iChapter0;
      _iChapter1 = iChapter1;   
      break;

   case UnitTypeBookChapterVerses:
      if( 0 >= iChapter || nChapters < iChapter ) {
         goto PIX_EXIT;
      }
      nVerses = books.GetBookChapterVerses( iBook, iChapter );
      if( 0 > nVerses ) {
         goto PIX_EXIT;
      }
      if( 0 >= iVerse0 || nVerses < iVerse0 ) {
         goto PIX_EXIT;
      }
      if( 0 >= iVerse1 || nVerses < iVerse1 ) {
         goto PIX_EXIT;
      }
      //
      _iChapter = iChapter;
      _iVerse0 = iVerse0;
      _iVerse1 = iVerse1;
      break;

   default:
      goto PIX_EXIT;
      break;
   }

   _sType = sType;
   _iBook = iBook+1;

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

bool BiblePlanUnit::SetBookChapterEnVerses( int iDay,
                        BibleAllBooks books, 
                        QString strUnit ) // [i] short english book name and chapters
{
   bool bRetCode = false;
   bool bOK;
   short sType;
   int nVerses, nSize, iBook, nChapters, iChapter0, iChapter1; 
   int iChapter, iVerse0, iVerse1;
   QString strBuffer, strBook, strChapters, strChapter0;
   QString strChapter1, strVerses, strVerse0, strVerse1;
   QStringList sep;
   BibleBook bc;

   QChar chBlank = ' ';
   QChar chColon = ':';
   QChar chHyphen = '-';

   _iDay = iDay;

   // decode the string to book and chpaters

   strUnit = strUnit.trimmed( );
   if( 0 >= strUnit.size( ) ) {
      goto PIX_EXIT;
   }

   sep = strUnit.split( chBlank, QString::SkipEmptyParts );
   nSize = (int)sep.size( );
   if( 0 >= nSize || 2 < nSize ) {
      goto PIX_EXIT;
   }

   // first word must be a short name of the book 
   strBook = sep.at( 0 );
   iBook = books.FindFromEnAbbrev( strBook );
   if( 0 > iBook ) {
      goto PIX_EXIT;
   }

   if( 1 == nSize ) {
      // book name only - read the whole book
      iChapter0 = 1;
      iChapter1 = books.GetBookChapters( iBook );
      sType = UnitTypeBookChapters;
   } else {
      strBuffer = sep.at( 1 );
      //
      // colon?
      //
      sep = strBuffer.split( chColon, QString::SkipEmptyParts );
      nSize = (int)sep.size( );
      //
      if( 1 == nSize ) {
         // chapter(s) only
         strChapters = sep.at( 0 );
         sep = strChapters.split( chHyphen, QString::SkipEmptyParts );
         nSize = (int)sep.size( );
         if( 1 == nSize ) {
            // one chapter only
            strChapter0 = sep.at( 0 );
            iChapter0 = strChapter0.toInt( &bOK );
            if( !bOK ) {
               goto PIX_EXIT;
            }
            iChapter1 = iChapter0;
         } else if( 2 == nSize ) {
            strChapter0 = sep.at( 0 );
            iChapter0 = strChapter0.toInt( &bOK );
            if( !bOK ) {
               goto PIX_EXIT;
            }
            strChapter1 = sep.at( 1 );
            iChapter1 = strChapter1.toInt( &bOK );
            if( !bOK ) {
               goto PIX_EXIT;
            }
         } else {
            goto PIX_EXIT;
         }
         sType = UnitTypeBookChapters;
      } else if( 2 == nSize ) {
         // chapter(s):Verses
         //
         // it must be only one chapter
         strChapters = sep.at( 0 );
         iChapter = strChapters.toInt( &bOK );
         if( !bOK ) {
            goto PIX_EXIT;
         }
         // split verses, must look like 11-22
         strVerses = sep.at( 1 );
         sep = strVerses.split( chHyphen, QString::SkipEmptyParts );
         nSize = (int)sep.size( );
         if( 2 != nSize ) {
            goto PIX_EXIT;
         }
         strVerse0 = sep.at( 0 );
         iVerse0 = strVerse0.toInt( &bOK );
         if( !bOK ) {
            goto PIX_EXIT;
         }
         strVerse1 = sep.at( 1 );
         iVerse1 = strVerse1.toInt( &bOK );
         if( !bOK ) {
            goto PIX_EXIT;
         }
         sType = UnitTypeBookChapterVerses;
      } else {
         goto PIX_EXIT;
      }
   }

   // check chapter numbers

   nChapters = books.GetBookChapters( iBook );
   if( 0 > nChapters ) {
      goto PIX_EXIT;
   }

   switch( sType ) {
   case UnitTypeBookChapters:
      if( 0 >= iChapter0 || nChapters < iChapter0 ) {
         goto PIX_EXIT;
      }
      if( 0 >= iChapter1 || nChapters < iChapter1 ) {
         goto PIX_EXIT;
      }
      _iChapter0 = iChapter0;
      _iChapter1 = iChapter1;   
      break;

   case UnitTypeBookChapterVerses:
      if( 0 >= iChapter || nChapters < iChapter ) {
         goto PIX_EXIT;
      }
      nVerses = books.GetBookChapterVerses( iBook, iChapter );
      if( 0 > nVerses ) {
         goto PIX_EXIT;
      }
      if( 0 >= iVerse0 || nVerses < iVerse0 ) {
         goto PIX_EXIT;
      }
      if( 0 >= iVerse1 || nVerses < iVerse1 ) {
         goto PIX_EXIT;
      }
      //
      _iChapter = iChapter;
      _iVerse0 = iVerse0;
      _iVerse1 = iVerse1;
      break;

   default:
      goto PIX_EXIT;
      break;
   }

   _sType = sType;
   _iBook = iBook+1;

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}
