#include <pixqt_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include "BiblePlanYear.h"

BiblePlanYear::BiblePlanYear(void)
{
   Clear( );
}

BiblePlanYear::~BiblePlanYear(void)
{
   Clear( );
}

BiblePlanYear &BiblePlanYear::operator=( const BiblePlanYear &that )
{
   int nSize;

   _iPlan = that._iPlan;

   //
   nSize = (int)that._DayAssign.size( );
   _DayAssign.resize( nSize );
   qCopy( that._DayAssign.begin(), that._DayAssign.end( ), _DayAssign.begin( ) );

   // no need to copy the tmp buffer!
   
   return *this;
}

void BiblePlanYear::Clear( void )
{
   _iPlan = pixq_Properties::BiblePlanUnknown;

   _DayAssign.clear( );
   _TmpUnitList.clear( );

	return;
}


QString BiblePlanYear::PlanJpTitle( int iPlan )
{
   QString strValue;

   switch( iPlan ) {
   case pixq_Properties::BiblePlanBeginingToEnd:
      strValue = "Sʓ[̃y[Wϓ]";
      break;

   case pixq_Properties::BiblePlanChronological:
      strValue = "SN㏇";
      break;

   case pixq_Properties::BiblePlanOldChronological:
      strValue = "N㏇";
      break;

   case pixq_Properties::BiblePlanNewChronological:
      strValue = "VN㏇";
      break;

   case pixq_Properties::BiblePlanHistorical:
      strValue = "Sꂽ";
      break;

   case pixq_Properties::BiblePlanOldAndNewOneDay:
      strValue = "ƐV𖈓";
      break;

   case pixq_Properties::BiblePlanThematic:
      strValue = "e[}[oCuX^fB[c[]";
      break;

   case pixq_Properties::BiblePlanMichaelColey: 
      strValue = "j[}CPER[]";
      break;
      
   case pixq_Properties::BiblePlanBookOrder:
      strValue = "Sʓ";
      break;

   case pixq_Properties::BiblePlanClassic:
      strValue = "NVbN[3ӏ]";
      break;

   case pixq_Properties::BiblePlanHikariOldNew:
      strValue = "1{V1[Hikari]";
      break;

   case pixq_Properties::BiblePlanHikariNewOldNew:
      strValue = "1{V2[Hikari]";
      break;

   case pixq_Properties::BiblePlanUnknown:
   default:
      strValue.clear( );
      break;
   }

	return strValue;
}

QString BiblePlanYear::PlanEnTitle( int iPlan )
{
   QString strValue;

   switch( iPlan ) {
   case pixq_Properties::BiblePlanBeginingToEnd:
      strValue = "Beginning to End[equable pages]";
      break;

   case pixq_Properties::BiblePlanChronological:
      strValue = "Chronological";
      break;

   case pixq_Properties::BiblePlanOldChronological:
      strValue = "Chronological[Old Testament]";
      break;

   case pixq_Properties::BiblePlanNewChronological:
      strValue = "Chronological[New Testament]";
      break;

   case pixq_Properties::BiblePlanHistorical:
      strValue = "Historical";
      break;

   case pixq_Properties::BiblePlanOldAndNewOneDay:
      strValue = "Old and New";
      break;

   case pixq_Properties::BiblePlanMichaelColey: 
      strValue = "By Subjects - Michael Coley";
      break;

   case pixq_Properties::BiblePlanThematic:
      strValue = "Thematic[Bible Study Tools]";
      break;
      
   case pixq_Properties::BiblePlanBookOrder:
      strValue = "Book Order";
      break;

   case pixq_Properties::BiblePlanClassic:
      strValue = "Classic";
      break;

   case pixq_Properties::BiblePlanHikariOldNew:
      strValue = "Old+New[Hikari]";
      break;

   case pixq_Properties::BiblePlanHikariNewOldNew:
      strValue = "New+Old+New[Hikari]";
      break;

   case pixq_Properties::BiblePlanUnknown:
   default:
      strValue.clear( );
      break;
   }

	return strValue;
}

QString BiblePlanYear::PlanJpNote( int iPlan )
{
   QString strValue;

   switch( iPlan ) {
   case pixq_Properties::BiblePlanBeginingToEnd:
      strValue = "nL̏߂Aَ^̏I܂Őʓ";
      break;

   case pixq_Properties::BiblePlanChronological:
      strValue = "nɉĐʓǁBƂ΁Au͓Vnn̂΂炭ŐAAunɐ܂Ă̂ŁAuL͑nL̓rœǂ";
      break;

   case pixq_Properties::BiblePlanOldChronological:
      strValue = "nɉċ񐹏ʓ";
      break;

   case pixq_Properties::BiblePlanNewChronological:
      strValue = "nɉĐV񐹏ʓ";
      break;

   case pixq_Properties::BiblePlanHistorical:
      strValue = "eꂽԂɉĒʓ";
      break;

   case pixq_Properties::BiblePlanOldAndNewOneDay:
      strValue = "AƐV񂩂班";
      break;

   case pixq_Properties::BiblePlanMichaelColey: 
      strValue = "@/j///a//Ȃ̃e[}ƂɕBǂޗʂ͕΂Ă";
      break;

   case pixq_Properties::BiblePlanThematic:
      strValue = "V薈eӏe[}ʂ+";
      break;
      
   case pixq_Properties::BiblePlanBookOrder:
      strValue = "SԂǂɁBɓǂޗʂ͂ł邾ϓɂȂĂ";
      break;

   case pixq_Properties::BiblePlanClassic:
      strValue = "A3ӏ\nӏǂނƂ";
      break;

   case pixq_Properties::BiblePlanHikariOldNew:
      strValue = "[Hikari]񁨐VBɓǂޕ͂ł邾ϓɁAA͂̓rŕȂ";
      break;

   case pixq_Properties::BiblePlanHikariNewOldNew:
      strValue = "[Hikari]V񁨋񁨐VBɓǂޕ͂ł邾ϓɁAA͂̓rŕȂ";
      break;

   case pixq_Properties::BiblePlanUnknown:
   default:
      strValue.clear( );
      break;
   }

	return strValue;
}

QString BiblePlanYear::PlanEnNote( int iPlan )
{
   QString strValue;

   switch( iPlan ) {
   case pixq_Properties::BiblePlanBeginingToEnd:
      strValue = "Read the Bible from start to finish, from Genesis to Revelation.";
      break;

   case pixq_Properties::BiblePlanChronological:
      strValue = "Read the Bible as its events occurred in real time. For example, Job lived sometime after the beginning of creation (Genesis 1) but before Abraham was born (Genesis 12). As a result, the Book of Job is integrated into the Book of Genesis.";
      break;

   case pixq_Properties::BiblePlanOldChronological:
      strValue = "Read the Bible as its events occurred in real time. For example, Job lived sometime after the beginning of creation (Genesis 1) but before Abraham was born (Genesis 12). As a result, the Book of Job is integrated into the Book of Genesis.";
      break;

   case pixq_Properties::BiblePlanNewChronological:
      strValue = "Read the Bible as its events occurred in real time. For example, Job lived sometime after the beginning of creation (Genesis 1) but before Abraham was born (Genesis 12). As a result, the Book of Job is integrated into the Book of Genesis.";
      break;

   case pixq_Properties::BiblePlanHistorical:
      strValue = "Read the books of the Bible as they were written historically, according to the estimated date of their writing.";
      break;

   case pixq_Properties::BiblePlanOldAndNewOneDay:
      strValue = "Each day includes a passage from both the Old Testament and New Testament.";
      break;

   case pixq_Properties::BiblePlanThematic:
      strValue = "This Bible reading schedule is thematic or connective in nature.";
      break;

   case pixq_Properties::BiblePlanMichaelColey: 
      strValue = "By Subjects - Michael Coley";
      break;
      
   case pixq_Properties::BiblePlanBookOrder:
      strValue = "Read from Genesis 1 to Revelation 22 in the order in which the books of the Bible are arranged.";
      break;

   case pixq_Properties::BiblePlanClassic:
      strValue = "Read 3 passages each day, starting with Genesis, Psalms, and Luke. From the original Bible Study Tools reading plan.";
      break;

   case pixq_Properties::BiblePlanHikariOldNew:
      strValue = "Read the Old Testament once and the New Testament Once[Hikari]";
      break;

   case pixq_Properties::BiblePlanHikariNewOldNew:
      strValue = "Read the New Testament, the Old Testament then the New Testament again[Hikari]";
      break;

   case pixq_Properties::BiblePlanUnknown:
   default:
      strValue.clear( );
      break;
   }

	return strValue;
}


//
// add reading unit to temporary unit list
//
bool BiblePlanYear::AddTmpBookChapters( int iDay,
                                       BibleAllBooks books, 
                                       char *szBook,
                                       char *szChapters ) // [i] short english book name and chapters )
{
   bool bRetCode = false; 
   BiblePlanUnit unit;

   if( !unit.SetBookChapters( iDay, books, szBook, szChapters ) ) {
      goto PIX_EXIT;
   }

   _TmpUnitList.push_back( unit );

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

//
// 1Sam 18-20; Ps 11; Ps 59  
//
bool BiblePlanYear::AddChronologicalDay( int iDay, 
                                        BibleAllBooks books, 
                                        char *szUnits ) // [i] short english book name and chapters )
{
   bool bRetCode = false; 
   int i, nCount;
   BiblePlanUnit unit;
   QString strUnits, strUnit;
   QStringList sep;

   QChar chBlank = ';';

   strUnits = szUnits;
   strUnits = strUnits.trimmed( );
   sep = strUnits.split( chBlank, QString::SkipEmptyParts );
   nCount = (int)sep.size( );

   for( i = 0 ; i < nCount ; i++ ) {
      strUnit = sep.at( i );
      if( !unit.SetBookChapterEnVerses( iDay, books, strUnit ) ) {
         goto PIX_EXIT;
      }
      _TmpUnitList.push_back( unit );
   }   

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

bool BiblePlanYear::AddHikariDay( int iDay, 
                                 BibleAllBooks books, 
                                 char *szUnits ) // [i] short english book name and chapters )
{
   bool bRetCode = false; 
   int i, nCount;
   BiblePlanUnit unit;
   QString strUnits, strUnit;
   QStringList sep;

   QChar chBlank = ';';

   strUnits = szUnits;
   strUnits = strUnits.trimmed( );
   sep = strUnits.split( chBlank, QString::SkipEmptyParts );
   nCount = (int)sep.size( );

   for( i = 0 ; i < nCount ; i++ ) {
      strUnit = sep.at( i );
      if( !unit.SetBookChapterJpVerses( iDay, books, strUnit ) ) {
         goto PIX_EXIT;
      }
   }

   _TmpUnitList.push_back( unit );

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

void BiblePlanYear::setList( void )
{
   int i, k, iUnit, nDayUnits, iDay, nFirstDay, nLastDay;
   int kk, iChapter, iVerse0, iVerse1, iBook, iChapter0, iChapter1;
   short sType;
   BiblePlanChapterUnit chapterunit;
   BiblePlanUnit unit;
   BiblePlanDay day_unit;
   QVector<BiblePlanUnit> DayUnitList;
   QVector<BiblePlanChapterUnit> DayChaptersList;

   int nUnits = _TmpUnitList.size( );

   unit = _TmpUnitList.at( nUnits - 1 );   
   nLastDay = unit.GetDay( );
   
   unit = _TmpUnitList.at( 0 );   
   nFirstDay = unit.GetDay( );

   _DayAssign.clear( );

   for( i = nFirstDay ; i <= nLastDay ; i++ ) {
      DayUnitList.clear( );
      for( k = 0 ; k < nUnits ; k++ ) {
         unit = _TmpUnitList.at( k );   
         iDay = unit.GetDay( );
         if( i != iDay ) continue;
         DayUnitList.push_back( unit );
      }

      //
      nDayUnits = (int)DayUnitList.size( );
      DayChaptersList.clear( );
      iUnit = 1;
      for( k = 0 ; k < nDayUnits ; k++ ) {
         unit = DayUnitList.at( k ); 
         chapterunit.Clear( );
         sType = unit.GetType( );
         switch( sType ) {
         case BiblePlanUnit::UnitTypeBookChapters:
            iBook = unit.GetBook( );
            iChapter0 = unit.GetChapter0( );
            iChapter1 = unit.GetChapter1( );
            for( kk = iChapter0 ; kk <= iChapter1 ; kk++ ) {
               chapterunit.Set( iUnit++, iBook, kk );
               DayChaptersList.push_back( chapterunit );
            }
            break;

         case BiblePlanUnit::UnitTypeBookChapterVerses:
            iBook = unit.GetBook( );
            iChapter = unit.GetChapter( );
            iVerse0 = unit.GetVerse0( );
            iVerse1 = unit.GetVerse1( );
            chapterunit.Set( iUnit++, iBook, iChapter, iVerse0, iVerse1 );
            DayChaptersList.push_back( chapterunit );
            break;

         case BiblePlanUnit::UnitTypeUnknown:
         default:
            continue;
            break;
         }

      }
      
      day_unit.Set( i, DayChaptersList );
      _DayAssign.push_back( day_unit );
   }

   _TmpUnitList.clear( );

	return;
}

QString BiblePlanYear::GetPlanFile( int iPlan )
{
   QString strFile, strPath;

   strFile = QDesktopServices::storageLocation( QDesktopServices::DataLocation );

   strPath.sprintf( "\\Hikari\\read_plan_%03d.xml\0", iPlan );
   strFile.append( strPath );

	return strFile;
}

bool BiblePlanYear::InitPlan( int iPlan )
{
   bool bRetCode = false;

   // failed to looad from file....
   // create and save!

   switch( iPlan ) {
   case pixq_Properties::BiblePlanBeginingToEnd:
      CreateBeginingToEnd( );
      break;

   case pixq_Properties::BiblePlanChronological:
      CreateChronological( );
      break;

   case pixq_Properties::BiblePlanOldChronological:
      CreateOldChronological( );
      break;

   case pixq_Properties::BiblePlanNewChronological:
      CreateNewChronological( );
      break;

   case pixq_Properties::BiblePlanHistorical:
      CreateHistorical( );
      break;

   case pixq_Properties::BiblePlanOldAndNewOneDay:
      CreateOldAndNewOneDay( );
      break;

   case pixq_Properties::BiblePlanMichaelColey: 
      CreateMichaelColey( );
      break;
      
   case pixq_Properties::BiblePlanThematic:
      CreateThematic( );
      break;

   case pixq_Properties::BiblePlanBookOrder:
      CreateBookOrder( );
      break;

   case pixq_Properties::BiblePlanClassic:
      CreateClassic( );
      break;

   case pixq_Properties::BiblePlanHikariOldNew:
      CreateHikariOldNew( );
      break;

   case pixq_Properties::BiblePlanHikariNewOldNew:
      CreateHikariNewOldNew( );
      break;

   case pixq_Properties::BiblePlanUnknown:
   default:
      goto PIX_EXIT;
      break;
   }

   if( !SavePlan( ) ) {
      goto PIX_EXIT;
   }

	// --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

bool BiblePlanYear::SavePlan( void )
{
   bool bRetCode = false;
   int nDays, k;
   QFile *file = NULL;
   QString strValue;
   QXmlStreamWriter writer;
   BiblePlanDay day_unit;

   QString strFile = GetPlanFile( _iPlan );

   // create output xml file
   
   if( !CreateFolder_PC( strFile ) ) {
      // ERROR! Failed to Create Temporary Path
      goto PIX_EXIT;
   }

   file = new QFile( strFile );
   if ( !file->open( QFile::WriteOnly | QFile::Text ) ) {
      goto PIX_EXIT;
   }

   writer.setAutoFormatting( true );
   writer.setDevice( file );

   writer.writeStartDocument();
   //writer.writeDTD("<!DOCTYPE occasions>");

   writer.writeStartElement( "hikari" );
   writer.writeAttribute( "version", "1.0");
   writer.writeAttribute( "data", "readplan" );

   // plan

   strValue.sprintf( "%d", _iPlan );
   writer.writeAttribute( "plan", strValue );

   // plan name

   strValue = PlanJpTitle( _iPlan );
   writer.writeAttribute( "plan_jp_name", strValue );

   strValue = PlanEnTitle( _iPlan );
   writer.writeAttribute( "plan_en_name", strValue );

   // number of days 

   nDays = (int)_DayAssign.size( );
   strValue.sprintf( "%d", nDays );
   writer.writeAttribute( "days", strValue );

   // store each day

   for( k = 0 ; k < nDays ; k++ ) {
      day_unit = _DayAssign.at( k );
      if( !day_unit.Save( &writer ) ) {
         goto PIX_EXIT;      
      }
   }

   // end the last section

   writer.writeEndElement();

   // create output xml file

   writer.writeEndDocument();

	// --- DONE ---
   bRetCode = true;
PIX_EXIT:
   if( file ) {
      file->close( );
      file = NULL;
   }
   return bRetCode;
}

bool BiblePlanYear::LoadPlan( int iPlan )
{
   bool bRetCode = false;
   bool bOK;
   int nDays, k, iReadPlan;
   QString strFile, strValue;   
   QFile *file = NULL;
   BiblePlanDay day_unit;
   QXmlStreamReader reader;
   QXmlStreamAttributes attr;
   
   Clear( );

   //
   // try to load the bible plan from xml file
   // init the plan and create the new xml file
   // 

   strFile = GetPlanFile( iPlan );

   file = new QFile( strFile );   
   if ( !file->open( QIODevice::ReadOnly | QIODevice::Text ) ) {
      goto PIX_EXIT;
   }

   reader.setDevice( file );

   if( !reader.readNextStartElement( ) ) {
      goto PIX_EXIT;
   }

   if( reader.name() != "hikari" ) {
      goto PIX_EXIT;
   }
   
   attr = reader.attributes();
   if( attr.value("version") != "1.0") {
      goto PIX_EXIT;
   }

   if( attr.value("data") != "readplan") {
      goto PIX_EXIT;
   }

   strValue = attr.value( "plan" ).toString();
   iReadPlan = strValue.toInt( &bOK );
   if( !bOK ) {
      goto PIX_EXIT;
   }

   if( iReadPlan != iPlan ) {
      goto PIX_EXIT;
   }

   strValue = attr.value( "days" ).toString();
   nDays = strValue.toInt( &bOK );
   if( !bOK ) {
      goto PIX_EXIT;
   }


   _iPlan = iPlan;

   for( k = 0 ; k < nDays ; k++ ) {
      if( !day_unit.Load( &reader ) ) {
         goto PIX_EXIT;      
      }
      _DayAssign.push_back( day_unit );
   }

	// --- DONE ---
   bRetCode = true;
PIX_EXIT:
   if( file ) {
      file->close( );
      file = NULL;
   }
   return bRetCode;
}


bool BiblePlanYear::LoadInitPlan( int iPlan )
{
   bool bRetCode = false;
   
   Clear( );

   //
   // try to load the bible plan from xml file
   // init the plan and create the new xml file
   // 

   if( !LoadPlan( iPlan ) ) {
   
      // failed to load from file....
      // create and save new plan file!

      if( !InitPlan( iPlan ) ) {
         goto PIX_EXIT;
      }
   }

	// --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

BiblePlanDay BiblePlanYear::GetDaysPlan( int iDay ) // [i] start from zero
const
{
   BiblePlanDay day;
   int nDays = NumberOfDays( );

   if( 0 > iDay || nDays <= iDay ) {
      day.Clear( );
      goto PIX_EXIT;
   }

   day = _DayAssign.at( iDay );

PIX_EXIT:
   return day;
}

void BiblePlanYear::setDaysPlan( int iDay, 
                                const BiblePlanDay day )
{
   int nDays = NumberOfDays( );

   if( 0 > iDay || nDays <= iDay ) {
      goto PIX_EXIT;
   }

   _DayAssign.replace( iDay, day );

PIX_EXIT:
   return;
}

int BiblePlanYear::NumberOfDays( void ) 
const
{
   int nDays = (int)_DayAssign.size( );

   return nDays;
}

//
// bible read plan, return the last read day for the plan
//
int BiblePlanYear::GetLastReadDay( pixq_Properties *pEnv ) 
{
   int iPlan = pEnv->_HikariPlanSelected.iGet( );
   int iDay;

   switch( iPlan ) {
   case pixq_Properties::BiblePlanBeginingToEnd:
      iDay = pEnv->_HikariPlanBeginingToEndDay.iGet( );
      break;

   case pixq_Properties::BiblePlanChronological:
      iDay = pEnv->_HikariPlanChronologicalDay.iGet( );
      break;

   case pixq_Properties::BiblePlanOldChronological:
      iDay = pEnv->_HikariPlanOldChronologicalDay.iGet( );
      break;

   case pixq_Properties::BiblePlanNewChronological:
      iDay = pEnv->_HikariPlanNewChronologicalDay.iGet( );
      break;

   case pixq_Properties::BiblePlanHistorical:
      iDay = pEnv->_HikariPlanHistoricalDay.iGet( );
      break;

   case pixq_Properties::BiblePlanOldAndNewOneDay:
      iDay = pEnv->_HikariPlanOldAndNewOneDayDay.iGet( );
      break;

   case pixq_Properties::BiblePlanMichaelColey:
      iDay = pEnv->_HikariPlanMichaelColeyDay.iGet( ); 
      break;

   case pixq_Properties::BiblePlanThematic:
      iDay = pEnv->_HikariPlanThematicDay.iGet( );
      break;

   case pixq_Properties::BiblePlanBookOrder:
      iDay = pEnv->_HikariPlanBookOrderDay.iGet( );
      break;

   case pixq_Properties::BiblePlanClassic:
      iDay = pEnv->_HikariPlanClassicDay.iGet( );
      break;

   case pixq_Properties::BiblePlanHikariOldNew:
      iDay = pEnv->_HikariPlanHikariOldNewDay.iGet( );
      break;

   case pixq_Properties::BiblePlanHikariNewOldNew:
      iDay = pEnv->_HikariPlanHikariNewOldNewDay.iGet( );
      break;

   case pixq_Properties::BiblePlanUnknown:
   default:
     iDay = 0;
     break;
   }

	return iDay;
}


//
// bible read plan, return the last read day for the plan
//
void BiblePlanYear::SetLastReadDay( pixq_Properties *pEnv, 
                                  int iDay,
                                  QString strOrg,
                                  QString strApp )
{
   int iPlan = pEnv->_HikariPlanSelected.iGet( );

   switch( iPlan ) {
   case pixq_Properties::BiblePlanBeginingToEnd:
      pEnv->_HikariPlanBeginingToEndDay.Set( iDay );
      break;

   case pixq_Properties::BiblePlanChronological:
      pEnv->_HikariPlanChronologicalDay.Set( iDay );
      break;

   case pixq_Properties::BiblePlanOldChronological:
      pEnv->_HikariPlanOldChronologicalDay.Set( iDay );
      break;

   case pixq_Properties::BiblePlanNewChronological:
      pEnv->_HikariPlanNewChronologicalDay.Set( iDay );
      break;

   case pixq_Properties::BiblePlanHistorical:
      pEnv->_HikariPlanHistoricalDay.Set( iDay );
      break;

   case pixq_Properties::BiblePlanOldAndNewOneDay:
      pEnv->_HikariPlanOldAndNewOneDayDay.Set( iDay );
      break;

   case pixq_Properties::BiblePlanMichaelColey: 
      pEnv->_HikariPlanMichaelColeyDay.Set( iDay ); 
      break;

   case pixq_Properties::BiblePlanThematic:
      pEnv->_HikariPlanThematicDay.Set( iDay );
      break;
      
   case pixq_Properties::BiblePlanBookOrder:
      pEnv->_HikariPlanBookOrderDay.Set( iDay );
      break;

   case pixq_Properties::BiblePlanClassic:
      pEnv->_HikariPlanClassicDay.Set( iDay );
      break;

   case pixq_Properties::BiblePlanHikariOldNew:
      pEnv->_HikariPlanHikariOldNewDay.Set( iDay );
      break;

   case pixq_Properties::BiblePlanHikariNewOldNew:
      pEnv->_HikariPlanHikariNewOldNewDay.Set( iDay );
      break;

   case pixq_Properties::BiblePlanUnknown:
   default:
     goto PIX_EXIT;
     break;
   }

   pEnv->SetRegEnv( strOrg, strApp );

PIX_EXIT:
   return;
}


//
// set size (rows and columns) of table to show the plan
// according tothe size of the whole plan(number of days)
//
void BiblePlanYear::setTableRows( QVector<int> &tableRows )
const
{
   int i, nCols;

   int nDays = NumberOfDays( );

   switch( nDays ) {
   case 364:
      // 364 days
      // 52 weeks, 7 * 52
      tableRows.resize( 7 );
      tableRows.fill( 52 );
	   break;
      
   case 365:
      // every day one year, divide by month
      tableRows.resize( 12 );
      tableRows.replace( 0, 31 ); 
      tableRows.replace( 1, 28 );
      tableRows.replace( 2, 31 );
      tableRows.replace( 3, 30 );
      tableRows.replace( 4, 31 );
      tableRows.replace( 5, 30 );
      tableRows.replace( 6, 31 );
      tableRows.replace( 7, 31 );
      tableRows.replace( 8, 30 );
      tableRows.replace( 9, 31 );
      tableRows.replace( 10, 30 );
      tableRows.replace( 11, 31 );
	   break;

   case 273:
      tableRows.resize( 8 );
      tableRows.replace( 0, 35 ); 
      tableRows.replace( 1, 35 );
      tableRows.replace( 2, 35 );
      tableRows.replace( 3, 35 );
      tableRows.replace( 4, 35 );
      tableRows.replace( 5, 35 );
      tableRows.replace( 6, 35 );
      tableRows.replace( 7, 28 );
	   break;

   case 92:
      tableRows.resize( 3 );
      tableRows.replace( 0, 31 ); 
      tableRows.replace( 1, 31 );
      tableRows.replace( 2, 30 );
	   break;

   default:
      nCols = 5;
      if( nDays < nCols ) {
         tableRows.resize( 1 );
         tableRows.replace( 0, nDays ); 
      } else {
         double dRow = (double)nDays / (double)nCols;
         int nRow = (int)floor( dRow );
         int nAmari = nDays % nCols;
         tableRows.resize( nCols );
         for( i = 0 ; i < nCols ; i++ ) {
            if( i < nAmari ) {
               tableRows.replace( i, nRow+1 ); 
            } else {
               tableRows.replace( i, nRow ); 
            }
         }
      }
      break;
   }
   
   // --- DONE ---
//PIX_EXIT:
   return;
}

int BiblePlanYear::GetNumberOfDays( int iPlan )
{
   int nDays = -1;

   //
   // try to load the bible plan from xml file
   // init the plan and create the new xml file
   // 

   nDays = ReadNumberOfDays( iPlan );
   if( 0 > nDays ) {
   
      // failed to looad from file....
      // create and save!

      BiblePlanYear plan;

      if( !plan.InitPlan( iPlan ) ) {
         goto PIX_EXIT;
      }

      nDays = plan.NumberOfDays( );
      plan.Clear( );
   }

	// --- DONE ---
PIX_EXIT:
   return nDays;
}


int BiblePlanYear::ReadNumberOfDays( int iPlan )
{
   bool bOK;
   int nDays, iReadPlan;
   QString strFile, strValue;   
   QFile *file = NULL;
   BiblePlanDay day_unit;
   QXmlStreamReader reader;
   QXmlStreamAttributes attr;
   
   nDays = -1;

   //
   // try to load the bible plan from xml file
   // init the plan and create the new xml file
   // 

   strFile = GetPlanFile( iPlan );

   file = new QFile( strFile );   
   if ( !file->open( QIODevice::ReadOnly | QIODevice::Text ) ) {
      goto PIX_EXIT;
   }

   reader.setDevice( file );

   if( !reader.readNextStartElement( ) ) {
      goto PIX_EXIT;
   }

   if( reader.name() != "hikari" ) {
      goto PIX_EXIT;
   }
   
   attr = reader.attributes();
   if( attr.value("version") != "1.0") {
      goto PIX_EXIT;
   }

   if( attr.value("data") != "readplan") {
      goto PIX_EXIT;
   }

   strValue = attr.value( "plan" ).toString();
   iReadPlan = strValue.toInt( &bOK );
   if( !bOK ) {
      goto PIX_EXIT;
   }

   if( iReadPlan != iPlan ) {
      goto PIX_EXIT;
   }

   strValue = attr.value( "days" ).toString();
   nDays = strValue.toInt( &bOK );
   if( !bOK ) {
      goto PIX_EXIT;
   }

	// --- DONE ---
PIX_EXIT:
   if( file ) {
      file->close( );
      file = NULL;
   }
   return nDays;
}