#pragma once

namespace _pix_plot_qt_framework {

#include <pixqtlib_global.h>

//
// ʓǂ̋L^
//
   
class BibleReadUnit;
class BiblePlanDay;
class pixq_Properties;

class PIXQTLIB_EXPORT BiblePlanYear
{
public:
   BiblePlanYear(void);
   ~BiblePlanYear(void);

private:
   // one of dddd::BibleYearReadPlan
   int _iPlan;

   // list of daily plans
   QVector<BiblePlanDay> _DayAssign;

   // work buffer
   QVector<BiblePlanUnit> _TmpUnitList;

private:
	BiblePlanYear &operator=( const BiblePlanYear &that );

   bool AddChronologicalDay( int iDay, BibleAllBooks books,
      char *szUnits );
   
   bool AddTmpBookChapters( int iDay, BibleAllBooks books,
      char *szBook, char *szChapters );
   
   bool AddHikariDay( int iDay, BibleAllBooks books,
      char *szUnits );

public:
   BiblePlanDay GetDaysPlan( int iDay ) const;
   void setDaysPlan( int iDay, const BiblePlanDay day );

   int NumberOfDays( void ) const;
   void setList( void );
   void Clear( void );

   void CreateMichaelColey( void );
   void CreateThematic( void );

   void CreateChronological( void );
   void CreateOldChronological( void );
   void CreateNewChronological( void );
   void CreateBeginingToEnd( void );
   void CreateOldAndNewOneDay( void );
   void CreateHistorical( void );

   void CreateClassic( void );
   void CreateBookOrder( void );

   void CreateHikariOldNew( void );
   void CreateHikariNewOldNew( void );

public:
   static QString PlanJpTitle( int iPlan );
   static QString PlanEnTitle( int iPlan );
   static QString PlanJpNote( int iPlan );
   static QString PlanEnNote( int iPlan );
   
   static QString GetPlanFile( int iPlan );
   
   bool InitPlan( int iPlan );
   bool LoadPlan( int iPlan );
   bool LoadInitPlan( int iPlan );
   static int GetNumberOfDays( int iPlan );
   static int ReadNumberOfDays( int iPlan );
   bool SavePlan( void );
   void setTableRows( QVector<int> &tableRows ) const;

   static int GetLastReadDay( pixq_Properties *pEnv );
   static void SetLastReadDay( pixq_Properties *pEnv, int iDay, QString strOrg, QString strApp );
};

} // namespace 
