#include <pixqt_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include "BibleSetVerses.h"

BibleSetVerses::BibleSetVerses(void)
{
   _iBook = -1;
   _iChapter = -1;

   _viVerses0.clear( );
   _viVerses1.clear( );
}

BibleSetVerses::~BibleSetVerses(void)
{
}

BibleSetVerses &BibleSetVerses::operator=( const BibleSetVerses &that )
{
   int nSize;

   _iBook = that._iBook;
   _iChapter = that._iChapter; 

   //
   nSize = (int)that._viVerses0.size( );
   _viVerses0.resize( nSize );
   qCopy( that._viVerses0.begin(), that._viVerses0.end( ), _viVerses0.begin( ) );

   //
   nSize = (int)that._viVerses1.size( );
   _viVerses1.resize( nSize );
   qCopy( that._viVerses1.begin(), that._viVerses1.end( ), _viVerses1.begin( ) );

   return *this;
}


bool BibleSetVerses::IsSameBook( const BibleSetVerses &that )
{
   bool bRetCode = false; 
   
   if( _iBook != that._iBook ) {
      goto PIX_EXIT;
   }

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

bool BibleSetVerses::IsSameBookChapter( const BibleSetVerses &that )
{
   bool bRetCode = false;
   
   if( _iBook != that._iBook ) {
      goto PIX_EXIT;
   }

   if( _iChapter != that._iChapter ) {
      goto PIX_EXIT;
   }

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}


//
// example
// Psa.23:1,4
//
bool BibleSetVerses::GetBool( BibleAllBooks *pBL,
                        int iVersion, // [i]
                        QString strLine )
{
   bool bRetCode = false;
   bool bOK;
   int iPos, i, iFrom, nComma, iChapter, nNumber, nBookLen, iBook, iSide, nSize;
   int iStart, nVerses, iLength, iVerse0, iVerse1;
   int nHyphen, nColonPos, nBooks = pBL->GetLength( );
   QString strChapter, strNumber, strVerse, strVerses, strVerse0, strVerse1;
   
   QVector<int> viComma;
   QStringList strListVerses;

   QChar chColon = ':';
   QChar chCamma = ',';
   QChar chHyphen = '-';

   //

   nSize = (int)strLine.size( );

   // find the book

   switch( iVersion ) {
   case pixq_Properties::BibleShinkaiyaku2:
   case pixq_Properties::BibleKougoyaku:
      iBook = pBL->FindFromShinkai( strLine, &iSide );
      if( 0 > iBook ) {
         goto PIX_EXIT;
      }
      nBookLen = pBL->ShinkaiShortNameSize( iBook, iSide );
      break;

   case pixq_Properties::BibleKingJames: 
      iBook = pBL->FindFromShortKjv( strLine );
      if( 0 > iBook ) {
         goto PIX_EXIT;
      }
      nBookLen = pBL->KjvShortNameSize( iBook );
      break;

   case pixq_Properties::BibleIntlStandard:
   default:
      goto PIX_EXIT;
      break;
   }

   //
   
   strNumber = strLine.mid( nBookLen, nSize - nBookLen );
   nNumber = (int)strNumber.size( );
   nColonPos = strNumber.indexOf( chColon, 0 );

   if( 0 > nColonPos ) {
      // : Ȃ
      goto PIX_EXIT;
   }

   strChapter = strNumber.left( nColonPos );
   iChapter = strChapter.toInt( &bOK );
   if( !bOK ) {
      // ͔ԍs
      goto PIX_EXIT;
   }
   
   // decompose verse numbers

   strVerses = strNumber.right( nNumber - nColonPos - 1 );
   
   // positions of (

   viComma.clear( );
   viComma.push_back( -1 );

   nComma = strVerses.count( chCamma );
   iFrom = 0;
   for( i = 0 ; i < nComma ; i++ ) {
      iPos = strVerses.indexOf( chCamma, iFrom );
      viComma.push_back( iPos );
      iFrom = iPos + 1;
   }
   
   viComma.push_back( (int)strVerses.size( ) );

   strListVerses.clear( );
   for( i = 0 ; i <= nComma ; i++ ) {
      iStart = (int)viComma.at( i ) + 1;
      iLength = (int)viComma.at( i+1 ) - (int)viComma.at( i ) - 1;
      strVerse = strVerses.mid( iStart, iLength );
      strListVerses.push_back( strVerse );
   }

   _viVerses0.clear( );
   _viVerses1.clear( );

   nVerses = (int)strListVerses.size( );
   for( i = 0 ; i < nVerses ; i++ ) {
      strVerse = strListVerses.at( i );

      // ߔԍɃnCt-܂܂Ă

      nHyphen = strVerse.count( chHyphen );
      if( 0 == nHyphen ) {
         // 1
         iVerse0 = strVerse.toInt( &bOK );
         if( !bOK ) {
            // Verseԍs
            goto PIX_EXIT;
         }
         iVerse1 = iVerse0;
      } else if( 1 == nHyphen ) {
         iPos = strVerse.indexOf( chHyphen, 0 );
         strVerse0 = strVerse.left( iPos );
         strVerse1 = strVerse.right( (int)strVerse.size( ) - iPos - 1 );
         //
         iVerse0 = strVerse0.toInt( &bOK );
         if( !bOK ) {
            // Verseԍs
            goto PIX_EXIT;
         }
         //
         iVerse1 = strVerse1.toInt( &bOK );
         if( !bOK ) {
            // Verseԍs
            goto PIX_EXIT;
         }
         //
         if( iVerse1 <= iVerse0 ) {
            // Verseԍs
            goto PIX_EXIT;
         }
      } else {
         // two or more -... wrong!
         goto PIX_EXIT;
      }

      //

      _viVerses0.push_back( iVerse0 );
      _viVerses1.push_back( iVerse1 );
   }

   //

   _iBook = iBook;
   _iChapter = iChapter;

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}
