#include <pixqt_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include "BibleShiori.h"

BibleShiori::BibleShiori(void)
{
   Init( );
}

BibleShiori::~BibleShiori(void)
{
   return;
}

void BibleShiori::Init( void )
{
   _iBook = -1;
   _iChapter = -1;

   _iReadYear = -1;
   _iReadMonth = -1;
   _iReadDay = -1;

   return;
}

//
// 𕶎
//
QString BibleShiori::SetLabel( BibleAllBooks *pBL,
                              bool bJapanese )
{
   int iBook, iChapter, iYear, iMonth, iDay;
   QDate dt;
   QString strBook, strDate, strLabel;

   BibleBook *pBc;

   if( !Valid( ) ) {
      strLabel = "----";
      goto PIX_EXIT;
   }

   iBook = GetBook( );
   pBc = pBL->pGetBook( iBook-1 );
   iChapter = GetChapter( );
   iYear = GetYear( );
   iMonth = GetMonth( );
   iDay = GetDay( );
   
   if( bJapanese ) {
      strBook = pBc->GetBookJpName( );
      strLabel.sprintf( " %d\t%dN%d%d", iChapter, iYear, iMonth, iDay );
      strLabel = strBook + strLabel;
   } else {
      strBook = pBc->GetBookEnName( );
      dt.setDate( iYear, iMonth, iDay );
      strDate = dt.toString( Qt::SystemLocaleLongDate );
      strLabel.sprintf( " Chapter %d\t", iChapter );
      strLabel = strBook + strLabel + strDate;
   }

   
   // --- DONE ---
PIX_EXIT:
   return strLabel;
}

bool BibleShiori::Valid( void )
{
   bool bRetCode = false;

   if( 0 > _iBook ) {
      goto PIX_EXIT;
   }

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

BibleShiori &BibleShiori::operator=( const BibleShiori &that )
{
   _iBook      = that._iBook;
   _iChapter   = that._iChapter;

   _iReadYear  = that._iReadYear;
   _iReadMonth = that._iReadMonth;
   _iReadDay   = that._iReadDay; 

   return *this;
}

void BibleShiori::Set( int iBook, int iChapter ) 
{
   QDate date;
   int iYear;
   int iMonth;
   int iDay;

   //
   // set today's date
   //

   date = QDate::currentDate( );
   iYear = (int)date.year( );
   iMonth = (int)date.month( );
   iDay = (int)date.day( );

   Set( iBook, iChapter, iYear, iMonth, iDay ); 

   return;
}

void BibleShiori::Set( int iBook,
                      int iChapter,
                      int iYear,
                      int iMonth,
                      int iDay ) 
{
   _iBook = iBook;
   _iChapter = iChapter;
   _iReadYear  = iYear;
   _iReadMonth = iMonth;
   _iReadDay   = iDay; 

   return;
}
