#pragma once

namespace _pix_plot_qt_framework {

#include <pixqtlib_global.h>

//
// Shiori for Bible
//

class BibleAllBooks;

class PIXQTLIB_EXPORT BibleShiori
{
public:
   BibleShiori(void);
   ~BibleShiori(void);

private:
   // book number starting from zero
   int _iBook;
   
   // chapter number starting from zero
   int _iChapter;

   // read date - year
   int _iReadYear;
   
   // read date - month, 1-12
   int _iReadMonth;

   // read date - day, 1-31
   int _iReadDay; 

public:
	BibleShiori &operator=( const BibleShiori &that );

   int GetBook( void ) { return _iBook; }
   int GetChapter( void ) { return _iChapter; }
   int GetYear( void ) { return _iReadYear; }
   int GetMonth( void ) { return _iReadMonth; }
   int GetDay( void ) { return _iReadDay; }

   void Set( int iBook, int iChapter );
   void Set( int iBook, int iChapter, int iYear, int iMonth, int iDay );
   
   void Init( void );
   bool Valid( void );

   QString SetLabel( BibleAllBooks *pBL, bool bJapanese );
};

} // namespace 
