#pragma once

namespace _pix_plot_qt_framework {

#include <pixqtlib_global.h>

class PIXQTLIB_EXPORT pixq_EnvItem
{
public:
   enum {
      ItemBool = 0,
      ItemInt = 1,
      ItemDouble = 2,
      ItemString = 3, // QString
      ItemColor = 4, // QColor(long)
      ItemFont = 5, // QFontInfo
      // to initialize
      ItemUnknown = -1,
   } pixq_EnvItemType;

   //
   // *** Never change these values! ***
   // Item Category
   //
   enum {
      ItemCategoryUnknown = -1,
      //
      // Common
      //
      ItemCategorySystem = 501,
      ItemCategoryCommonGui = 502,
      ItemCategoryImage = 503,
      ItemCategoryPlayback = 504,
      //
      // Bagster
      //
      ItemCategoryBagsterView = 101,
      ItemCategoryBagsterTimer = 102,
      ItemCategoryBagsterWindow = 103,
      //
      // Hikari
      //
      ItemCategoryHikariInit = 201,
      ItemCategoryHikariView = 202,
      ItemCategoryHikariBible = 203,
      ItemCategoryHikariBagster = 204,
      ItemCategoryHikariPlan = 205,
      ItemCategoryHikariEdit = 206,
      //
      // Scope
      //
      ItemCategoryScope = 301,
      //
      // Sampler
      //
      ItemCategoryDftFilter = 401,
      //
      //
      //
   } ItfEnvItemCategory;

public:
   pixq_EnvItem(void);
   ~pixq_EnvItem(void);

   // copy constructor
	pixq_EnvItem &operator=( const pixq_EnvItem &that );
   pixq_EnvItem &operator=( const QColor &that );
   pixq_EnvItem &operator=( const QFont &that );

	bool operator==( const pixq_EnvItem& that );
   
	pixq_EnvItem &CopyValue( const pixq_EnvItem &that );

private:
   // Registry key
   QString _strRegField;

   // item type
   char _cItemType;

   // value for string
   QString _strValue;

   // value for bool, int, double
   void *_Value;

   // value range for int and double
   void *_minValue;
   void *_maxValue;
   bool _bRange;

   // item category
   // must be one of ItfEnvItemCategory
   
   short _sCategory;

public:
   // boolean
   void Set( short sCategory, bool bValue, QString strReg );

   // integer
   void Set( short sCategory, int iValue, QString strReg );
   void Set( short sCategory, int iValue, QString strReg, int iMinValue, int nMaxValue );
   void SetRange( int iMinValue, int nMaxValue );

   // double
   void Set( short sCategory, double dValue, QString strReg );
   void Set( short sCategory, double dValue, QString strReg, double dMinValue, double dMaxValue );
   void SetRange( double dMinValue, double dMaxValue );

   // string
   void Set( short sCategory, QString strValue, QString strReg );
   
   // color
   void Set( short sCategory, QColor colValue, QString strReg );
   
   // font
   void Set( short sCategory, QFont lfValue, QString strReg );
   
   // reset value
   void Set( bool bValue );
   void Set( int iValue );
   void Set( double dValue );
   void Set( QString strValue );
   void Set( QColor colValue );
   void Set( QFont lfValue );

   void GetReg( QString strOrg, QString strApp );
   void SetReg( QString strOrg, QString strApp );
   void RemoveReg( QString strOrg, QString strApp );

   void Clear( void );

   bool CompareItem( const pixq_EnvItem &Item ) const;

   // get values

   bool GetBool( void ) const;
   int iGet( void ) const;
   double dGet( void ) const;
   QString strGet( void ) const;
   QColor colGet( void ) const;
   QFont lfGet( void ) const;
   
   // get range
   bool GetRange( void ) const { return _bRange; }
   int GetIntMin( void ) const;
   int GetIntMax( void ) const;
   double dGetMin( void ) const;
   double dGetMax( void ) const;

public:
   char GetItemType( void ) const { return _cItemType; }
   QString GetRegField( void ) const { return _strRegField; }
   
   short GetCategory( void ) const { return _sCategory; }
   void SetCategory( short sCategory ) { _sCategory = sCategory; }
};

} // namespace 

