//
// pixq_Matrix
// 2D matrix class, data statistics
//

// matrix analysis, statistics and histogram, etc

namespace _pix_plot_qt_framework {

//
// calculate basic statistics of the matrix
// such as min and max values, average and standard deviation
//
// notes:
// if null value is set, it is not included in the calculation
//
template <class T> void pixq_Matrix<T>::Statistics(
   T *vmin, // [o] minimum value, excluding null value
   T *vmax, // [o] maxmum value, excluding null value
   bool bRecalc ) // [i] if true, recalculate all statistics again
{
	int i, j;
	T tValue, tMin, tMax;
   T *pRow = NULL;

   // if the last statistics exists, just return them!

   if( bRecalc ) _bStatSet = false;

   if( _bStatSet ) {
	 	*vmin = _vMin;
	   *vmax = _vMax;
	   goto PIX_EXIT;
   }

   // start to get the statistics

   if( _bNullSet ) {

      // check if there is any valid(not null) value
      bool bFound = false;
	   for( i = 0 ; !bFound && i < _iNrows ; i++ ) {
   	   pRow = _pDataRow[i];
         for( j = 0 ; !bFound && j < _iNcols ; j++ ) {
	   	   
            tValue = *pRow++;
		      if( tValue == _Null ) continue;
            tMin = tValue;
			   tMax = tValue;
		      bFound = true;
         }
      }

      if( !bFound ) {
         tMin = _Null;
			tMax = _Null;
      } else {      
	      for( i = 0 ; i < _iNrows ; i++ ) {
   	      pRow = _pDataRow[i];
            for( j = 0 ; j < _iNcols ; j++ ) {
		         tValue = *pRow++;
		         if( tValue == _Null ) continue;
   		      if( tValue < tMin ) tMin = tValue;
	  		      if( tValue > tMax ) tMax = tValue;
            }
         }
      }

   } else {
      
	   tMin = Get( 0, 0 );
	   tMax = Get( 0, 0 );
      for( i = 0 ; i < _iNrows ; i++ ) {
   	   pRow = _pDataRow[i];
         for( j = 0 ; j < _iNcols ; j++ ) {
			   tValue = *pRow++;
   			if( tValue < tMin ) tMin = tValue;
	   		if( tValue > tMax ) tMax = tValue;
         }
      }
	}

   // set the obtained values

	*vmin = tMin;
	*vmax = tMax;

	_vMin = *vmin;
	_vMax = *vmax;
	_bStatSet = true;

PIX_EXIT:
   return;
}

template <class T> void pixq_Matrix<T>::Statistics( 
   T *vmin,  // [o] minimum value, excluding null value
	T *vmax, // [o] maxmum value, excluding null value
	T *vmean, // [o] average value, excluding null value
   bool bRecalc ) // [i] if true, recalculate all statistics again
{
	double dCount, dMean, dSum;
	int i, j;
   T tValue, tMin, tMax;
   T *pRow = NULL;

   // if the last statistics exists, just return them!

   if( bRecalc ) _bStatSet = false;
   
   if( _bStatSet ) {
      *vmin = _vMin;
		*vmax = _vMax;
		*vmean = _vMean;
	   goto PIX_EXIT;
   }

   // start to get the statistics

   if( _bNullSet ) {

      // check if there is any valid(not null) value
      bool bFound = false;
	   for( i = 0 ; !bFound && i < _iNrows ; i++ ) {
   	   pRow = _pDataRow[i];
         for( j = 0 ; !bFound && j < _iNcols ; j++ ) {
	   	   tValue = *pRow++;
		      if( tValue == _Null ) continue;
            tMin = tValue;
			   tMax = tValue;
		      bFound = true;
         }
      }

      if( !bFound ) {
         dMean = 0.0;
         tMin = _Null;
			tMax = _Null;
      } else {      
         dSum = 0.0;
         dCount = 0.0;
	      for( i = 0 ; i < _iNrows ; i++ ) {
   	      pRow = _pDataRow[i];
            for( j = 0 ; j < _iNcols ; j++ ) {
		         tValue = *pRow++;
		         if( tValue == _Null ) continue;
   		      if( tValue < tMin ) tMin = tValue;
	  		      if( tValue > tMax ) tMax = tValue;
	   	      dSum = dSum + (double)tValue;
               dCount = dCount + 1.0;
            }
         }

         if( 0.0 >= dCount ) {
            dMean = 0.0;
         } else {
            dMean = dSum / dCount;
         }
      }

   } else {
      
	   dSum = 0.0;
      tMin = Get( 0, 0 );
	   tMax = Get( 0, 0 );
      for( i = 0 ; i < _iNrows ; i++ ) {
   	   pRow = _pDataRow[i];
         for( j = 0 ; j < _iNcols ; j++ ) {
			   tValue = *pRow++;
   			if( tValue < tMin ) tMin = tValue;
	   		if( tValue > tMax ) tMax = tValue;
		   	dSum = dSum + (double)tValue;
         }
      }
      
   	dCount = (double)( _iNrows * _iNcols );
      if( 0.0 >= dCount ) {
         dMean = 0.0;
      } else {
         dMean = dSum / dCount;
      }
	}

   // set the obtained values

	*vmin = tMin;
	*vmax = tMax;
	*vmean = (T)dMean;

	_vMin = *vmin;
	_vMax = *vmax;
	_vMean = *vmean;
	_bStatSet = true;

PIX_EXIT:
   return;
}

template <class T> void pixq_Matrix<T>::Statistics( 
	T *vmin,  // [o] minimum value, excluding null value
	T *vmax, // [o] maxmum value, excluding null value
	T *vmean, // [o] average value, excluding null value
	T *stdev, // [o] STANDARD DEVIATION, excluding null value
   bool bRecalc ) // [i] if true, recalculate all statistics again
{
   T tValue, vmin2, vmax2, vmean2;
	int i, j;
	double dCount, dSum, dStDev, dValue2, dMean;
   T *pRow = NULL;

   // if the last statistics exists, just return them!

   if( bRecalc ) _bStatSet = false;

  	if( _bStatSet ) {
   	*vmin = _vMin;
	   *vmax = _vMax;
	   *vmean = _vMean;
	   *stdev = _vstDev;
      goto PIX_EXIT;
   }

   // get value range and average

	*vmin = (T)0;
	*vmax = (T)0;
	*vmean = (T)0;
	*stdev = (T)0;
   dStDev = 0.0;

   Statistics( &vmin2, &vmax2, &vmean2, bRecalc );

   // get stdev

   dMean = (double)vmean2;

   if( _bNullSet ) {

      dCount = 0.0;
      dSum = 0.0;
      for( i = 0 ; i < _iNrows ; i++ ) {
   	   pRow = _pDataRow[i];
         for( j = 0 ; j < _iNcols ; j++ ) {
   		   tValue = *pRow++;
	   	   if( tValue == _Null ) continue;
            dValue2 = (double)tValue - dMean;
            dSum = dSum + dValue2 * dValue2;
            dCount = dCount + 1.0;
         }
      }

      if( 0.0 == dCount ) {
         dStDev = 0.0;
      } else {
         dStDev = sqrt( dSum / dCount );
      }

   } else {

      dSum = 0.0;
      for( i = 0 ; i < _iNrows ; i++ ) {
   	   pRow = _pDataRow[i];
         for( j = 0 ; j < _iNcols ; j++ ) {
   	   tValue = *pRow++;
	         dValue2 = (double)tValue - dMean;
            dSum = dSum + dValue2 * dValue2;
         }
      }
//fprintf( stdout, "*** _iNrows'%d.\n", _iNrows );
//fprintf( stdout, "*** _iNcols'%d.\n", _iNcols );

      dCount = (double)( _iNrows * _iNcols );
      dStDev = sqrt( dSum / dCount );
	}

	*vmin = vmin2;
	*vmax = vmax2;
	*vmean = vmean2;
	*stdev = (T)dStDev;

	_vMin = *vmin;
	_vMax = *vmax;
	_vMean = *vmean;
	_vstDev = *stdev;
	_bStatSet = true;

PIX_EXIT:
   return;
}


template <class T> void pixq_Matrix<T>::Statistics(
   T *vmin, // [o] minimum value, excluding null value
   T *vmax, // [o] maxmum value, excluding null value
   const pixq_Matrix<bool> *pMask,
   bool bRecalc ) // [i] if true, recalculate all statistics again
{
   bool bMask;
	int i, j, nValid;
	T tValue, tMin, tMax;
   T *pRow = NULL;

   // if the last statistics exists, just return them!

   if( bRecalc ) _bStatSet = false;

   if( _bStatSet ) {
	 	*vmin = _vMin;
	   *vmax = _vMax;
	   goto PIX_EXIT;
   }

   // start to get the statistics
      
   nValid = 0;
	tMin = Get( 0, 0 );
	tMax = Get( 0, 0 );
   for( i = 0 ; i < _iNrows ; i++ ) {
      pRow = _pDataRow[i];
      for( j = 0 ; j < _iNcols ; j++ ) {
		   tValue = *pRow++;
         
         bMask = pMask->Get( i, j );
         if( !bMask ) continue;

   		if( tValue < tMin ) tMin = tValue;
			if( tValue > tMax ) tMax = tValue;
         nValid++;
      }
   }
	
   // set the obtained values

	*vmin = tMin;
	*vmax = tMax;

	_vMin = *vmin;
	_vMax = *vmax;
	_bStatSet = true;

PIX_EXIT:
   return;
}

template <class T> void pixq_Matrix<T>::Statistics( 
   T *vmin,  // [o] minimum value, excluding null value
	T *vmax, // [o] maxmum value, excluding null value
	T *vmean, // [o] average value, excluding null value
   const pixq_Matrix<bool> *pMask,
   bool bRecalc ) // [i] if true, recalculate all statistics again
{
   bool bMask;
	double dCount, dMean, dSum;
	int nValid, i, j;
   T tValue, tMin, tMax;
   T *pRow = NULL;

   // if the last statistics exists, just return them!

   if( bRecalc ) _bStatSet = false;
   
   if( _bStatSet ) {
      *vmin = _vMin;
		*vmax = _vMax;
		*vmean = _vMean;
	   goto PIX_EXIT;
   }

   // start to get the statistics
      
   nValid = 0;
	dSum = 0.0;
   tMin = Get( 0, 0 );
	tMax = Get( 0, 0 );
   for( i = 0 ; i < _iNrows ; i++ ) {
      pRow = _pDataRow[i];
      for( j = 0 ; j < _iNcols ; j++ ) {
		   tValue = *pRow++;

         bMask = pMask->Get( i, j );
         if( !bMask ) continue;

   		if( tValue < tMin ) tMin = tValue;
			if( tValue > tMax ) tMax = tValue;
	   	dSum = dSum + (double)tValue;
         nValid++;
      }
   }
   
   dCount = (double)nValid;
   if( 0.0 >= dCount ) {
      dMean = 0.0;
   } else {
      dMean = dSum / dCount;
   }
	
   // set the obtained values

	*vmin = tMin;
	*vmax = tMax;
	*vmean = (T)dMean;

	_vMin = *vmin;
	_vMax = *vmax;
	_vMean = *vmean;
	_bStatSet = true;

PIX_EXIT:
   return;
}

template <class T> void pixq_Matrix<T>::Statistics( 
	T *vmin,  // [o] minimum value, excluding null value
	T *vmax, // [o] maxmum value, excluding null value
	T *vmean, // [o] average value, excluding null value
	T *stdev, // [o] STANDARD DEVIATION, excluding null value
   const pixq_Matrix<bool> *pMask,
   bool bRecalc ) // [i] if true, recalculate all statistics again
{
   bool bMask;
   T tValue, vmin2, vmax2, vmean2;
	int i, j, nValid;
	double dCount, dSum, dStDev, dValue2, dMean;
   T *pRow = NULL;

   // if the last statistics exists, just return them!

   if( bRecalc ) _bStatSet = false;

  	if( _bStatSet ) {
   	*vmin = _vMin;
	   *vmax = _vMax;
	   *vmean = _vMean;
	   *stdev = _vstDev;
      goto PIX_EXIT;
   }

   // get value range and average

	*vmin = (T)0;
	*vmax = (T)0;
	*vmean = (T)0;
	*stdev = (T)0;
   dStDev = 0.0;

   Statistics( &vmin2, &vmax2, &vmean2, pMask, bRecalc );

   // get stdev

   dMean = (double)vmean2;

   nValid = 0;
   dSum = 0.0;
   for( i = 0 ; i < _iNrows ; i++ ) {
      pRow = _pDataRow[i];
      for( j = 0 ; j < _iNcols ; j++ ) {
         tValue = *pRow++;
	      
         bMask = pMask->Get( i, j );
         if( !bMask ) continue;
      
         dValue2 = (double)tValue - dMean;
         dSum = dSum + dValue2 * dValue2;
         nValid++;
      }
   }

   dCount = (double)nValid;
   dStDev = sqrt( dSum / dCount );

	*vmin = vmin2;
	*vmax = vmax2;
	*vmean = vmean2;
	*stdev = (T)dStDev;

	_vMin = *vmin;
	_vMax = *vmax;
	_vMean = *vmean;
	_vstDev = *stdev;
	_bStatSet = true;

PIX_EXIT:
   return;
}

template <class T> void pixq_Matrix<T>::Statistics( 
   T *vmin,  // [o] minimum value, excluding null value
	T *vmax, // [o] maxmum value, excluding null value
	T *vmean ) // [o] average value, excluding null value
   const
{
	double dCount, dMean, dSum;
	int i, j;
   T tValue, tMin, tMax;
   T *pRow = NULL;

   // if the last statistics exists, just return them!

   // start to get the statistics

   if( _bNullSet ) {

      // check if there is any valid(not null) value
      bool bFound = false;
	   for( i = 0 ; !bFound && i < _iNrows ; i++ ) {
   	   pRow = _pDataRow[i];
         for( j = 0 ; !bFound && j < _iNcols ; j++ ) {
	   	   tValue = *pRow++;
		      if( tValue == _Null ) continue;
            tMin = tValue;
			   tMax = tValue;
		      bFound = true;
         }
      }

      if( !bFound ) {
         dMean = 0.0;
         tMin = _Null;
			tMax = _Null;
      } else {      
         dSum = 0.0;
         dCount = 0.0;
	      for( i = 0 ; i < _iNrows ; i++ ) {
   	      pRow = _pDataRow[i];
            for( j = 0 ; j < _iNcols ; j++ ) {
		         tValue = *pRow++;
		         if( tValue == _Null ) continue;
   		      if( tValue < tMin ) tMin = tValue;
	  		      if( tValue > tMax ) tMax = tValue;
	   	      dSum = dSum + (double)tValue;
               dCount = dCount + 1.0;
            }
         }

         if( 0.0 >= dCount ) {
            dMean = 0.0;
         } else {
            dMean = dSum / dCount;
         }
      }

   } else {
      
	   dSum = 0.0;
      tMin = Get( 0, 0 );
	   tMax = Get( 0, 0 );
      for( i = 0 ; i < _iNrows ; i++ ) {
   	   pRow = _pDataRow[i];
         for( j = 0 ; j < _iNcols ; j++ ) {
			   tValue = *pRow++;
   			if( tValue < tMin ) tMin = tValue;
	   		if( tValue > tMax ) tMax = tValue;
		   	dSum = dSum + (double)tValue;
         }
      }
      
   	dCount = (double)( _iNrows * _iNcols );
      if( 0.0 >= dCount ) {
         dMean = 0.0;
      } else {
         dMean = dSum / dCount;
      }
	}

   // set the obtained values

	*vmin = tMin;
	*vmax = tMax;
	*vmean = (T)dMean;

   return;
}

template <class T> void pixq_Matrix<T>::Statistics( 
	T *vmin,  // [o] minimum value, excluding null value
	T *vmax, // [o] maxmum value, excluding null value
	T *vmean, // [o] average value, excluding null value
	T *stdev ) // [o] STANDARD DEVIATION, excluding null value
   const
{
   T tValue, vmin2, vmax2, vmean2;
	int i, j;
	double dCount, dSum, dStDev, dValue2, dMean;
   T *pRow = NULL;

   // get value range and average

	*vmin = (T)0;
	*vmax = (T)0;
	*vmean = (T)0;
	*stdev = (T)0;
   dStDev = 0.0;

   Statistics( &vmin2, &vmax2, &vmean2 );

   // get stdev

   dMean = (double)vmean2;

   if( _bNullSet ) {

      dCount = 0.0;
      dSum = 0.0;
      for( i = 0 ; i < _iNrows ; i++ ) {
   	   pRow = _pDataRow[i];
         for( j = 0 ; j < _iNcols ; j++ ) {
   		   tValue = *pRow++;
	   	   if( tValue == _Null ) continue;
            dValue2 = (double)tValue - dMean;
            dSum = dSum + dValue2 * dValue2;
            dCount = dCount + 1.0;
         }
      }

      if( 0.0 == dCount ) {
         dStDev = 0.0;
      } else {
         dStDev = sqrt( dSum / dCount );
      }

   } else {

      dSum = 0.0;
      for( i = 0 ; i < _iNrows ; i++ ) {
   	   pRow = _pDataRow[i];
         for( j = 0 ; j < _iNcols ; j++ ) {
   	   tValue = *pRow++;
	         dValue2 = (double)tValue - dMean;
            dSum = dSum + dValue2 * dValue2;
         }
      }

      dCount = (double)( _iNrows * _iNcols );
      dStDev = sqrt( dSum / dCount );
	}

	*vmin = vmin2;
	*vmax = vmax2;
	*vmean = vmean2;
	*stdev = (T)dStDev;

   return;
}


template <class T> void pixq_Matrix<T>::Statistics( 
   T *vmin,  // [o] minimum value, excluding null value
	T *vmax, // [o] maxmum value, excluding null value
	T *vmean, // [o] average value, excluding null value,
   const pixq_Matrix<bool> *pMask )
   const
{
	double dCount, dMean, dSum;
	bool bMask;
   int nValid, i, j;
   T tValue, tMin, tMax;
   T *pRow = NULL;

   // if the last statistics exists, just return them!

   // start to get the statistics

   nValid = 0;
	dSum = 0.0;
   tMin = Get( 0, 0 );
	tMax = Get( 0, 0 );
   for( i = 0 ; i < _iNrows ; i++ ) {

      pRow = _pDataRow[i];
      for( j = 0 ; j < _iNcols ; j++ ) {
         
		   tValue = *pRow++;
   		
         bMask = pMask->Get( i, j );
         if( !bMask ) continue;
         
         if( tValue < tMin ) tMin = tValue;
			if( tValue > tMax ) tMax = tValue;
	   	dSum = dSum + (double)tValue;
         nValid++;
      }
   }
   
   dCount = (double)nValid;
   if( 0.0 >= dCount ) {
      dMean = 0.0;
   } else {
      dMean = dSum / dCount;
   }

   // set the obtained values

	*vmin = tMin;
	*vmax = tMax;
	*vmean = (T)dMean;

   return;
}

template <class T> void pixq_Matrix<T>::Statistics( 
	T *vmin,  // [o] minimum value, excluding null value
	T *vmax, // [o] maxmum value, excluding null value
	T *vmean, // [o] average value, excluding null value
	T *stdev, // [o] STANDARD DEVIATION, excluding null value
   const pixq_Matrix<bool> *pMask )
   const
{
   T tValue, vmin2, vmax2, vmean2;
	bool bMask;
	int nValid, i, j;
	double dCount, dSum, dStDev, dValue2, dMean;
   T *pRow = NULL;

   // get value range and average

	*vmin = (T)0;
	*vmax = (T)0;
	*vmean = (T)0;
	*stdev = (T)0;
   dStDev = 0.0;

   Statistics( &vmin2, &vmax2, &vmean2, pMask );

   // get stdev

   dMean = (double)vmean2;

   nValid = 0;
   dSum = 0.0;
   for( i = 0 ; i < _iNrows ; i++ ) {
      pRow = _pDataRow[i];
      for( j = 0 ; j < _iNcols ; j++ ) {

         tValue = *pRow++;
         
         bMask = pMask->Get( i, j );
         if( !bMask ) continue;

	      dValue2 = (double)tValue - dMean;
         dSum = dSum + dValue2 * dValue2;
         nValid++;
      }
   }

   dCount = (double)nValid;
   dStDev = sqrt( dSum / dCount );
	
	*vmin = vmin2;
	*vmax = vmax2;
	*vmean = vmean2;
	*stdev = (T)dStDev;

   return;
}

} // namespace _pix_plot_qt_framework 

