//
// pixq_Matrix
// 2D matrix class, data utility
//

namespace _pix_plot_qt_framework {

template <class T> bool pixq_Matrix<T>::Copy( pixq_Matrix<T> *pSrc )
{
   bool bRetCode = false;
   int i, j;
   bool bDiff = true;

   int nRows = _iNrows;
   int nCols = _iNcols;
   int nFrameRows = _iFrameRows;
   int nFrameCols = _iFrameCols;
   
   int nSrcRows = pSrc->_iNrows;
   int nSrcCols = pSrc->_iNcols;
   int nSrcFrameRows = pSrc->_iFrameRows;
   int nSrcFrameCols = pSrc->_iFrameCols;

   _bStatSet = false;
   
   // check if this matrix is already assigned as the same size as source 
   bDiff = false;
   if( nRows != nSrcRows ) bDiff = true;
   if( nCols != nSrcCols ) bDiff = true;
   if( nFrameRows != nSrcFrameRows ) bDiff = true;
   if( nFrameCols != nSrcFrameCols ) bDiff = true;

   // realloc the matrix if necessary

   if( bDiff ) {
      Free( );
      if( !Alloc( nSrcRows, nSrcCols, nSrcFrameRows, nSrcFrameCols ) ) {
         goto PIX_EXIT;
      }
   }

   // copy all data

   for( i = 0 ; i < _iWholeRows ; i++ ) {
      for( j = 0 ; j < _iWholeCols ; j++ ) {
         _Data[i][j] = pSrc->_Data[i][j];
      }
   }

	_bStatSet = false;

   // --- Done ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

//
// absolute difference, mtx0 - mtx1
//
template <class T> bool pixq_Matrix<T>::AbsoluteDiff( pixq_Matrix<T> *pMtx0,  // [i]
                                                      pixq_Matrix<T> *pMtx1 ) // [i]
{
   bool bRetCode = false;
   int i, j;
   bool bDiff = true;
   T tVal[2], tDiff;

   int nSrcRows[2];
   int nSrcCols[2];
   int nSrcFrameRows[2];
   int nSrcFrameCols[2];

   int nRows = _iNrows;
   int nCols = _iNcols;
   int nFrameRows = _iFrameRows;
   int nFrameCols = _iFrameCols;
   
   nSrcRows[0] = pMtx0->_iNrows;
   nSrcRows[1] = pMtx1->_iNrows;

   nSrcCols[0] = pMtx0->_iNcols;
   nSrcCols[1] = pMtx1->_iNcols;

   nSrcFrameRows[0] = pMtx0->_iFrameRows;
   nSrcFrameRows[1] = pMtx1->_iFrameRows;

   nSrcFrameCols[0] = pMtx0->_iFrameCols;
   nSrcFrameCols[1] = pMtx1->_iFrameCols;

   _bStatSet = false;
   
   // check if two input matrices are same size 
   
   bDiff = false;
   if( nSrcRows[0] != nSrcRows[1] ) bDiff = true;
   if( nSrcCols[0] != nSrcCols[1] ) bDiff = true;
   if( nSrcFrameRows[0] != nSrcFrameRows[1] ) bDiff = true;
   if( nSrcFrameCols[0] != nSrcFrameCols[1] ) bDiff = true;
   if( bDiff ) {
      goto PIX_EXIT;
   }

   // realloc the matrix if necessary

   bDiff = false;
   if( nRows != nSrcRows[0] ) bDiff = true;
   if( nCols != nSrcCols[0] ) bDiff = true;
   if( nFrameRows != nSrcFrameRows[0] ) bDiff = true;
   if( nFrameCols != nSrcFrameCols[0] ) bDiff = true;

   if( bDiff ) {
      Free( );
      if( !Alloc( nSrcRows[0], nSrcCols[0], nSrcFrameRows[0], nSrcFrameCols[0] ) ) {
         goto PIX_EXIT;
      }
   }

   // copy all data

   for( i = 0 ; i < _iWholeRows ; i++ ) {
      for( j = 0 ; j < _iWholeCols ; j++ ) {
         tVal[0] = pMtx0->_Data[i][j];
         tVal[1] = pMtx1->_Data[i][j];
         if( tVal[0] >= tVal[1] ) {
            tDiff = tVal[0] - tVal[1];
         } else {
            tDiff = tVal[1] - tVal[0];
         }
         _Data[i][j] = tDiff;
      }
   }

	_bStatSet = false;

   // --- Done ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

//
// fill the frame area around the matrix body
//
// notes:
// you can choose ho you want to fill the frame area by sMethod
// sMethod must be one of MatrixFillFrameMethod
// tConst is only used when the method is MatrixFillFrameConst
//
template <class T> void pixq_Matrix<T>::FillFrame( short sMethod, // [i] method to fill
                                  T tConst ) // [i] a value to fill the frame = (T)0
{
   if( 0 >= _iFrameRows && 0 >= _iFrameCols ) {
      goto PIX_EXIT;
   }
   
   switch( sMethod ) {
   // fill the frame area with given constant value
   case MatrixFillFrameConst:
      FillConstFrame( tConst );
      break;

   // fill with the last value on the edge for the all row and color outside
   case MatrixFillFrameClamp:
      FillClampFrame( );
      break;

   // fill the frame area with zero
   case MatrixFillFrameZero:
   case MatrixFillFrameMirror:
   case MatrixFillFrameRepeat:
   default:
      FillConstFrame( (T)0 );
      break;
   }
 
PIX_EXIT:
   return;
}
 
//
// fill the frame area around the matrix body
// with the given constant value
//
template <class T> void pixq_Matrix<T>::FillConstFrame( T tConst )
{
   int i, j;
   T *p = NULL;

//fprintf( stdout, "*** FillConstFrame: tConst=%d.\n", tConst );
//fprintf( stdout, "*** FillConstFrame: _iFrameRows=%d.\n", _iFrameRows );
//fprintf( stdout, "*** FillConstFrame: _iFrameCols=%d.\n", _iFrameCols );
 
   if( 0 >= _iFrameRows && 0 >= _iFrameCols ) {
      goto PIX_EXIT;
   }

   // 
   // +-------------------+
   // |*******************|
   // +  +-------------+  +
   // |  |             |  |
   // |  |             |  |
   // |  |             |  |
   // |  |             |  |
   // |  |             |  |
   // +  +-------------+  +
   // |                   |
   // +-------------------+
   // 
   for( i = -_iFrameRows ; i < 0 ; i++ ) {
      p = _Data[i + _iFrameRows];
      for( j = -_iFrameCols ; j < _iNcols + _iFrameCols ; j++ ) {
         //Set( i, j, tConst );
         *(p++) = tConst;
      }
   }

   // 
   // +-------------------+
   // |                   |
   // +  +-------------+  +
   // |  |             |  |
   // |  |             |  |
   // |  |             |  |
   // |  |             |  |
   // |  |             |  |
   // +  +-------------+  +
   // |*******************|
   // +-------------------+
   //
   for( i = _iNrows ; i < _iNrows + _iFrameRows ; i++ ) {
      p = _Data[i + _iFrameRows];
      for( j = -_iFrameCols ; j < _iNcols + _iFrameCols ; j++ ) {
         //Set( i, j, tConst );
         *(p++) = tConst;
      }
   }

   // 
   // +-------------------+
   // |                   |
   // +**+-------------+**+
   // |**|             |**|
   // |**|             |**|
   // |**|             |**|
   // |**|             |**|
   // |**|             |**|
   // +**+-------------+**+
   // |                   |
   // +-------------------+
   //  
   for( i = 0 ; i < _iNrows ; i++ ) {
      p = _Data[i + _iFrameRows];
      for( j = -_iFrameCols ; j < 0 ; j++ ) {
         *(p++) = tConst;
      }

      p = (T*)&_Data[i + _iFrameRows][_iNcols + _iFrameCols];
      for( j = _iNcols ; j < _iNcols + _iFrameCols ; j++ ) {
         *(p++) = tConst;
      }
   }

PIX_EXIT:
   return;
}

//
// fill with the last value on the edge for the all row and color outside
//
template <class T> void pixq_Matrix<T>::FillClampFrame( void )
{
   T tValue;
   T *p = NULL;
   int i, j;

   if( 0 >= _iFrameRows && 0 >= _iFrameCols ) {
      goto PIX_EXIT;
   }

   // 
   // +-------------------+
   // |**                 |
   // +  +-------------+  +
   // |  |             |  |
   // |  |             |  |
   // |  |             |  |
   // |  |             |  |
   // |  |             |  |
   // +  +-------------+  +
   // |                   |
   // +-------------------+
   // 
   tValue = Get( 0, 0 );
   for( i = -_iFrameRows ; i < 0 ; i++ ) {
      p = _Data[i + _iFrameRows];
      for( j = -_iFrameCols ; j < 0 ; j++ ) {
         //Set( i, j, tValue );
         *(p++) = tValue;
      }
   }

   // 
   // +-------------------+
   // |  ***************  |
   // +  +-------------+  +
   // |  |             |  |
   // |  |             |  |
   // |  |             |  |
   // |  |             |  |
   // |  |             |  |
   // +  +-------------+  +
   // |                   |
   // +-------------------+
   //
   for( i = -_iFrameRows ; i < 0 ; i++ ) {
      p = (T*)&_Data[i + _iFrameRows][_iFrameCols];
      for( j = 0 ; j < _iNcols ; j++ ) {
         //tValue = 0;
         tValue = Get( 0, j );
         //Set( i, j, tValue );
         *(p++) = tValue;
      }
   }

   //
   // +-------------------+ 
   // |                 **|
   // +  +-------------+  +
   // |  |             |  |
   // |  |             |  |
   // |  |             |  |
   // |  |             |  |
   // |  |             |  |
   // +  +-------------+  +
   // |                   |
   // +-------------------+
   //
   tValue = Get( 0, _iNcols - 1 ); 
   for( i = -_iFrameRows ; i < 0 ; i++ ) {
      p = (T*)&_Data[i + _iFrameRows][_iNcols+_iFrameCols];
      for( j = _iNcols ; j < _iNcols + _iFrameCols ; j++ ) { 
         //Set( i, j, tValue );
         *(p++) = tValue;
      } 
   }

   // 
   // +-------------------+
   // |                   |
   // +**+-------------+  +
   // |**|             |  |
   // |**|             |  |
   // |**|             |  |
   // |**|             |  |
   // |**|             |  |
   // +**+-------------+  +
   // |                   |
   // +-------------------+
   //    
   for( i = 0 ; i < _iNrows ; i++ ) {
      tValue = Get( i, 0 );
      p = _Data[i + _iFrameRows];
      for( j = -_iFrameCols ; j < 0 ; j++ ) {
         //Set( i, j, tValue );
         *(p++) = tValue;
      }
   } 

   // 
   // +-------------------+
   // |                   |
   // +  +-------------+**+
   // |  |             |**|
   // |  |             |**|
   // |  |             |**|
   // |  |             |**|
   // |  |             |**|
   // +  +-------------+**+
   // |                   |
   // +-------------------+
   //   
   for( i = 0 ; i < _iNrows ; i++ ) {
      tValue = Get( i, _iNcols - 1 );
      p = (T*)&_Data[i + _iFrameRows][_iNcols+_iFrameCols];
      for( j = _iNcols ; j < _iNcols + _iFrameCols ; j++ ) {
         //Set( i, j, tValue );
         *(p++) = tValue;
      }
   }

   // 
   // +-------------------+
   // |                   |
   // +  +-------------+  +
   // |  |             |  |
   // |  |             |  |
   // |  |             |  |
   // |  |             |  |
   // |  |             |  |
   // +  +-------------+  +
   // |**                 |
   // +-------------------+
   // 
   tValue = Get( _iNrows - 1, 0 );
   for( i = _iNrows ; i < _iNrows + _iFrameRows ; i++ ) {
      p = _Data[i + _iFrameRows];
      for( j = -_iFrameCols ; j < 0 ; j++ ) {
         //Set( i, j, tValue );
         *(p++) = tValue;
      }
   }
   
   // 
   // +-------------------+
   // |                   |
   // +  +-------------+  +
   // |  |             |  |
   // |  |             |  |
   // |  |             |  |
   // |  |             |  |
   // |  |             |  |
   // +  +-------------+  +
   // |  ***************  |
   // +-------------------+
   // 
   for( i = _iNrows ; i < _iNrows + _iFrameRows ; i++ ) {   
      p = (T*)&_Data[i + _iFrameRows][_iFrameCols];
      for( j = 0 ; j < _iNcols ; j++ ) {
         tValue = Get( _iNrows - 1, j );      
         //Set( i, j, tValue );
         *(p++) = tValue;
      }
   }

   // 
   // +-------------------+
   // |                   |
   // +  +-------------+  +
   // |  |             |  |
   // |  |             |  |
   // |  |             |  |
   // |  |             |  |
   // |  |             |  |
   // +  +-------------+  +
   // |                 **|
   // +-------------------+
   //
   tValue = Get( _iNrows - 1, _iNcols - 1 );
   for( i = _iNrows ; i < _iNrows + _iFrameRows ; i++ ) {
      p = (T*)&_Data[i + _iFrameRows][_iNcols+_iFrameCols];
      for( j = _iNcols ; j < _iNcols + _iFrameCols ; j++ ) {
         //Set( i, j, tValue );
         *(p++) = tValue;
      }
   }

PIX_EXIT:
   return;
}

//
// check the validity of the row number
//
template <class T> 
bool pixq_Matrix<T>::CheckRow( int iRow ) // [i] row number
const
{
   bool bRetCode = false;

   if( -_iFrameRows > iRow ) goto PIX_EXIT;
   if( iRow >= _iNrows + _iFrameRows ) goto PIX_EXIT;
      
   // --- Done ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

//
// check the validity of the column number
//
template <class T> 
bool pixq_Matrix<T>::CheckCol( int iCol ) // [i] column number
const
{
   bool bRetCode = false;

   if( -_iFrameCols > iCol ) goto PIX_EXIT;
   if( iCol >= _iNcols + _iFrameCols ) goto PIX_EXIT;
      
   // --- Done ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

//
// check the validity of the row range
//
template <class T> bool pixq_Matrix<T>::CheckRowRange( int iRow0, // [i] first row number
                                                      int iRow1 ) // [i] second row number
const
{
   bool bRetCode = false;

   if( !CheckRow( iRow0 )  ) goto PIX_EXIT;
   if( !CheckRow( iRow1 )  ) goto PIX_EXIT;
   if( iRow0 > iRow1 ) goto PIX_EXIT;
      
   // --- Done ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}


//
// check the validity of the column range
//
template <class T> bool pixq_Matrix<T>::CheckColRange( int iCol0, // [i] first column number
                                                      int iCol1 ) // [i] second column number
const
{
   bool bRetCode = false;

   if( !CheckCol( iCol0 )  ) goto PIX_EXIT;
   if( !CheckCol( iCol1 )  ) goto PIX_EXIT;
   if( iCol0 > iCol1 ) goto PIX_EXIT;
      
   // --- Done ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

//
// check if the given row and column is inside the valid matrix extent
// not including the frame area
//
template <class T> bool pixq_Matrix<T>::IsInside( 
   int iX, 
   int iY )
{
   bool bRetCode = false;

   if( 0 > iX || iX >= _iNcols ) goto PIX_EXIT;
   if( 0 > iY || iY >= _iNrows ) goto PIX_EXIT;
   
   // --- Done ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

template <class T> 
bool pixq_Matrix<T>::IsInside(
   float fX,
   float fY )
{
	int iX = (int)floor( 0.5 + fX );
	int iY = (int)floor( 0.5 + fY );
   return IsInside( iX, iY );
}

template <class T> bool pixq_Matrix<T>::IsInside( 
   double dX,
   double dY )
{
	int iX = (int)floor( 0.5 + dX );
	int iY = (int)floor( 0.5 + dY );
   return IsInside( iX, iY );
}


//
// crop partangle area of matrix 
//
// notes:
// need improvement! using line buffer
//
template <class T> bool pixq_Matrix<T>::Crop( 
   int nStartRow,  // [i] start row
   int nEndRow,    // [i] end row
   int nStartCol,  // [i] start column
   int nEndCol,    // [i] end column
   pixq_Matrix<T>  *pDest )    // [o] destination matrix 
const 
{
   bool bRetCode = false;
   int iRow, iCol, i, j, nOutRows, nOutCols;
   T tNull, tValue;

   if( nEndRow < nStartRow ) goto PIX_EXIT;
   if( nEndCol < nStartCol ) goto PIX_EXIT;

   pDest->Free( );
   nOutRows = nEndRow - nStartRow + 1;
   nOutCols = nEndCol - nStartCol + 1;
   if( !pDest->Alloc( nOutRows, nOutCols ) ) goto PIX_EXIT;

   tNull = (T)0.0;
   
   for( i = nStartRow ; i <= nEndRow ; i++ ) {
      iRow = i - nStartRow;
      if( 0 > iRow || iRow >= _iNrows ) {
         for( j = nStartCol ; j <= nEndCol ; j++ ) {
            iCol = j - nStartCol;
            pDest->Set( iRow, iCol, tNull );
         }
         continue;
      }
      
      for( j = nStartCol ; j <= nEndCol ; j++ ) {
         iCol = j - nStartCol;
         if( 0 > iCol || iCol >= _iNcols ) {
            pDest->Set( iRow, iCol, tNull );
            continue;
         }

         tValue = Get( i, j );
         pDest->Set( iRow, iCol, tValue );
      }
   }

   // --- Done ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

} // namespace _pix_plot_qt_framework 

