#include <pixqt_common.h>

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <math.h>
#include <ctype.h>
#include <errno.h>
#include <fcntl.h>
#include <time.h>

#include <limits.h>
#include <signal.h>
#include <stddef.h>

#include <sys/stat.h>
#include <sys/types.h>

#include <vector>
#include <string>
#include <map>
#include <algorithm>
using namespace std;

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include "pixq_EnvItem.h"
#include "pixq_Properties.h"

pixq_Properties::pixq_Properties(void)
{
   ; // empty
}

pixq_Properties::~pixq_Properties(void)
{
   ; // empty
}

void pixq_Properties::InitAllEnv( void )
{
   // Common

   InitCommon( );
   InitImage( );
   InitPlayback( );
   InitSystem( );

   // Bagster
   
   InitBagsterWindow( );
   InitBagsterView( );
   InitBagsterTimer( );

   // Hikari

   InitHikariInitial( );
   InitHikariBible( );
   InitHikariView( );
   InitHikariEdit( );
   InitHikariBagster( );
   InitHikariBiblePlan( );

   // Scope

   InitScope( );
   
   InitDftFilter( );

   return;
}

void pixq_Properties::InitEnv( QString strOrg, QString strApp )
{
   InitAllEnv( );
   
   // set organization and application name

   _CommonOrganisationName.Set( strOrg );
   _CommonApplicationName.Set( strApp );

   // restore the last setting from the registry

   GetRegEnv( strOrg, strApp );

   return;
}

void pixq_Properties::ResetEnv( QString strOrg, QString strApp )
{
   InitAllEnv( );
   
   // clear organization and application name

   _CommonOrganisationName.Set( strOrg );
   _CommonApplicationName.Set( strApp );

   // restore the last setting from the registry

   SetRegEnv( strOrg, strApp );

   return;
}

static QFont InitBagsterHeaderFont( void )
{
   bool bMatch;
   QFont fn;

   // wb_[̃tHg

   fn.setBold( true );
   fn.setStrikeOut( false );
   fn.setItalic( false );
   fn.setOverline( false );
   fn.setUnderline( false );
   
   fn.setFamily( "lr oSVbN" );

   //fn.setPointSize( 8 );
   fn.setPointSizeF( 12.0 );
   fn.setPixelSize( -1 );

   fn.setWeight( QFont::Bold );

   fn.setStyle( QFont::StyleNormal );
   fn.setStyleHint( QFont::AnyStyle );

   // members not explicitly set

   //fn.setFixedPitch( bool enable );
   //fn.setCapitalization( Capitalization caps );
   //fn.setKerning( bool enable );
   //fn.setLetterSpacing( SpacingType type, qreal spacing );
   //fn.setRawMode( bool enable );
   //fn.setRawName( const QString & name );
   //fn.setStretch( int factor );
   //fn.setStyleStrategy( StyleStrategy s );
   //fn.setWordSpacing( qreal spacing )

   // Returns true if a window system font exactly matching the settings of this font is available.
   bMatch = fn.exactMatch( );

   return fn;
}  

void pixq_Properties::InitCommon( void )
{
   QString strValue;

   short sCat = (short)pixq_EnvItem::ItemCategoryCommonGui;

   strValue = "PixTopo";
   _CommonApplicationName.Set( sCat, strValue, "Common Application Name" );

   strValue = "PixTopo";
   _CommonOrganisationName.Set( sCat, strValue, "Common Organisation Name" );

   // for sequence selection dialog

   // directory of the last seleced images

#ifdef _WINDOWS
   strValue = "c:/";
#else
   strValue = "~";
#endif
   _CommonLastImage0Dir.Set( sCat, strValue, "ItfTools Common Last First Image Dir" );  
   _CommonLastImage1Dir.Set( sCat, strValue, "ItfTools Common Last Second Image Dir" ); 

   // last selected image

   strValue.clear( );
   _CommonLastImage0File.Set( sCat, strValue, "ItfTools Common Last Selected First Image" );    
   _CommonLastImage1File.Set( sCat, strValue, "ItfTools Common Last Selected Second Image" ); 

   // last selected video

#ifdef _WINDOWS
   strValue = "c:/";
#else
   strValue = "~";
#endif
   _CommonLastVideoDir.Set( sCat, strValue, "ItfTools Common Last Video Dir" );  

   return;
}

void pixq_Properties::InitBagsterWindow( void )
{
   int iValue;
   QColor colValue;
   QFont fn;

   short sCat = (short)pixq_EnvItem::ItemCategoryBagsterWindow;

   // Őݒ肷鍀ڂ͋L̂݁Aݒplɂ͌Ȃ

   // ***********************
   // *** window position ***
   // ***********************

   iValue = 30;
   _BagsterWinLeft.Set( sCat, iValue, "Bagster Window Start Left" );
   
   iValue = 30;
   _BagsterWinTop.Set( sCat, iValue, "Bagster Window Start Top" );

   iValue = 600;
   _BagsterWinWidth.Set( sCat, iValue, "Bagster Window Start Width" );
   
   iValue = 700;
   _BagsterWinHeight.Set( sCat, iValue, "Bagster Window Start Height" );

   // ****************
   // *** \ ***
   // ****************

   // wb_[̃tHg
   
   fn = InitBagsterHeaderFont( );
   _BagsterHeaderFont.Set( sCat, fn, "Bagster Header Font" );

   // wb_[̃tHgF
   
   colValue.setRgb( 255, 255, 235 );
   _BagsterHeaderFgColor.Set( sCat, colValue, "Bagster Header Foreground Color" );

   // wb_[̔wiFiJ1j
   
   colValue.setRgb( 84, 130, 210 );
   _BagsterHeaderBg0Color.Set( sCat, colValue, "Bagster Header Background Top Color" );

   // wb_[̔wiFiJ2j
   
   colValue.setRgb( 9, 54, 156 );
   _BagsterHeaderBg1Color.Set( sCat, colValue, "Bagster Header Background Bottom Color" );

   return;
}  


void pixq_Properties::InitBagsterTimer( void )
{
   bool bValue;
   int iValue;

   short sCat = (short)pixq_EnvItem::ItemCategoryBagsterTimer;

   // ************
   // ***  ***
   // ************

   // show at selected time?
   bValue = true;
   _BagsterShowEveryDay.Set( sCat, bValue, "Bagster Morning Show Every Day" );

   // time to show the morning words
   
   iValue = 8;
   _BagsterAmShowHour.Set( sCat, iValue, "Bagster Morning Show Time Hour" );
   
   iValue = 0;
   _BagsterAmShowMinuite.Set( sCat, iValue, "Bagster Morning Show Time Minuite" );

   iValue = 0;
   _BagsterAmShowSecond.Set( sCat, iValue, "Bagster Morning Show Time Second" );

   // time to show the evening
   
   iValue = 20;
   _BagsterPmShowHour.Set( sCat, iValue, "Bagster Night Show Time Hour" );
   
   iValue = 0;
   _BagsterPmShowMinuite.Set( sCat, iValue, "Bagster Night Show Time Minuite" );
   
   iValue = 0;
   _BagsterPmShowSecond.Set( sCat, iValue, "Bagster Night Show Time Second" );

   // **********
   // ***  ***
   // **********

   // bible version
   
   iValue = (int)BibleKougoyaku; 
   _BagsterBibleVersion.Set( sCat, iValue, "Bagster Bible Version" );

   return;
}
 
static QFont InitBagsterHikariJpFont( void )
{
   bool bMatch;
   QFont fn;

   fn.setBold( false );
   fn.setStrikeOut( false );
   fn.setItalic( false );
   fn.setOverline( false );
   fn.setUnderline( false );
   
   fn.setFamily( "lr oSVbN" );

   //fn.setPointSize( 8 );
   fn.setPointSizeF( 11 );
   fn.setPixelSize( -1 );

   fn.setWeight( QFont::Normal );

   fn.setStyle( QFont::StyleNormal );
   fn.setStyleHint( QFont::AnyStyle );

   // members not explicitly set

   //fn.setFixedPitch( bool enable );
   //fn.setCapitalization( Capitalization caps );
   //fn.setKerning( bool enable );
   //fn.setLetterSpacing( SpacingType type, qreal spacing );
   //fn.setRawMode( bool enable );
   //fn.setRawName( const QString & name );
   //fn.setStretch( int factor );
   //fn.setStyleStrategy( StyleStrategy s );
   //fn.setWordSpacing( qreal spacing )

   // Returns true if a window system font exactly matching the settings of this font is available.
   bMatch = fn.exactMatch( );

   return fn;
}

static QFont InitBagsterHikariEnFont( void )
{
   bool bMatch;
   QFont fn;

   fn.setBold( false );
   fn.setStrikeOut( false );
   fn.setItalic( false );
   fn.setOverline( false );
   fn.setUnderline( false );
   
   fn.setFamily( "Ariel" );

   //fn.setPointSize( 8 );
   fn.setPointSizeF( 11 );
   fn.setPixelSize( -1 );

   fn.setWeight( QFont::Normal );

   fn.setStyle( QFont::StyleNormal );
   fn.setStyleHint( QFont::AnyStyle );

   // members not explicitly set

   //fn.setFixedPitch( bool enable );
   //fn.setCapitalization( Capitalization caps );
   //fn.setKerning( bool enable );
   //fn.setLetterSpacing( SpacingType type, qreal spacing );
   //fn.setRawMode( bool enable );
   //fn.setRawName( const QString & name );
   //fn.setStretch( int factor );
   //fn.setStyleStrategy( StyleStrategy s );
   //fn.setWordSpacing( qreal spacing )

   // Returns true if a window system font exactly matching the settings of this font is available.
   bMatch = fn.exactMatch( );

   return fn;
}


void pixq_Properties::InitBagsterView( void )
{
   QFont fn;
   QColor colValue;
   int iValue;

   short sCat = (short)pixq_EnvItem::ItemCategoryBagsterView;

   // ************
   // *** \ ***
   // ************
   
   // tHgi{j

   fn = InitBagsterHikariJpFont( );
   _BagsterJapaneseFont.Set( sCat, fn, "Bagster Hikari Japanese Font" );
  
   // tHgipj
   fn = InitBagsterHikariEnFont( );
   _BagsterEnglishFont.Set( sCat, fn, "Bagster Hikari English Font" );

   // background color
   
   colValue.setRgb( 255, 255, 235 );
   _BagsterBgColor.Set( sCat, colValue, "Bagster Hikari Bg Color" );

   // line heightsԁA100%`
   iValue = 145;
   _BagsterLineHeight.Set( sCat, iValue, "Bagster Light View Line Height" );

   return;
}

static QFont InitHikariHeaderFont( void )
{
   bool bMatch;
   QFont fn;

   // wb_[̃tHg

   fn.setBold( true );
   fn.setStrikeOut( false );
   fn.setItalic( false );
   fn.setOverline( false );
   fn.setUnderline( false );
   
   fn.setFamily( "lr oSVbN" );

   //fn.setPointSize( 8 );
   fn.setPointSizeF( 12.0 );
   fn.setPixelSize( -1 );

   fn.setWeight( QFont::Bold );

   fn.setStyle( QFont::StyleNormal );
   fn.setStyleHint( QFont::AnyStyle );

   // members not explicitly set

   //fn.setFixedPitch( bool enable );
   //fn.setCapitalization( Capitalization caps );
   //fn.setKerning( bool enable );
   //fn.setLetterSpacing( SpacingType type, qreal spacing );
   //fn.setRawMode( bool enable );
   //fn.setRawName( const QString & name );
   //fn.setStretch( int factor );
   //fn.setStyleStrategy( StyleStrategy s );
   //fn.setWordSpacing( qreal spacing )

   // Returns true if a window system font exactly matching the settings of this font is available.
   bMatch = fn.exactMatch( );

   return fn;
}  

void pixq_Properties::InitHikariInitial( void )
{
   int iValue;
   QColor colValue;
   QFont fn;

   short sCat = (short)pixq_EnvItem::ItemCategoryHikariInit;

   // Őݒ肷鍀ڂ͋L̂݁Aݒplɂ͌Ȃ

   // **********************************
   // *** Hikari initial condtions ***
   // **********************************

   // *** last selection ***
   // [U[ɑIȂ

   // last content, one of HikariBibleContent
   iValue = ContentOldTestament;
   _HikariLastContent.Set( sCat, iValue, "Hikari Last Content" );

   // last selected book from old testament, 1-39
   iValue = 1;
   _HikariLastOldBook.Set( sCat, iValue, "Hikari Last Old Book" );
   
   // last selected book from new testament, 40-66
   iValue = 40;
   _HikariLastNewBook.Set( sCat, iValue, "Hikari Last New Book" );

   // last selected devotion type, one of HikariDevotionContent
   iValue = DevotionTypeDailyDays;
   _HikariLastDevotion.Set( sCat, iValue, "Hikari Last Devotions" );

   // last selected chapter for each book of the bible
   iValue = 1;   
   _HikariLastBookChapter01.Set( sCat, iValue, "Hikari Last Chapter Book 01" );
   _HikariLastBookChapter02.Set( sCat, iValue, "Hikari Last Chapter Book 02" );
   _HikariLastBookChapter03.Set( sCat, iValue, "Hikari Last Chapter Book 03" );
   _HikariLastBookChapter04.Set( sCat, iValue, "Hikari Last Chapter Book 04" );
   _HikariLastBookChapter05.Set( sCat, iValue, "Hikari Last Chapter Book 05" );
   _HikariLastBookChapter06.Set( sCat, iValue, "Hikari Last Chapter Book 06" );
   _HikariLastBookChapter07.Set( sCat, iValue, "Hikari Last Chapter Book 07" );
   _HikariLastBookChapter08.Set( sCat, iValue, "Hikari Last Chapter Book 08" );
   _HikariLastBookChapter09.Set( sCat, iValue, "Hikari Last Chapter Book 09" );
   _HikariLastBookChapter10.Set( sCat, iValue, "Hikari Last Chapter Book 10" );
   _HikariLastBookChapter11.Set( sCat, iValue, "Hikari Last Chapter Book 11" );
   _HikariLastBookChapter12.Set( sCat, iValue, "Hikari Last Chapter Book 12" );
   _HikariLastBookChapter13.Set( sCat, iValue, "Hikari Last Chapter Book 13" );
   _HikariLastBookChapter14.Set( sCat, iValue, "Hikari Last Chapter Book 14" );
   _HikariLastBookChapter15.Set( sCat, iValue, "Hikari Last Chapter Book 15" );
   _HikariLastBookChapter16.Set( sCat, iValue, "Hikari Last Chapter Book 16" );
   _HikariLastBookChapter17.Set( sCat, iValue, "Hikari Last Chapter Book 17" );
   _HikariLastBookChapter18.Set( sCat, iValue, "Hikari Last Chapter Book 18" );
   _HikariLastBookChapter19.Set( sCat, iValue, "Hikari Last Chapter Book 19" );
   _HikariLastBookChapter20.Set( sCat, iValue, "Hikari Last Chapter Book 20" );
   _HikariLastBookChapter21.Set( sCat, iValue, "Hikari Last Chapter Book 21" );
   _HikariLastBookChapter22.Set( sCat, iValue, "Hikari Last Chapter Book 22" );
   _HikariLastBookChapter23.Set( sCat, iValue, "Hikari Last Chapter Book 23" );
   _HikariLastBookChapter24.Set( sCat, iValue, "Hikari Last Chapter Book 24" );
   _HikariLastBookChapter25.Set( sCat, iValue, "Hikari Last Chapter Book 25" );
   _HikariLastBookChapter26.Set( sCat, iValue, "Hikari Last Chapter Book 26" );
   _HikariLastBookChapter27.Set( sCat, iValue, "Hikari Last Chapter Book 27" );
   _HikariLastBookChapter28.Set( sCat, iValue, "Hikari Last Chapter Book 28" );
   _HikariLastBookChapter29.Set( sCat, iValue, "Hikari Last Chapter Book 29" );
   _HikariLastBookChapter30.Set( sCat, iValue, "Hikari Last Chapter Book 30" );
   _HikariLastBookChapter31.Set( sCat, iValue, "Hikari Last Chapter Book 31" );
   _HikariLastBookChapter32.Set( sCat, iValue, "Hikari Last Chapter Book 32" );
   _HikariLastBookChapter33.Set( sCat, iValue, "Hikari Last Chapter Book 33" );
   _HikariLastBookChapter34.Set( sCat, iValue, "Hikari Last Chapter Book 34" );
   _HikariLastBookChapter35.Set( sCat, iValue, "Hikari Last Chapter Book 35" );
   _HikariLastBookChapter36.Set( sCat, iValue, "Hikari Last Chapter Book 36" );
   _HikariLastBookChapter37.Set( sCat, iValue, "Hikari Last Chapter Book 37" );
   _HikariLastBookChapter38.Set( sCat, iValue, "Hikari Last Chapter Book 38" );
   _HikariLastBookChapter39.Set( sCat, iValue, "Hikari Last Chapter Book 39" );
   _HikariLastBookChapter40.Set( sCat, iValue, "Hikari Last Chapter Book 40" );
   _HikariLastBookChapter41.Set( sCat, iValue, "Hikari Last Chapter Book 41" );
   _HikariLastBookChapter42.Set( sCat, iValue, "Hikari Last Chapter Book 42" );
   _HikariLastBookChapter43.Set( sCat, iValue, "Hikari Last Chapter Book 43" );
   _HikariLastBookChapter44.Set( sCat, iValue, "Hikari Last Chapter Book 44" );
   _HikariLastBookChapter45.Set( sCat, iValue, "Hikari Last Chapter Book 45" );
   _HikariLastBookChapter46.Set( sCat, iValue, "Hikari Last Chapter Book 46" );
   _HikariLastBookChapter47.Set( sCat, iValue, "Hikari Last Chapter Book 47" );
   _HikariLastBookChapter48.Set( sCat, iValue, "Hikari Last Chapter Book 48" );
   _HikariLastBookChapter49.Set( sCat, iValue, "Hikari Last Chapter Book 49" );
   _HikariLastBookChapter50.Set( sCat, iValue, "Hikari Last Chapter Book 50" );
   _HikariLastBookChapter51.Set( sCat, iValue, "Hikari Last Chapter Book 51" );
   _HikariLastBookChapter52.Set( sCat, iValue, "Hikari Last Chapter Book 52" );
   _HikariLastBookChapter53.Set( sCat, iValue, "Hikari Last Chapter Book 53" );
   _HikariLastBookChapter54.Set( sCat, iValue, "Hikari Last Chapter Book 54" );
   _HikariLastBookChapter55.Set( sCat, iValue, "Hikari Last Chapter Book 55" );
   _HikariLastBookChapter56.Set( sCat, iValue, "Hikari Last Chapter Book 56" );
   _HikariLastBookChapter57.Set( sCat, iValue, "Hikari Last Chapter Book 57" );
   _HikariLastBookChapter58.Set( sCat, iValue, "Hikari Last Chapter Book 58" );
   _HikariLastBookChapter59.Set( sCat, iValue, "Hikari Last Chapter Book 59" );
   _HikariLastBookChapter60.Set( sCat, iValue, "Hikari Last Chapter Book 60" );
   _HikariLastBookChapter61.Set( sCat, iValue, "Hikari Last Chapter Book 61" );
   _HikariLastBookChapter62.Set( sCat, iValue, "Hikari Last Chapter Book 62" );
   _HikariLastBookChapter63.Set( sCat, iValue, "Hikari Last Chapter Book 63" );
   _HikariLastBookChapter64.Set( sCat, iValue, "Hikari Last Chapter Book 64" );
   _HikariLastBookChapter65.Set( sCat, iValue, "Hikari Last Chapter Book 65" );
   _HikariLastBookChapter66.Set( sCat, iValue, "Hikari Last Chapter Book 66" );
                       
   // ****************
   // *** \ ***
   // ****************

   // wb_[̃tHg
   
   fn = InitHikariHeaderFont( );
   _HikariHeaderFont.Set( sCat, fn, "Hikari Header Font" );

   // wb_[̃tHgF
   
   colValue.setRgb( 255, 255, 235 );
   _HikariHeaderFgColor.Set( sCat, colValue, "Hikari Header Foreground Color" );

   // wb_[̔wiFiJ1j
   
   colValue.setRgb( 84, 130, 210 );
   _HikariHeaderBg0Color.Set( sCat, colValue, "Hikari Header Background Top Color" );

   // wb_[̔wiFiJ2j
   
   colValue.setRgb( 9, 54, 156 );
   _HikariHeaderBg1Color.Set( sCat, colValue, "Hikari Header Background Bottom Color" );

   return;                                                                   
}                                                                            
         
void pixq_Properties::InitHikariBible( void )
{
   bool bValue;
   QString strValue;
   int iValue;

   short sCat = (short)pixq_EnvItem::ItemCategoryHikariBible;

   // **********
   // ***  ***
   // **********

   // bible version, old testament
   
   iValue = (int)BibleKougoyaku; 
   _HikariBibleVersion.Set( sCat, iValue, "Hikari Bible Version" );

   // bible version, second, old testament
   
   iValue = (int)BibleKingJames; 
   _HikariBibleSecondVersion.Set( sCat, iValue, "Hikari Bible Second Version" );

   // language, one of PixTopoMainLanguange;
   iValue = (int)PixTopoLanguangeJp; 
   _HikariBibleSystemLanguage.Set( sCat, iValue, "Hikari Bible Control Language" );

   // use this bible version for search?

   bValue = false;
   _HikariBibleSearchShinkaiyaku2.Set( sCat, bValue, "Hikari Bible Search Shinkaiyaku2" );

   bValue = true;
   _HikariBibleSearchKougoyaku.Set( sCat, bValue, "Hikari Bible Search Kougoyaku" );

   bValue = false;
   _HikariBibleSearchKingJames.Set( sCat, bValue, "Hikari Bible Search KingJames" );
   
   bValue = false;
   _HikariBibleSearchIntlStandard.Set( sCat, bValue, "Hikari Bible Search IntlStandard" );
   
   bValue = false;
   _HikariBibleSearchBungo.Set( sCat, bValue, "Hikari Bible Search Bungo" );

   bValue = false;
   _HikariBibleSearchRaguet.Set( sCat, bValue, "Hikari Bible Search Raguet" );

   // last search word, just to memorize
   strValue.clear( );
   _HikariBibleSearchLastWord.Set( sCat, strValue, "Hikari Bible Search Last Words" );

   // last search mode, one of BibleSearchWordsCombination
   iValue = SearchWordAnd;
   _HikariBibleSearchLastMode.Set( sCat, iValue, "Hikari Bible Search Last Combination" );

   // max number of searched words
   iValue = 100;
   _HikariBibleSearchMaxWords.Set( sCat, iValue, "Hikari Bible Search Max Results" );


   return;
}
 
static QFont InitHikariHikariJpFont( void )
{
   bool bMatch;
   QFont fn;

   fn.setBold( false );
   fn.setStrikeOut( false );
   fn.setItalic( false );
   fn.setOverline( false );
   fn.setUnderline( false );
   
   fn.setFamily( "CI" );

   //fn.setPointSize( 8 );
   fn.setPointSizeF( 11 );
   fn.setPixelSize( -1 );

   fn.setWeight( QFont::Normal );

   fn.setStyle( QFont::StyleNormal );
   fn.setStyleHint( QFont::AnyStyle );

   // members not explicitly set

   //fn.setFixedPitch( bool enable );
   //fn.setCapitalization( Capitalization caps );
   //fn.setKerning( bool enable );
   //fn.setLetterSpacing( SpacingType type, qreal spacing );
   //fn.setRawMode( bool enable );
   //fn.setRawName( const QString & name );
   //fn.setStretch( int factor );
   //fn.setStyleStrategy( StyleStrategy s );
   //fn.setWordSpacing( qreal spacing )

   // Returns true if a window system font exactly matching the settings of this font is available.
   bMatch = fn.exactMatch( );

   return fn;
}

static QFont InitHikariHikariEnFont( void )
{
   bool bMatch;
   QFont fn;

   fn.setBold( false );
   fn.setStrikeOut( false );
   fn.setItalic( false );
   fn.setOverline( false );
   fn.setUnderline( false );
   
   fn.setFamily( "Ariel" );

   //fn.setPointSize( 8 );
   fn.setPointSizeF( 11 );
   fn.setPixelSize( -1 );

   fn.setWeight( QFont::Normal );

   fn.setStyle( QFont::StyleNormal );
   fn.setStyleHint( QFont::AnyStyle );

   // members not explicitly set

   //fn.setFixedPitch( bool enable );
   //fn.setCapitalization( Capitalization caps );
   //fn.setKerning( bool enable );
   //fn.setLetterSpacing( SpacingType type, qreal spacing );
   //fn.setRawMode( bool enable );
   //fn.setRawName( const QString & name );
   //fn.setStretch( int factor );
   //fn.setStyleStrategy( StyleStrategy s );
   //fn.setWordSpacing( qreal spacing )

   // Returns true if a window system font exactly matching the settings of this font is available.
   bMatch = fn.exactMatch( );

   return fn;
}

static QFont InitHikariSearchJpFont( void )
{
   QFont fn;

   fn.setBold( false );
   fn.setStrikeOut( false );
   fn.setItalic( false );
   fn.setOverline( false );
   fn.setUnderline( false );
   
   fn.setFamily( "CI" );

   //fn.setPointSize( 8 );
   fn.setPointSizeF( 8 );
   fn.setPixelSize( -1 );

   fn.setWeight( QFont::Normal );
   fn.setStyle( QFont::StyleNormal );
   fn.setStyleHint( QFont::AnyStyle );

   return fn;
}

static QFont InitHikariSearchEnFont( void )
{
   QFont fn;

   fn.setBold( false );
   fn.setStrikeOut( false );
   fn.setItalic( false );
   fn.setOverline( false );
   fn.setUnderline( false );
   
   fn.setFamily( "Ariel" );

   //fn.setPointSize( 8 );
   fn.setPointSizeF( 8 );
   fn.setPixelSize( -1 );

   fn.setWeight( QFont::Normal );
   fn.setStyle( QFont::StyleNormal );
   fn.setStyleHint( QFont::AnyStyle );

   return fn;
}

void pixq_Properties::InitHikariView( void )
{
   QFont fn;
   QColor colValue;
   bool bValue;
   int iValue;

   short sCat = (short)pixq_EnvItem::ItemCategoryHikariView;

   // *******************
   // *** Hikari \ ***
   // *******************
   
   // tHgi{j

   fn = InitHikariHikariJpFont( );
   _HikariViewHikariJpFont.Set( sCat, fn, "Hikari View Japanese Font" );
  
   // tHgipj
   fn = InitHikariHikariEnFont( );
   _HikariViewHikariEnFont.Set( sCat, fn, "Hikari View English Font" );

   // 1\, or 2i\
   iValue = 1;
   _HikariVieBibleNum.Set( sCat, iValue, "Hikari View Bibles Number" );

   // \Őߔԍ̕\,ShowChapterVerseNumber̂ǂꂩ 
   iValue = VerseNumberChapterVerse;
   _HikariViewShowVerseNum.Set( sCat, iValue, "Hikari View Show Chapter Verse" );

   // draw table boundary
   bValue = true;
   _HikariViewShowTableLines.Set( sCat, bValue, "Hikari View Show Table Lines" );

   // ߔԍƗʃJɂH
   bValue = true;
   _HikariViewVersesSeparateColumn.Set( sCat, bValue, "Hikari View Show Verses In Separate Column" );

   // tHgʁi{j
   
   fn = InitHikariSearchJpFont( );
   _HikariViewSearchJpFont.Set( sCat, fn, "Hikari View Search Japanese Font" );
   
   // tHgʁipj
   
   fn = InitHikariSearchEnFont( );
   _HikariViewSearchEnFont.Set( sCat, fn, "Hikari View Search English Font" );

   return;
}

void pixq_Properties::InitHikariEdit( void )
{
   bool bValue;
   int iValue;

   short sCat = (short)pixq_EnvItem::ItemCategoryHikariEdit;

   // *******************
   // *** Hikari ҏW ***
   // *******************
   
   // Copy - include book name

   bValue = true;
   _HikariCopyIncludeBook.Set( sCat, bValue, "Hikari Copy Include Book Name" );
  
   // Copy - include version Name
   
   bValue = false;
   _HikariCopyIncludeVersion.Set( sCat, bValue, "Hikari Copy Include Version Name" );

   // Copy - chapter verse number? One of ShowChapterVerseNumber 
   iValue = VerseNumberChapterVerse;
   _HikariCopyIncludeVerse.Set( sCat, iValue, "Hikari Copy Include Chapter Verse" );

   // Copy - separate verses(change line for each verse) 
   
   bValue = true;
   _HikariCopyChangeLine.Set( sCat, bValue, "Hikari Copy Separate Verses" );

   return;
}

void pixq_Properties::InitHikariBagster( void )
{
    bool bValue;
   int iValue;

   short sCat = (short)pixq_EnvItem::ItemCategoryHikariBagster;

   // ****************************
   // *** Hikari̒Bagster ***
   // ****************************
   
   // bible version to show daily light inside Hikari
   iValue = (int)BibleKougoyaku; 
   _HikariBagsterBibleVer.Set( sCat, iValue, "Hikari Bagster Bible Version" );

   // second bible version to show daily light inside Hikari
   iValue = (int)BibleKingJames; 
   _HikariBagster2ndBibleVer.Set( sCat, iValue, "Hikari Bagster Second Bible Version" );

   // show at selected time?
   bValue = true;
   _HikariBagsterShowEveryDay.Set( sCat, bValue, "Hikari Bagster Morning Show Every Day" );

   // time to show the morning words
   
   iValue = 8;
   _HikariBagsterAmShowHour.Set( sCat, iValue, "Hikari Bagster Morning Show Time Hour" );
   
   iValue = 0;
   _HikariBagsterAmShowMinuite.Set( sCat, iValue, "Hikari Bagster Morning Show Time Minuite" );

   iValue = 0;
   _HikariBagsterAmShowSecond.Set( sCat, iValue, "Hikari Bagster Morning Show Time Second" );

   // time to show the evening
   
   iValue = 20;
   _HikariBagsterPmShowHour.Set( sCat, iValue, "Hikari Bagster Night Show Time Hour" );
   
   iValue = 0;
   _HikariBagsterPmShowMinuite.Set( sCat, iValue, "Hikari Bagster Night Show Time Minuite" );
   
   iValue = 0;
   _HikariBagsterPmShowSecond.Set( sCat, iValue, "Hikari Bagster Night Show Time Second" );

   return;
}

void pixq_Properties::InitHikariBiblePlan( void )
{
   int iValue;
   QColor colValue;

   short sCat = (short)pixq_EnvItem::ItemCategoryHikariPlan;

   // ************
   // *** ʓ ***
   // ************

   // ʓǃv, one of BibleYearReadPlan
   
   iValue = (int)BiblePlanClassic;
   _HikariPlanSelected.Set( sCat, iValue, "Hikari Plan Last Selected Plan" );

   // eʓǃv̍ŏIiy[Wj,day start from zero
   
   iValue = 0;
   _HikariPlanBeginingToEndDay.Set( sCat, iValue, "Hikari Plan Day BeginingToEnd" );
   
   iValue = 0;
   _HikariPlanChronologicalDay.Set( sCat, iValue, "Hikari Plan Day Chronological" );
   
   iValue = 0;
   _HikariPlanOldChronologicalDay.Set( sCat, iValue, "Hikari Plan Day OldChronological" );
   
   iValue = 0;
   _HikariPlanNewChronologicalDay.Set( sCat, iValue, "Hikari Plan Day NewChronological" );
   
   iValue = 0;
   _HikariPlanHistoricalDay.Set( sCat, iValue, "Hikari Plan Day Historical" );
   
   iValue = 0;
   _HikariPlanOldAndNewOneDayDay.Set( sCat, iValue, "Hikari Plan Day OldAndNewOneDay" );
   
   iValue = 0;
   _HikariPlanMichaelColeyDay.Set( sCat, iValue, "Hikari Plan Day Michael Coley" ); 
   
   iValue = 0;
   _HikariPlanThematicDay.Set( sCat, iValue, "Hikari Plan Day Thematic" );
   
   iValue = 0;
   _HikariPlanBookOrderDay.Set( sCat, iValue, "Hikari Plan Day BookOrder" );
   
   iValue = 0;
   _HikariPlanClassicDay.Set( sCat, iValue, "Hikari Plan Day Classic" );
   
   iValue = 0;
   _HikariPlanHikariOldNewDay.Set( sCat, iValue, "Hikari Plan Day HikariOldNew" );
   
   iValue = 0;
   _HikariPlanHikariNewOldNewDay.Set( sCat, iValue, "Hikari Plan Day HikariNewOldNew" );

   // Day all read color - fill 
   //colValue.setRgb( 9, 54, 156 );
   colValue.setRgb( 9, 54, 156 );
   _HikariPlanReadColor.Set( sCat, colValue, "Hikari Plan Full Read Fill Color" );

   // Day all partially read color - fill 
   colValue.setRgb( 127, 127, 255 );
   _HikariPlanPartReadColor.Set( sCat, colValue, "Hikari Plan Partially Read Fill Color" );

   // Day all not read color - fill 
   colValue.setRgb( 223, 223, 223 );
   _HikariPlanNotReadColor.Set( sCat, colValue, "Hikari Plan Not Read Fill Color" );
   
   // Chart background color - fill 
   colValue.setRgb( 63, 63, 63 );
   _HikariPlanBackgroundColor.Set( sCat, colValue, "Hikari Plan Chart Background Fill Color" );

   // Day all read color - text
   colValue.setRgb( 255, 255, 255 );
   _HikariPlanReadTextColor.Set( sCat, colValue, "Hikari Plan Full Read Text Color" );

   // Day all partially read color - text
   colValue.setRgb( 255, 255, 255 );
   _HikariPlanPartReadTextColor.Set( sCat, colValue, "Hikari Plan Partially Read Text Color" );

   // Day all not read color - text
   colValue.setRgb( 0, 0, 0 );
   _HikariPlanNotReadTextColor.Set( sCat, colValue, "Hikari Plan Not Read Text Color" );

   return;
}

void pixq_Properties::InitPlayback( void )
{
   bool bValue;
   int iValue, iMin, nMax;
   QColor colValue;

   short sCat = pixq_EnvItem::ItemCategoryPlayback;

   // ****************
   // *** Playback ***
   // ****************

   // *** image comparison ***

   // show wiper/box as line
   bValue = true;
   _PlaybackDrawWiperLine.Set( sCat, bValue, "Playback Draw Wiper Box" ); 

   // wiper/box color   
   colValue.setRgb( 255, 255, 0 );
   _PlaybackWiperLineColor.Set( sCat, colValue, "Playback Wiper Box Color" ); 

   // box(scope) radius, pixels on screen
   iValue = 50;
   iMin = 20;
   nMax = 600;
   _PlaybackBoxRadius.Set( sCat, iValue, "Playback Box Radius", iMin, nMax ); 

   // *** fullscreen ***

   // number of pixels at the edge, top/bottom
   iValue = 0;
   _PlaybackEdgePixelsTop.Set( sCat, iValue, "Playback Edge Pixels Top Bottom" ); 

   // number of pixels at the edge, left/right
   iValue = 0;
   _PlaybackEdgePixelsLeft.Set( sCat, iValue, "Playback Edge Pixels Left Right" ); 

   return;
}

void pixq_Properties::InitSystem( void )
{
   bool bValue;
   int iValue;
   QString strValue;

   short sCat = pixq_EnvItem::ItemCategorySystem;

   // **************
   // *** system ***
   // **************

   // use disk cache for playback
   bValue = true;
   _SystemUseDiskCache.Set( sCat, bValue, "System Use Disk Cache" );

   // use CUDA program if applicable?
   bValue = true;
   _SystemUseCuda.Set( sCat, bValue, "System Use Cuda" ); 

   // screen number to use for dual view configuration, 0(left) or 1(right)
   iValue = (int)0;
   _SystemMonitorPosition.Set( sCat, iValue, "System Monitors Screen Position" );

   // Type of 3D-TV, must be one of TypeOfThreeDimensionalTV;
   //iValue = (int)TV3DTypeSplitSideBySide;
   iValue = (int)TV3DTypeOpenGLQuadBuffer;
   _System3DPictureFormat.Set( sCat, iValue, "System 3D-TV Type" );

   // directory to store all dmr sampler batch files
#ifdef _WINDOWS
   strValue = QString::fromLatin1("c:\\");
#else
   strValue = QString::fromLatin1("/home");
#endif
   _SystemSamplerBatchPath.Set( sCat, strValue, "System Sampler Batch File Path" );

   // report processing time after image processing?
   bValue = true;
   _SystemSamplerReportTime.Set( sCat, bValue, "System Sampler Report Time" );

   // show detailed message in DMR2Sampler?
   bValue = true;
   _SystemSamplerDetailMsg.Set( sCat, bValue, "System Sampler Show Detailed Messages" );

   return;
}

 
void pixq_Properties::InitScope( void )
{
   QString strValue;

   short sCat = pixq_EnvItem::ItemCategoryScope;

   // **************
   // *** scope ***
   // **************

   // directory of the last seleced images

#ifdef _WINDOWS
   strValue = QString::fromLatin1("c:\\");
#else
   strValue = QString::fromLatin1("/home");
#endif
   _ScopeLastImageDir.Set( sCat, strValue, "Scope Last Selected Image Path" );
   
   return;
}


void pixq_Properties::InitDftFilter( void )
{
   double dValue;
   int iValue;

   short sCat = pixq_EnvItem::ItemCategoryDftFilter;

   // ******************
   // *** DFT Filter ***
   // ******************

   // filter DFT visualize sigma range
   // when the results of DFT is visualized, extent of average +/- sigma * range is
   // scaled to 0 - 255
   dValue = 2.0;
   _DftFilterDftSigmaRange.Set( sCat, dValue, "Filter DFT Visualize Sigma Range" );

   // filter - low/high filter, boundary
   dValue = 350.0;
   _DftFilterHighLowPassBoundary.Set( sCat, dValue, "Filter High Low Pass Boundary" );

   // filter - band-pass filter, lower boundary
   dValue = 100.0; 
   _DftFilterBandPassLowBoundary.Set( sCat, dValue, "Filter BandPass Lower Boundary" );

   // filter - band-pass filter,  higher boundary 
   dValue = 1000.0;
   _DftFilterBandPassHighBoundary.Set( sCat, dValue, "Filter BandPass Higher Boundary" );

   // filter - filter type, one of DigitalImageFilterShape
   iValue = DigitalFilterLowPass;
   _DftFilterDigitalFilterShape.Set( sCat, iValue, "Filter Digital Filter Shape" );

   // filter - channel to analyze for 1D or 2D visualization of DFT results
   // one of PixImageColorChannel
   iValue = PixImageColorRed;
   _DftFilterDftVisualizeColor.Set( sCat, iValue, "Filter Digital Filter Shape" );

   return;
}

void pixq_Properties::InitImage( void )
{
   bool bValue;
   int iValue;
   double dValue;

   short sCat = pixq_EnvItem::ItemCategoryImage;

   // *************
   // *** Image ***
   // *************
      
   iValue = (int)TextureFilterNearest;
   _ImageTextureFilter.Set( sCat, iValue, "Image Texture Filter" ); 

   // gamma correction for image   
   dValue = 1.0;
   _ImageGammaCorrection.Set( sCat, dValue, "Image Gamma Correction Value" ); 

   // use Ping's 10_10_10_2 texture if applicable
   bValue = true;
   _Image10BitTexture.Set( sCat, bValue, "Image Use 10-bit texture" ); 

   // sampling interval for image statistics/histopram
   iValue = 10;
   _ImageStatSamplePitch.Set( sCat, iValue, "Image Statistics Sampling Pitch" ); 

   // get and show statistics when new frame is selected?
   bValue = false;
   _ImageStatActiveFrame.Set( sCat, bValue, "Image Statistics Active Frame" ); 

   return;
}

//
// make a list of all env items
//
void pixq_Properties::GetEnvItems( vector<pixq_EnvItem*> *pItemsList )
{
   pItemsList->clear( );
   
   // **************
   // *** Common ***
   // **************

   pItemsList->push_back( (pixq_EnvItem*)&_CommonApplicationName );
   pItemsList->push_back( (pixq_EnvItem*)&_CommonOrganisationName );

   pItemsList->push_back( (pixq_EnvItem*)&_CommonLastImage0Dir );
   pItemsList->push_back( (pixq_EnvItem*)&_CommonLastImage1Dir );

   pItemsList->push_back( (pixq_EnvItem*)&_CommonLastImage0File );
   pItemsList->push_back( (pixq_EnvItem*)&_CommonLastImage1File );

   pItemsList->push_back( (pixq_EnvItem*)&_CommonLastVideoDir );

   // *************
   // *** Image ***
   // *************   

   pItemsList->push_back( (pixq_EnvItem*)&_ImageTextureFilter );
   pItemsList->push_back( (pixq_EnvItem*)&_ImageGammaCorrection );
   pItemsList->push_back( (pixq_EnvItem*)&_Image10BitTexture );   

   pItemsList->push_back( (pixq_EnvItem*)&_ImageStatSamplePitch );
   pItemsList->push_back( (pixq_EnvItem*)&_ImageStatActiveFrame );

   // ****************
   // *** Playback ***
   // ****************

   pItemsList->push_back( (pixq_EnvItem*)&_PlaybackDrawWiperLine );
   pItemsList->push_back( (pixq_EnvItem*)&_PlaybackWiperLineColor );
   pItemsList->push_back( (pixq_EnvItem*)&_PlaybackBoxRadius );

   pItemsList->push_back( (pixq_EnvItem*)&_PlaybackEdgePixelsTop );
   pItemsList->push_back( (pixq_EnvItem*)&_PlaybackEdgePixelsLeft );

   // **************
   // *** system ***
   // **************

   pItemsList->push_back( (pixq_EnvItem*)&_SystemUseDiskCache );
   pItemsList->push_back( (pixq_EnvItem*)&_SystemUseCuda );
   pItemsList->push_back( (pixq_EnvItem*)&_SystemMonitorPosition );
   pItemsList->push_back( (pixq_EnvItem*)&_System3DPictureFormat );

   pItemsList->push_back( (pixq_EnvItem*)&_SystemSamplerBatchPath );
   pItemsList->push_back( (pixq_EnvItem*)&_SystemSamplerReportTime );
   pItemsList->push_back( (pixq_EnvItem*)&_SystemSamplerDetailMsg );

   // **************
   // *** scope ***
   // **************

   pItemsList->push_back( (pixq_EnvItem*)&_ScopeLastImageDir );

   // ******************************
   // *** Bagster window position ***
   // ******************************

   pItemsList->push_back( (pixq_EnvItem*)&_BagsterWinLeft );
   pItemsList->push_back( (pixq_EnvItem*)&_BagsterWinTop );
   pItemsList->push_back( (pixq_EnvItem*)&_BagsterWinWidth );
   pItemsList->push_back( (pixq_EnvItem*)&_BagsterWinHeight );

   pItemsList->push_back( (pixq_EnvItem*)&_BagsterHeaderFont );
   pItemsList->push_back( (pixq_EnvItem*)&_BagsterHeaderFgColor );
   pItemsList->push_back( (pixq_EnvItem*)&_BagsterHeaderBg0Color );
   pItemsList->push_back( (pixq_EnvItem*)&_BagsterHeaderBg1Color );

   // *******************
   // *** Bagster  ***
   // *******************

   // show at selected time?
   pItemsList->push_back( (pixq_EnvItem*)&_BagsterShowEveryDay );

   // time to show the morning words
   pItemsList->push_back( (pixq_EnvItem*)&_BagsterAmShowHour );
   pItemsList->push_back( (pixq_EnvItem*)&_BagsterAmShowMinuite );
   pItemsList->push_back( (pixq_EnvItem*)&_BagsterAmShowSecond );

   // time to show the evening
   pItemsList->push_back( (pixq_EnvItem*)&_BagsterPmShowHour );
   pItemsList->push_back( (pixq_EnvItem*)&_BagsterPmShowMinuite );
   pItemsList->push_back( (pixq_EnvItem*)&_BagsterPmShowSecond );

   // bible version
   pItemsList->push_back( (pixq_EnvItem*)&_BagsterBibleVersion );
   
   // *******************
   // *** Bagster \ ***
   // *******************
   
   pItemsList->push_back( (pixq_EnvItem*)&_BagsterJapaneseFont );
   pItemsList->push_back( (pixq_EnvItem*)&_BagsterEnglishFont );
   pItemsList->push_back( (pixq_EnvItem*)&_BagsterBgColor );
   pItemsList->push_back( (pixq_EnvItem*)&_BagsterLineHeight );

   // **********************************
   // *** Hikari initial condtions ***
   // **********************************

   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastContent );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastOldBook );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastNewBook );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastDevotion );

   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter01 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter02 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter03 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter04 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter05 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter06 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter07 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter08 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter09 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter10 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter11 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter12 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter13 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter14 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter15 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter16 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter17 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter18 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter19 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter20 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter21 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter22 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter23 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter24 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter25 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter26 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter27 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter28 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter29 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter30 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter31 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter32 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter33 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter34 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter35 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter36 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter37 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter38 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter39 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter40 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter41 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter42 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter43 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter44 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter45 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter46 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter47 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter48 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter49 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter50 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter51 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter52 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter53 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter54 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter55 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter56 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter57 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter58 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter59 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter60 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter61 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter62 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter63 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter64 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter65 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariLastBookChapter66 );
                                                                     
   // ****************                                               
   // *** \ ***                                               
   // ****************                                               
                                                                     
   pItemsList->push_back( (pixq_EnvItem*)&_HikariHeaderFont );     
   pItemsList->push_back( (pixq_EnvItem*)&_HikariHeaderFgColor );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariHeaderBg0Color );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariHeaderBg1Color );

   // *********************
   // *** Hikari  ***
   // *********************
   
   pItemsList->push_back( (pixq_EnvItem*)&_HikariBibleVersion );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariBibleSecondVersion );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariBibleSystemLanguage );
   
   pItemsList->push_back( (pixq_EnvItem*)&_HikariBibleSearchShinkaiyaku2 );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariBibleSearchKougoyaku );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariBibleSearchKingJames );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariBibleSearchIntlStandard );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariBibleSearchBungo );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariBibleSearchRaguet );

   pItemsList->push_back( (pixq_EnvItem*)&_HikariBibleSearchLastWord );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariBibleSearchLastMode );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariBibleSearchMaxWords );

   // *********************
   // *** Hikari \ ***
   // *********************
   
   pItemsList->push_back( (pixq_EnvItem*)&_HikariViewHikariJpFont );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariViewHikariEnFont );

   pItemsList->push_back( (pixq_EnvItem*)&_HikariVieBibleNum );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariViewShowVerseNum );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariViewShowTableLines );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariViewVersesSeparateColumn );

   pItemsList->push_back( (pixq_EnvItem*)&_HikariViewSearchJpFont );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariViewSearchEnFont );

   // *******************
   // *** Hikari ҏW ***
   // *******************

   pItemsList->push_back( (pixq_EnvItem*)&_HikariCopyIncludeBook );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariCopyIncludeVersion );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariCopyIncludeVerse );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariCopyChangeLine );

   // ****************************
   // *** Hikari̒Bagster ***
   // ****************************

   pItemsList->push_back( (pixq_EnvItem*)&_HikariBagsterBibleVer );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariBagster2ndBibleVer );

   pItemsList->push_back( (pixq_EnvItem*)&_HikariBagsterShowEveryDay );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariBagsterAmShowHour );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariBagsterAmShowMinuite );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariBagsterAmShowSecond );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariBagsterPmShowHour );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariBagsterPmShowMinuite );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariBagsterPmShowSecond );

   // ************
   // *** ʓ ***
   // ************
   
   pItemsList->push_back( (pixq_EnvItem*)&_HikariPlanSelected );

   pItemsList->push_back( (pixq_EnvItem*)&_HikariPlanBeginingToEndDay );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariPlanChronologicalDay );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariPlanOldChronologicalDay );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariPlanNewChronologicalDay );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariPlanHistoricalDay );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariPlanOldAndNewOneDayDay );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariPlanMichaelColeyDay ); 
   pItemsList->push_back( (pixq_EnvItem*)&_HikariPlanThematicDay );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariPlanBookOrderDay );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariPlanClassicDay );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariPlanHikariOldNewDay );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariPlanHikariNewOldNewDay );

   pItemsList->push_back( (pixq_EnvItem*)&_HikariPlanReadColor );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariPlanPartReadColor );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariPlanNotReadColor );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariPlanBackgroundColor );

   pItemsList->push_back( (pixq_EnvItem*)&_HikariPlanReadTextColor );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariPlanPartReadTextColor );
   pItemsList->push_back( (pixq_EnvItem*)&_HikariPlanNotReadTextColor );

   // ******************
   // *** DFT Filter ***
   // ******************

   pItemsList->push_back( (pixq_EnvItem*)&_DftFilterDftSigmaRange );
   pItemsList->push_back( (pixq_EnvItem*)&_DftFilterHighLowPassBoundary );
   pItemsList->push_back( (pixq_EnvItem*)&_DftFilterBandPassLowBoundary );
   pItemsList->push_back( (pixq_EnvItem*)&_DftFilterBandPassHighBoundary );
   pItemsList->push_back( (pixq_EnvItem*)&_DftFilterDigitalFilterShape );
   pItemsList->push_back( (pixq_EnvItem*)&_DftFilterDftVisualizeColor );

   // --- Done ---
   return;
}

void pixq_Properties::GetRegEnv( QString strOrg, QString strApp )
{
   vector<pixq_EnvItem*> ItemsList;
   pixq_EnvItem *pItem;
   int i, nItems;

   GetEnvItems( &ItemsList );

   nItems = (int)ItemsList.size( );
   for( i = 0 ; i < nItems ; i++ ) {
      pItem = (pixq_EnvItem*)ItemsList.at( i );
      pItem->GetReg( strOrg, strApp );
   }

   // --- Done ---
   return;
}

// 
// ݒWXg[ɏ
//
void pixq_Properties::SetRegEnv( QString strOrg, QString strApp )
{
   vector<pixq_EnvItem*> ItemsList;
   pixq_EnvItem *pItem;
   int i, nItems;

   GetEnvItems( &ItemsList );

   nItems = (int)ItemsList.size( );
   for( i = 0 ; i < nItems ; i++ ) {
      pItem = (pixq_EnvItem*)ItemsList.at( i );
      pItem->SetReg( strOrg, strApp );
   }

   // --- Done ---
   return;
}

//
// copy constructor
//
pixq_Properties &pixq_Properties::operator=( pixq_Properties &that )
{
   vector<pixq_EnvItem*> ItemsThis;
   vector<pixq_EnvItem*> ItemsThat;

   pixq_EnvItem *pThisItem, *pThatItem;
   int i, nItems;

   GetEnvItems( &ItemsThis );
   that.GetEnvItems( &ItemsThat );

   nItems = (int)ItemsThis.size( );
   for( i = 0 ; i < nItems ; i++ ) {
      try {
         pThisItem = (pixq_EnvItem*)ItemsThis.at( i );
         pThatItem = (pixq_EnvItem*)ItemsThat.at( i );
         //
         *pThisItem = *pThatItem;      
      }

      catch ( char * /* message */ ) {
         goto PIX_EXIT;    
	   };
   }
                                        
   // --- Done ---
PIX_EXIT:
   return *this;
}

QString pixq_Properties::GetBibleVersionName( int iVersion ) // [i] version number
{
   QString strValue;

   switch( iVersion ) {
   case pixq_Properties::BibleShinkaiyaku2:   
      strValue = "V2\0";
      break;

   case pixq_Properties::BibleShinkaiyaku3:
      strValue = "V3\0";
      break;

   case pixq_Properties::BibleKougoyaku: 
      strValue = "\0";
      break;

   case pixq_Properties::BibleKingJames: 
      //strValue = "King James Version/Ԓ\0";
      //strValue = "King James Version\0";
      strValue = "KJV\0";
      break;

   case pixq_Properties::BibleIntlStandard:
      //strValue = "International Standard Version\0";
      strValue = "ISV\0";
      break;
      
   case pixq_Properties::BibleBungo: 
      strValue = "吳E\0";
      break;
      
   case pixq_Properties::BibleRaguet:
      strValue = "Q\0";
      //strValue = tr("QiV̂݁j\0");
      break;

   default:
      strValue = "Unknown\0";
      break;
   }

   return strValue;
}

bool pixq_Properties::BibleVersionJapanese( int iVersion ) // [i] version number
{
   bool bJapanese;

   switch( iVersion ) {
   case pixq_Properties::BibleShinkaiyaku2:   
   case pixq_Properties::BibleShinkaiyaku3:
   case pixq_Properties::BibleKougoyaku: 
   case pixq_Properties::BibleBungo:  
   case pixq_Properties::BibleRaguet: 
      bJapanese = true;
      break;

   case pixq_Properties::BibleKingJames: 
   case pixq_Properties::BibleIntlStandard:
   default:
      bJapanese = false;
      break;
   }

   return bJapanese;
}

bool pixq_Properties::BagsterBibleVersionJapanese( void ) 
{
   int iVersion = _BagsterBibleVersion.iGet( );

   return BibleVersionJapanese( iVersion );
}

QString pixq_Properties::BagsterGetBibleVersionName( void )
{
   int iVersion = _BagsterBibleVersion.iGet( );

   return GetBibleVersionName( iVersion );
}

QString pixq_Properties::HikariGetBibleVersionName( void )
{
   int iVersion = _HikariBibleVersion.iGet( );

   return GetBibleVersionName( iVersion );
}

QString pixq_Properties::HikariGet2ndBibleVersionName( void )
{
   int iVersion = _HikariBibleSecondVersion.iGet( );

   return GetBibleVersionName( iVersion );
}

QString pixq_Properties::HikariGetBagsterVersionName( void )
{
   int iVersion = _HikariBagsterBibleVer.iGet( );

   return GetBibleVersionName( iVersion );
}

QString pixq_Properties::HikariGet2ndBagsterVersionName( void )
{
   int iVersion = _HikariBagster2ndBibleVer.iGet( );

   return GetBibleVersionName( iVersion );
}


QString pixq_Properties::GetHikariBibleXmlFile( int iSide ) // [i] side, 0 or 1
{
   QString strPath;

   if( 0 == iSide ) {     
      strPath = GetHikariFirstBibleXmlFile( );
   } else {
      strPath = GetHikariSecondBibleXmlFile( );
   }

   return strPath;
}

//
// check whether the bible xml file exists
//
bool pixq_Properties::VersionBibleXmlExist( int iVersion )
{
   bool bRetCode = false;
   QString strPath;
   QFileInfo fi;

   strPath = GetBibleXmlFile_PC( iVersion );
   if( strPath.isEmpty( ) ) {
      goto PIX_EXIT;
   }

   fi.setFile( strPath );
   if( !fi.exists( ) ) {
      goto PIX_EXIT;
   }

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

//
// check whether the daily bagster xml file exists
//
bool pixq_Properties::VersionDailyXmlExist( int iVersion )
{
   bool bRetCode = false;
   QString strPath;
   QFileInfo fi;

   strPath = GetDailyWordsFile_PC( iVersion );
   if( strPath.isEmpty( ) ) {
      goto PIX_EXIT;
   }

   fi.setFile( strPath );
   if( !fi.exists( ) ) {
      goto PIX_EXIT;
   }

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

//
// get bible xml file for the first selected bible version
//
QString pixq_Properties::GetHikariFirstBibleXmlFile( void )
{
   QString strPath;

   int iVersion = _HikariBibleVersion.iGet( );

   switch( iVersion ) {     
   case pixq_Properties::BibleShinkaiyaku2:   
   case pixq_Properties::BibleShinkaiyaku3:
      //
      // V2IłꍇAt@C݂邩`FbNI
      //
      if( VersionBibleXmlExist( iVersion ) ) {
         strPath = GetBibleXmlFile_PC( iVersion );
      } else {
         //
         // Vt@C݂Ȃɐ؂ւ
         //
         QString strError;
         QString strApplication = _CommonApplicationName.strGet( );
         
         strError = "̃VXeɂ́AV󐹏t@C݂܂B\n\n";
         strError = strError + "󐹏ɐ؂ւ܂B";
         QMessageBox::information( NULL, strApplication, strError );
         //
         iVersion = pixq_Properties::BibleKougoyaku;
         _HikariBibleVersion.Set( iVersion );
         strPath = GetBibleXmlFile_PC( iVersion );
         
      }
      break;

   case pixq_Properties::BibleKougoyaku:
   case pixq_Properties::BibleKingJames:
   case pixq_Properties::BibleIntlStandard:
   case pixq_Properties::BibleBungo: 
   case pixq_Properties::BibleRaguet:
      strPath = GetBibleXmlFile_PC( iVersion );
      break;

   default:
      iVersion = (int)pixq_Properties::BibleKougoyaku;
      _HikariBibleVersion.Set( iVersion );
      strPath = GetBibleXmlFile_PC( iVersion );
      break;
   }

   return strPath;
}

//
// get bible xml file for the second selected bible version
//
QString pixq_Properties::GetHikariSecondBibleXmlFile( void )
{
   QString strPath;

   int iVersion = _HikariBibleSecondVersion.iGet( );

   switch( iVersion ) {     
   case pixq_Properties::BibleShinkaiyaku2:  
   case pixq_Properties::BibleShinkaiyaku3:
      //
      // VIłꍇAt@C݂邩`FbNI
      //
      if( VersionBibleXmlExist( iVersion ) ) {
         strPath = GetBibleXmlFile_PC( iVersion );
      } else {
         //
         // Vt@C݂Ȃɐ؂ւ
         //
         QString strError;
         QString strApplication = _CommonApplicationName.strGet( );
         
         strError = "̃VXeɂ́AV󐹏t@C݂܂B\n\n";
         strError = strError + "󐹏ɐ؂ւ܂B";
         QMessageBox::information( NULL, strApplication, strError );
         //
         iVersion = pixq_Properties::BibleKougoyaku;
         _HikariBibleSecondVersion.Set( iVersion );
         strPath = GetBibleXmlFile_PC( iVersion );          
      }
      break;

   case pixq_Properties::BibleKougoyaku:
   case pixq_Properties::BibleKingJames:
   case pixq_Properties::BibleIntlStandard:
   case pixq_Properties::BibleBungo: 
   case pixq_Properties::BibleRaguet:
      strPath = GetBibleXmlFile_PC( iVersion );
      break;

   default:
      iVersion = pixq_Properties::BibleKougoyaku;
      _HikariBibleSecondVersion.Set( iVersion );
      strPath = GetBibleXmlFile_PC( iVersion );
      break;
   }

   return strPath;
}

//
// ^ꂽVersion匟Ŏgp邩𒲂ׂ
//
bool pixq_Properties::VersionUsedForSearch( int iVersion )
{
   bool bSearch = false;
   
   switch( iVersion ) {
   case BibleShinkaiyaku2:
      bSearch = _HikariBibleSearchShinkaiyaku2.GetBool( );
      break;
   case BibleKougoyaku:
      bSearch = _HikariBibleSearchKougoyaku.GetBool( );
      break;
   case BibleKingJames:
      bSearch = _HikariBibleSearchKingJames.GetBool( );
      break;
   case BibleIntlStandard:
      bSearch = _HikariBibleSearchIntlStandard.GetBool( );
      break;
   case BibleBungo:
      bSearch = _HikariBibleSearchBungo.GetBool( );
      break;
   case BibleRaguet:
      bSearch = _HikariBibleSearchRaguet.GetBool( );
      break;
   case BibleShinkaiyaku3:
   default:
      bSearch = false;
      break;      
   } 

   return bSearch;
}

//
// ^ꂽVersion匟Ŏgp邩ݒ肷
//
void pixq_Properties::SetVersionUsedForSearch( int iVersion, 
                                              bool bSearch )
{   
   switch( iVersion ) {
   case BibleShinkaiyaku2:
      _HikariBibleSearchShinkaiyaku2.Set( bSearch );
      break;
   case BibleKougoyaku:
      _HikariBibleSearchKougoyaku.Set( bSearch );
      break;
   case BibleKingJames:
      _HikariBibleSearchKingJames.Set( bSearch );
      break;
   case BibleIntlStandard:
      _HikariBibleSearchIntlStandard.Set( bSearch );
      break;
   case BibleBungo:
      _HikariBibleSearchBungo.Set( bSearch );
      break;
   case BibleRaguet:
      _HikariBibleSearchRaguet.Set( bSearch );
      break;
   case BibleShinkaiyaku3:
   default:
      false;
      break;      
   } 

   return;
}

//
// gpł鐹̔ł̃Xg쐬
//

vector<int> pixq_Properties::HikariBibleJpVersions( void )
{
   vector<int> versions;
   
   versions.clear( );
   versions.push_back( (int)BibleShinkaiyaku2 );
   versions.push_back( (int)BibleKougoyaku );
   versions.push_back( (int)BibleBungo );
   versions.push_back( (int)BibleRaguet );

   return versions;
}

vector<int> pixq_Properties::HikariBibleEnVersions( void )
{
   vector<int> versions;
   
   versions.clear( );
   versions.push_back( (int)BibleKingJames );
   versions.push_back( (int)BibleIntlStandard );

   return versions;
}

vector<int> pixq_Properties::HikariBibleVersions( void )
{
   int nJp, nEn;
   vector<int> versions;
   vector<int> versions_jp;
   vector<int> versions_en;
   
   versions_jp = HikariBibleJpVersions( );
   versions_en = HikariBibleEnVersions( );

   nJp = (int)versions_jp.size( );
   nEn = (int)versions_en.size( );

   versions.resize( nJp + nEn );

   copy( versions_jp.begin( ), versions_jp.end( ), versions.begin( ) );
   copy( versions_en.begin(), versions_en.end( ), versions.begin( )+nJp );

   return versions;
}

//
// make a list of available bible read plans
//
void pixq_Properties::BibleReadPlanList( QList<int> &iNumbers ) // [o] plan ID
{
   iNumbers.clear( );

   iNumbers.push_back( (int)BiblePlanClassic );

   iNumbers.push_back( (int)BiblePlanBookOrder );
   iNumbers.push_back( (int)BiblePlanBeginingToEnd );

   iNumbers.push_back( (int)BiblePlanChronological );
   iNumbers.push_back( (int)BiblePlanOldChronological );
   iNumbers.push_back( (int)BiblePlanNewChronological );
   iNumbers.push_back( (int)BiblePlanHistorical );
   iNumbers.push_back( (int)BiblePlanOldAndNewOneDay ); 
         
   iNumbers.push_back( (int)BiblePlanMichaelColey ); 
   iNumbers.push_back( (int)BiblePlanThematic );
         
   return;
}
