#pragma once

namespace _pix_plot_qt_framework {

class pixq_EnvItem;

#include <pixqtlib_global.h>

class PIXQTLIB_EXPORT pixq_Properties
{
public:
   //
   // Do not change these numbers!
   // it is recorded in the registry
   //

   //
   // *** System ***
   //
   
   // Platform
   enum {
      PlatformUnknown = 0,
      PlatformWin32,
      PlatformWin64,
   } PixTopoSystemPlatform;

   // language
   enum {
      // {
      PixTopoLanguangeJp = 0,
      // English 
      PixTopoLanguangeEn,
   } PixTopoMainLanguange;

   enum {
      TextureFilterNearest = 0, // nearest neighbour 
      TextureFilterLinear = 1,
   } TextureMaginificationFilter;

   //
   // *** Bible ***
   //

   enum {
      // V󐹏2
      BibleShinkaiyaku2 = 0, 
      //  
      BibleKougoyaku,
      // KJV 
      BibleKingJames,
      // ISV 
      BibleIntlStandard,
      // 吳uV񐹏v(1950N)/up񐹏v(1953N)
      BibleBungo,
      // QuCGYXLXg̐V񐹏v(1910N)
      BibleRaguet,
      //
      // not yet prepared
      //
      // V󐹏3
      BibleShinkaiyaku3,
      //
   } BibleVersion;

   // hikari content to show
   // *** do not change these numbers! *** 
   enum {
      // Old Testamanet
      ContentOldTestament = 0,
      // Old Testamanet
      ContentNewTestament,
      // Devotions
      ContentDevotion,
   } HikariBibleContent;

   // hikari devotion content
   // *** do not change these numbers! *** 
   enum {
      // X̌A
      DevotionTypeDailyDays = 1,
      // X̌AXyVIP[V
      DevotionTypeDailyOccasion,
   } HikariDevotionContent;

   // ߔԍ̕\
   enum {
      // ߔԍ̂
      VerseNumberVerse = 1,
      // :
      VerseNumberChapterVerse,
      // Ȃ
      VerseNumberNone,
   } ShowChapterVerseNumber;

   // words searching mode
   enum {
      SearchWordAnd = 0,
      SearchWordOr,
   } BibleSearchWordsCombination;

   // gpĂ鐹ʓǃv
   // Do NOT CHANGE THESE NUMBERS!
   // 3̐
   enum {
      //
      BiblePlanUnknown = -1,
      //
      BiblePlanBeginingToEnd = 101,
      BiblePlanChronological = 102,
      BiblePlanOldChronological = 103,
      BiblePlanNewChronological = 104,
      BiblePlanHistorical = 105,
      BiblePlanOldAndNewOneDay = 106,
      //
      BiblePlanMichaelColey = 111, 
      BiblePlanThematic = 112,
      //
      BiblePlanBookOrder = 121,
      BiblePlanClassic = 122,
      //
      // Hikari exclusive
      BiblePlanHikariOldNew = 131,
      BiblePlanHikariNewOldNew = 132,
      //
   } BibleYearReadPlan;

   // shape of digital image filter
   enum {
      DigitalFilterLowPass = 0, // low-pass filter 
      DigitalFilterHighPass, // high-pass filter 
      DigitalFilterBandPass, // band-pass filter 
      DigitalFilterNotch, // notch filter 
   } DigitalImageFilterShape;

   // color channel
   enum {
      PixImageColorRed = 0, // red
      PixImageColorGreen, // green 
      PixImageColorBlue, // blue 
      PixImageColorGrayscale, // grayscale 
   } PixImageColorChannel;

   // *** Do Not Change Numbers! ***
   // *** Each Entry must have Unique Number ***
   enum {
      SamplerDerivedNone = 0, // no second image created
      //
      // *** derive from single image ***
      // *** Basic *** 
      //
      // same as the first image
      SamplerDerivedOriginal = 101, 
      SamplerDerivedGrayscale = 102,  
      SamplerDerivedMedian = 103, 
      //
      SamplerDerivedDelog = 104,
      SamplerDerivedResize = 105, 
      SamplerDerivedGaussian = 106, 
      SamplerDerivedEdge = 108, 
      //
      // FFT/DCT
      SamplerDerivedVisualDftValue = 110, 
      SamplerDerivedVisualDftShape = 111, 
      SamplerDerivedVisualDftFilter = 112, 
      //
      // OpenCV
      SamplerDerivedOpenCvSepia = 130, 
      //
      // *** Sharpening ***
      //     
      // edge preserving sharpening
      SamplerDerivedEpdow = 201,   
      // Ping's Sharping 
      SamplerDerivedSharping =202,
      //
   } SamplerDerivedImageType;

   // Type of 3D-TV
   enum {
      // Opengl Quadbuffer Stereo
      TV3DTypeOpenGLQuadBuffer = 0, 
      // DLP-TV, Checkered Flag, Sumchon
      TV3DTypeDlpCheckeredFlag, 
      // Split Screen, Side by Side, Panasonic
      TV3DTypeSplitSideBySide, 
      // Split Screen, Top and Bottom, Panasonic
      TV3DTypeSplitTopAndBottom, 
   } TypeOfThreeDimensionalTV;

public:
   pixq_Properties(void);
   ~pixq_Properties(void);

public:
   // **************
   // *** Common ***
   // **************

   // AvP[V쐬c̖
   pixq_EnvItem _CommonOrganisationName;

   // ÑAvP[V 
   pixq_EnvItem _CommonApplicationName;
   
   // for sequence selection dialog
   // directory of the last seleced images

   pixq_EnvItem _CommonLastImage0Dir;
   pixq_EnvItem _CommonLastImage1Dir;

   // last selected image

   pixq_EnvItem _CommonLastImage0File;
   pixq_EnvItem _CommonLastImage1File;

   // last selected video

   pixq_EnvItem _CommonLastVideoDir;

   // *************
   // *** Image ***
   // *************

   // openGL texture magnification filter, nearest or linear, one of TextureMaginificationFilter
   pixq_EnvItem _ImageTextureFilter;

   // gamma correction for image
   pixq_EnvItem _ImageGammaCorrection;

   // use Ping's 10_10_10_2 texture if applicable
   pixq_EnvItem _Image10BitTexture;

   // sampling interval for image statistics/histopram
   pixq_EnvItem _ImageStatSamplePitch;

   // get and show statistics when new frame is selected?
   pixq_EnvItem _ImageStatActiveFrame;

   // ****************
   // *** Playback ***
   // ****************
   
   // *** image comparison ***

   // show wiper/box as line
   pixq_EnvItem _PlaybackDrawWiperLine;

   // wiper/box color
   pixq_EnvItem _PlaybackWiperLineColor;

   // box(scope) radius, pixels on screen
   pixq_EnvItem _PlaybackBoxRadius;

   // number of pixels at the edge, top/bottom
   pixq_EnvItem _PlaybackEdgePixelsTop;

   // number of pixels at the edge, left/right
   pixq_EnvItem _PlaybackEdgePixelsLeft;

   // **************
   // *** System ***
   // **************

   // use disk cache for playback
   pixq_EnvItem _SystemUseDiskCache; 

   // use CUDA program if applicable?
   pixq_EnvItem _SystemUseCuda; 

   // screen number to use for dual view configuration, 0(left) or 1(right)
   pixq_EnvItem _SystemMonitorPosition;

   // Format of 3D-TV, must be one of TypeOfThreeDimensionalTV;
   pixq_EnvItem _System3DPictureFormat;

   // directory to store all dmr sampler batch files
   pixq_EnvItem _SystemSamplerBatchPath;

   // report processing time after image processing?
   pixq_EnvItem _SystemSamplerReportTime;

   // show detailed message in DMR2Sampler?
   pixq_EnvItem _SystemSamplerDetailMsg; 

   // *************
   // *** Scope ***
   // *************
   
   // directory of the last seleced images

   pixq_EnvItem _ScopeLastImageDir;

   // *******************************
   // *** Bagster window position ***
   // *******************************

   // [U[ɑIȂ

   pixq_EnvItem _BagsterWinLeft;
   pixq_EnvItem _BagsterWinTop;
   pixq_EnvItem _BagsterWinWidth;
   pixq_EnvItem _BagsterWinHeight;

   // wb_[̃tHg
   pixq_EnvItem _BagsterHeaderFont;

   // wb_[̃tHgF
   pixq_EnvItem _BagsterHeaderFgColor;

   // wb_[̔wiFiJ1j
   pixq_EnvItem _BagsterHeaderBg0Color;

   // wb_[̔wiFiJ2j
   pixq_EnvItem _BagsterHeaderBg1Color;

   // ********************
   // *** Bagster  ***
   // ********************

   // show at selected time?
   pixq_EnvItem _BagsterShowEveryDay;

   // time to show the morning words
   pixq_EnvItem _BagsterAmShowHour;
   pixq_EnvItem _BagsterAmShowMinuite;
   pixq_EnvItem _BagsterAmShowSecond;

   // time to show the evening words
   pixq_EnvItem _BagsterPmShowHour;
   pixq_EnvItem _BagsterPmShowMinuite;
   pixq_EnvItem _BagsterPmShowSecond;

   // ******************
   // *** Bagster  ***
   // ******************

   // bible version, one of BibleVersion
   pixq_EnvItem _BagsterBibleVersion;

   // ********************
   // *** Bagster \ ***
   // ********************
   
   // tHgi{j
   pixq_EnvItem _BagsterJapaneseFont;

   // tHgipj
   pixq_EnvItem _BagsterEnglishFont;

   // background color
   pixq_EnvItem _BagsterBgColor;

   // line heightsԁA100%`
   pixq_EnvItem _BagsterLineHeight;

   // *********************************
   // *** Hikari initial conditions ***
   // *********************************

   // *** last selection ***
   // [U[ɑIȂ

   // last content, one of HikariBibleContent
   pixq_EnvItem _HikariLastContent;

   // last selected book from old testament, 1-39
   pixq_EnvItem _HikariLastOldBook;

   // last selected book from new testament, 40-66
   pixq_EnvItem _HikariLastNewBook;

   // last selected devotion type, one of HikariDevotionContent
   pixq_EnvItem _HikariLastDevotion;

   // last selected chapter for each book of the bible

   pixq_EnvItem _HikariLastBookChapter01;
   pixq_EnvItem _HikariLastBookChapter02;
   pixq_EnvItem _HikariLastBookChapter03;
   pixq_EnvItem _HikariLastBookChapter04;
   pixq_EnvItem _HikariLastBookChapter05;
   pixq_EnvItem _HikariLastBookChapter06;
   pixq_EnvItem _HikariLastBookChapter07;
   pixq_EnvItem _HikariLastBookChapter08;
   pixq_EnvItem _HikariLastBookChapter09;
   pixq_EnvItem _HikariLastBookChapter10;
   pixq_EnvItem _HikariLastBookChapter11;
   pixq_EnvItem _HikariLastBookChapter12;
   pixq_EnvItem _HikariLastBookChapter13;
   pixq_EnvItem _HikariLastBookChapter14;
   pixq_EnvItem _HikariLastBookChapter15;
   pixq_EnvItem _HikariLastBookChapter16;
   pixq_EnvItem _HikariLastBookChapter17;
   pixq_EnvItem _HikariLastBookChapter18;
   pixq_EnvItem _HikariLastBookChapter19;
   pixq_EnvItem _HikariLastBookChapter20;
   pixq_EnvItem _HikariLastBookChapter21;
   pixq_EnvItem _HikariLastBookChapter22;
   pixq_EnvItem _HikariLastBookChapter23;
   pixq_EnvItem _HikariLastBookChapter24;
   pixq_EnvItem _HikariLastBookChapter25;
   pixq_EnvItem _HikariLastBookChapter26;
   pixq_EnvItem _HikariLastBookChapter27;
   pixq_EnvItem _HikariLastBookChapter28;
   pixq_EnvItem _HikariLastBookChapter29;
   pixq_EnvItem _HikariLastBookChapter30;
   pixq_EnvItem _HikariLastBookChapter31;
   pixq_EnvItem _HikariLastBookChapter32;
   pixq_EnvItem _HikariLastBookChapter33;
   pixq_EnvItem _HikariLastBookChapter34;
   pixq_EnvItem _HikariLastBookChapter35;
   pixq_EnvItem _HikariLastBookChapter36;
   pixq_EnvItem _HikariLastBookChapter37;
   pixq_EnvItem _HikariLastBookChapter38;
   pixq_EnvItem _HikariLastBookChapter39;
   pixq_EnvItem _HikariLastBookChapter40;
   pixq_EnvItem _HikariLastBookChapter41;
   pixq_EnvItem _HikariLastBookChapter42;
   pixq_EnvItem _HikariLastBookChapter43;
   pixq_EnvItem _HikariLastBookChapter44;
   pixq_EnvItem _HikariLastBookChapter45;
   pixq_EnvItem _HikariLastBookChapter46;
   pixq_EnvItem _HikariLastBookChapter47;
   pixq_EnvItem _HikariLastBookChapter48;
   pixq_EnvItem _HikariLastBookChapter49;
   pixq_EnvItem _HikariLastBookChapter50;
   pixq_EnvItem _HikariLastBookChapter51;
   pixq_EnvItem _HikariLastBookChapter52;
   pixq_EnvItem _HikariLastBookChapter53;
   pixq_EnvItem _HikariLastBookChapter54;
   pixq_EnvItem _HikariLastBookChapter55;
   pixq_EnvItem _HikariLastBookChapter56;
   pixq_EnvItem _HikariLastBookChapter57;
   pixq_EnvItem _HikariLastBookChapter58;
   pixq_EnvItem _HikariLastBookChapter59;
   pixq_EnvItem _HikariLastBookChapter60;
   pixq_EnvItem _HikariLastBookChapter61;
   pixq_EnvItem _HikariLastBookChapter62;
   pixq_EnvItem _HikariLastBookChapter63;
   pixq_EnvItem _HikariLastBookChapter64;
   pixq_EnvItem _HikariLastBookChapter65;
   pixq_EnvItem _HikariLastBookChapter66;

   // ****************
   // *** \ ***
   // ****************

   // wb_[̃tHg
   pixq_EnvItem _HikariHeaderFont;

   // wb_[̃tHgF
   pixq_EnvItem _HikariHeaderFgColor;

   // wb_[̔wiFiJ1j
   pixq_EnvItem _HikariHeaderBg0Color;

   // wb_[̔wiFiJ2j
   pixq_EnvItem _HikariHeaderBg1Color;

   // *****************
   // *** Hikari  ***
   // *****************

   // bible version, one of BibleVersion
   pixq_EnvItem _HikariBibleVersion;

   // bible version, second, one of BibleVersion
   pixq_EnvItem _HikariBibleSecondVersion;

   // language, one of PixTopoMainLanguange;
   pixq_EnvItem _HikariBibleSystemLanguage;
   
   // use this bible version for search?

   pixq_EnvItem _HikariBibleSearchShinkaiyaku2;
   pixq_EnvItem _HikariBibleSearchKougoyaku;
   pixq_EnvItem _HikariBibleSearchKingJames;
   pixq_EnvItem _HikariBibleSearchIntlStandard;
   pixq_EnvItem _HikariBibleSearchBungo;
   pixq_EnvItem _HikariBibleSearchRaguet;

   // last search word, just to memorize
   pixq_EnvItem _HikariBibleSearchLastWord;

   // last search mode, one of BibleSearchWordsCombination
   pixq_EnvItem _HikariBibleSearchLastMode;

   // max number of searched words
   pixq_EnvItem _HikariBibleSearchMaxWords;

   // *******************
   // *** Hikari \ ***
   // *******************
   
   // tHgi{j
   pixq_EnvItem _HikariViewHikariJpFont;

   // tHgipj
   pixq_EnvItem _HikariViewHikariEnFont;

   // 1\, or 2i\
   pixq_EnvItem _HikariVieBibleNum;

   // \Őߔԍ̕\,ShowChapterVerseNumber̂ǂꂩ 
   pixq_EnvItem _HikariViewShowVerseNum;

   // draw table boundary
   pixq_EnvItem _HikariViewShowTableLines;

   // ߔԍƗʃJɂH
   pixq_EnvItem _HikariViewVersesSeparateColumn;

   // tHgʁi{j
   pixq_EnvItem _HikariViewSearchJpFont;
   
   // tHgʁipj
   pixq_EnvItem _HikariViewSearchEnFont;

   // *******************
   // *** Hikari ҏW ***
   // *******************

   // Copy - include book name
   pixq_EnvItem _HikariCopyIncludeBook;

   // Copy - include version Name
   pixq_EnvItem _HikariCopyIncludeVersion;

   // Copy - chapter verse number? One of ShowChapterVerseNumber 
   pixq_EnvItem _HikariCopyIncludeVerse;

   // Copy - separate verses(change line for each verse) 
   pixq_EnvItem _HikariCopyChangeLine;

   // ***************************
   // *** Hikari̒Bagster ***
   // ****************************

   // show at selected time?
   pixq_EnvItem _HikariBagsterShowEveryDay;

   // time to show the morning words
   pixq_EnvItem _HikariBagsterAmShowHour;
   pixq_EnvItem _HikariBagsterAmShowMinuite;
   pixq_EnvItem _HikariBagsterAmShowSecond;

   // time to show the evening words
   pixq_EnvItem _HikariBagsterPmShowHour;
   pixq_EnvItem _HikariBagsterPmShowMinuite;
   pixq_EnvItem _HikariBagsterPmShowSecond;

   // bible version to show daily light inside Hikari
   pixq_EnvItem _HikariBagsterBibleVer;

   // second bible version to show daily light inside Hikari
   pixq_EnvItem _HikariBagster2ndBibleVer;

   // ************
   // *** ʓ ***
   // ************

   // ʓǃv, one of BibleYearReadPlan
   pixq_EnvItem _HikariPlanSelected;

   // eʓǃv̍ŏIiy[Wj,day start from zero
   
   pixq_EnvItem _HikariPlanBeginingToEndDay;
   pixq_EnvItem _HikariPlanChronologicalDay;
   pixq_EnvItem _HikariPlanOldChronologicalDay;
   pixq_EnvItem _HikariPlanNewChronologicalDay;
   pixq_EnvItem _HikariPlanHistoricalDay;
   pixq_EnvItem _HikariPlanOldAndNewOneDayDay; 
   pixq_EnvItem _HikariPlanMichaelColeyDay; 
   pixq_EnvItem _HikariPlanThematicDay;
   pixq_EnvItem _HikariPlanBookOrderDay;
   pixq_EnvItem _HikariPlanClassicDay;
   pixq_EnvItem _HikariPlanHikariOldNewDay;
   pixq_EnvItem _HikariPlanHikariNewOldNewDay;

   // Day all read color - fill 
   pixq_EnvItem _HikariPlanReadColor;

   // Day all partially read color - fill
   pixq_EnvItem _HikariPlanPartReadColor;

   // Day all not read color - fill
   pixq_EnvItem _HikariPlanNotReadColor;

   // Chart background color - fill
   pixq_EnvItem _HikariPlanBackgroundColor;

   // Day all read color - text
   pixq_EnvItem _HikariPlanReadTextColor;

   // Day all partially read color - text
   pixq_EnvItem _HikariPlanPartReadTextColor;

   // Day all not read color - text
   pixq_EnvItem _HikariPlanNotReadTextColor;

   // ******************
   // *** DFT Filter ***
   // ******************

   // filter DFT visualize sigma range
   // when the results of DFT is visualized, extent of average +/- sigma * range is
   // scaled to 0 - 255
   pixq_EnvItem _DftFilterDftSigmaRange;

   // filter - low/high filter, boundary
   pixq_EnvItem _DftFilterHighLowPassBoundary;

   // filter - band-pass filter, lower boundary
   pixq_EnvItem _DftFilterBandPassLowBoundary;

   // filter - band-pass filter,  higher boundary
   pixq_EnvItem _DftFilterBandPassHighBoundary;

   // filter - filter type, one of DigitalImageFilterShape
   pixq_EnvItem _DftFilterDigitalFilterShape;

   // filter - channel to analyze for 1D or 2D visualization of DFT results
   // one of PixImageColorChannel
   pixq_EnvItem _DftFilterDftVisualizeColor;

public: 

   // make a list of all env items
   void GetEnvItems( vector<pixq_EnvItem*> *pItemsList );

   void InitAllEnv( void  );
   void InitEnv( QString strOrg, QString strApp );
   void ResetEnv( QString strOrg, QString strApp );

   // Common

   void InitCommon( void );
   void InitImage( void );
   void InitPlayback( void );
   void InitSystem( void );
      
   // Bagster

   void InitBagsterWindow( void );
   void InitBagsterTimer( void );
   void InitBagsterView( void );
   
   // Hikari

   void InitHikariInitial( void );
   void InitHikariBible( void );
   void InitHikariView( void );
   void InitHikariEdit( void );
   void InitHikariBagster( void );
   void InitHikariBiblePlan( void );

   // Scope

   void InitScope( void );

   // Sampler

   void InitDftFilter( void );

   // 

   void GetRegEnv( QString strOrg, QString strApp );
   void SetRegEnv( QString strOrg, QString strApp );   
   
   // copy constructor
	pixq_Properties &operator=( pixq_Properties &that);

   // bagster
   QString BagsterGetBibleVersionName( void );
   
   // hikari

   QString HikariGetBibleVersionName( void );
   QString HikariGet2ndBibleVersionName( void );

   QString HikariGetBagsterVersionName( void );
   QString HikariGet2ndBagsterVersionName( void );
   
   static QString GetBibleVersionName( int iVersion );

   // japanese or english bible version?
   bool BagsterBibleVersionJapanese( void );
   static bool BibleVersionJapanese( int iVersion );

   // japanese or english bible version?
   bool bHikariBagsterBibleVersionJapanese( void );

   QString GetHikariBibleXmlFile( int iSide );

   QString GetHikariFirstBibleXmlFile( void );

   QString GetHikariSecondBibleXmlFile( void );

   static bool VersionBibleXmlExist( int iVersion );
   static bool VersionDailyXmlExist( int iVersion );

   bool VersionUsedForSearch( int iVersion );
   void SetVersionUsedForSearch( int iVersion, bool bSearch );
   vector<int> HikariBibleVersions( void );
   vector<int> HikariBibleJpVersions( void );
   vector<int> HikariBibleEnVersions( void );
   
   static void BibleReadPlanList( QList<int> &iNumbers );
};

} // namespace  