#pragma once

namespace _pix_plot_qt_framework {

#include <pixqtlib_global.h>

class PIXQTLIB_EXPORT pixq_Version
{
public:
   pixq_Version(void);
   ~pixq_Version(void);

public:
   // copy constructor
	pixq_Version &operator=( const pixq_Version &that );

   // check whter this version is newer than that
	bool operator>=( const pixq_Version &that ) const;
	bool operator>( const pixq_Version &that ) const;

private:
   QString _strCompany;
   QString _strProductName;
   QString _strApplication;
   QString _strDescription;

   unsigned short _usMajorVersion;
   unsigned short _usMinorVersion;

   // notes:
   // release numbergȂꍇ0ɂĂ
   // ̏ꍇ͉ʂɕ\Ȃ
   //
   unsigned short _usReleaseNumber;

   QDate _ReleaseDate;

   QString _strContact;
   QString _strWebSite;

   // must be one of pixq_Properties::PixTopoSystemPlatform
   short _sPlatform;

public:
   void Clear( void );

   void SetCompany( QString strCompany ) { _strCompany = strCompany; }
   void SetProductName( QString strProductName ) { _strProductName = strProductName; }
   void SetApplication( QString strApplication ) { _strApplication = strApplication; }
   void SetDescription( QString strDescription ) { _strDescription = strDescription; }

   void SetMajorVersion( unsigned short usMajorVersion ) { _usMajorVersion = usMajorVersion; }
   void SetMinorVersion( unsigned short usMinorVersion ) { _usMinorVersion = usMinorVersion; }
   void SetReleaseNumber( unsigned short usReleaseNumber ) { _usReleaseNumber = usReleaseNumber; }
   
   void SetReleaseDate( QDate Date ) { _ReleaseDate = Date; }

   void SetContact( QString strContact ) { _strContact = strContact; }
   void SetWebSite( QString strWebSite ) { _strWebSite = strWebSite; }
   
   void SetPlatform( short sPlatform ) { _sPlatform = sPlatform; }

   //

   QString GetVersionString( void ) const;

   QString GetCompany( void ) { return _strCompany; } 
   QString GetProductName( void ) { return _strProductName; }
   QString GetApplication( void ) { return _strApplication; }
   QString GetDescription( void ) { return _strDescription; }

   unsigned short GetMajorVersion( void ) { return _usMajorVersion; }
   unsigned short GetMinorVersion( void ) { return _usMinorVersion; }
   unsigned short GetReleaseNumber( void ) { return _usReleaseNumber; }
   
   QDate GetReleaseDate( void ) { return _ReleaseDate; }

   QString GetContact( void ) { return _strContact; }
   QString GetWebSite( void ) { return _strWebSite; }

   short GetPlatform( void ) { return _sPlatform; }

   bool WriteXml( QString strFile );
   bool ReadXml( QString strFile );
};

} // namespace 

