#include <pixqt_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include "pixq_about_dialog.h"

pixq_about_dialog::pixq_about_dialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::pixq_about_dialog)
{
   ui->setupUi(this);    
}

pixq_about_dialog::~pixq_about_dialog()
{
    delete ui;
}

void pixq_about_dialog::on_ok_button_clicked()
{
   close( );
}

void pixq_about_dialog::Init( pixq_Version *pVer )
{
   QString strHeader, strValue, strDate, strProgram, strVersion, strProduct;
   QString strPlatform;
   QDate date;
   short usRelease;
   unsigned short sPlatform;

   //
   // notes:
   // release number=0̏ꍇ͉ʂɕ\Ȃ
   //

   usRelease = pVer->GetReleaseNumber( );
   if( 0 >= usRelease ) {
      strVersion.sprintf( "%d.%d", pVer->GetMajorVersion( ),
         pVer->GetMinorVersion( ) );
   } else {
      strVersion.sprintf( "%d.%d.%d", pVer->GetMajorVersion( ),
         pVer->GetMinorVersion( ),
         usRelease );
   }

   sPlatform = pVer->GetPlatform( );
   switch( sPlatform ) {
   case pixq_Properties::PlatformWin32:
      strPlatform = "(x86)";
      break;
   case pixq_Properties::PlatformWin64:
      strPlatform = "(x64)";
      break;
   case pixq_Properties::PlatformUnknown:
   default:
      strPlatform.clear( );
      break;
   }

   strValue = pVer->GetApplication( );
   if( !strPlatform.isEmpty( ) ) {
      strValue = strValue + strPlatform;
   }
   strValue = strValue + tr(" ") + strVersion;
   ui->application_label->setText( strValue );

   //

   date = pVer->GetReleaseDate( );
   strDate.sprintf( "%d.%d.%d", date.year( ), date.month( ), date.day( ) );
   ui->release_date_label->setText( strDate );

   strValue = pVer->GetDescription( );
   ui->description_label->setText( strValue );

   strValue = pVer->GetCompany( );
   ui->company_label->setText( strValue );

   strValue = pVer->GetContact( );
   ui->contact_label->setText( strValue );
   
   strValue = pVer->GetWebSite( );
   ui->website_label->setText( strValue );

   // 
   
   strProduct = pVer->GetProductName( );
   strHeader = strProduct + tr(" - ") + strVersion;
   setWindowTitle( strHeader );

   return;
}

void pixq_about_dialog::paintEvent(QPaintEvent *event)
{
   Q_UNUSED(event);

   return;
}

void pixq_about_dialog::showEvent(QShowEvent *event)
{
   QString strValue;
   QPixmap in_pix, scaled_pix;
   QSize view_size, in_size, scaled_size;
   int iWidth;

   QGraphicsScene *scn = new QGraphicsScene( ui->logo_view );

   Q_UNUSED(event);

   // set image

   view_size = ui->logo_view->viewport()->size( );
   
   scn->setSceneRect( ui->logo_view->rect() );
   ui->logo_view->setScene( scn );

   in_pix = QPixmap( ":/images/BibleCross.bmp" );

   iWidth = ui->logo_view->frameWidth( );
   iWidth = ui->logo_view->lineWidth( );

   in_size = in_pix.size( );
   scaled_pix = in_pix.scaled( view_size );
   scaled_size = scaled_pix.size( );

   scn->addPixmap( scaled_pix );

   return;
}
