#include <pixqt_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include "pixq_word.h"
#include "pixq_dictionary.h"

pixq_Dictionary::pixq_Dictionary(void)
{
   Clear( );
}

pixq_Dictionary::~pixq_Dictionary(void)
{
   Clear( );
}

void pixq_Dictionary::Clear( void )
{
   _strName.clear( );
   _Words.clear( );

   return;
}

pixq_Dictionary &pixq_Dictionary::operator=( const pixq_Dictionary &that )
{   
   int nWords, i;
   pixq_Word wrd;

   if( this == &that ) {
      goto PIX_EXIT;
   }

   // 

   Clear( );

   _strName = that._strName;

   nWords = (int)that._Words.size( );
   for( i = 0 ; i < nWords ; i++ ) {
      wrd = that._Words.at( i );
      _Words.push_back( wrd );
   }

PIX_EXIT:
   return *this;
}

void pixq_Dictionary::Store( short sCategory,
                            QString strJp, 
                            QString strEn )
{
   pixq_Word wrd;
   
   wrd.Set( sCategory, strJp, strEn );

   _Words.push_back( wrd );

   return;
}

//
// create bible name dictionary
//
void pixq_Dictionary::CreateBibleName( void )
{
   short sCategory = pixq_Word::WordCategoryBibleName;

   Store( sCategory, "}^C", "Matthew" );
   Store( sCategory, "}R", "Mark" );
   Store( sCategory, "J", "Luke" );
   Store( sCategory, "nl", "John" );

   Store( sCategory, "[}l", "Romans" );
   Store( sCategory, "Rgl", "Corinthians" );
   Store( sCategory, "Kel", "Galatians" );
   Store( sCategory, "Gy\l", "Ephesians" );
   Store( sCategory, "ssl", "Philippians" );
   Store( sCategory, "RTCl", "Colossians" );
   Store( sCategory, "eTjPl", "Thessalonians" );

   Store( sCategory, "ee", "Timothy" );
   Store( sCategory, "egX", "Titus" );
   Store( sCategory, "s", "Philemon" );
   Store( sCategory, "wul", "Hebrews" );
   Store( sCategory, "Ru", "James" );
   Store( sCategory, "ye", "Peter" );
   Store( sCategory, "_", "Jude" );  

   return;
}

void pixq_Dictionary::CreateBiblePlace( void )
{
   short sCategory = pixq_Word::WordCategoryBiblePlace;

   Store( sCategory, "Ke", "Galatia" );  
   Store( sCategory, "ss", "Philippi" );  
   Store( sCategory, "Rg", "Corinth" );  

   return;
}

//
// create bible book name dictionary
//
void pixq_Dictionary::CreateBibleBook( void )
{
   short sCategory = pixq_Word::WordCategoryBibleBook;
   
   Store( sCategory, "nL", "Genesis" );     
   Store( sCategory, "oGWvgL", "Exodus" );
   Store( sCategory, "rL", "Leviticus" );
   Store( sCategory, "L", "Numbers" );
   Store( sCategory, "\L", "Deuteronomy" ); 

   Store( sCategory, "VAL", "Joshua" );
   Store( sCategory, "mtL", "Judges" );
   Store( sCategory, "cL", "Ruth" );
   Store( sCategory, "TGL", "Samuel" );
   Store( sCategory, "񉤋L", "Kings" );
   Store( sCategory, "㎏", "Chronicles" );
   Store( sCategory, "GYL", "Ezra" );
   Store( sCategory, "lw~L", "Nehemiah" );
   Store( sCategory, "GXeL", "Esther" );  

   Store( sCategory, "uL", "Job" );
   Store( sCategory, "", "Psalms" );
   Store( sCategory, "⼌", "Proverbs" );
   Store( sCategory, "`҂̏", "Ecclesiastes" );
   Store( sCategory, "", "Song of songs" );  

   Store( sCategory, "CU", "Isaiah" );
   Store( sCategory, "G~", "Jeremiah" );
   Store( sCategory, "", "Lamentations  " );
   Store( sCategory, "G[LG", "Ezekiel" );
   Store( sCategory, "_jG", "Daniel" );

   Store( sCategory, "zZA", "Hosea" );
   Store( sCategory, "G", "Joel" );
   Store( sCategory, "AX", "Amos" );
   Store( sCategory, "Iof", "Obadiah" );
   Store( sCategory, "i", "Jonah" );
   Store( sCategory, "~J", "Micah" );
   Store( sCategory, "iz", "Nahum" );
   Store( sCategory, "noNN", "Habakkuk" );
   Store( sCategory, "[pj", "Zephaniah" );
   Store( sCategory, "nKC", "Haggai" );
   Store( sCategory, "[J", "Zechariah" );
   Store( sCategory, "}L", "Malachi" );  

   Store( sCategory, "}^C̕", "Gospel According to Matthew" );
   Store( sCategory, "}R̕", "Gospel According to Mark" );
   Store( sCategory, "J̕", "Gospel According to Luke" );
   Store( sCategory, "nl̕", "Gospel According to John" );

   Store( sCategory, "gk̓", "Acts of the Apostles" ); 
   Store( sCategory, "gk̓", "Acts" ); 

   Store( sCategory, "[}lւ̎莆", "Epistle to the Romans" );
   Store( sCategory, "Rglւ̎莆 ", "First Epistle to the Corinthians" );
   Store( sCategory, "Rglւ̎莆 ", "Second Epistle to the Corinthians" );
   Store( sCategory, "Kelւ̎莆", "Epistle to the Galatians" );
   Store( sCategory, "Gy\lւ̎莆", "Epistle to the Ephesians" );
   Store( sCategory, "sslւ̎莆", "Epistle to the Philippians" );
   Store( sCategory, "RTClւ̎莆", "Epistle to the Colossians" );
   Store( sCategory, "eTjPlւ̎莆 ", "First Epistle to the Thessalonians" );
   Store( sCategory, "eTjPlւ̎莆 ", "Second Epistle to the Thessalonians" );
   Store( sCategory, "eeւ̎莆 ", "First Epistle to Timothy" );
   Store( sCategory, "eeւ̎莆 ", "Second Epistle to Timothy" );
   Store( sCategory, "egXւ̎莆", "Epistle to Titus" );
   Store( sCategory, "sւ̎莆", "Epistle to Philemon" );
   Store( sCategory, "wulւ̎莆", "Epistle to the Hebrews" );

   Store( sCategory, "Ru̎莆", "Epistle of James" );
   Store( sCategory, "ye̎莆 ", "First Epistle of Peter" );
   Store( sCategory, "ye̎莆 ", "Second Epistle of Peter" );
   Store( sCategory, "nl̎莆 ", "First Epistle of John" );
   Store( sCategory, "nl̎莆 ", "Second Epistle of John" );
   Store( sCategory, "nl̎莆 O", "Third Epistle of John" );
   Store( sCategory, "_̎莆", "Epistle of Jude" );  

   Store( sCategory, "nlَ̖^", "Revelation" );
   Store( sCategory, "nlَ̖^", "Book of Revelation" );

   return;
}


void pixq_Dictionary::CreateBibleProper( void )
{
   short sCategory = pixq_Word::WordCategoryBibleProper;


   return;
}

void pixq_Dictionary::CreateBibleOthers( void )
{
   short sCategory = pixq_Word::WordCategoryBibleOthers;

   Store( sCategory, "", "Gospel" );
   Store( sCategory, "莆", "Epistle" );
   Store( sCategory, "[", "revelation" );
   Store( sCategory, "[", "inspiration" );
   Store( sCategory, "[", "reveal" );
   Store( sCategory, "", "repentance" );
   Store( sCategory, "ٖMl", "heathen" );
   Store( sCategory, "ًk", "heathen" );
   Store( sCategory, "k_lɂƂẮlLXgkAٖMl", "gentile" );
   Store( sCategory, "k_lɂƂẮlLXgkAٖMl", "gentile" );

   return;
}

void pixq_Dictionary::CreateGeneralName( void )
{
   short sCategory = pixq_Word::WordCategoryGeneralName;


   return;
}

void pixq_Dictionary::CreateGeneralPlace( void )
{
   short sCategory = pixq_Word::WordCategoryGeneralPlace;


   return;
}

void pixq_Dictionary::CreateGeneralProper( void )
{
   short sCategory = pixq_Word::WordCategoryGeneralProper;


   return;
}

void pixq_Dictionary::CreateGeneralOthers( void )
{
   short sCategory = pixq_Word::WordCategoryGeneralOthers;


   return;
}

void pixq_Dictionary::CreateOthers( void )
{
   short sCategory = pixq_Word::WordCategoryOthers;


   return;
}

void pixq_Dictionary::CreateBible( void )
{
   Clear( );

   CreateBibleName( );
   CreateBiblePlace( );
   CreateBibleBook( );
   CreateBibleProper( );
   CreateBibleOthers( );

   CreateGeneralName( );
   CreateGeneralPlace( );
   CreateGeneralProper( );
   CreateGeneralOthers( );

   CreateOthers( );

   return;
}
