#pragma once

#include <QtCore>
#include <QtGui>
#include <QApplication>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

QT_BEGIN_NAMESPACE
class QPushButton;
class QTabWidget;
QT_END_NAMESPACE

class props_page_bagster_timer;
class props_page_bagster_view;

class props_page_hikari_view;
class props_page_hikari_edit;
class props_page_hikari_bible;
class props_page_hikari_bagster;

class props_page_image;
class props_page_playback;
class props_page_system;

class pixq_options : public QDialog
{
    Q_OBJECT

public:
    pixq_options( QWidget *parent = 0);
   ~pixq_options(void);

private:
    QTabWidget *_tabWidget;

    QPushButton *buttonDefault;
    QPushButton *buttonOk;
    QPushButton *buttonCancel;
    
public:
   void Init( const QString strOrganisation, const QString strApplication, 
      pixq_Properties *pEnv, int iMode, short sPage );

   pixq_Properties *GetEnv( void ) { return _pTmpEnv; }
   void Store( pixq_Properties *pEnv ) { _pTmpEnv = pEnv; }
   
   bool SelectPage( short sPage );

private:
   int _iPropMode;
   QString _strOrganisation;
   QString _strApplication;

   pixq_Properties *_pTmpEnv;

    props_page_bagster_timer *_opt_bagster_timer;
    props_page_bagster_view *_opt_bagster_view;

    props_page_hikari_bible *_opt_hikari_bible;
    props_page_hikari_view *_opt_hikari_view;
    props_page_hikari_edit *_opt_hikari_edit;
    props_page_hikari_bagster *_opt_hikari_bagster;

    props_page_image *_opt_common_image;
    props_page_playback *_opt_common_playback;
    props_page_system *_opt_common_system;

protected:
   void closeEvent(QCloseEvent *event);
   void showEvent(QShowEvent *event);
   
private slots:
   void ButtonDefaultPressed( void );
   void ButtonOkPressed( void );
   void ButtonCancelPressed( void );
   
};