#pragma once

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

class pixq_options_page
{
public:
   pixq_options_page(void);
   virtual ~pixq_options_page(void);

public:
   virtual void SetData( void ) = 0;
   virtual bool Check( void ) = 0;

   void Store( pixq_Properties *pEnv );
   pixq_Properties *GetEnv( void ) { return _pTmpEnv; }

private:
   pixq_Properties *_pTmpEnv;
   

public:
   void SetBool( pixq_EnvItem *pItem, QCheckBox *pEdit );
   void GetBool( pixq_EnvItem *pItem, QCheckBox *pEdit );

   void SetString( pixq_EnvItem *pItem, QLineEdit *pEdit );
   void GetString( pixq_EnvItem *pItem, QLineEdit *pEdit );

   void SetInteger( int iValue, int iMin, int nMax, QLineEdit *pEdit );
   void SetInteger( int iValue, QLineEdit *pEdit );
   void SetInteger( pixq_EnvItem *pItem, QLineEdit *pEdit );
   bool GetSpinInteger( pixq_EnvItem *pItem, QSpinBox *pSpin );
   void SetSpinInteger( pixq_EnvItem *pItem, QSpinBox *pSpin );

   bool GetInteger( int *iValue, QLineEdit *pEdit );
   bool GetInteger( pixq_EnvItem *pItem, QLineEdit *pEdit );

   void Set2Double( double dValue, QLineEdit *pEdit );
   void Set2Double( pixq_EnvItem *pItem, QLineEdit *pEdit );

   void SetDouble( double dValue, QLineEdit *pEdit, const char *szFormat );
   void SetDouble( pixq_EnvItem *pItem, QLineEdit *pEdit, const char *szFormat );

   bool GetDouble( double *dValue, QLineEdit *pEdit );
   bool GetDouble( pixq_EnvItem *pItem, QLineEdit *pEdit );

   void ClearItem( QLineEdit *pEdit );

   short GetPageID( void ) { return _sPageId; }

protected:
   // one of value_property_page
   short _sPageId;
};