#include <pixqt_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include "pixq_word.h"

pixq_Word::pixq_Word(void)
{
   Clear( );
}

pixq_Word::~pixq_Word(void)
{
   Clear( );
}

void pixq_Word::Clear( void )
{
   _sWordCategory = WordCategoryUnknown;

   _strEnglish.clear( );
   _strJapanese.clear( );
   _strExamples.clear( );

   return;
}

pixq_Word &pixq_Word::operator=( const pixq_Word &that )
{   
   int nWords, i;
   QString strWord;

   if( this == &that ) {
      goto PIX_EXIT;
   }

   // 

   Clear( );

   _sWordCategory = that._sWordCategory;

   nWords = (int)that._strEnglish.size( );
   for( i = 0 ; i < nWords ; i++ ) {
      strWord = that._strEnglish.at( i );
      _strEnglish.push_back( strWord );
   }

   nWords = (int)that._strJapanese.size( );
   for( i = 0 ; i < nWords ; i++ ) {
      strWord = that._strJapanese.at( i );
      _strJapanese.push_back( strWord );
   }
       
   nWords = (int)that._strExamples.size( );
   for( i = 0 ; i < nWords ; i++ ) {
      strWord = that._strExamples.at( i );
      _strExamples.push_back( strWord );
   }

PIX_EXIT:
   return *this;
}


void pixq_Word::Set( short sCategory, 
                    QString strJp, 
                    QString strEn )
{
   Clear( );
  
   _sWordCategory = sCategory;
   _strEnglish.push_back( strEn );
   _strJapanese.push_back( strJp );

   return;
}

void pixq_Word::AddJp( QString strWord )
{
   _strJapanese.push_back( strWord );
}

void pixq_Word::AddEn( QString strWord )
{
   _strEnglish.push_back( strWord );
}

void pixq_Word::AddEx( QString strWord )
{
   _strExamples.push_back( strWord );
}


QString pixq_Word::GetWordCategory( short sCategory )
{
   QString strCategory;

   switch( sCategory ) {
   case pixq_Word::WordCategoryUnknown:
      strCategory = "Ȃ";
      break;
   
   case pixq_Word::WordCategoryBibleName:
      strCategory = "l-";
      break;

   case pixq_Word::WordCategoryBiblePlace:
      strCategory = "n/";
      break;

   case pixq_Word::WordCategoryBibleBook:
      strCategory = "-";
      break;

   case pixq_Word::WordCategoryBibleProper:
      strCategory = "ŗL-";
      break;
   case pixq_Word::WordCategoryBibleOthers:
      strCategory = "̑-";
      break;
   //
   case pixq_Word::WordCategoryGeneralName:
      strCategory = "l";
      break;
   case pixq_Word::WordCategoryGeneralPlace:
      strCategory = "n";
      break;
   case pixq_Word::WordCategoryGeneralProper:
      strCategory = "ŗL";
      break;
   
   case pixq_Word::WordCategoryGeneralOthers:
      strCategory = "";
      break;
   
   case pixq_Word::WordCategoryOthers:
      strCategory = "̑";
      break;
      
   default:
      strCategory = "Ȃ";
      break;
   }

   return strCategory;
}

QString pixq_Word::GetWordCategory( void )
{
   QString strCategory = GetWordCategory( _sWordCategory );
   
   return strCategory;
}