#pragma once

namespace _pix_plot_qt_framework {

class PIXQTLIB_EXPORT pixq_Word
{
public:
   //
   // word category
   // do not alter these numbers!
   // change GetWordCategory( ) when something is added to this
   //
   enum {
      WordCategoryUnknown = 0,
      //
      WordCategoryBibleName = 11,  
      WordCategoryBiblePlace = 12,
      WordCategoryBibleBook = 13,
      WordCategoryBibleProper = 14, 
      WordCategoryBibleOthers = 15,
      //
      WordCategoryGeneralName = 21,
      WordCategoryGeneralPlace = 22,
      WordCategoryGeneralProper = 23,
      WordCategoryGeneralOthers = 24,
      //
      WordCategoryOthers = 41,
   } CategoryOfWord;

public:
   pixq_Word(void);
   ~pixq_Word(void);

   // copy constructor
	pixq_Word &operator=( const pixq_Word &that );

public:
   void Clear( void );

   static QString GetWordCategory( short sCategory );
   QString GetWordCategory( void );

private:
   QStringList _strEnglish;
   QStringList _strJapanese;
   QStringList _strExamples;

   // must be one of CategoryOfWord
   short _sWordCategory;

public:
   void Set( short sCategory, QString strJp, QString strEn );
   void AddJp( QString strWord );
   void AddEn( QString strWord );
   void AddEx( QString strWord );

};

} // namespace 