#include <pixqt_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

QString GetBagsterOccasionsXmlFile_PC( void ) 
{
   QString strPath;

   strPath = QFileInfo( QCoreApplication::applicationDirPath( ) ).filePath( );
   
   strPath.append( "/occasions.xml\0" );
  
   return strPath;
}

QString GetDailyWordsFile_PC( int iVersion )
{   
   return GetDailyWordsXmlFile_PC( iVersion );
}

QString GetDailyWordsXmlFile_PC( int iVersion )
{
   QString strPath = QFileInfo( QCoreApplication::applicationDirPath( ) ).filePath( );

   switch( iVersion ) {     
   case pixq_Properties::BibleShinkaiyaku2:  
      strPath.append( "/daily_shin.xml\0" );
      break;

   case pixq_Properties::BibleKougoyaku:
      strPath.append( "/daily_kougo.xml\0" );
      break;
      
   case pixq_Properties::BibleKingJames:
      strPath.append( "/daily_kjv.xml\0" ); 
      break;
   
   default:
      strPath.clear( );
      break;
   }
   
   return strPath;
}

QString GetDailyWordsTxtFile_PC( int iVersion )
{
   QString strPath = QFileInfo( QCoreApplication::applicationDirPath( ) ).filePath( );

   switch( iVersion ) {     
   case pixq_Properties::BibleShinkaiyaku2: 
      strPath.append( "/daily_shin.txt\0" );
      break;

   case pixq_Properties::BibleKougoyaku:
      strPath.append( "/daily_kougo.txt\0" );
      break;
      
   case pixq_Properties::BibleKingJames:
      strPath.append( "/daily_kjv.txt\0" ); 
      break;
   
   default:
      strPath.append( "/daily_shin.txt\0" );
      break;
   }
   
   return strPath;
}

//
// get the name of the dailiy light xml file used in Bagster program
//
QString GetBagsterDailyWordsFile_PC( pixq_Properties *pEnv )
{
   QString strPath;

   int iVersion = pEnv->_BagsterBibleVersion.iGet( );

   switch( iVersion ) {     
   case pixq_Properties::BibleShinkaiyaku2: 
      //
      // VIłꍇAt@C݂邩`FbNI
      //
      if( pixq_Properties::VersionDailyXmlExist( iVersion ) ) {
         strPath = GetDailyWordsFile_PC( iVersion ); 
      } else {
         //
         // Vt@C݂Ȃɐ؂ւ
         //
         QString strError;
         QString strApplication = pEnv->_CommonApplicationName.strGet( );
         
         strError = "̃VXeɂ́AVŁwX̌xt@C݂܂B\n\n";
         strError = strError + "󐹏ɐ؂ւ܂B";
         QMessageBox::information( NULL, strApplication, strError );
         //
         iVersion = pixq_Properties::BibleKougoyaku;
         pEnv->_BagsterBibleVersion.Set( iVersion );
         strPath = GetDailyWordsFile_PC( iVersion );         
      }
      break;

   case pixq_Properties::BibleKougoyaku:
   case pixq_Properties::BibleKingJames:
      strPath = GetDailyWordsFile_PC( iVersion );
      break;
      
   default:
      iVersion = pixq_Properties::BibleKougoyaku;
      pEnv->_BagsterBibleVersion.Set( iVersion );
      strPath = GetDailyWordsFile_PC( iVersion ); 
      break; 
   }

   return strPath;
}

//
// get the name of the dailiy light xml file used in Bagster program
//
QString GetHikariBagsterDailyWordsFile_PC( pixq_Properties *pEnv,
                                          int iVer )  // [i] 0 or 1, bible version
{
   QString strPath;
   int iVersion;
   
   if( 0 == iVer ) {
      iVersion = pEnv->_HikariBagsterBibleVer.iGet( );
   } else {
      iVersion = pEnv->_HikariBagster2ndBibleVer.iGet( );
   }

   switch( iVersion ) {     
   case pixq_Properties::BibleShinkaiyaku2: 
      //
      // VIłꍇAt@C݂邩`FbNI
      //
      if( pixq_Properties::VersionDailyXmlExist( iVersion ) ) {
         strPath = GetDailyWordsFile_PC( iVersion );  
      } else {
         //
         // Vt@C݂Ȃɐ؂ւ
         //
         QString strError;
         QString strApplication = pEnv->_CommonApplicationName.strGet( );
         
         strError = "̃VXeɂ́AVŁwX̌xt@C݂܂B\n\n";
         strError = strError + "󐹏ɐ؂ւ܂B";
         QMessageBox::information( NULL, strApplication, strError );
         //
         iVersion = pixq_Properties::BibleKougoyaku;
         if( 0 == iVer ) {
            pEnv->_HikariBagsterBibleVer.Set( iVersion );
         } else {
            pEnv->_HikariBagster2ndBibleVer.Set( iVersion );
         }
         strPath = GetDailyWordsFile_PC( iVersion );         
      }
      break;

   case pixq_Properties::BibleKougoyaku:
   case pixq_Properties::BibleKingJames:
      strPath = GetDailyWordsFile_PC( iVersion );
      break;
      
   default:
      iVersion = pixq_Properties::BibleKougoyaku;
      if( 0 == iVer ) {
         pEnv->_HikariBagsterBibleVer.Set( iVersion );
      } else {
         pEnv->_HikariBagster2ndBibleVer.Set( iVersion );
      }
      strPath = GetDailyWordsFile_PC( iVersion );
      break;
   }

   return strPath;
}

//
// JeS[ʁAX̌A݂Ƃ΃t@C
// st@CƓpXɂAOcategory_all.txt
//
QString GetTabijiWordsFile_PC( void )
{
   QString strPath;

   strPath = QFileInfo( QCoreApplication::applicationDirPath( ) ).filePath( );
   strPath.append( "/category_all.txt\0" );

   return strPath;
}

QString GetOccasionsWordsFile_PC( void )
{
   QString strPath;

   strPath = QFileInfo( QCoreApplication::applicationDirPath( ) ).filePath( );
   strPath.append( "/category_kjv.txt\0" );

   return strPath;
}

QString GetOccasionsCsvFile_PC( void )
{
   QString strPath;

   strPath = QFileInfo( QCoreApplication::applicationDirPath( ) ).filePath( );
   strPath.append( "/occasions_review.csv\0" );

   return strPath;
}


QString GetCsvTabijiFile_PC( void ) 
{
   QString strPath;

   strPath = QFileInfo( QCoreApplication::applicationDirPath( ) ).filePath( );
   
   strPath.append( "/category_review.csv\0" );
  
   return strPath;
}

QString GetCsvOccasionsFile_PC( void ) 
{
   QString strPath;

   strPath = QFileInfo( QCoreApplication::applicationDirPath( ) ).filePath( );
   
   strPath.append( "/occasions_review.csv\0" );
  
   return strPath;
}


QString GetXmlBagsterFile_PC( int iVersion ) 
{
   QString strPath;

   strPath = QFileInfo( QCoreApplication::applicationDirPath( ) ).filePath( );
   
   switch( iVersion ) {
   case pixq_Properties::BibleKingJames:
      strPath.append( "/daily_kjv.xml\0" );
      break;

   case pixq_Properties::BibleKougoyaku:
      strPath.append( "/daily_kougo.xml\0" );
      break;

   case pixq_Properties::BibleShinkaiyaku2: 
      strPath.append( "/daily_shin.xml\0" );
      break;

   default:
      strPath.clear( );
      break;
   }
    
   return strPath;
}

QString GetTodaysHtmlFile_PC( void ) 
{
   // get %APPDATA% path

   QString strFile = QDesktopServices::storageLocation( QDesktopServices::DataLocation );
   strFile.append( "\\Bagster\\today.htm\0" );

   return strFile;
}

QString GetTorreyTopicalFile_PC( int iPage ) 
{
   QString strPath, strPage;

   strPath = QFileInfo( QCoreApplication::applicationDirPath( ) ).filePath( );
   strPage.sprintf( "/Files_Torreys/%03d.txt\0", iPage );

   strPath.append( strPage );
  
   return strPath;
}

QString GetTorreyIndexFile_PC( void ) 
{
   QString strPath;

   strPath = QFileInfo( QCoreApplication::applicationDirPath( ) ).filePath( );
   
   strPath.append( "/Files_Torreys/index.txt\0" );
  
   return strPath;
}

//
// make a list of devotions supported
//
void MakeDevotionsList_PC( QVector<int> &viDev )
{
   int iValue;
   viDev.clear( );

   iValue = pixq_Properties::DevotionTypeDailyDays;
   viDev.push_back( iValue );
   
   iValue = pixq_Properties::DevotionTypeDailyOccasion;
   viDev.push_back( iValue );

   return;
}

QString GetDevotionJpName_PC( int iDev ) // [i] one of pixq_Properties::HikariDevotionContent
{
   QString strDev;

   switch( iDev ) {
   case pixq_Properties::DevotionTypeDailyDays:
      strDev = "X̌";
      break;
   
   case pixq_Properties::DevotionTypeDailyOccasion:
      strDev = "X̌[ʂȓ]";
      break;

   default: 
      strDev = "Devotion";
      break;
   }

   return strDev;
}

QString GetDevotionEnName_PC( int iDev ) // [i] one of pixq_Properties::HikariDevotionContent
{
   QString strDev;

   switch( iDev ) {
   case pixq_Properties::DevotionTypeDailyDays:
      strDev = "Daily Lights";
      break;
   
   case pixq_Properties::DevotionTypeDailyOccasion:
      strDev = "Daily Lights : Special Occasions";
      break;

   default: 
      strDev = "Devotion";
      break;
   }

   return strDev;
}

QString GetDevotionName_PC( int iLang, 
                              int iDev ) // [i] one of pixq_Properties::HikariDevotionContent
{
   QString strDev;

   switch( iLang ) {
   case pixq_Properties::PixTopoLanguangeJp:
      strDev = GetDevotionJpName_PC( iDev );
      break;
   
   case pixq_Properties::PixTopoLanguangeEn:
      strDev = GetDevotionEnName_PC( iDev );
      break;

   default: 
      strDev = GetDevotionJpName_PC( iDev );
      break;
   }

   return strDev;
}

//
// X̌̈񕪂̃Gg[A䌾t̃XgƁAA:߂̃Xgɕ
//
// notes:
// Example:
// In - strLine
// aaaaa(gen1:2) bbbbb(john3:4) ccccc(rev:4:56-12) 
//
// output
// strVerses: 
// 0:aaaaa
// 1:bbbbb
// 2:ccccc
//
// strBooks: 
// 0:gen1:2
// 1:john3:4
// 2:rev:4:56-12
//
bool SplitBagsterLine_PC( const QString strLine, // [i] input single line
                       QStringList &strVerses, // [o] list of verses
                       QStringList &strBooks ) // [o] list of book, chapter:verse
{
   bool bRetCode = false;
   int nStart, nEnd, i, iFrom, iPos, iStart, iEnd;
   QChar chStart = '(';
   QChar chEnd = ')';
   QString strVerse, strBook;
   QVector<int> viStart;
   QVector<int> viEnd;
   QVector<int> viVerseStart;

   nStart = strLine.count( chStart );
   nEnd = strLine.count( chEnd );

   if( nStart != nEnd ) {
      goto  PIX_EXIT;      
   }

   // positions of (

   viStart.clear( );
   iFrom = 0;
   for( i = 0 ; i < nStart ; i++ ) {
      iPos = strLine.indexOf( chStart, iFrom );
      viStart.push_back( iPos );
      iFrom = iPos + 1;
   }

   // positions of )

   viEnd.clear( );
   iFrom = 0;
   for( i = 0 ; i < nEnd ; i++ ) {
      iPos = strLine.indexOf( chEnd, iFrom );
      viEnd.push_back( iPos );
      
      iFrom = iPos + 1;
   }

   // positions verse starts

   viVerseStart.clear( );
   viVerseStart.push_back( 0 );
   for( i = 1 ; i < nEnd ; i++ ) {
      iEnd = viEnd.at( i-1 );
      viVerseStart.push_back( iEnd+1 );
   }

   // words string

   strVerses.clear( );
   strBooks.clear( );

   for( i = 0 ; i < nEnd ; i++ ) {
      iStart = viStart.at( i );
      iEnd = viEnd.at( i );
      strBook = strLine.mid( iStart + 1, iEnd - iStart - 1 );
      strBooks.push_back( strBook );
      //
      iStart = viVerseStart.at( i );
      iEnd = viStart.at( i ) - 1;
      strVerse = strLine.mid( iStart, iEnd - iStart + 1 );
      strVerses.push_back( strVerse );
   }

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}  



//
// :ߔԍƂ݌t̕񂾕𕪊
//
// notes:
// Example:
// strLine
// 1:1 aaaaa  
//
// output
// strChapter=1:1 
// strVerse=aaaaa
//
bool SplitMikotobaLine_PC( const QString strLine, // [i] input single line
                       QString &strChapter, // [o] list of verses
                       QString &strVerse ) // [o] list of book, chapter:verse
{
   bool bRetCode = false;
   int nLength, iPos;

   // uN̈ʒu
   
   nLength = (int)strLine.size( );
   if( 0 >= nLength ) {
      strChapter = "-";
      strVerse = "-";
      goto PIX_EXIT;
   }

   iPos = strLine.indexOf( ' ', 0 );

   if( 0 >= iPos ) {
      strChapter = "-";
      strVerse = strLine;
      goto PIX_EXIT;
   }

   strChapter = strLine.left( iPos );
   strVerse = strLine.right( nLength - iPos - 1 );

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
} 

bool NumberOfWords_PC( const QString strLine, // [i] input single line
                       QStringList &strBooks ) // [o] list of book, chapter:verse
{
   bool bRetCode = false;
   int nStart, nEnd, i, iFrom, iPos, iStart, iEnd;
   QChar chStart = '(';
   QChar chEnd = ')';
   QString strBook;
   QVector<int> viStart;
   QVector<int> viEnd;

   nStart = strLine.count( chStart );
   nEnd = strLine.count( chEnd );

   if( nStart != nEnd ) {
      goto  PIX_EXIT;      
   }

   // positions of (

   viStart.clear( );
   iFrom = 0;
   for( i = 0 ; i < nStart ; i++ ) {
      iPos = strLine.indexOf( chStart, iFrom );
      viStart.push_back( iPos );
      iFrom = iPos + 1;
   }

   // positions of )

   viEnd.clear( );
   iFrom = 0;
   for( i = 0 ; i < nEnd ; i++ ) {
      iPos = strLine.indexOf( chEnd, iFrom );
      viEnd.push_back( iPos );
      iFrom = iPos + 1;
   }

   // words string

   strBooks.clear( );
   for( i = 0 ; i < nEnd ; i++ ) {
      iStart = viStart.at( i );
      iEnd = viEnd.at( i );
      strBook = strLine.mid( iStart+1, iEnd - iStart - 1 );
      strBooks.push_back( strBook );
   }

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}  


QString GetBibleXmlFile_PC( int iVersion )
{
   QString strPath = QFileInfo( QCoreApplication::applicationDirPath( ) ).filePath( );

   switch( iVersion ) {     
   case pixq_Properties::BibleShinkaiyaku2: 
      strPath.append( "/bible_shin2.xml\0" );
      break;

   case pixq_Properties::BibleShinkaiyaku3:
      strPath.append( "/bible_shin3.xml\0" );
      break;

   case pixq_Properties::BibleKougoyaku:
      strPath.append( "/bible_kougo.xml\0" );
      break;
      
   case pixq_Properties::BibleKingJames:
      strPath.append( "/bible_kjv.xml\0" ); 
      break;
      
   case pixq_Properties::BibleIntlStandard:
      strPath.append( "/bible_isv.xml\0" ); 
      break;
      
   case pixq_Properties::BibleBungo: 
      strPath.append( "/bible_bungo.xml\0" ); 
      break;
      
   case pixq_Properties::BibleRaguet:
      strPath.append( "/bible_raguet.xml\0" ); 
      break;
   
   default:
      strPath.clear( );
      break;
   }
   
   return strPath;
}

