#include <pixqt_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

void ChrTranslate_PC( 
      QString *str, 
		QChar	chr )
{
	QChar	cp = QChar::Null;
	str->replace( chr, cp, Qt::CaseInsensitive );
}

void ChrTranslate_PC( 
      QString	*str, 
		QChar	chr0, 
		QChar	chr1 )
{
	str->replace( chr0, chr1, Qt::CaseInsensitive );
}

bool IsIntNumber_PC( const QString strValue )
{
   bool bRetCode = false;
	QChar c;
   int i, nLen;

	// ̒0

   nLen = strValue.size( );
	if( 0 >= nLen ) {
		goto PIX_EXIT;
	}

	// 1ڂl܂-
	c = strValue.at( 0 );
   if( !c.isDigit( ) && c != QChar('-') ) {
		goto PIX_EXIT;
	}

	// 2ڈȍ~ׂĐ
	for ( i = 1; i < nLen; i++ ) {
		c = strValue.at( i );
      if( !c.isDigit( ) ) {
			goto PIX_EXIT;
		}
	}

   // --- Done ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

bool IsPositiveIntNumber_PC( const QString strValue ) 
{
   bool bRetCode = false;
	QChar c;
   int i, nLen;

	// ̒0
   
   nLen = strValue.size( );
	if( 0 >= nLen ) {
		goto PIX_EXIT;
	}

	// 2ڈȍ~ׂĐ

	for ( i = 0 ; i < nLen ; i++ ) {
		c = strValue.at( i );
      if( !c.isDigit( ) ) {
			goto PIX_EXIT;
		}
	}

   // --- Done ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

//
// decide the largest value from the araay of value and return the sequence number of the largest
//
int GetMaxValue_ITF( int nSize, // [i] size of the array
                    double *dArray, // [i] data array
                    double *dMaxVal  ) // [o] largest value
{
   int nMaxPos = -1;
   int i;
   double dValue, dMax;
   
   if( 0 >= nSize ) goto PIX_EXIT;

   i = 0;
   dMax = dArray[i];
   nMaxPos = i;
   
   for( i = 1 ; i < nSize ; i++ ) {
      dValue = dArray[i];
      if( dValue > dMax ) {
         dMax = dArray[i];
         nMaxPos = i;
      }
   }

   *dMaxVal = dMax;
   
   // --- Done ---
PIX_EXIT:
	return nMaxPos;
}

//
// Determines whether an expression is a valid real number type.
//
bool IsFloatNumber_ITF( char *szBuff )
{
   bool bRetCode = false;
	bool bDecimalPointFlag;
   int i, iLen;

	iLen = (int)strlen( szBuff );
	if( iLen <= 0 ) return false;

   if ( !isdigit( szBuff[0] ) && szBuff[0] != '-' ) {
      goto PIX_EXIT;
   }

	bDecimalPointFlag = false;
	for ( i = 1; i < iLen; i++ ) {
		if ( isdigit( szBuff[i] ) ) continue;
		if( szBuff[i] != '.' ) return false;

		if( bDecimalPointFlag == true ) {
			return false;
		} else {
			bDecimalPointFlag = true;
		}
	}

   // --- Done ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}


//
// check if the number if power of two
// 
// notes:
// 
bool IsPowerOfTwo_ITF( int iValue, // [i] input value
                       int *iPower ) // [i] if input value is power of two, it is 2**iPower
{
   int i = 0;   
   while( (1<<i) < iValue ) {
      i++;
   }

   if( iValue == (1<<i) ) {
      *iPower = i;
      return true;
   } else {
      *iPower = 0;
      return false;
   }
}

//
// get file name for the file
//
// example
// on Window,
// for "C:\\Hub\\sh1901\\right\\sh1901_v01.0012.cin",
// returns "sh1901_v01.0012.cin"
// 
// on Linux,
// for "/home/user/Hubsh1901/right/sh1901_v01.0012.cin",
// returns "sh1901_v01.0012.cin"
//
void GetFileName_ITF( const QString szFile, // [i] input file name
                     QString *szName ) // [i] file name portion
{
   QFileInfo file;
  
   file.setFile( szFile );

   *szName = file.fileName( );

	return;
}
