#include <pixqt_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

//
// check whether the file exists.
//
bool FileExist_PC( const QString strFile )
{
   QFileInfo fi;   
   fi.setFile( strFile );
   return fi.exists( );
}

//
// this is the name of the local file to copy the update file from
// website
//
// name of the xml file storing the latest version info of our software
//
// notes:
// basically, files are in the same directory as the executable file
// NEVER change these name!
//
QString GetLatestVerXmlFile_PC( int iMode )
{
   QString strPath;

   strPath = QFileInfo( QCoreApplication::applicationDirPath( ) ).filePath( );
   
   switch( iMode ) {
   case EnvModeHikari: 
      //
      // no diff for x86/x64
      //
#ifdef _WIN64
      strPath.append( "/hikari_version.xml\0" );
      //strPath.append( "/hikari_version_x64.xml\0" );
#else // _WIN64
      strPath.append( "/hikari_version.xml\0" );
      //strPath.append( "/hikari_version_x86.xml\0" );
#endif // _WIN64
      break;
    
   case EnvModeScope:
#ifdef _WIN64
      strPath.append( "/scope_version_x64.xml\0" );
#else // _WIN64
      strPath.append( "/scope_version_x86.xml\0" );
#endif // _WIN64
      break;
    
   case EnvModeSampler:
#ifdef _WIN64
      strPath.append( "/sampler_version_x64.xml\0" );
#else // _WIN64
      strPath.append( "/sampler_version_x86.xml\0" );
#endif // _WIN64
      break;

   case EnvModeBagster:  
   default:
      break;
   }

   return strPath;
}

QString GetTentativeVerXmlFile_PC( int iMode )
{
   QString strPath;

   strPath = QDesktopServices::storageLocation( QDesktopServices::DataLocation );
     
   switch( iMode ) {
   case EnvModeHikari: 
      strPath.append( "\\hikari_version.xml\0" );
      break;
    
   case EnvModeScope:
      strPath.append( "\\scope_version.xml\0" );
      break;
    
   case EnvModeSampler:
      strPath.append( "\\sampler_version.xml\0" );
      break;

   case EnvModeBagster:  
   default:
      break;
   }

   return strPath;
}

//
// name of the xml file on the web storing the latest version info of our software
// 
// notes:
// file is updated everytime software's version is updated.
// NEVER change these name!
//
// name for hikari: http://hikari.sourceforge.jp/hikari_version.xml
// 
QString GetUpdateVerXmlFile_PC( int iMode )
{
   QString strPath;

   strPath = GetWebsiteUrl_PC( );
   
   switch( iMode ) {
   case EnvModeHikari:
      strPath.append( "/hikari/hikari_version.xml\0" );
      break;
    
   case EnvModeScope:
      strPath.append( "/scope/scope_version.xml\0" );
      break;
    
   case EnvModeSampler:
      strPath.append( "/sampler/sampler_version.xml\0" );
      break;

   case EnvModeBagster:  
   default:
      break;
   }

   return strPath;
}

//
// return URL of our website
//
QString GetWebsiteUrl_PC( void )
{
   QString strPath = "http://hikari.sourceforge.jp";
   //QString strPath = "http://www.pixtopo.com/hikari";

   return strPath;
}

//
// return URL of our website for each project
//
QString GetProjectUrl_PC( int iMode )
{
   QString strPath;

   strPath = GetWebsiteUrl_PC( );
   
   switch( iMode ) {
   case EnvModeHikari:
      strPath.append( "/hikari\0" );
      break;
    
   case EnvModeScope:
      strPath.append( "/scope\0" );
      break;
    
   case EnvModeSampler:
      strPath.append( "/sampler\0" );
      break;

   case EnvModeBagster:  
   default:
      break;
   }

   return strPath;
}

//
// return URL of the top html file of each project
//
QString GetProjectTopUrl_PC( int iMode )
{
   QString strPath;

   strPath = GetProjectUrl_PC( iMode );
   
   switch( iMode ) {
   case EnvModeHikari:
      strPath.append( "/index.html\0" );
      break;
    
   case EnvModeScope:
      strPath.append( "/index.html\0" );
      break;
    
   case EnvModeSampler:
      strPath.append( "/index.html\0" );
      break;

   case EnvModeBagster:  
   default:
      break;
   }

   return strPath;
}

//
// create directory to store strFile recursively
//
// notes:
//
bool CreateFolder_PC( const QString strFile ) // [i] file name, not directory!
{
   bool bRetCode = false;
   QFileInfo fi;
   QString strPath;
   QDir dir;

   if( FileExist_PC( strFile ) ) {
      bRetCode = true;
      goto PIX_EXIT;
   }

   fi.setFile( strFile );
   //strPath = fi.path( );
   strPath = fi.absolutePath( );

   if( dir.exists( strPath ) ) {
      bRetCode = true;
      goto PIX_EXIT;
   }

   if( !dir.mkdir( strPath ) ) {
      goto PIX_EXIT;
   }

   // --- Done ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

//
// get 
QString GetFileExtention_ITF( const QString strFile ) 
{
   QFileInfo fi;
   QString strDir, strEntry, strExt;
   
   fi.setFile( strFile );
   strDir = fi.path( );
   strEntry = fi.completeBaseName( );
   strExt = fi.suffix( );

	return strExt;
}