#include <pixqt_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

//
// custom widgets
//

#include "pixq_about_dialog.h"
#include "pixq_options.h"

//
// 
//
void ShowPixAbout_PC( pixq_Version *pVer )
{
   pixq_about_dialog dlg;

   dlg.Init( pVer );
   dlg.exec( );

   return;
}

bool ShowPixProperty_PC( const QString strOrganisation, 
                        const QString strApplication, 
                        pixq_Properties *pEnv,
                        int iMode ) // [i] program mode, one of PixEnvModeSetting
{
   bool bRetCode = false;
   short sPage = -1;
   
   if( !ShowPixProperty_PC( strOrganisation, strApplication, pEnv, iMode, sPage ) ) {;
      goto PIX_EXIT;
   }

   // --- Done ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

bool ShowPixProperty_PC( const QString strOrganisation, 
                           const QString strApplication, 
                           pixq_Properties *pEnv,                           
                           int iMode, // [i] program mode, one of PixEnvModeSetting
                           short sPage )
{
   bool bRetCode = false;
   pixq_options dlg;
   int iRet;
   pixq_Properties TmpEnv;

   TmpEnv.InitEnv( strOrganisation, strApplication );
   TmpEnv = *pEnv;

   dlg.Init( strOrganisation, strApplication, &TmpEnv, iMode, sPage );

   iRet = dlg.exec( );
   switch( iRet ) {
   case QDialog::Accepted:
      
      break;
   case QDialog::Rejected:
      // canceled
      goto PIX_EXIT;
      break;
   }
   
   // store the changed env

   *pEnv = TmpEnv;

   // --- Done ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}
