#pragma once

using namespace _pix_plot_qt_framework;

//
// *** Can't USE TCHAR Functions! ***
//

//
// --- utility functions for bagster ---
// --- pixqf_bagster_utility.cpp ---
//

PIXQTLIB_EXPORT QString GetBagsterOccasionsXmlFile_PC( void );

PIXQTLIB_EXPORT QString GetXmlBagsterFile_PC( int iVersion );

PIXQTLIB_EXPORT QString GetDailyWordsXmlFile_PC( int iVersion );
PIXQTLIB_EXPORT QString GetDailyWordsTxtFile_PC( int iVersion );

PIXQTLIB_EXPORT QString GetDailyWordsFile_PC( int iVersion );
PIXQTLIB_EXPORT QString GetBagsterDailyWordsFile_PC( pixq_Properties *pEnv );
PIXQTLIB_EXPORT QString GetHikariBagsterDailyWordsFile_PC( pixq_Properties *pEnv, 
                                                             int iVer );

PIXQTLIB_EXPORT QString GetTabijiWordsFile_PC( void );
PIXQTLIB_EXPORT QString GetOccasionsWordsFile_PC( void );
PIXQTLIB_EXPORT QString GetOccasionsCsvFile_PC( void );

PIXQTLIB_EXPORT QString GetCsvTabijiFile_PC( void );
PIXQTLIB_EXPORT QString GetCsvOccasionsFile_PC( void );
PIXQTLIB_EXPORT QString GetTodaysHtmlFile_PC( void );

PIXQTLIB_EXPORT QString GetTorreyTopicalFile_PC( int iPage );
PIXQTLIB_EXPORT QString GetTorreyIndexFile_PC( void );

PIXQTLIB_EXPORT void MakeDevotionsList_PC( QVector<int> &viDev );
PIXQTLIB_EXPORT QString GetDevotionJpName_PC( int iDev );
PIXQTLIB_EXPORT QString GetDevotionEnName_PC( int iDev );
PIXQTLIB_EXPORT QString GetDevotionName_PC( int iLang, int iDev );

PIXQTLIB_EXPORT QString GetBibleXmlFile_PC( int iVersion );

PIXQTLIB_EXPORT bool NumberOfWords_PC( const QString strLine, QStringList &strBooks );
PIXQTLIB_EXPORT bool SplitBagsterLine_PC( const QString strLine, 
                                         QStringList &strVerses,
                                         QStringList &strBooks );
PIXQTLIB_EXPORT bool SplitMikotobaLine_PC( const QString strLine,
                                          QString &strChapter,
                                          QString &strVerse );

//
// --- Debugging, log, functions for developers ---
// --- pixqf_data_utility.cpp ---
//

PIXQTLIB_EXPORT void ChrTranslate_PC( QString *str, QChar chr0, QChar chr1 );
PIXQTLIB_EXPORT void ChrTranslate_PC( QString *str, QChar chr );

PIXQTLIB_EXPORT bool IsIntNumber_PC( const QString strValue );
PIXQTLIB_EXPORT bool IsPositiveIntNumber_PC( const QString strValue );

PIXQTLIB_EXPORT int GetMaxValue_ITF( int nSize, double *dArray, double *dMaxVal  );

// Determines whether an expression is a valid real number type.
PIXQTLIB_EXPORT bool IsFloatNumber_ITF( char* );

// check if the number if power of two
PIXQTLIB_EXPORT bool IsPowerOfTwo_ITF( int iValue, int *iPower );

PIXQTLIB_EXPORT void GetFileName_ITF( const QString szFile, QString *szName ); 

//
// --- fourier transform ---
// --- pixq_dft.cpp ---
//

// run 1D fft
PIXQTLIB_EXPORT bool Calc1DFftCalc_ITF( float *fReal, 
                                        float *fImag,
                                        int nPower, 
                                        bool bInv );

PIXQTLIB_EXPORT bool Calc1DFftCalc_ITF( vector<float> *fReal,
                                        vector<float> *fImag, 
                                        bool bInv );

// fft image of the first image in the second image
PIXQTLIB_EXPORT bool Get2DImageFft_ITF( pixq_Matrix<float> *fInReal,
                                        pixq_Matrix<float> *fInImag, 
                                        bool bInverse );

PIXQTLIB_EXPORT bool DftAmplitudeImage_ITF( pixq_Matrix<float> *fReal, 
                                            pixq_Matrix<float> *fImag,
                                            pixq_Matrix<float> *fDft ); 

PIXQTLIB_EXPORT bool DftAmplitudeImage_ITF( vector<float> *fReal, 
                                            vector<float> *fImag,
                                            vector<float> *fDft ); 

//
// --- fiel handling utility ---
// --- pixqf_file_utility.cpp ---
//

PIXQTLIB_EXPORT bool FileExist_PC( const QString strFile );
PIXQTLIB_EXPORT bool CreateFolder_PC( const QString strPath );

PIXQTLIB_EXPORT QString GetFileExtention_ITF( const QString strFile ); 

PIXQTLIB_EXPORT QString GetTentativeVerXmlFile_PC( int iMode );
PIXQTLIB_EXPORT QString GetLatestVerXmlFile_PC( int iMode );
PIXQTLIB_EXPORT QString GetUpdateVerXmlFile_PC( int iMode );

PIXQTLIB_EXPORT QString GetWebsiteUrl_PC( void );
PIXQTLIB_EXPORT QString GetProjectUrl_PC( int iMode );
PIXQTLIB_EXPORT QString GetProjectTopUrl_PC( int iMode );

//
// --- custom user interface ---
// --- pixqf_user_interface.cpp ---
//

PIXQTLIB_EXPORT void ShowPixAbout_PC( pixq_Version *pVer );

PIXQTLIB_EXPORT bool ShowPixProperty_PC( const QString strOrganisation, 
                                         const QString strApplication, 
                                         pixq_Properties *pEnv,
                                         int iMode,
                                         short sPage );

PIXQTLIB_EXPORT bool ShowPixProperty_PC( const QString strOrganisation, 
                                         const QString strApplication, 
                                         pixq_Properties *pEnv,
                                         int iMode );
