#include <pixqt_common.h>

#include<pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include "property_page.h"

property_page::property_page( void )
{
   _pTmpEnv = NULL;
   _strApplication.clear( );
}

property_page::~property_page( void )
{
   ; // empty
}

void property_page::ClearItem( QLineEdit *pEdit )
{
   pEdit->clear( );

   return;
}

void property_page::SetBool( pixq_EnvItem *pItem, 
                            QCheckBox *pCheck )
{
   bool bValue = pItem->GetBool( );   
   pCheck->setCheckState( bValue ? Qt::Checked : Qt::Unchecked );

   return;
}

void property_page::GetBool( pixq_EnvItem *pItem, 
                            QCheckBox *pCheck )
{   
   Qt::CheckState cs = pCheck->checkState( );
   bool bValue = ( Qt::Checked == cs ) ? true : false;
   pItem->Set( bValue );

   return;
}

void property_page::SetInteger( int iValue,
                                int iMin, 
                                int nMax, 
                                QLineEdit *pEdit )
{
   QString strValue;
    
   strValue.sprintf( "%d", iValue );
   pEdit->setText( strValue );
   
   pEdit->setValidator( new QIntValidator( iMin, nMax, pEdit ) );
   
   return;
}

void property_page::SetInteger( int iValue,
                                QLineEdit *pEdit )
{    
   QString strValue;
    
   strValue.sprintf( "%d", iValue );
   pEdit->setText( strValue );
   
   return;
}

void property_page::SetInteger( pixq_EnvItem *pItem,
                               QLineEdit *pEdit )
{
   QString strValue;

   bool bRange = pItem->GetRange( );
   int iValue = pItem->iGet( );   

   if( bRange ) {
      int iMin = pItem->GetIntMin( );
      int nMax = pItem->GetIntMax( );
      SetInteger( iValue, iMin, nMax, pEdit );
   } else {
      SetInteger( iValue, pEdit );
   }

   return;
}

void property_page::SetSpinInteger( pixq_EnvItem *pItem,
                                   QSpinBox *pSpin )
{
   QString strValue;
   int iMin;
   int nMax;

   bool bRange = pItem->GetRange( );
   int iValue = pItem->iGet( );   

   if( bRange ) {
      iMin = pItem->GetIntMin( );
      nMax = pItem->GetIntMax( );
   } else {
      iMin = -1000;
      nMax = 1000;
   }

   pSpin->setSingleStep( 1 );
   pSpin->setMinimum( iMin );
   pSpin->setMaximum( nMax );
   pSpin->setValue( iValue );

   return;
}

bool property_page::GetSpinInteger( pixq_EnvItem *pItem,
                                    QSpinBox *pSpin )
{
   bool bRetCode = false;
   int iValue;

   iValue = pSpin->value( );

   pItem->Set( iValue );  

   // --- Done ---
   bRetCode = true;
//PIX_EXIT:
   return bRetCode;
}

bool property_page::GetInteger( int *iValue,
                                 QLineEdit *pEdit )
{   
   bool bRetCode = false;
   bool bOK;
   QString strValue;

   // median filter radius

   strValue = pEdit->text( );
   *iValue = strValue.toInt( &bOK );
   if( !bOK ) {
      pEdit->setFocus( Qt::MouseFocusReason );
      goto PIX_EXIT;
   }

   // --- Done ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

bool property_page::GetInteger( pixq_EnvItem *pItem, 
                                QLineEdit *pEdit )
{   
   bool bRetCode = false;
   int iValue;

   if( !GetInteger( &iValue, pEdit ) ) {
      pEdit->setFocus( Qt::MouseFocusReason );
      goto PIX_EXIT;
   }

   pItem->Set( iValue );  

   // --- Done ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

void property_page::Set2Double( pixq_EnvItem *pItem,
                               QLineEdit *pEdit )
{
   SetDouble( pItem, pEdit, "%.2f" );
   
   return;
}

void property_page::Set2Double( double dValue,
                               QLineEdit *pEdit )
{
   SetDouble( dValue, pEdit, "%.2f" );
   
   return;
}

void property_page::SetDouble( pixq_EnvItem *pItem,
                               QLineEdit *pEdit, 
                               const char *szFormat )
{
   double dValue = pItem->dGet( );
   bool bRange = pItem->GetRange( );

   if( bRange ) {
      double dMin = pItem->dGetMin( );
      double dMax = pItem->dGetMax( );      
      //pEdit->setValidator( new QDoubleValidator( dMin, dMax, iDecimals, pEdit ) );
   }

   SetDouble( dValue, pEdit, szFormat );
   
   return;
}

void property_page::SetDouble( double dValue,
                               QLineEdit *pEdit, 
                               const char *szFormat )
{
   QString strValue;
   int iDecimals = 3;

   strValue.sprintf( szFormat, dValue );
   pEdit->setText( strValue ); 
   
   return;
}

bool property_page::GetDouble( double *dValue,
                               QLineEdit *pEdit )
{   
   bool bRetCode = false;
   bool bOK;
   QString strValue;

   // median filter radius

   strValue = pEdit->text( );
   *dValue = strValue.toDouble( &bOK );
   if( !bOK ) {
      pEdit->setFocus( Qt::MouseFocusReason );
      goto PIX_EXIT;
   }

   // --- Done ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

bool property_page::GetDouble( pixq_EnvItem *pItem,
                               QLineEdit *pEdit )
{   
   bool bRetCode = false;
   double dValue;

   if( !GetDouble( &dValue, pEdit ) ) {
      pEdit->setFocus( Qt::MouseFocusReason );
      goto PIX_EXIT;
   }

   pItem->Set( dValue );  

   // --- Done ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

void property_page::SetString( pixq_EnvItem *pItem,
                              QLineEdit *pEdit )
{
   QString strValue = pItem->strGet( );
   pEdit->setText( strValue ); 
   
   return;
}

void property_page::GetString( pixq_EnvItem *pItem,
                              QLineEdit *pEdit )
{
   QString strValue = pEdit->text( );
   pItem->Set( strValue ); 
   
   return;
}
