#pragma once

#include <QtCore>
#include <QtGui>
#include <QApplication>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

namespace _pix_plot_qt_framework {

class PIXQTLIB_EXPORT property_page
{
public:
   enum {
      //
      value_prop_page_none = -1,
      //
      // Do Not Change These Numbers!
      //
      value_prop_page_image = 101,
      value_prop_page_delog,
      value_prop_page_playback,
      value_prop_page_system,
      value_prop_page_tiff,
      value_prop_page_rectify, 
      value_prop_page_align,
      value_prop_page_fringe,
      value_prop_page_match_image,
      value_prop_page_match_depth,
      value_prop_page_match_result,
      value_prop_page_stripes,
      //
      // Dmr2Sampler
      //
      value_prop_page_op_basic = 201,
      value_prop_page_op_sharp,
      value_prop_page_op_feature, 
      value_prop_page_op_dft_filter,
      value_prop_page_op_epdow,
      value_prop_page_op_fuse3base,
      value_prop_page_op_fuse3med,
      value_prop_page_op_fuse3fine,
      //
    } value_property_page;

public:
   property_page( void );
   ~property_page(void);
   
private:
   pixq_Properties *_pTmpEnv;
   
public:
   QString _strOrganisation;
   QString _strApplication;

protected:
   // one of value_property_page
   int _propPage;

public:
   void Store( pixq_Properties *pEnv ) { _pTmpEnv = pEnv; }
   pixq_Properties *GetEnv( void ) { return _pTmpEnv; }

public:
   void SetBool( pixq_EnvItem *pItem, QCheckBox *pEdit );
   void GetBool( pixq_EnvItem *pItem, QCheckBox *pEdit );

   void SetString( pixq_EnvItem *pItem, QLineEdit *pEdit );
   void GetString( pixq_EnvItem *pItem, QLineEdit *pEdit );

   void SetInteger( int iValue, int iMin, int nMax, QLineEdit *pEdit );
   void SetInteger( int iValue, QLineEdit *pEdit );
   void SetInteger( pixq_EnvItem *pItem, QLineEdit *pEdit );
   bool GetSpinInteger( pixq_EnvItem *pItem, QSpinBox *pSpin );
   void SetSpinInteger( pixq_EnvItem *pItem, QSpinBox *pSpin );

   bool GetInteger( int *iValue, QLineEdit *pEdit );
   bool GetInteger( pixq_EnvItem *pItem, QLineEdit *pEdit );

   void Set2Double( double dValue, QLineEdit *pEdit );
   void Set2Double( pixq_EnvItem *pItem, QLineEdit *pEdit );

   void SetDouble( double dValue, QLineEdit *pEdit, const char *szFormat );
   void SetDouble( pixq_EnvItem *pItem, QLineEdit *pEdit, const char *szFormat );

   bool GetDouble( double *dValue, QLineEdit *pEdit );
   bool GetDouble( pixq_EnvItem *pItem, QLineEdit *pEdit );

   void ClearItem( QLineEdit *pEdit );

public: 
   virtual void SetData( void ) = 0;
   virtual bool Check( void ) = 0;
   virtual void Init( pixq_Properties *pEnv ) = 0;
   
};

} // namespace _pix_plot_qt_framework 
