#include <pixqt_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include "pixq_options_page.h"
#include "props_page_bagster_timer.h"
#include "ui_props_page_bagster_timer.h"

props_page_bagster_timer::props_page_bagster_timer(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::props_page_bagster_timer)
{
    ui->setupUi(this);
    _sPageId = (short)pixq_EnvItem::ItemCategoryBagsterTimer;
}

props_page_bagster_timer::~props_page_bagster_timer()
{
    delete ui;
}

void props_page_bagster_timer::closeEvent(QCloseEvent * /* event */ )
{
   Check( );

   return;
}

void props_page_bagster_timer::SetData( void )
{
   pixq_Properties *pEnv = GetEnv( );
   bool bValue;
   QTime time;
   int iHour, iSec, iMin;

   // ************
   // ***  ***
   // ************

   // show at selected time?
   bValue = pEnv->_BagsterShowEveryDay.GetBool( );
   if( bValue ) {
      ui->opt_timer_show_everyday->setCheckState( Qt::Checked );
   } else {
      ui->opt_timer_show_everyday->setCheckState( Qt::Unchecked );
   }

   // time to show the morning words
   iHour = pEnv->_BagsterAmShowHour.iGet( );
   iMin = pEnv->_BagsterAmShowMinuite.iGet( );
   iSec = pEnv->_BagsterAmShowSecond.iGet( );
   time.setHMS ( iHour, iMin, iSec );
   ui->opt_time_morning_show_time->setTime( time );

   // time to show the evening words
   iHour = pEnv->_BagsterPmShowHour.iGet( );
   iMin = pEnv->_BagsterPmShowMinuite.iGet( );
   iSec = pEnv->_BagsterPmShowSecond.iGet( );
   time.setHMS ( iHour, iMin, iSec );
   ui->opt_time_evening_show_time->setTime( time );

   // **********
   // ***  ***
   // **********

   // bible version

   SetBagsterBibleVersion( );

   return;
}

//
// returns:
// true
// false, if some unacceptale values are set
//
bool props_page_bagster_timer::Check( void )
{
   bool bRetCode = false;
   pixq_Properties *pEnv = GetEnv( );
   bool bValue;
   QTime time;
   int iHour, iSec, iMin;
   Qt::CheckState checkState;

   // ************
   // ***  ***
   // ************

   // show at selected time?

   checkState = ui->opt_timer_show_everyday->checkState( );
   if( Qt::Checked == checkState ) {
      bValue = true;
   } else { // Qt::Unchecked
      bValue = false;
   }
   pEnv->_BagsterShowEveryDay.Set( bValue );

   // time to show the morning words

   time = ui->opt_time_morning_show_time->time( );
   iHour = time.hour( );
   iMin = time.minute( );
   iSec = time.second( );
   pEnv->_BagsterAmShowHour.Set( iHour );
   pEnv->_BagsterAmShowMinuite.Set( iMin );
   pEnv->_BagsterAmShowSecond.Set( iSec );

   // time to show the evening words

   time = ui->opt_time_evening_show_time->time( );
   iHour = time.hour( );
   iMin = time.minute( );
   iSec = time.second( );
   pEnv->_BagsterPmShowHour.Set( iHour );
   pEnv->_BagsterPmShowMinuite.Set( iMin );
   pEnv->_BagsterPmShowSecond.Set( iSec );

   // **********
   // ***  ***
   // **********

   // bible version

   // already set by radio

   // --- DOne ---
   bRetCode = true;
//PIX_EXIT:
   return bRetCode;
}

//
// set texture style mode
//
void props_page_bagster_timer::SetBagsterBibleVersion( void )
{
   pixq_Properties *pEnv = GetEnv( );
   int iVersion;

   ui->opt_version_shinkaiyaku_radio->setChecked( false );
   ui->opt_version_kougoyaku_radio->setChecked( false );
   ui->opt_version_kjv_radio->setChecked( false );

   // bible version

   iVersion = pEnv->_BagsterBibleVersion.iGet( );

   switch( iVersion ) {
   case pixq_Properties::BibleShinkaiyaku2: 
      ui->opt_version_shinkaiyaku_radio->setChecked( true );
      break;
   case pixq_Properties::BibleKougoyaku:
      ui->opt_version_kougoyaku_radio->setChecked( true );
      break;
   case pixq_Properties::BibleKingJames: // IRAN
      ui->opt_version_kjv_radio->setChecked( true );
      break;
   }

   return;
}

void props_page_bagster_timer::on_opt_version_shinkaiyaku_radio_clicked(bool checked)
{
   pixq_Properties *pEnv = GetEnv( );
   int iVersion = pixq_Properties::BibleShinkaiyaku2; 

   if( checked ) {
      pEnv->_BagsterBibleVersion.Set( iVersion );
      SetBagsterBibleVersion( );
   }

   return;
}

void props_page_bagster_timer::on_opt_version_kougoyaku_radio_clicked(bool checked)
{
   pixq_Properties *pEnv = GetEnv( );
   int iVersion = pixq_Properties::BibleKougoyaku;

   if( checked ) {
      pEnv->_BagsterBibleVersion.Set( iVersion );
      SetBagsterBibleVersion( );
   }

   return;
}

void props_page_bagster_timer::on_opt_version_kjv_radio_clicked(bool checked)
{
   pixq_Properties *pEnv = GetEnv( );
   int iVersion = pixq_Properties::BibleKingJames; // IRAN

   if( checked ) {
      pEnv->_BagsterBibleVersion.Set( iVersion );
      SetBagsterBibleVersion( );
   }

   return;
}
