#include <pixqt_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include "pixq_options_page.h"
#include "props_page_bagster_view.h"
#include "ui_props_page_bagster_view.h"

props_page_bagster_view::props_page_bagster_view(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::props_page_bagster_view)
{
    ui->setupUi(this);
    _sPageId = (short)pixq_EnvItem::ItemCategoryBagsterView;
}

props_page_bagster_view::~props_page_bagster_view()
{
    delete ui;
}

void props_page_bagster_view::closeEvent(QCloseEvent * /* event */ )
{
   Check( );

   return;
}

void props_page_bagster_view::SetData( void )
{
   pixq_Properties *pEnv = GetEnv( );
   int iValue;
   QFont jp_fn, en_fn;

   // ************
   // *** \ ***
   // ************

   // JapanesetHg

   jp_fn = pEnv->_BagsterJapaneseFont.lfGet();
   ui->bagster_font_jp_sample->setFont( jp_fn );
   ui->bagster_font_jp_sample->setText( "X̌" );

   // EnglishtHg

   en_fn = pEnv->_BagsterEnglishFont.lfGet();
   ui->bagster_font_en_sample->setFont( en_fn );
   ui->bagster_font_en_sample->setText( "Daily Light" );

   // background color
   // _BagsterBgColor;

   ui->bagster_bg_color_sample->StoreEnv( pEnv );
   ui->bagster_bg_color_sample->repaint( );
   
   // line heightsԁA100%`
   iValue = pEnv->_BagsterLineHeight.iGet( );
   ui->opt_view_line_height->setValue( iValue );

   return;
}


bool props_page_bagster_view::Check( void )
{
   bool bRetCode = false;
   pixq_Properties *pEnv = GetEnv( );
   int iValue;

   // ************
   // *** \ ***
   // ************

   // Japanese Font
   // done

   // English Font
   // done

   // background color
   // done

   // line heightsԁA100%`
   iValue = ui->opt_view_line_height->value( );
   pEnv->_BagsterLineHeight.Set( iValue );

   bRetCode = true;
//PIX_EXIT:
   return bRetCode;
}

void props_page_bagster_view::keyPressEvent(QKeyEvent *event)
{
   switch (event->key()) {
   case Qt::Key_Enter:
      // ignore this
      goto PIX_EXIT;
      break;

   default:
      break;
   }

   props_page_bagster_view::keyPressEvent( event );

PIX_EXIT:
   return;
}

void props_page_bagster_view::on_opt_view_select_font_clicked()
{
   pixq_Properties *pEnv = GetEnv( );
   QFont newFn;
   QFont fn = pEnv->_BagsterJapaneseFont.lfGet( );
   QFontDialog dlg( fn );

   if( QDialog::Accepted != dlg.exec( ) ) {
      goto PIX_EXIT;
   }

   newFn = dlg.selectedFont( );
   pEnv->_BagsterJapaneseFont.Set( newFn );

   SetData( );

PIX_EXIT:
   return;
}

void props_page_bagster_view::on_opt_view_select_en_font_clicked()
{
   pixq_Properties *pEnv = GetEnv( );
   QFont newFn;
   QFont fn = pEnv->_BagsterEnglishFont.lfGet( );
   QFontDialog dlg( fn );

   if( QDialog::Accepted != dlg.exec( ) ) {
      goto PIX_EXIT;
   }

   newFn = dlg.selectedFont( );
   pEnv->_BagsterEnglishFont.Set( newFn );

   SetData( );

PIX_EXIT:
   return;
}

void props_page_bagster_view::on_opt_view_select_bg_color_clicked()
{
   pixq_Properties *pEnv = GetEnv( );
   QColor newColor;
   QColor rgb = pEnv->_BagsterBgColor.colGet( );
   QColorDialog dlg( rgb );

   if( QDialog::Accepted != dlg.exec( ) ) {
      goto PIX_EXIT;
   }

   newColor = dlg.selectedColor( );
   pEnv->_BagsterBgColor.Set( newColor );
   SetData( );

PIX_EXIT:
   return;
}
