#include <pixqt_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include "pixq_options_page.h"
#include "props_page_hikari_bagster.h"
#include "ui_props_page_hikari_bagster.h"

props_page_hikari_bagster::props_page_hikari_bagster(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::props_page_hikari_bagster)
{
    ui->setupUi(this);
    _sPageId = (short)pixq_EnvItem::ItemCategoryHikariBagster;
}

props_page_hikari_bagster::~props_page_hikari_bagster()
{
    delete ui;
}

void props_page_hikari_bagster::closeEvent(QCloseEvent * /* event */ )
{
   Check( );

   return;
}

void props_page_hikari_bagster::SetData( void )
{
   pixq_Properties *pEnv = GetEnv( );
   QTime time;
   int iVersion, iHour, iSec, iMin;

   // ***************************
   // *** Hikari̒Bagster ***
   // *********************8*****

   // V2FXMLt@CȂ΁AWI{^Disable

   iVersion = pixq_Properties::BibleShinkaiyaku2;

   if( pixq_Properties::VersionDailyXmlExist( iVersion ) ) {
      ui->hikari_bagster_version_shinkaiyaku_radio->setEnabled( true );
      ui->hikari_bagster_2nd_version_shinkaiyaku_radio->setEnabled( true );
   } else {
      ui->hikari_bagster_version_shinkaiyaku_radio->setEnabled( false );
      ui->hikari_bagster_2nd_version_shinkaiyaku_radio->setEnabled( false );
   }

   // show at selected time?
   
   SetBool( &pEnv->_HikariBagsterShowEveryDay, ui->hikari_bagster_timer_show_everyday );

   // time to show the morning words
   iHour = pEnv->_HikariBagsterAmShowHour.iGet( );
   iMin = pEnv->_HikariBagsterAmShowMinuite.iGet( );
   iSec = pEnv->_HikariBagsterAmShowSecond.iGet( );
   time.setHMS ( iHour, iMin, iSec );
   ui->hikari_bagster_morning_show_time->setTime( time );

   // time to show the evening words
   iHour = pEnv->_HikariBagsterPmShowHour.iGet( );
   iMin = pEnv->_HikariBagsterPmShowMinuite.iGet( );
   iSec = pEnv->_HikariBagsterPmShowSecond.iGet( );
   time.setHMS ( iHour, iMin, iSec );
   ui->hikari_bagster_evening_show_time->setTime( time );

   // bible version to show daily light inside Hikari
   SetBibleVersion( );

   // second bible version to show daily light inside Hikari
   
   SetSecondBibleVersion( );

   return;
}

bool props_page_hikari_bagster::Check( void )
{
   bool bRetCode = false;
   pixq_Properties *pEnv = GetEnv( );
   QTime time;
   int iHour, iSec, iMin;

   // **************************
   // *** Hikari̒Bagster ***
   // **************************

   // show at selected time?

   GetBool( &pEnv->_HikariBagsterShowEveryDay, ui->hikari_bagster_timer_show_everyday );

   // time to show the morning words

   time = ui->hikari_bagster_morning_show_time->time( );
   iHour = time.hour( );
   iMin = time.minute( );
   iSec = time.second( );
   pEnv->_HikariBagsterAmShowHour.Set( iHour );
   pEnv->_HikariBagsterAmShowMinuite.Set( iMin );
   pEnv->_HikariBagsterAmShowSecond.Set( iSec );

   // time to show the evening words

   time = ui->hikari_bagster_evening_show_time->time( );
   iHour = time.hour( );
   iMin = time.minute( );
   iSec = time.second( );
   pEnv->_HikariBagsterPmShowHour.Set( iHour );
   pEnv->_HikariBagsterPmShowMinuite.Set( iMin );
   pEnv->_HikariBagsterPmShowSecond.Set( iSec );

   // bible version to show daily light inside Hikari
   // already set by radio

   // second bible version to show daily light inside Hikari
   // already set by radio

   // --- DONE ---
   bRetCode = true;
//PIX_EXIT:
   return bRetCode;
}

void props_page_hikari_bagster::keyPressEvent(QKeyEvent *event)
{
   switch (event->key()) {
   case Qt::Key_Enter:
      // ignore this
      goto PIX_EXIT;
      break;

   default:
      break;
   }

   props_page_hikari_bagster::keyPressEvent( event );

PIX_EXIT:
   return;
}

void props_page_hikari_bagster::on_hikari_bagster_version_shinkaiyaku_radio_clicked()
{
   pixq_Properties *pEnv = GetEnv( );
   int iVersion = pixq_Properties::BibleShinkaiyaku2; 

   pEnv->_HikariBagsterBibleVer.Set( iVersion );
   SetBibleVersion( );

   return;
}

void props_page_hikari_bagster::on_hikari_bagster_version_kougoyaku_radio_clicked()
{
   pixq_Properties *pEnv = GetEnv( );
   int iVersion = pixq_Properties::BibleKougoyaku;

   pEnv->_HikariBagsterBibleVer.Set( iVersion );
   SetBibleVersion( );

   return;
}

void props_page_hikari_bagster::on_hikari_bagster_version_kjv_radio_clicked()
{
   pixq_Properties *pEnv = GetEnv( );
   int iVersion = pixq_Properties::BibleKingJames; 

   pEnv->_HikariBagsterBibleVer.Set( iVersion );
   SetBibleVersion( );

   return;
}

void props_page_hikari_bagster::on_hikari_bagster_2nd_version_shinkaiyaku_radio_clicked()
{
   pixq_Properties *pEnv = GetEnv( );
   int iVersion = pixq_Properties::BibleShinkaiyaku2; 

   pEnv->_HikariBagster2ndBibleVer.Set( iVersion );
   SetSecondBibleVersion( );

   return;
}

void props_page_hikari_bagster::on_hikari_bagster_2nd_version_kougoyaku_radio_clicked()
{
   pixq_Properties *pEnv = GetEnv( );
   int iVersion = pixq_Properties::BibleKougoyaku;

   pEnv->_HikariBagster2ndBibleVer.Set( iVersion );
   SetSecondBibleVersion( );

   return;    
}

void props_page_hikari_bagster::on_hikari_bagster_2nd_version_kjv_radio_clicked()
{
   pixq_Properties *pEnv = GetEnv( );
   int iVersion = pixq_Properties::BibleKingJames; 

   pEnv->_HikariBagster2ndBibleVer.Set( iVersion );
   SetSecondBibleVersion( );

   return;
}

//
// set texture style mode
//
void props_page_hikari_bagster::SetBibleVersion( void )
{
   pixq_Properties *pEnv = GetEnv( );
   int iVersion;

   ui->hikari_bagster_version_shinkaiyaku_radio->setChecked( false );
   ui->hikari_bagster_version_kougoyaku_radio->setChecked( false );
   ui->hikari_bagster_version_kjv_radio->setChecked( false );

   // bible version

   iVersion = pEnv->_HikariBagsterBibleVer.iGet( );

   switch( iVersion ) {
   case pixq_Properties::BibleShinkaiyaku2: 
      ui->hikari_bagster_version_shinkaiyaku_radio->setChecked( true );
      break;
   case pixq_Properties::BibleKougoyaku:
      ui->hikari_bagster_version_kougoyaku_radio->setChecked( true );
      break;
   case pixq_Properties::BibleKingJames: 
      ui->hikari_bagster_version_kjv_radio->setChecked( true );
      break;
   }

   return;
}

void props_page_hikari_bagster::SetSecondBibleVersion( void )
{
   pixq_Properties *pEnv = GetEnv( );
   int iVersion;

   ui->hikari_bagster_2nd_version_shinkaiyaku_radio->setChecked( false );
   ui->hikari_bagster_2nd_version_kougoyaku_radio->setChecked( false );
   ui->hikari_bagster_2nd_version_kjv_radio->setChecked( false );

   // bible version

   iVersion = pEnv->_HikariBagster2ndBibleVer.iGet( );

   switch( iVersion ) {
   case pixq_Properties::BibleShinkaiyaku2: 
      ui->hikari_bagster_2nd_version_shinkaiyaku_radio->setChecked( true );
      break;
   case pixq_Properties::BibleKougoyaku:
      ui->hikari_bagster_2nd_version_kougoyaku_radio->setChecked( true );
      break;
   case pixq_Properties::BibleKingJames: 
      ui->hikari_bagster_2nd_version_kjv_radio->setChecked( true );
      break;
   }

   return;
}
