#include <pixqt_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include "pixq_options_page.h"

#include "props_page_hikari_bible.h"
#include "ui_props_page_hikari_bible.h"

props_page_hikari_bible::props_page_hikari_bible(QWidget *parent) :
   QWidget(parent),
   ui(new Ui::props_page_hikari_bible)
{
   ui->setupUi(this);
   _sPageId = (short)pixq_EnvItem::ItemCategoryHikariBible;
}

props_page_hikari_bible::~props_page_hikari_bible()
{
   delete ui;
}

void props_page_hikari_bible::closeEvent(QCloseEvent * /* event */ )
{
   Check( );

   return;
}

void props_page_hikari_bible::SetData( void )
{
   pixq_Properties *pEnv = GetEnv( );
   int iVersion;
   QTime time;

   // **********
   // ***  ***
   // **********

   // V2FXMLt@CȂ΁AWI{^Disable

   iVersion = pixq_Properties::BibleShinkaiyaku2;

   if( pixq_Properties::VersionBibleXmlExist( iVersion ) ) {
      ui->hikari_version_shinkai2_radio->setEnabled( true );
      ui->hikari_2nd_version_shinkai2_radio->setEnabled( true );
      ui->search_shinkai2_check->setEnabled( true );
   } else {
      ui->hikari_version_shinkai2_radio->setEnabled( false );
      ui->hikari_2nd_version_shinkai2_radio->setEnabled( false );
      ui->search_shinkai2_check->setEnabled( false );
   }

   // bible version

   SetBibleVersion( );
   SetSecondBibleVersion( );

   // use this bible version for search?
   
   SetBool( &pEnv->_HikariBibleSearchShinkaiyaku2, ui->search_shinkai2_check );
   SetBool( &pEnv->_HikariBibleSearchKougoyaku, ui->search_kougo_check );
   SetBool( &pEnv->_HikariBibleSearchKingJames, ui->search_kjv_check );
   SetBool( &pEnv->_HikariBibleSearchIntlStandard, ui->search_isv_check );
   SetBool( &pEnv->_HikariBibleSearchBungo, ui->search_bungo_check );
   SetBool( &pEnv->_HikariBibleSearchRaguet, ui->search_raguet_check );

   return;
}

//
// returns:
// true
// false, if some unacceptale values are set
//
bool props_page_hikari_bible::Check( void )
{
   bool bRetCode = false;
   pixq_Properties *pEnv = GetEnv( );

   // **********
   // ***  ***
   // **********

   // bible version

   // already set by radio

   // use this bible version for search?
   
   GetBool( &pEnv->_HikariBibleSearchShinkaiyaku2, ui->search_shinkai2_check );
   GetBool( &pEnv->_HikariBibleSearchKougoyaku, ui->search_kougo_check );
   GetBool( &pEnv->_HikariBibleSearchKingJames, ui->search_kjv_check );
   GetBool( &pEnv->_HikariBibleSearchIntlStandard, ui->search_isv_check );
   GetBool( &pEnv->_HikariBibleSearchBungo, ui->search_bungo_check );
   GetBool( &pEnv->_HikariBibleSearchRaguet, ui->search_raguet_check );

   // --- DOne ---
   bRetCode = true;
//PIX_EXIT:
   return bRetCode;
}

//
// set texture style mode
//
void props_page_hikari_bible::SetBibleVersion( void )
{
   pixq_Properties *pEnv = GetEnv( );
   int iVersion;

   ui->hikari_version_shinkai2_radio->setChecked( false );
   ui->hikari_version_bungo_radio->setChecked( false );
   ui->hikari_version_kougo_radio->setChecked( false );
   ui->hikari_version_raguet_radio->setChecked( false );
   ui->hikari_version_kjv_radio->setChecked( false );
   ui->hikari_version_isv_radio->setChecked( false );

   // bible version

   iVersion = pEnv->_HikariBibleVersion.iGet( );

   switch( iVersion ) {
   case pixq_Properties::BibleShinkaiyaku2:
      ui->hikari_version_shinkai2_radio->setChecked( true );
      break;
   case pixq_Properties::BibleBungo: 
      ui->hikari_version_bungo_radio->setChecked( true );
      break;
   case pixq_Properties::BibleRaguet:
      ui->hikari_version_raguet_radio->setChecked( true );
      break;
   case pixq_Properties::BibleKougoyaku:
      ui->hikari_version_kougo_radio->setChecked( true );
      break;
   case pixq_Properties::BibleKingJames: 
      ui->hikari_version_kjv_radio->setChecked( true );
      break;
   case pixq_Properties::BibleIntlStandard:
      ui->hikari_version_isv_radio->setChecked( true );
      break;
   }

   return;
}

void props_page_hikari_bible::SetSecondBibleVersion( void )
{
   pixq_Properties *pEnv = GetEnv( );
   int iVersion;

   ui->hikari_2nd_version_shinkai2_radio->setChecked( false );
   ui->hikari_2nd_version_bungo_radio->setChecked( false );
   ui->hikari_2nd_version_kougo_radio->setChecked( false );
   ui->hikari_2nd_version_raguet_radio->setChecked( false );
   ui->hikari_2nd_version_kjv_radio->setChecked( false );
   ui->hikari_2nd_version_isv_radio->setChecked( false );

   // bible version

   iVersion = pEnv->_HikariBibleSecondVersion.iGet( );

   switch( iVersion ) {
   case pixq_Properties::BibleShinkaiyaku2:
      ui->hikari_2nd_version_shinkai2_radio->setChecked( true );
      break;
   case pixq_Properties::BibleBungo: 
      ui->hikari_2nd_version_bungo_radio->setChecked( true );
      break;
   case pixq_Properties::BibleRaguet:
      ui->hikari_2nd_version_raguet_radio->setChecked( true );
      break;
   case pixq_Properties::BibleKougoyaku:
      ui->hikari_2nd_version_kougo_radio->setChecked( true );
      break;
   case pixq_Properties::BibleKingJames: 
      ui->hikari_2nd_version_kjv_radio->setChecked( true );
      break;
   case pixq_Properties::BibleIntlStandard:
      ui->hikari_2nd_version_isv_radio->setChecked( true );
      break;
   }

   return;
}

void props_page_hikari_bible::on_hikari_version_shinkai2_radio_clicked()
{
   pixq_Properties *pEnv = GetEnv( );
   int iVersion = pixq_Properties::BibleShinkaiyaku2;

   pEnv->_HikariBibleVersion.Set( iVersion );
   SetBibleVersion( );

   return;
}

void props_page_hikari_bible::on_hikari_version_bungo_radio_clicked()
{
    pixq_Properties *pEnv = GetEnv( );
    int iVersion = pixq_Properties::BibleBungo; 

    pEnv->_HikariBibleVersion.Set( iVersion );
    SetBibleVersion( );

    return;
}

void props_page_hikari_bible::on_hikari_version_raguet_radio_clicked()
{
    pixq_Properties *pEnv = GetEnv( );
    int iVersion = pixq_Properties::BibleRaguet;

    pEnv->_HikariBibleVersion.Set( iVersion );
    SetBibleVersion( );

    return;
}

void props_page_hikari_bible::on_hikari_version_kougo_radio_clicked()
{
   pixq_Properties *pEnv = GetEnv( );
   int iVersion = pixq_Properties::BibleKougoyaku;

   pEnv->_HikariBibleVersion.Set( iVersion );
   SetBibleVersion( );

   return;
}

void props_page_hikari_bible::on_hikari_version_kjv_radio_clicked()
{
   pixq_Properties *pEnv = GetEnv( );
   int iVersion = pixq_Properties::BibleKingJames; 

   pEnv->_HikariBibleVersion.Set( iVersion );
   SetBibleVersion( );

   return;
}

void props_page_hikari_bible::on_hikari_version_isv_radio_clicked()
{
   pixq_Properties *pEnv = GetEnv( );
   int iVersion = pixq_Properties::BibleIntlStandard;

   pEnv->_HikariBibleVersion.Set( iVersion );
   SetBibleVersion( );

   return;
}

void props_page_hikari_bible::on_hikari_2nd_version_shinkai2_radio_clicked()
{
   pixq_Properties *pEnv = GetEnv( );
   int iVersion = pixq_Properties::BibleShinkaiyaku2;

   pEnv->_HikariBibleSecondVersion.Set( iVersion );
   SetSecondBibleVersion( );

   return;
}

void props_page_hikari_bible::on_hikari_2nd_version_bungo_radio_clicked()
{
    pixq_Properties *pEnv = GetEnv( );
    int iVersion = pixq_Properties::BibleBungo; 

    pEnv->_HikariBibleSecondVersion.Set( iVersion );
    SetSecondBibleVersion( );

    return;
}

void props_page_hikari_bible::on_hikari_2nd_version_kougo_radio_clicked()
{
   pixq_Properties *pEnv = GetEnv( );
   int iVersion = pixq_Properties::BibleKougoyaku;

   pEnv->_HikariBibleSecondVersion.Set( iVersion );
   SetSecondBibleVersion( );

   return;
}

void props_page_hikari_bible::on_hikari_2nd_version_raguet_radio_clicked()
{
   pixq_Properties *pEnv = GetEnv( );
   int iVersion = pixq_Properties::BibleRaguet;

   pEnv->_HikariBibleSecondVersion.Set( iVersion );
   SetSecondBibleVersion( );

   return;
}


void props_page_hikari_bible::on_hikari_2nd_version_kjv_radio_clicked()
{
   pixq_Properties *pEnv = GetEnv( );
   int iVersion = pixq_Properties::BibleKingJames; 

   pEnv->_HikariBibleSecondVersion.Set( iVersion );
   SetSecondBibleVersion( );

   return;
}

void props_page_hikari_bible::on_hikari_2nd_version_isv_radio_clicked()
{
   pixq_Properties *pEnv = GetEnv( );
   int iVersion = pixq_Properties::BibleIntlStandard;

   pEnv->_HikariBibleSecondVersion.Set( iVersion );
   SetSecondBibleVersion( );

   return;
}
