#include <pixqt_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include "pixq_options_page.h"
#include "props_page_hikari_edit.h"
#include "ui_props_page_hikari_edit.h"

props_page_hikari_edit::props_page_hikari_edit(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::props_page_hikari_edit)
{
    ui->setupUi(this);
    _sPageId = (short)pixq_EnvItem::ItemCategoryHikariEdit;
}

props_page_hikari_edit::~props_page_hikari_edit()
{
    delete ui;
}

void props_page_hikari_edit::closeEvent(QCloseEvent * /* event */ )
{
   Check( );

   return;
}

void props_page_hikari_edit::keyPressEvent(QKeyEvent *event)
{
   switch (event->key()) {
   case Qt::Key_Enter:
      // ignore this
      goto PIX_EXIT;
      break;

   default:
      break;
   }

   props_page_hikari_edit::keyPressEvent( event );

PIX_EXIT:
   return;
}

void props_page_hikari_edit::SetData( void )
{
   pixq_Properties *pEnv = GetEnv( );

   // *******************
   // *** Hikari ҏW ***
   // *******************

   // Copy - include book name
    
   SetBool( &pEnv->_HikariCopyIncludeBook, ui->hikari_edit_copy_include_book_name_check );

   // Copy - include version Name
   
   SetBool( &pEnv->_HikariCopyIncludeVersion, ui->hikari_edit_copy_include_version_name_check );

   // Copy - chapter verse number? One of ShowChapterVerseNumber 
   
   SetChapterVerse( );
   
   // Copy - separate verses(change line for each verse) 
      
   SetBool( &pEnv->_HikariCopyChangeLine, ui->hikari_show_column_line_check );

   return;
}

bool props_page_hikari_edit::Check( void )
{
   bool bRetCode = false;
   pixq_Properties *pEnv = GetEnv( );

   // Copy - include book name
    
   GetBool( &pEnv->_HikariCopyIncludeBook, ui->hikari_edit_copy_include_book_name_check );

   // Copy - include version Name
   
   GetBool( &pEnv->_HikariCopyIncludeVersion, ui->hikari_edit_copy_include_version_name_check );

   // Copy - chapter verse number? One of ShowChapterVerseNumber 
   
   // done
   
   // Copy - separate verses(change line for each verse) 
      
   GetBool( &pEnv->_HikariCopyChangeLine, ui->hikari_show_column_line_check );

   // --- DONE ---
   bRetCode = true;
//PIX_EXIT:
   return bRetCode;
}

void props_page_hikari_edit::on_hikari_edit_copy_verse_chapter_verse_radio_clicked(bool checked)
{
   pixq_Properties *pEnv = GetEnv( );
   int iMode = pixq_Properties::VerseNumberChapterVerse;

   if( checked ) {
      pEnv->_HikariCopyIncludeVerse.Set( iMode );
      SetChapterVerse( );
   }

   return;
}

void props_page_hikari_edit::on_hikari_edit_copy_verse_verse_radio_clicked(bool checked)
{
   pixq_Properties *pEnv = GetEnv( );
   int iMode = pixq_Properties::VerseNumberVerse;

   if( checked ) {
      pEnv->_HikariCopyIncludeVerse.Set( iMode );
      SetChapterVerse( );
   }

   return;
}

void props_page_hikari_edit::on_hikari_edit_copy_verse_chapter_none_radio_clicked(bool checked)
{
   pixq_Properties *pEnv = GetEnv( );
   int iMode = pixq_Properties::VerseNumberNone;

   if( checked ) {
      pEnv->_HikariCopyIncludeVerse.Set( iMode );
      SetChapterVerse( );
   }

   return;
}

void props_page_hikari_edit::SetChapterVerse( void )
{
   pixq_Properties *pEnv = GetEnv( );
   int iMode;

   ui->hikari_edit_copy_verse_chapter_verse_radio->setChecked( false );
   ui->hikari_edit_copy_verse_verse_radio->setChecked( false );
   ui->hikari_edit_copy_verse_chapter_none_radio->setChecked( false );

   // bible version

   iMode = pEnv->_HikariCopyIncludeVerse.iGet( );

   switch( iMode ) {
   case pixq_Properties::VerseNumberChapterVerse:
      ui->hikari_edit_copy_verse_chapter_verse_radio->setChecked( true );
      break;
   case pixq_Properties::VerseNumberVerse:
      ui->hikari_edit_copy_verse_verse_radio->setChecked( true );
      break;
   case pixq_Properties::VerseNumberNone:
      ui->hikari_edit_copy_verse_chapter_none_radio->setChecked( true );
      break;
   }

   return;
}
